/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines;

import appeng.api.AEApi;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.GridFlags;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.IGridProxyable;
import appeng.util.Platform;
import appeng.util.ReadableNumberConverter;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_Hatch_OutputBus_ME
extends GT_MetaTileEntity_Hatch_OutputBus
implements IPowerChannelState {
    private BaseActionSource requestSource = null;
    private AENetworkProxy gridProxy = null;
    IItemList<IAEItemStack> itemCache = GregTech_API.mAE2 ? AEApi.instance().storage().createItemList() : null;
    long lastOutputTick = 0L;
    long tickCounter = 0L;
    boolean lastOutputFailed = false;
    boolean infiniteCache = true;

    public GT_MetaTileEntity_Hatch_OutputBus_ME(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 1, new String[]{"Item Output for Multiblocks", "Stores directly into ME"}, 0);
    }

    public GT_MetaTileEntity_Hatch_OutputBus_ME(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_OutputBus_ME(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_ME_HATCH_ACTIVE)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_ME_HATCH)};
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        this.getProxy().onReady();
    }

    @Override
    public boolean storeAll(ItemStack aStack) {
        if (!GregTech_API.mAE2) {
            return false;
        }
        aStack.field_77994_a = this.store(aStack);
        return aStack.field_77994_a == 0;
    }

    public int store(ItemStack stack) {
        if (!this.infiniteCache && this.lastOutputFailed) {
            return stack.field_77994_a;
        }
        this.itemCache.add((IAEStack)AEApi.instance().storage().createItemStack(stack));
        return 0;
    }

    private BaseActionSource getRequest() {
        if (this.requestSource == null) {
            this.requestSource = new MachineSource((IActionHost)this.getBaseMetaTileEntity());
        }
        return this.requestSource;
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection forgeDirection) {
        return this.isOutputFacing((byte)forgeDirection.ordinal()) ? AECableType.SMART : AECableType.NONE;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        return false;
    }

    @Override
    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (!this.getBaseMetaTileEntity().getCoverInfoAtSide(aSide).isGUIClickable()) {
            return;
        }
        this.infiniteCache = !this.infiniteCache;
        GT_Utility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)("GT5U.hatch.infiniteCache." + this.infiniteCache)));
    }

    @Override
    public AENetworkProxy getProxy() {
        if (this.gridProxy == null && this.getBaseMetaTileEntity() instanceof IGridProxyable) {
            this.gridProxy = new AENetworkProxy((IGridProxyable)this.getBaseMetaTileEntity(), "proxy", ItemList.Hatch_Output_Bus_ME.get(1L, new Object[0]), true);
            this.gridProxy.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
            if (this.getBaseMetaTileEntity().getWorld() != null) {
                this.gridProxy.setOwner(this.getBaseMetaTileEntity().getWorld().func_72924_a(this.getBaseMetaTileEntity().getOwnerName()));
            }
        }
        return this.gridProxy;
    }

    @Override
    public void gridChanged() {
    }

    private void flushCachedStack() {
        this.lastOutputFailed = false;
        AENetworkProxy proxy = this.getProxy();
        if (proxy == null) {
            this.lastOutputFailed = true;
            return;
        }
        try {
            IMEMonitor sg = proxy.getStorage().getItemInventory();
            for (IAEItemStack s : this.itemCache) {
                if (s.getStackSize() == 0L) continue;
                IAEItemStack rest = (IAEItemStack)Platform.poweredInsert((IEnergySource)proxy.getEnergy(), (IMEInventory)sg, (IAEStack)s, (BaseActionSource)this.getRequest());
                if (rest != null && rest.getStackSize() > 0L) {
                    this.lastOutputFailed = true;
                    s.setStackSize(rest.getStackSize());
                    break;
                }
                s.setStackSize(0L);
            }
        }
        catch (GridAccessException ignored) {
            this.lastOutputFailed = true;
        }
        this.lastOutputTick = this.tickCounter;
    }

    public boolean isPowered() {
        return this.getProxy() != null && this.getProxy().isPowered();
    }

    public boolean isActive() {
        return this.getProxy() != null && this.getProxy().isActive();
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (GT_Values.GT.isServerSide()) {
            this.tickCounter = aTick;
            if (this.tickCounter > this.lastOutputTick + 40L) {
                this.flushCachedStack();
            }
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        if (GregTech_API.mAE2) {
            NBTTagList items = new NBTTagList();
            for (IAEItemStack s : this.itemCache) {
                if (s.getStackSize() == 0L) continue;
                NBTTagCompound tag = new NBTTagCompound();
                NBTTagCompound tagItemStack = new NBTTagCompound();
                s.getItemStack().func_77955_b(tagItemStack);
                tag.func_74782_a("itemStack", (NBTBase)tagItemStack);
                tag.func_74772_a("size", s.getStackSize());
                items.func_74742_a((NBTBase)tag);
            }
            aNBT.func_74782_a("cachedItems", (NBTBase)items);
            this.getProxy().writeToNBT(aNBT);
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (GregTech_API.mAE2) {
            NBTBase t = aNBT.func_74781_a("cachedStack");
            if (t instanceof NBTTagCompound) {
                this.itemCache.add((IAEStack)AEApi.instance().storage().createItemStack(GT_Utility.loadItem((NBTTagCompound)t)));
            }
            if ((t = aNBT.func_74781_a("cachedItems")) instanceof NBTTagList) {
                NBTTagList l = (NBTTagList)t;
                for (int i = 0; i < l.func_74745_c(); ++i) {
                    NBTTagCompound tag = l.func_150305_b(i);
                    if (!tag.func_74764_b("itemStack")) {
                        this.itemCache.add((IAEStack)AEApi.instance().storage().createItemStack(GT_Utility.loadItem(l.func_150305_b(i))));
                        continue;
                    }
                    NBTTagCompound tagItemStack = tag.func_74775_l("itemStack");
                    IAEItemStack s = AEApi.instance().storage().createItemStack(GT_Utility.loadItem(tagItemStack));
                    if (s != null) {
                        s.setStackSize(tag.func_74763_f("size"));
                        this.itemCache.add((IAEStack)s);
                        continue;
                    }
                    GT_Mod.GT_FML_LOGGER.warn("An error occurred while loading contents of ME Output Bus, some items have been voided");
                }
            }
            this.getProxy().readFromNBT(aNBT);
        }
    }

    public boolean isLastOutputFailed() {
        return this.lastOutputFailed;
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        if (!GregTech_API.mAE2) {
            return new String[0];
        }
        ArrayList<String> ss = new ArrayList<String>();
        ss.add("The bus is " + (this.getProxy() != null && this.getProxy().isActive() ? EnumChatFormatting.GREEN + "online" : EnumChatFormatting.RED + "offline" + this.getAEDiagnostics()) + EnumChatFormatting.RESET);
        if (this.itemCache.isEmpty()) {
            ss.add("The bus has no cached items");
        } else {
            ReadableNumberConverter nc = ReadableNumberConverter.INSTANCE;
            ss.add(String.format("The bus contains %d cached stacks: ", this.itemCache.size()));
            int counter = 0;
            for (IAEItemStack s : this.itemCache) {
                ss.add(s.getItem().func_77653_i(s.getItemStack()) + ": " + EnumChatFormatting.GOLD + nc.toWideReadableForm(s.getStackSize()) + EnumChatFormatting.RESET);
                if (++counter <= 100) continue;
                break;
            }
        }
        return ss.toArray(new String[this.itemCache.size() + 2]);
    }

    @Override
    public boolean useModularUI() {
        return false;
    }
}

