/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTech_API;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingFallEvent;

public class GT_EnergyArmor_Item
extends ItemArmor
implements ISpecialArmor {
    public static Map jumpChargeMap = new ConcurrentHashMap();
    public int mCharge;
    public int mTransfer;
    public int mTier;
    public int mDamageEnergyCost;
    public int mSpecials;
    public boolean mChargeProvider;
    public double mArmorAbsorbtionPercentage;

    public GT_EnergyArmor_Item(int aID, String aUnlocalized, String aEnglish, int aCharge, int aTransfer, int aTier, int aDamageEnergyCost, int aSpecials, double aArmorAbsorbtionPercentage, boolean aChargeProvider, int aType, int aArmorIndex) {
        super(ItemArmor.ArmorMaterial.DIAMOND, aArmorIndex, aType);
        this.func_77625_d(1);
        this.func_77656_e(100);
        this.setNoRepair();
        this.func_77655_b(aUnlocalized);
        GT_LanguageManager.addStringLocalization(this.func_77658_a() + ".name", aEnglish);
        this.mCharge = Math.max(1, aCharge);
        this.mTransfer = Math.max(1, aTransfer);
        this.mTier = Math.max(1, aTier);
        this.mSpecials = aSpecials;
        this.mChargeProvider = aChargeProvider;
        this.mDamageEnergyCost = Math.max(0, aDamageEnergyCost);
        this.mArmorAbsorbtionPercentage = aArmorAbsorbtionPercentage;
        this.func_77637_a(GregTech_API.TAB_GREGTECH);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private static void setCharge(ItemStack aStack) {
        NBTTagCompound tNBT = aStack.func_77978_p();
        if (tNBT == null) {
            tNBT = new NBTTagCompound();
        }
        tNBT.func_74768_a("charge", 1000000000);
        aStack.func_77982_d(tNBT);
    }

    public ItemStack func_77659_a(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        ItemStack tStack = aPlayer.field_71071_by.field_70460_b[3 - this.field_77881_a];
        if (tStack != null) {
            for (int i = 0; i < 9; ++i) {
                if (aPlayer.field_71071_by.field_70462_a[i] != aStack) continue;
                aPlayer.field_71071_by.field_70460_b[3 - this.field_77881_a] = aPlayer.field_71071_by.field_70462_a[i];
                aPlayer.field_71071_by.field_70462_a[i] = tStack;
                return tStack;
            }
        }
        return super.func_77659_a(aStack, aWorld, aPlayer);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister aIconRegister) {
        this.field_77791_bV = aIconRegister.func_94245_a("gregtech:" + this.func_77658_a());
    }

    public void func_77624_a(ItemStack aStack, EntityPlayer aPlayer, List aList, boolean aF3_H) {
        aList.add("Tier: " + this.mTier);
        if ((this.mSpecials & 1) != 0) {
            aList.add("Rebreather");
        }
        if ((this.mSpecials & 2) != 0) {
            aList.add("Inertia Damper");
        }
        if ((this.mSpecials & 4) != 0) {
            aList.add("Food Replicator");
        }
        if ((this.mSpecials & 8) != 0) {
            aList.add("Medicine Module");
        }
        if ((this.mSpecials & 0x10) != 0) {
            aList.add("Lamp");
        }
        if ((this.mSpecials & 0x20) != 0) {
            aList.add("Solarpanel");
        }
        if ((this.mSpecials & 0x40) != 0) {
            aList.add("Extinguisher Module");
        }
        if ((this.mSpecials & 0x80) != 0) {
            aList.add("Jump Booster");
        }
        if ((this.mSpecials & 0x100) != 0) {
            aList.add("Speed Booster");
        }
        if ((this.mSpecials & 0x200) != 0) {
            aList.add("Invisibility Field");
        }
        if ((this.mSpecials & 0x400) != 0) {
            aList.add("Infinite Charge");
        }
    }

    public void onArmorTick(World aWorld, EntityPlayer aPlayer, ItemStack aStack) {
        if (this.mSpecials == 0) {
            return;
        }
        if (!aPlayer.field_70170_p.field_72995_K && (this.mSpecials & 1) != 0) {
            int airSupply = aPlayer.func_70086_ai();
            if (GT_ModHandler.canUseElectricItem(aStack, 1000) && airSupply < 50) {
                aPlayer.func_70050_g(airSupply + 250);
                GT_ModHandler.useElectricItem(aStack, 1000, aPlayer);
            }
        }
        if (!aPlayer.field_70170_p.field_72995_K && (this.mSpecials & 4) != 0 && GT_ModHandler.canUseElectricItem(aStack, 50000) && aPlayer.func_71024_bL().func_75121_c()) {
            aPlayer.func_71024_bL().func_75122_a(1, 0.0f);
            GT_ModHandler.useElectricItem(aStack, 50000, aPlayer);
        }
        if ((this.mSpecials & 8) != 0) {
            if (GT_ModHandler.canUseElectricItem(aStack, 10000) && aPlayer.func_70644_a(Potion.field_76436_u)) {
                GT_Utility.removePotion((EntityLivingBase)aPlayer, Potion.field_76436_u.field_76415_H);
                GT_ModHandler.useElectricItem(aStack, 10000, aPlayer);
            }
            if (GT_ModHandler.canUseElectricItem(aStack, 100000) && aPlayer.func_70644_a(Potion.field_82731_v)) {
                GT_Utility.removePotion((EntityLivingBase)aPlayer, Potion.field_82731_v.field_76415_H);
                GT_ModHandler.useElectricItem(aStack, 100000, aPlayer);
            }
        }
        if ((this.mSpecials & 0x40) != 0) {
            aPlayer.func_70015_d(0);
        }
        if (!aPlayer.field_70170_p.field_72995_K && (this.mSpecials & 0x80) != 0) {
            float jumpCharge;
            float f = jumpCharge = jumpChargeMap.containsKey(aPlayer) ? ((Float)jumpChargeMap.get(aPlayer)).floatValue() : 1.0f;
            if (GT_ModHandler.canUseElectricItem(aStack, 1000) && aPlayer.field_70122_E && jumpCharge < 1.0f) {
                jumpCharge = 1.0f;
                GT_ModHandler.useElectricItem(aStack, 1000, aPlayer);
            }
            if (aPlayer.field_70181_x >= 0.0 && jumpCharge > 0.0f && !aPlayer.func_70090_H()) {
                if (GT_ModHandler.getJumpKeyDown(aPlayer) && GT_ModHandler.getBoostKeyDown(aPlayer)) {
                    if (jumpCharge == 1.0f) {
                        aPlayer.field_70159_w *= 3.5;
                        aPlayer.field_70179_y *= 3.5;
                    }
                    aPlayer.field_70181_x += (double)(jumpCharge * 0.3f);
                    jumpCharge = (float)((double)jumpCharge * 0.75);
                } else if (jumpCharge < 1.0f) {
                    jumpCharge = 0.0f;
                }
            }
            jumpChargeMap.put(aPlayer, Float.valueOf(jumpCharge));
        }
        if ((this.mSpecials & 0x100) != 0 && GT_ModHandler.canUseElectricItem(aStack, 100) && aPlayer.func_70051_ag() && (aPlayer.field_70122_E && Math.abs(aPlayer.field_70159_w) + Math.abs(aPlayer.field_70179_y) > (double)0.1f || aPlayer.func_70090_H())) {
            GT_ModHandler.useElectricItem(aStack, 100, aPlayer);
            float bonus = 0.22f;
            if (aPlayer.func_70090_H()) {
                GT_ModHandler.useElectricItem(aStack, 100, aPlayer);
                bonus = 0.1f;
                if (aPlayer.field_70181_x > 0.0) {
                    aPlayer.field_70181_x += (double)0.1f;
                }
            }
            if (bonus > 0.0f) {
                aPlayer.func_70060_a(0.0f, 1.0f, bonus);
            }
        }
        if ((this.mSpecials & 0x200) != 0 && GT_ModHandler.canUseElectricItem(aStack, 10000)) {
            GT_ModHandler.useElectricItem(aStack, 10000, aPlayer);
            aPlayer.func_70690_d(new PotionEffect(Potion.field_76441_p.func_76396_c(), 25, 1, true));
        }
        if (!aPlayer.field_70170_p.field_72995_K && (this.mSpecials & 0x30) != 0) {
            ItemStack tTargetChargeItem = aStack;
            ItemStack tTargetDechargeItem = aStack;
            if (GT_ModHandler.chargeElectricItem(tTargetChargeItem, 1, Integer.MAX_VALUE, true, true) < 1) {
                tTargetChargeItem = aPlayer.field_71071_by.field_70460_b[2];
            }
            if (GT_ModHandler.dischargeElectricItem(tTargetDechargeItem, 10, Integer.MAX_VALUE, true, true, true) < 10) {
                tTargetDechargeItem = aPlayer.field_71071_by.field_70460_b[2];
            }
            if (tTargetChargeItem == null || !GT_ModHandler.isElectricItem(tTargetChargeItem)) {
                tTargetChargeItem = null;
            }
            if (aPlayer.field_70170_p.func_72935_r() && aPlayer.field_70170_p.func_72937_j(MathHelper.func_76128_c((double)aPlayer.field_70165_t), MathHelper.func_76128_c((double)(aPlayer.field_70163_u + 1.0)), MathHelper.func_76128_c((double)aPlayer.field_70161_v)) && (this.mSpecials & 0x20) != 0 && tTargetChargeItem != null) {
                GT_ModHandler.chargeElectricItem(tTargetChargeItem, 20, Integer.MAX_VALUE, true, false);
            }
        }
    }

    public boolean func_77651_p() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item aItem, CreativeTabs creativeTab, List outputSubItems) {
        ItemStack tCharged = new ItemStack((Item)this, 1);
        ItemStack tUncharged = new ItemStack((Item)this, 1, this.func_77612_l());
        GT_ModHandler.chargeElectricItem(tCharged, Integer.MAX_VALUE, Integer.MAX_VALUE, true, false);
        outputSubItems.add(tCharged);
        outputSubItems.add(tUncharged);
    }

    public boolean canProvideEnergy(ItemStack aStack) {
        if ((this.mSpecials & 0x400) != 0) {
            GT_EnergyArmor_Item.setCharge(aStack);
        }
        return this.mChargeProvider;
    }

    public Item getChargedItem(ItemStack aStack) {
        if ((this.mSpecials & 0x400) != 0) {
            GT_EnergyArmor_Item.setCharge(aStack);
        }
        return this;
    }

    public Item getEmptyItem(ItemStack aStack) {
        if ((this.mSpecials & 0x400) != 0) {
            GT_EnergyArmor_Item.setCharge(aStack);
        }
        return this;
    }

    public int getMaxCharge(ItemStack aStack) {
        if ((this.mSpecials & 0x400) != 0) {
            GT_EnergyArmor_Item.setCharge(aStack);
        }
        return this.mCharge;
    }

    public int getTier(ItemStack aStack) {
        if ((this.mSpecials & 0x400) != 0) {
            GT_EnergyArmor_Item.setCharge(aStack);
        }
        return this.mTier;
    }

    public int getTransferLimit(ItemStack aStack) {
        if ((this.mSpecials & 0x400) != 0) {
            GT_EnergyArmor_Item.setCharge(aStack);
        }
        return this.mTransfer;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack ingredient, ItemStack bookEnchant) {
        return false;
    }

    public boolean func_82789_a(ItemStack toBeRepaired, ItemStack repairWith) {
        return false;
    }

    public void onEntityLivingFallEvent(LivingFallEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            for (int i = 0; i < 4; ++i) {
                int distanceFactor;
                int energyCost;
                ItemStack armor = player.field_71071_by.field_70460_b[i];
                if (armor == null || armor.func_77973_b() != this || (this.mSpecials & 2) == 0 || (energyCost = this.mDamageEnergyCost * (distanceFactor = (int)event.distance - 3) / 4) > GT_ModHandler.dischargeElectricItem(armor, Integer.MAX_VALUE, Integer.MAX_VALUE, true, true, true)) continue;
                GT_ModHandler.dischargeElectricItem(armor, energyCost, Integer.MAX_VALUE, true, false, true);
                event.setCanceled(true);
                break;
            }
        }
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slotIndex) {
        return new ISpecialArmor.ArmorProperties(source == DamageSource.field_76379_h && (this.mSpecials & 2) != 0 ? 10 : 0, this.getBaseAbsorptionRatio() * this.mArmorAbsorbtionPercentage, this.mDamageEnergyCost > 0 ? 25 * GT_ModHandler.dischargeElectricItem(armor, Integer.MAX_VALUE, Integer.MAX_VALUE, true, true, true) / this.mDamageEnergyCost : 0);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slotIndex) {
        return (int)Math.round(20.0 * this.getBaseAbsorptionRatio() * this.mArmorAbsorbtionPercentage);
    }

    public void damageArmor(EntityLivingBase entity, ItemStack itemStack, DamageSource source, int damage, int slotIndex) {
        GT_ModHandler.dischargeElectricItem(itemStack, damage * this.mDamageEnergyCost, Integer.MAX_VALUE, true, false, true);
    }

    private double getBaseAbsorptionRatio() {
        if (this.mArmorAbsorbtionPercentage <= 0.0) {
            return 0.0;
        }
        switch (this.field_77881_a) {
            case 0: {
                return 0.15;
            }
            case 1: {
                return 0.4;
            }
            case 2: {
                return 0.3;
            }
            case 3: {
                return 0.15;
            }
        }
        return 0.0;
    }
}

