/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.SubTag;
import gregtech.api.interfaces.IItemBehaviour;
import gregtech.api.items.GT_Generic_Item;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public abstract class GT_MetaBase_Item
extends GT_Generic_Item
implements ISpecialElectricItem,
IElectricItemManager,
IFluidContainerItem {
    private final ConcurrentHashMap<Short, ArrayList<IItemBehaviour<GT_MetaBase_Item>>> mItemBehaviors = new ConcurrentHashMap();

    public GT_MetaBase_Item(String aUnlocalized) {
        super(aUnlocalized, "Generated Item", null, false);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public final GT_MetaBase_Item addItemBehavior(int aMetaValue, IItemBehaviour<GT_MetaBase_Item> aBehavior) {
        if (aMetaValue < 0 || aMetaValue >= 32766 || aBehavior == null) {
            return this;
        }
        ArrayList tList = this.mItemBehaviors.computeIfAbsent((short)aMetaValue, k -> new ArrayList(1));
        tList.add(aBehavior);
        return this;
    }

    public abstract Long[] getElectricStats(ItemStack var1);

    public abstract Long[] getFluidContainerStats(ItemStack var1);

    @Override
    public boolean hasProjectile(SubTag aProjectileType, ItemStack aStack) {
        ArrayList<IItemBehaviour<GT_MetaBase_Item>> tList = this.mItemBehaviors.get((short)this.getDamage(aStack));
        if (tList != null) {
            for (IItemBehaviour<GT_MetaBase_Item> tBehavior : tList) {
                if (!tBehavior.hasProjectile(this, aProjectileType, aStack)) continue;
                return true;
            }
        }
        return super.hasProjectile(aProjectileType, aStack);
    }

    @Override
    public EntityArrow getProjectile(SubTag aProjectileType, ItemStack aStack, World aWorld, double aX, double aY, double aZ) {
        ArrayList<IItemBehaviour<GT_MetaBase_Item>> tList = this.mItemBehaviors.get((short)this.getDamage(aStack));
        if (tList != null) {
            for (IItemBehaviour<GT_MetaBase_Item> tBehavior : tList) {
                EntityArrow rArrow = tBehavior.getProjectile(this, aProjectileType, aStack, aWorld, aX, aY, aZ);
                if (rArrow == null) continue;
                return rArrow;
            }
        }
        return super.getProjectile(aProjectileType, aStack, aWorld, aX, aY, aZ);
    }

    @Override
    public EntityArrow getProjectile(SubTag aProjectileType, ItemStack aStack, World aWorld, EntityLivingBase aEntity, float aSpeed) {
        ArrayList<IItemBehaviour<GT_MetaBase_Item>> tList = this.mItemBehaviors.get((short)this.getDamage(aStack));
        if (tList != null) {
            for (IItemBehaviour<GT_MetaBase_Item> tBehavior : tList) {
                EntityArrow rArrow = tBehavior.getProjectile(this, aProjectileType, aStack, aWorld, aEntity, aSpeed);
                if (rArrow == null) continue;
                return rArrow;
            }
        }
        return super.getProjectile(aProjectileType, aStack, aWorld, aEntity, aSpeed);
    }

    @Override
    public ItemStack onDispense(IBlockSource aSource, ItemStack aStack) {
        ArrayList<IItemBehaviour<GT_MetaBase_Item>> tList = this.mItemBehaviors.get((short)this.getDamage(aStack));
        if (tList != null) {
            for (IItemBehaviour<GT_MetaBase_Item> tBehavior : tList) {
                if (!tBehavior.canDispense(this, aSource, aStack)) continue;
                return tBehavior.onDispense(this, aSource, aStack);
            }
        }
        return super.onDispense(aSource, aStack);
    }

    @Override
    public boolean isItemStackUsable(ItemStack aStack) {
        ArrayList<IItemBehaviour<GT_MetaBase_Item>> tList = this.mItemBehaviors.get((short)this.getDamage(aStack));
        if (tList != null) {
            for (IItemBehaviour<GT_MetaBase_Item> tBehavior : tList) {
                if (tBehavior.isItemStackUsable(this, aStack)) continue;
                return false;
            }
        }
        return super.isItemStackUsable(aStack);
    }

    public boolean onLeftClickEntity(ItemStack aStack, EntityPlayer aPlayer, Entity aEntity) {
        block6: {
            this.use(aStack, 0.0, (EntityLivingBase)aPlayer);
            this.isItemStackUsable(aStack);
            ArrayList<IItemBehaviour<GT_MetaBase_Item>> tList = this.mItemBehaviors.get((short)this.getDamage(aStack));
            try {
                if (tList != null) {
                    for (IItemBehaviour<GT_MetaBase_Item> tBehavior : tList) {
                        if (!tBehavior.onLeftClickEntity(this, aStack, aPlayer, aEntity)) continue;
                        if (aStack.field_77994_a <= 0) {
                            aPlayer.func_71028_bD();
                        }
                        return true;
                    }
                }
                if (aStack.field_77994_a <= 0) {
                    aPlayer.func_71028_bD();
                    return false;
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block6;
                e.printStackTrace(GT_Log.err);
            }
        }
        return false;
    }

    public boolean func_77648_a(ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide, float hitX, float hitY, float hitZ) {
        block6: {
            this.use(aStack, 0.0, (EntityLivingBase)aPlayer);
            this.isItemStackUsable(aStack);
            ArrayList<IItemBehaviour<GT_MetaBase_Item>> tList = this.mItemBehaviors.get((short)this.getDamage(aStack));
            try {
                if (tList != null) {
                    for (IItemBehaviour<GT_MetaBase_Item> tBehavior : tList) {
                        if (!tBehavior.onItemUse(this, aStack, aPlayer, aWorld, aX, aY, aZ, aSide, hitX, hitY, hitZ)) continue;
                        if (aStack.field_77994_a <= 0) {
                            aPlayer.func_71028_bD();
                        }
                        return true;
                    }
                }
                if (aStack.field_77994_a <= 0) {
                    aPlayer.func_71028_bD();
                    return false;
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block6;
                e.printStackTrace(GT_Log.err);
            }
        }
        return false;
    }

    public boolean onItemUseFirst(ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide, float hitX, float hitY, float hitZ) {
        block6: {
            this.use(aStack, 0.0, (EntityLivingBase)aPlayer);
            this.isItemStackUsable(aStack);
            ArrayList<IItemBehaviour<GT_MetaBase_Item>> tList = this.mItemBehaviors.get((short)this.getDamage(aStack));
            try {
                if (tList != null) {
                    for (IItemBehaviour<GT_MetaBase_Item> tBehavior : tList) {
                        if (!tBehavior.onItemUseFirst(this, aStack, aPlayer, aWorld, aX, aY, aZ, aSide, hitX, hitY, hitZ)) continue;
                        if (aStack.field_77994_a <= 0) {
                            aPlayer.func_71028_bD();
                        }
                        return true;
                    }
                }
                if (aStack.field_77994_a <= 0) {
                    aPlayer.func_71028_bD();
                    return false;
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block6;
                e.printStackTrace(GT_Log.err);
            }
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        block4: {
            this.use(aStack, 0.0, (EntityLivingBase)aPlayer);
            this.isItemStackUsable(aStack);
            ArrayList<IItemBehaviour<GT_MetaBase_Item>> tList = this.mItemBehaviors.get((short)this.getDamage(aStack));
            try {
                if (tList != null) {
                    for (IItemBehaviour<GT_MetaBase_Item> tBehavior : tList) {
                        aStack = tBehavior.onItemRightClick(this, aStack, aWorld, aPlayer);
                    }
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block4;
                e.printStackTrace(GT_Log.err);
            }
        }
        return aStack;
    }

    @Override
    public final void func_77624_a(ItemStack aStack, EntityPlayer aPlayer, List aList, boolean aF3_H) {
        ArrayList<IItemBehaviour<GT_MetaBase_Item>> tList;
        String[] tStrings;
        String tKey = this.func_77667_c(aStack) + ".tooltip";
        for (String tString : tStrings = GT_LanguageManager.getTranslation(tKey).split("/n ")) {
            if (!GT_Utility.isStringValid(tString) || tKey.equals(tString)) continue;
            aList.add(tString);
        }
        Long[] tStats = this.getElectricStats(aStack);
        if (tStats != null) {
            if (tStats[3] > 0L) {
                aList.add(EnumChatFormatting.AQUA + String.format(this.transItem("009", "Contains %s EU   Tier: %s"), GT_Utility.formatNumbers(tStats[3]), "" + (tStats[2] >= 0L ? tStats[2] : 0L)) + EnumChatFormatting.GRAY);
            } else {
                long tCharge = this.getRealCharge(aStack);
                if (tStats[3] == -2L && tCharge <= 0L) {
                    aList.add(EnumChatFormatting.AQUA + this.transItem("010", "Empty. You should recycle it properly.") + EnumChatFormatting.GRAY);
                } else {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = GT_Utility.formatNumbers(tCharge);
                    objectArray[1] = GT_Utility.formatNumbers(Math.abs(tStats[0]));
                    objectArray[2] = "" + GT_Values.V[(int)(tStats[2] >= 0L ? (tStats[2] < (long)GT_Values.V.length ? tStats[2] : (long)(GT_Values.V.length - 1)) : 1L)];
                    aList.add(String.valueOf(EnumChatFormatting.AQUA) + String.format(this.transItem("011", "%s / %s EU - Voltage: %s"), objectArray) + EnumChatFormatting.GRAY);
                }
            }
        }
        if ((tStats = this.getFluidContainerStats(aStack)) != null && tStats[0] > 0L) {
            FluidStack tFluid = this.getFluidContent(aStack);
            aList.add(EnumChatFormatting.BLUE + (tFluid == null ? this.transItem("012", "No Fluids Contained") : GT_Utility.getFluidName(tFluid, true)) + EnumChatFormatting.GRAY);
            aList.add(EnumChatFormatting.BLUE + String.format(this.transItem("013", "%sL / %sL"), "" + (tFluid == null ? Integer.valueOf(0) : GT_Utility.formatNumbers(tFluid.amount)), "" + GT_Utility.formatNumbers(tStats[0])) + EnumChatFormatting.GRAY);
        }
        if ((tList = this.mItemBehaviors.get((short)this.getDamage(aStack))) != null) {
            for (IItemBehaviour<GT_MetaBase_Item> tBehavior : tList) {
                aList = tBehavior.getAdditionalToolTips(this, aList, aStack);
            }
        }
        this.addAdditionalToolTips(aList, aStack, aPlayer);
    }

    public void func_77663_a(ItemStack aStack, World aWorld, Entity aPlayer, int aTimer, boolean aIsInHand) {
        ArrayList<IItemBehaviour<GT_MetaBase_Item>> tList = this.mItemBehaviors.get((short)this.getDamage(aStack));
        if (tList != null) {
            for (IItemBehaviour<GT_MetaBase_Item> tBehavior : tList) {
                tBehavior.onUpdate(this, aStack, aWorld, aPlayer, aTimer, aIsInHand);
            }
        }
    }

    public final boolean canProvideEnergy(ItemStack aStack) {
        Long[] tStats = this.getElectricStats(aStack);
        if (tStats == null) {
            return false;
        }
        return tStats[3] > 0L || aStack.field_77994_a == 1 && (tStats[3] == -2L || tStats[3] == -3L);
    }

    public final double getMaxCharge(ItemStack aStack) {
        Long[] tStats = this.getElectricStats(aStack);
        if (tStats == null) {
            return 0.0;
        }
        return Math.abs(tStats[0]);
    }

    public final double getTransferLimit(ItemStack aStack) {
        Long[] tStats = this.getElectricStats(aStack);
        if (tStats == null) {
            return 0.0;
        }
        return Math.max(tStats[1], tStats[3]);
    }

    public final double charge(ItemStack aStack, double aCharge, int aTier, boolean aIgnoreTransferLimit, boolean aSimulate) {
        Long[] tStats = this.getElectricStats(aStack);
        if (tStats == null || tStats[2] > (long)aTier || tStats[3] != -1L && tStats[3] != -3L && (tStats[3] >= 0L || aCharge != 2.147483647E9) || aStack.field_77994_a != 1) {
            return 0.0;
        }
        long tTransfer = aIgnoreTransferLimit ? (long)aCharge : Math.min(tStats[1], (long)aCharge);
        long tChargeBefore = this.getRealCharge(aStack);
        long tNewCharge = Math.min(Math.abs(tStats[0]), Long.MAX_VALUE - tTransfer >= tChargeBefore ? tChargeBefore + tTransfer : Long.MAX_VALUE);
        if (!aSimulate) {
            this.setCharge(aStack, tNewCharge);
        }
        return tNewCharge - tChargeBefore;
    }

    public final double discharge(ItemStack aStack, double aCharge, int aTier, boolean aIgnoreTransferLimit, boolean aBatteryAlike, boolean aSimulate) {
        Long[] tStats = this.getElectricStats(aStack);
        if (tStats == null || tStats[2] > (long)aTier) {
            return 0.0;
        }
        if (aBatteryAlike && !this.canProvideEnergy(aStack)) {
            return 0.0;
        }
        if (tStats[3] > 0L) {
            if (aCharge < (double)tStats[3].longValue() || aStack.field_77994_a < 1) {
                return 0.0;
            }
            if (!aSimulate) {
                --aStack.field_77994_a;
            }
            return tStats[3].longValue();
        }
        long tChargeBefore = this.getRealCharge(aStack);
        long tNewCharge = Math.max(0L, tChargeBefore - (aIgnoreTransferLimit ? (long)aCharge : Math.min(tStats[1], (long)aCharge)));
        if (!aSimulate) {
            this.setCharge(aStack, tNewCharge);
        }
        return tChargeBefore - tNewCharge;
    }

    public final double getCharge(ItemStack aStack) {
        return this.getRealCharge(aStack);
    }

    public final boolean canUse(ItemStack aStack, double aAmount) {
        return (double)this.getRealCharge(aStack) >= aAmount;
    }

    public final boolean use(ItemStack aStack, double aAmount, EntityLivingBase aPlayer) {
        this.chargeFromArmor(aStack, aPlayer);
        if (aPlayer instanceof EntityPlayer && ((EntityPlayer)aPlayer).field_71075_bZ.field_75098_d) {
            return true;
        }
        double tTransfer = this.discharge(aStack, aAmount, Integer.MAX_VALUE, true, false, true);
        if (Math.abs(tTransfer - aAmount) < 1.0E-7) {
            this.discharge(aStack, aAmount, Integer.MAX_VALUE, true, false, false);
            this.chargeFromArmor(aStack, aPlayer);
            return true;
        }
        this.discharge(aStack, aAmount, Integer.MAX_VALUE, true, false, false);
        this.chargeFromArmor(aStack, aPlayer);
        return false;
    }

    public final void chargeFromArmor(ItemStack aStack, EntityLivingBase aPlayer) {
        if (aPlayer == null || aPlayer.field_70170_p.field_72995_K) {
            return;
        }
        for (int i = 1; i < 5; ++i) {
            Container tContainer;
            double tCharge;
            IElectricItem tArmorItem;
            ItemStack tArmor = aPlayer.func_71124_b(i);
            if (!GT_ModHandler.isElectricItem(tArmor) || !(tArmorItem = (IElectricItem)tArmor.func_77973_b()).canProvideEnergy(tArmor) || tArmorItem.getTier(tArmor) < this.getTier(aStack) || !((tCharge = ElectricItem.manager.discharge(tArmor, this.charge(aStack, 2.147483646E9, Integer.MAX_VALUE, true, true), Integer.MAX_VALUE, true, true, false)) > 0.0)) continue;
            this.charge(aStack, tCharge, Integer.MAX_VALUE, true, false);
            if (!(aPlayer instanceof EntityPlayer) || (tContainer = ((EntityPlayer)aPlayer).field_71070_bA) == null) continue;
            tContainer.func_75142_b();
        }
    }

    public final long getRealCharge(ItemStack aStack) {
        Long[] tStats = this.getElectricStats(aStack);
        if (tStats == null) {
            return 0L;
        }
        if (tStats[3] > 0L) {
            return (int)tStats[3].longValue();
        }
        NBTTagCompound tNBT = aStack.func_77978_p();
        return tNBT == null ? 0L : tNBT.func_74763_f("GT.ItemCharge");
    }

    public final boolean setCharge(ItemStack aStack, long aCharge) {
        Long[] tStats = this.getElectricStats(aStack);
        if (tStats == null || tStats[3] > 0L) {
            return false;
        }
        NBTTagCompound tNBT = aStack.func_77978_p();
        if (tNBT == null) {
            tNBT = new NBTTagCompound();
        }
        tNBT.func_82580_o("GT.ItemCharge");
        aCharge = Math.min(tStats[0] < 0L ? Math.abs(tStats[0] / 2L) : aCharge, Math.abs(tStats[0]));
        if (aCharge > 0L) {
            aStack.func_77964_b((int)this.getChargedMetaData(aStack));
            tNBT.func_74772_a("GT.ItemCharge", aCharge);
        } else {
            aStack.func_77964_b((int)this.getEmptyMetaData(aStack));
        }
        if (tNBT.func_82582_d()) {
            aStack.func_77982_d(null);
        } else {
            aStack.func_77982_d(tNBT);
        }
        this.isItemStackUsable(aStack);
        return true;
    }

    public short getChargedMetaData(ItemStack aStack) {
        return (short)aStack.func_77960_j();
    }

    public short getEmptyMetaData(ItemStack aStack) {
        return (short)aStack.func_77960_j();
    }

    public FluidStack getFluid(ItemStack aStack) {
        return this.getFluidContent(aStack);
    }

    public int getCapacity(ItemStack aStack) {
        Long[] tStats = this.getFluidContainerStats(aStack);
        return tStats == null ? 0 : (int)Math.max(0L, tStats[0]);
    }

    public int fill(ItemStack aStack, FluidStack aFluid, boolean doFill) {
        if (aStack == null || aStack.field_77994_a != 1) {
            return 0;
        }
        ItemStack tStack = GT_Utility.fillFluidContainer(aFluid, aStack, false, false);
        if (tStack != null) {
            aStack.func_77964_b(tStack.func_77960_j());
            aStack.func_150996_a(tStack.func_77973_b());
            return GT_Utility.getFluidForFilledItem((ItemStack)tStack, (boolean)false).amount;
        }
        Long[] tStats = this.getFluidContainerStats(aStack);
        if (tStats == null || tStats[0] <= 0L || aFluid == null || aFluid.getFluid().getID() <= 0 || aFluid.amount <= 0) {
            return 0;
        }
        FluidStack tFluid = this.getFluidContent(aStack);
        if (tFluid == null || tFluid.getFluid().getID() <= 0) {
            if ((long)aFluid.amount <= tStats[0]) {
                if (doFill) {
                    this.setFluidContent(aStack, aFluid);
                }
                return aFluid.amount;
            }
            if (doFill) {
                tFluid = aFluid.copy();
                tFluid.amount = (int)tStats[0].longValue();
                this.setFluidContent(aStack, tFluid);
            }
            return (int)tStats[0].longValue();
        }
        if (!tFluid.isFluidEqual(aFluid)) {
            return 0;
        }
        int space = (int)tStats[0].longValue() - tFluid.amount;
        if (aFluid.amount <= space) {
            if (doFill) {
                tFluid.amount += aFluid.amount;
                this.setFluidContent(aStack, tFluid);
            }
            return aFluid.amount;
        }
        if (doFill) {
            tFluid.amount = (int)tStats[0].longValue();
            this.setFluidContent(aStack, tFluid);
        }
        return space;
    }

    public FluidStack drain(ItemStack aStack, int maxDrain, boolean doDrain) {
        if (aStack == null || aStack.field_77994_a != 1) {
            return null;
        }
        FluidStack tFluid = GT_Utility.getFluidForFilledItem(aStack, false);
        if (tFluid != null && maxDrain >= tFluid.amount) {
            ItemStack tStack = GT_Utility.getContainerItem(aStack, false);
            if (tStack == null) {
                if (doDrain) {
                    aStack.field_77994_a = 0;
                }
                return tFluid;
            }
            if (doDrain) {
                aStack.func_77964_b(tStack.func_77960_j());
                aStack.func_150996_a(tStack.func_77973_b());
            }
            return tFluid;
        }
        Long[] tStats = this.getFluidContainerStats(aStack);
        if (tStats == null || tStats[0] <= 0L) {
            return null;
        }
        tFluid = this.getFluidContent(aStack);
        if (tFluid == null) {
            return null;
        }
        int used = maxDrain;
        if (tFluid.amount < used) {
            used = tFluid.amount;
        }
        if (doDrain) {
            tFluid.amount -= used;
            this.setFluidContent(aStack, tFluid);
        }
        FluidStack drained = tFluid.copy();
        drained.amount = used;
        return drained;
    }

    public FluidStack getFluidContent(ItemStack aStack) {
        Long[] tStats = this.getFluidContainerStats(aStack);
        if (tStats == null || tStats[0] <= 0L) {
            return GT_Utility.getFluidForFilledItem(aStack, false);
        }
        NBTTagCompound tNBT = aStack.func_77978_p();
        return tNBT == null ? null : FluidStack.loadFluidStackFromNBT((NBTTagCompound)tNBT.func_74775_l("GT.FluidContent"));
    }

    public void setFluidContent(ItemStack aStack, FluidStack aFluid) {
        NBTTagCompound tNBT = aStack.func_77978_p();
        if (tNBT == null) {
            tNBT = new NBTTagCompound();
        } else {
            tNBT.func_82580_o("GT.FluidContent");
        }
        if (aFluid != null && aFluid.amount > 0) {
            tNBT.func_74782_a("GT.FluidContent", (NBTBase)aFluid.writeToNBT(new NBTTagCompound()));
        }
        if (tNBT.func_82582_d()) {
            aStack.func_77982_d(null);
        } else {
            aStack.func_77982_d(tNBT);
        }
        this.isItemStackUsable(aStack);
    }

    public int getItemStackLimit(ItemStack aStack) {
        Long[] tStats = this.getElectricStats(aStack);
        if (tStats != null && (tStats[3] == -1L || tStats[3] == -2L || tStats[3] == -3L) && this.getRealCharge(aStack) > 0L) {
            return 1;
        }
        tStats = this.getFluidContainerStats(aStack);
        if (tStats != null) {
            return (int)tStats[1].longValue();
        }
        if (this.getDamage(aStack) == 32763) {
            return 1;
        }
        return 64;
    }

    public final Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public final Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    @Override
    public final int getTier(ItemStack aStack) {
        Long[] tStats = this.getElectricStats(aStack);
        return (int)(tStats == null ? Integer.MAX_VALUE : tStats[2]);
    }

    public final String getToolTip(ItemStack aStack) {
        return null;
    }

    public final IElectricItemManager getManager(ItemStack aStack) {
        return this;
    }

    public final boolean func_77651_p() {
        return true;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack aStack, ItemStack aBook) {
        return false;
    }

    public boolean func_82789_a(ItemStack aStack, ItemStack aMaterial) {
        return false;
    }
}

