/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity;

import gregtech.api.enums.Materials;
import gregtech.api.multitileentity.MultiTileEntityBlock;
import gregtech.api.multitileentity.MultiTileEntityRegistry;
import gregtech.api.multitileentity.base.BaseMultiTileEntity;
import gregtech.api.multitileentity.multiblock.casing.AdvancedCasing;
import gregtech.api.util.GT_Util;
import java.lang.ref.WeakReference;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Tuple;

public class MultiTileEntityClassContainer {
    private final WeakReference<MultiTileEntityRegistry> mRegistry;
    private String mLocalized;
    private String mCategoryName;
    public final short mID;
    public Class<? extends BaseMultiTileEntity> mClass;
    public MultiTileEntityBlock mBlock;
    public BaseMultiTileEntity mCanonicalTileEntity;
    public NBTTagCompound mParameters;
    public byte mBlockMetaData = 1;
    public byte mStackSize = (byte)64;
    public boolean mHidden = false;

    public MultiTileEntityClassContainer(MultiTileEntityRegistry aRegistry, int aID, Class<? extends BaseMultiTileEntity> aClass) {
        this.mRegistry = new WeakReference<MultiTileEntityRegistry>(aRegistry);
        this.mID = (short)aID;
        this.mClass = aClass;
        this.mParameters = new NBTTagCompound();
    }

    public boolean register() {
        MultiTileEntityRegistry registry = (MultiTileEntityRegistry)this.mRegistry.get();
        if (this.mParameters.func_74764_b("gt.material") && !this.mParameters.func_74764_b("gt.color")) {
            this.mParameters.func_74768_a("gt.color", GT_Util.getRGBInt(Materials.get(this.mParameters.func_74779_i("gt.material")).getRGBA()));
        }
        try {
            this.mCanonicalTileEntity = this.mClass.newInstance();
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
        this.mCanonicalTileEntity.initFromNBT(this.mParameters, this.mID, (short)-1);
        return registry != null && registry.add(this.mLocalized, this.mCategoryName, this) != null;
    }

    public MultiTileEntityClassContainer name(String aName) {
        this.mLocalized = aName;
        return this;
    }

    public MultiTileEntityClassContainer category(String aCategoryName) {
        this.mCategoryName = aCategoryName;
        return this;
    }

    public MultiTileEntityClassContainer meta(int aMeta) {
        this.mBlockMetaData = (byte)aMeta;
        return this;
    }

    public MultiTileEntityClassContainer stackSize(int aStackSize) {
        this.mStackSize = (byte)aStackSize;
        return this;
    }

    public MultiTileEntityClassContainer hide() {
        this.mHidden = true;
        return this;
    }

    public MultiTileEntityClassContainer setBlock(MultiTileEntityBlock aBlock) {
        this.mBlock = aBlock;
        return this;
    }

    public MultiTileEntityClassContainer material(Materials aMaterial) {
        this.mParameters.func_74778_a("gt.material", aMaterial.toString());
        if (!this.mParameters.func_74764_b("gt.color")) {
            this.mParameters.func_74768_a("gt.color", GT_Util.getRGBInt(aMaterial.getRGBA()));
        }
        return this;
    }

    public MultiTileEntityClassContainer color(int aRPG) {
        this.mParameters.func_74768_a("gt.color", aRPG);
        return this;
    }

    public MultiTileEntityClassContainer color(short[] aRPGA) {
        this.mParameters.func_74768_a("gt.color", GT_Util.getRGBInt(aRPGA));
        return this;
    }

    public MultiTileEntityClassContainer texture(String aTexture) {
        this.mParameters.func_74778_a("gt.texture", aTexture);
        return this;
    }

    public MultiTileEntityClassContainer inputInventorySize(int aSize) {
        this.mParameters.func_74768_a("gt.invsize.in", aSize);
        return this;
    }

    public MultiTileEntityClassContainer outputInventorySize(int aSize) {
        this.mParameters.func_74768_a("gt.invsize.out", aSize);
        return this;
    }

    public MultiTileEntityClassContainer tankCapacity(Long aCapacity) {
        this.mParameters.func_74772_a("gt.tankcap", aCapacity.longValue());
        return this;
    }

    public MultiTileEntityClassContainer tier(int aTier) {
        this.verifyDescendentOf(AdvancedCasing.class);
        this.mParameters.func_74768_a("gt.tier", aTier);
        return this;
    }

    public MultiTileEntityClassContainer upgradeInventorySize(int aSize) {
        this.verifyDescendentOf(AdvancedCasing.class);
        this.mParameters.func_74768_a("gt.invsize.upg", aSize);
        return this;
    }

    public MultiTileEntityClassContainer setNBT(String key, Object val) {
        return this.setNBT(new Tuple((Object)key, val));
    }

    public MultiTileEntityClassContainer setNBT(Tuple ... aTags) {
        this.mParameters = GT_Util.fuseNBT(this.mParameters, GT_Util.makeNBT(aTags));
        return this;
    }

    private void verifyDescendentOf(Class<?> cls) {
        if (!cls.isAssignableFrom(this.mClass)) {
            throw new IllegalArgumentException("Expected a descendent of " + cls.getName() + " got " + this.mClass.getName() + " instead.");
        }
    }
}

