/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.metatileentity.CoverableTileEntity;
import gregtech.api.multitileentity.MultiTileEntityBlockInternal;
import gregtech.api.multitileentity.MultiTileEntityClassContainer;
import gregtech.api.multitileentity.MultiTileEntityContainer;
import gregtech.api.multitileentity.interfaces.IItemUpdatable;
import gregtech.api.multitileentity.interfaces.IMultiTileEntity;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class MultiTileEntityItemInternal
extends ItemBlock
implements IFluidContainerItem,
IItemUpdatable {
    public final MultiTileEntityBlockInternal mBlock;

    public MultiTileEntityItemInternal(Block aBlock) {
        super(aBlock);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.mBlock = (MultiTileEntityBlockInternal)aBlock;
    }

    public void func_77624_a(ItemStack aStack, EntityPlayer aPlayer, List aList, boolean aF3_H) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer == null) {
            aList.add("INVALID ITEM!");
            return;
        }
        if (tTileEntityContainer.mTileEntity instanceof IMultiTileEntity.IMTE_AddToolTips) {
            try {
                ((IMultiTileEntity.IMTE_AddToolTips)tTileEntityContainer.mTileEntity).addToolTips(aList, aStack, aF3_H);
            }
            catch (Throwable e) {
                GT_Mod.GT_FML_LOGGER.error("addInformation", e);
            }
        }
        NBTTagCompound aNBT = aStack.func_77978_p();
        CoverableTileEntity.addInstalledCoversInformation(aNBT, aList);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item aItem, CreativeTabs aTab, List aList) {
        for (MultiTileEntityClassContainer tClass : this.mBlock.mMultiTileEntityRegistry.mRegistrations) {
            if (tClass.mHidden || !tClass.mCanonicalTileEntity.getSubItems(this.mBlock, aItem, aTab, aList, tClass.mID)) continue;
            aList.add(this.mBlock.mMultiTileEntityRegistry.getItem(tClass.mID));
        }
    }

    public boolean func_77648_a(ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide, float aHitX, float aHitY, float aHitZ) {
        block21: {
            if (aY < 0 || aY > aWorld.func_72800_K()) {
                return false;
            }
            try {
                Block tClickedBlock = aWorld.func_147439_a(aX, aY, aZ);
                if (tClickedBlock instanceof BlockSnow && (aWorld.func_72805_g(aX, aY, aZ) & 7) < 1) {
                    aSide = 1;
                } else if (tClickedBlock != Blocks.field_150395_bd && tClickedBlock != Blocks.field_150329_H && tClickedBlock != Blocks.field_150330_I && !tClickedBlock.isReplaceable((IBlockAccess)aWorld, aX, aY, aZ)) {
                    aX += GT_Values.OFFX[aSide];
                    aY += GT_Values.OFFY[aSide];
                    aZ += GT_Values.OFFZ[aSide];
                }
                Block tReplacedBlock = aWorld.func_147439_a(aX, aY, aZ);
                if (!tReplacedBlock.isReplaceable((IBlockAccess)aWorld, aX, aY, aZ) || !this.mBlock.func_149705_a(aWorld, aX, aY, aZ, aSide, aStack)) {
                    return false;
                }
                if (aStack.field_77994_a == 0 || aPlayer != null && !aPlayer.func_82247_a(aX, aY, aZ, aSide, aStack)) {
                    return false;
                }
                MultiTileEntityContainer aMTEContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aWorld, aX, aY, aZ, aStack);
                if (aMTEContainer == null || aPlayer != null && !aPlayer.func_70093_af() && aMTEContainer.mTileEntity instanceof IMultiTileEntity.IMTE_OnlyPlaceableWhenSneaking && ((IMultiTileEntity.IMTE_OnlyPlaceableWhenSneaking)aMTEContainer.mTileEntity).onlyPlaceableWhenSneaking() || !aWorld.func_72855_b(AxisAlignedBB.func_72330_a((double)aX, (double)aY, (double)aZ, (double)(aX + 1), (double)(aY + 1), (double)(aZ + 1))) && (!(aMTEContainer.mTileEntity instanceof IMultiTileEntity.IMTE_IgnoreEntityCollisionWhenPlacing) || !((IMultiTileEntity.IMTE_IgnoreEntityCollisionWhenPlacing)aMTEContainer.mTileEntity).ignoreEntityCollisionWhenPlacing(aStack, aPlayer, aWorld, aX, aY, aZ, (byte)aSide, aHitX, aHitY, aHitZ)) || aMTEContainer.mTileEntity instanceof IMultiTileEntity.IMTE_CanPlace && !((IMultiTileEntity.IMTE_CanPlace)aMTEContainer.mTileEntity).canPlace(aStack, aPlayer, aWorld, aX, aY, aZ, (byte)aSide, aHitX, aHitY, aHitZ) || !aWorld.func_147465_d(aX, aY, aZ, (Block)aMTEContainer.mBlock, 15 - aMTEContainer.mBlockMetaData, 2)) break block21;
                aMTEContainer.setMultiTile(aWorld, aX, aY, aZ);
                try {
                    if (((IMultiTileEntity)aMTEContainer.mTileEntity).onPlaced(aStack, aPlayer, aWorld, aX, aY, aZ, (byte)aSide, aHitX, aHitY, aHitZ)) {
                        aWorld.func_72908_a((double)aX + 0.5, (double)aY + 0.5, (double)aZ + 0.5, aMTEContainer.mBlock.field_149762_H.func_150496_b(), (aMTEContainer.mBlock.field_149762_H.func_150497_c() + 1.0f) / 2.0f, aMTEContainer.mBlock.field_149762_H.func_150494_d() * 0.8f);
                    }
                }
                catch (Throwable e) {
                    GT_Mod.GT_FML_LOGGER.error("onPlaced", e);
                }
                try {
                    if (aMTEContainer.mTileEntity instanceof IMultiTileEntity.IMTE_HasMultiBlockMachineRelevantData && ((IMultiTileEntity.IMTE_HasMultiBlockMachineRelevantData)aMTEContainer.mTileEntity).hasMultiBlockMachineRelevantData()) {
                        GregTech_API.causeMachineUpdate(aWorld, aX, aY, aZ);
                    }
                }
                catch (Throwable e) {
                    GT_Mod.GT_FML_LOGGER.error("causeMachineUpdate", e);
                }
                try {
                    if (!aWorld.field_72995_K) {
                        aWorld.func_147444_c(aX, aY, aZ, tReplacedBlock);
                        aWorld.func_147453_f(aX, aY, aZ, (Block)aMTEContainer.mBlock);
                    }
                }
                catch (Throwable e) {
                    GT_Mod.GT_FML_LOGGER.error("notifyBlockChange", e);
                }
                try {
                    ((IMultiTileEntity)aMTEContainer.mTileEntity).onTileEntityPlaced();
                }
                catch (Throwable e) {
                    GT_Mod.GT_FML_LOGGER.error("onTileEntityPlaced", e);
                }
                try {
                    aWorld.func_147451_t(aX, aY, aZ);
                }
                catch (Throwable e) {
                    GT_Mod.GT_FML_LOGGER.error("updateAllLightTypes", e);
                }
                --aStack.field_77994_a;
                return true;
            }
            catch (Throwable e) {
                GT_Mod.GT_FML_LOGGER.error("onItemUse", e);
            }
        }
        return false;
    }

    @Override
    public void updateItemStack(ItemStack aStack) {
        MultiTileEntityClassContainer tContainer = this.mBlock.mMultiTileEntityRegistry.getClassContainer(aStack);
        if (tContainer == null) {
            return;
        }
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IItemUpdatable) {
            ((IItemUpdatable)tTileEntityContainer.mTileEntity).updateItemStack(aStack);
        }
    }

    @Override
    public void updateItemStack(ItemStack aStack, World aWorld, int aX, int aY, int aZ) {
        MultiTileEntityClassContainer tContainer = this.mBlock.mMultiTileEntityRegistry.getClassContainer(aStack);
        if (tContainer == null) {
            return;
        }
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IItemUpdatable) {
            ((IItemUpdatable)tTileEntityContainer.mTileEntity).updateItemStack(aStack, aWorld, aX, aY, aZ);
        }
    }

    public int getItemStackLimit(ItemStack aStack) {
        MultiTileEntityClassContainer tContainer = this.mBlock.mMultiTileEntityRegistry.getClassContainer(aStack);
        if (tContainer == null) {
            return 1;
        }
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IMultiTileEntity.IMTE_GetMaxStackSize) {
            return ((IMultiTileEntity.IMTE_GetMaxStackSize)tTileEntityContainer.mTileEntity).getMaxStackSize(aStack, tContainer.mStackSize);
        }
        return tContainer.mStackSize;
    }

    public void func_77622_d(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        this.updateItemStack(aStack);
    }

    public FluidStack getFluid(ItemStack aStack) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IFluidContainerItem) {
            FluidStack rFluid = ((IFluidContainerItem)tTileEntityContainer.mTileEntity).getFluid(aStack);
            this.updateItemStack(aStack);
            return rFluid;
        }
        return null;
    }

    public int getCapacity(ItemStack aStack) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IFluidContainerItem) {
            int rCapacity = ((IFluidContainerItem)tTileEntityContainer.mTileEntity).getCapacity(aStack);
            this.updateItemStack(aStack);
            return rCapacity;
        }
        return 0;
    }

    public int fill(ItemStack aStack, FluidStack aFluid, boolean aDoFill) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IFluidContainerItem) {
            int tFilled = ((IFluidContainerItem)tTileEntityContainer.mTileEntity).fill(aStack, aFluid, aDoFill);
            this.updateItemStack(aStack);
            return tFilled;
        }
        return 0;
    }

    public FluidStack drain(ItemStack aStack, int aMaxDrain, boolean aDoDrain) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IFluidContainerItem) {
            FluidStack rFluid = ((IFluidContainerItem)tTileEntityContainer.mTileEntity).drain(aStack, aMaxDrain, aDoDrain);
            this.updateItemStack(aStack);
            return rFluid;
        }
        return null;
    }

    public boolean func_150936_a(World aWorld, int aX, int aY, int aZ, int aSide, EntityPlayer aPlayer, ItemStack aStack) {
        return true;
    }

    public final String func_77658_a() {
        return this.mBlock.mMultiTileEntityRegistry.mNameInternal;
    }

    public final String func_77667_c(ItemStack aStack) {
        return this.mBlock.mMultiTileEntityRegistry.mNameInternal + "." + this.getDamage(aStack);
    }

    public int func_94901_k() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister aRegister) {
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int aMeta) {
        this.field_77791_bV = Items.field_151025_P.func_77617_a(0);
        return this.field_77791_bV;
    }

    public boolean func_77630_h(ItemStack aStack) {
        return false;
    }

    public final boolean func_77651_p() {
        return true;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_82789_a(ItemStack aStack, ItemStack aMaterial) {
        return false;
    }

    public ItemStack getContainerItem(ItemStack aStack) {
        return null;
    }

    public final boolean hasContainerItem(ItemStack aStack) {
        return this.getContainerItem(aStack) != null;
    }

    public boolean isBookEnchantable(ItemStack aStack, ItemStack aBook) {
        return false;
    }
}

