/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity.base;

import gregtech.GT_Mod;
import gregtech.api.multitileentity.base.BaseMultiTileEntity;
import gregtech.api.multitileentity.interfaces.IMultiTileEntity;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_Util;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;

public abstract class BaseTickableMultiTileEntity
extends BaseMultiTileEntity
implements IMultiTileEntity.IMTE_OnNeighborBlockChange {
    public boolean mIsRunningTick = false;
    public boolean mBlockUpdated = false;
    protected long mTimer = 0L;
    private boolean mSendClientData = false;

    public BaseTickableMultiTileEntity() {
        super(true);
    }

    @Override
    public final void func_145845_h() {
        this.mIsRunningTick = true;
        boolean isServerSide = this.isServerSide();
        try {
            if (this.mTimer++ == 0L) {
                this.func_70296_d();
                GT_Util.markChunkDirty(this);
                this.onFirstTick(isServerSide);
            }
            if (!this.isDead()) {
                this.onPreTick(this.mTimer, isServerSide);
            }
            if (!this.isDead()) {
                ++this.mTimer;
                super.func_145845_h();
            }
            if (!isServerSide && this.mNeedsUpdate) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.mNeedsUpdate = false;
            }
            if (!this.isDead()) {
                this.onTick(this.mTimer, isServerSide);
            }
            if (!this.isDead() && isServerSide && this.mTimer > 2L && this.mSendClientData) {
                this.sendClientData(null);
            }
            if (!this.isDead()) {
                this.onPostTick(this.mTimer, isServerSide);
            }
        }
        catch (Throwable e) {
            GT_Mod.GT_FML_LOGGER.error("UpdateEntity Failed", e);
            e.printStackTrace(GT_Log.err);
            try {
                this.onTickFailed(this.mTimer, isServerSide);
            }
            catch (Throwable e2) {
                GT_Mod.GT_FML_LOGGER.error("UpdateEntity:onTickFailed Failed", e);
            }
        }
        this.mIsRunningTick = false;
    }

    @Override
    public void sendClientData(EntityPlayerMP aPlayer) {
        if (this.mSendClientData) {
            GT_Mod.GT_FML_LOGGER.info("Sending client data");
            super.sendClientData(aPlayer);
            this.mSendClientData = false;
        }
    }

    public void onFirstTick(boolean isServerSide) {
        if (isServerSide) {
            this.checkDropCover();
        } else {
            this.requestCoverDataIfNeeded();
        }
    }

    public void onPreTick(long aTick, boolean isServerSide) {
    }

    public void onTick(long aTimer, boolean isServerSide) {
    }

    public void onPostTick(long aTick, boolean isServerSide) {
    }

    public void onTickFailed(long aTimer, boolean isServerSide) {
    }

    @Override
    public void onNeighborBlockChange(World aWorld, Block aBlock) {
        this.mBlockUpdated = true;
    }

    @Override
    public void issueClientUpdate() {
        this.mSendClientData = true;
    }

    @Override
    public byte getComparatorValue(byte aSide) {
        return 0;
    }
}

