/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity.machine;

import com.google.common.primitives.Ints;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.forge.ItemStackHandler;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.fluid.FluidTankGT;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.multitileentity.MultiTileEntityRegistry;
import gregtech.api.multitileentity.base.BaseTickableMultiTileEntity;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Util;
import gregtech.api.util.GT_Utility;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class MultiTileBasicMachine
extends BaseTickableMultiTileEntity {
    protected static final IItemHandlerModifiable EMPTY_INVENTORY = new ItemStackHandler(0);
    private static final String TEXTURE_LOCATION = "multitileentity/machines/";
    public IIconContainer[] mTexturesInactive = GT_Values.emptyIconContainerArray;
    public IIconContainer[] mTexturesActive = GT_Values.emptyIconContainerArray;
    protected int mParallel = 1;
    protected boolean mActive = false;
    protected long mStoredEnergy = 0L;
    protected FluidTankGT[] mTanksInput = GT_Values.emptyFluidTankGT;
    protected FluidTankGT[] mTanksOutput = GT_Values.emptyFluidTankGT;
    protected FluidStack[] mOutputFluids = GT_Values.emptyFluidStack;
    protected IItemHandlerModifiable mInputInventory = EMPTY_INVENTORY;
    protected IItemHandlerModifiable mOutputInventory = EMPTY_INVENTORY;
    protected boolean mOutputInventoryChanged = false;

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.machine.basic";
    }

    @Override
    public void writeMultiTileNBT(NBTTagCompound aNBT) {
        int i;
        super.writeMultiTileNBT(aNBT);
        if (this.mParallel > 0) {
            aNBT.func_74768_a("gt.parallel", this.mParallel);
        }
        if (this.mActive) {
            aNBT.func_74757_a("gt.active", this.mActive);
        }
        if (this.mInputInventory != null && this.mInputInventory.getSlots() > 0) {
            this.writeInventory(aNBT, this.mInputInventory, "gt.invlist.in");
        }
        if (this.mOutputInventory != null && this.mOutputInventory.getSlots() > 0) {
            this.writeInventory(aNBT, this.mOutputInventory, "gt.invlist.out");
        }
        for (i = 0; i < this.mTanksInput.length; ++i) {
            this.mTanksInput[i].writeToNBT(aNBT, "gt.tank.in." + i);
        }
        for (i = 0; i < this.mTanksOutput.length; ++i) {
            this.mTanksOutput[i].writeToNBT(aNBT, "gt.tank.out." + i);
        }
        if (this.mOutputFluids != null && this.mOutputFluids.length > 0) {
            this.writeFluids(aNBT, this.mOutputFluids, "gt.fluidout");
        }
    }

    protected void writeFluids(NBTTagCompound aNBT, FluidStack[] fluids, String fluidListTag) {
        if (fluids != null && fluids.length > 0) {
            NBTTagList tList = new NBTTagList();
            for (FluidStack tFluid : fluids) {
                if (tFluid == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tFluid.writeToNBT(tag);
                tList.func_74742_a((NBTBase)tag);
            }
            aNBT.func_74782_a(fluidListTag, (NBTBase)tList);
        }
    }

    protected void writeInventory(NBTTagCompound aNBT, IItemHandlerModifiable inv, String invListTag) {
        if (inv != null && inv.getSlots() > 0) {
            NBTTagList tList = new NBTTagList();
            for (int tSlot = 0; tSlot < inv.getSlots(); ++tSlot) {
                ItemStack tStack = inv.getStackInSlot(tSlot);
                if (tStack == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74774_a("s", (byte)tSlot);
                tStack.func_77955_b(tag);
                tList.func_74742_a((NBTBase)tag);
            }
            aNBT.func_74782_a(invListTag, (NBTBase)tList);
        }
    }

    @Override
    public void readMultiTileNBT(NBTTagCompound aNBT) {
        int i;
        super.readMultiTileNBT(aNBT);
        if (aNBT.func_74764_b("gt.parallel")) {
            this.mParallel = Math.max(1, aNBT.func_74762_e("gt.parallel"));
        }
        if (aNBT.func_74764_b("gt.active")) {
            this.mActive = aNBT.func_74767_n("gt.active");
        }
        this.mInputInventory = new ItemStackHandler(Math.max(aNBT.func_74762_e("gt.invsize.in"), 0));
        this.mOutputInventory = new ItemStackHandler(Math.max(aNBT.func_74762_e("gt.invsize.out"), 0));
        this.loadInventory(aNBT, this.mInputInventory, "gt.invlist.in");
        this.loadInventory(aNBT, this.mOutputInventory, "gt.invlist.out");
        long tCapacity = 1000L;
        if (aNBT.func_74764_b("gt.tankcap")) {
            tCapacity = Ints.saturatedCast((long)aNBT.func_74763_f("gt.tankcap"));
        }
        this.mTanksInput = new FluidTankGT[this.getFluidInputCount()];
        this.mTanksOutput = new FluidTankGT[this.getFluidOutputCount()];
        this.mOutputFluids = new FluidStack[this.getFluidOutputCount()];
        for (i = 0; i < this.mTanksInput.length; ++i) {
            this.mTanksInput[i] = new FluidTankGT(tCapacity).setCapacityMultiplier((long)this.mParallel * 2L).readFromNBT(aNBT, "gt.tank.in." + i);
        }
        for (i = 0; i < this.mTanksOutput.length; ++i) {
            this.mTanksOutput[i] = new FluidTankGT().readFromNBT(aNBT, "gt.tank.out." + i);
        }
        for (i = 0; i < this.mOutputFluids.length; ++i) {
            this.mOutputFluids[i] = FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT.func_74775_l("gt.fluidout." + i));
        }
    }

    protected void loadInventory(NBTTagCompound aNBT, IItemHandlerModifiable inv, String invListTag) {
        NBTTagList tList = aNBT.func_150295_c(invListTag, 10);
        for (int i = 0; i < tList.func_74745_c(); ++i) {
            NBTTagCompound tNBT = tList.func_150305_b(i);
            short tSlot = tNBT.func_74765_d("s");
            if (tSlot < 0 || tSlot >= inv.getSlots()) continue;
            inv.setStackInSlot((int)tSlot, GT_Utility.loadItem(tNBT));
        }
    }

    @Override
    public void loadTextureNBT(NBTTagCompound aNBT) {
        String textureName = aNBT.func_74779_i("gt.texture");
        this.mTextures = new IIconContainer[]{new Textures.BlockIcons.CustomIcon(TEXTURE_LOCATION + textureName + "/bottom"), new Textures.BlockIcons.CustomIcon(TEXTURE_LOCATION + textureName + "/top"), new Textures.BlockIcons.CustomIcon(TEXTURE_LOCATION + textureName + "/left"), new Textures.BlockIcons.CustomIcon(TEXTURE_LOCATION + textureName + "/front"), new Textures.BlockIcons.CustomIcon(TEXTURE_LOCATION + textureName + "/right"), new Textures.BlockIcons.CustomIcon(TEXTURE_LOCATION + textureName + "/side")};
        this.mTexturesInactive = new IIconContainer[]{new Textures.BlockIcons.CustomIcon(TEXTURE_LOCATION + textureName + "/overlay/inactive/bottom"), new Textures.BlockIcons.CustomIcon(TEXTURE_LOCATION + textureName + "/overlay/inactive/top"), new Textures.BlockIcons.CustomIcon(TEXTURE_LOCATION + textureName + "/overlay/inactive/left"), new Textures.BlockIcons.CustomIcon(TEXTURE_LOCATION + textureName + "/overlay/inactive/front"), new Textures.BlockIcons.CustomIcon(TEXTURE_LOCATION + textureName + "/overlay/inactive/right"), new Textures.BlockIcons.CustomIcon(TEXTURE_LOCATION + textureName + "/overlay/inactive/back")};
        this.mTexturesActive = new IIconContainer[]{new Textures.BlockIcons.CustomIcon(TEXTURE_LOCATION + textureName + "/overlay/active/bottom"), new Textures.BlockIcons.CustomIcon(TEXTURE_LOCATION + textureName + "/overlay/active/top"), new Textures.BlockIcons.CustomIcon(TEXTURE_LOCATION + textureName + "/overlay/active/left"), new Textures.BlockIcons.CustomIcon(TEXTURE_LOCATION + textureName + "/overlay/active/front"), new Textures.BlockIcons.CustomIcon(TEXTURE_LOCATION + textureName + "/overlay/active/right"), new Textures.BlockIcons.CustomIcon(TEXTURE_LOCATION + textureName + "/overlay/active/back")};
    }

    @Override
    public void copyTextures() {
        TileEntity tCanonicalTileEntity = MultiTileEntityRegistry.getCanonicalTileEntity(this.getMultiTileEntityRegistryID(), this.getMultiTileEntityID());
        if (tCanonicalTileEntity instanceof MultiTileBasicMachine) {
            this.mTextures = ((MultiTileBasicMachine)tCanonicalTileEntity).mTextures;
            this.mTexturesInactive = ((MultiTileBasicMachine)tCanonicalTileEntity).mTexturesInactive;
            this.mTexturesActive = ((MultiTileBasicMachine)tCanonicalTileEntity).mTexturesActive;
        } else {
            this.mTexturesActive = GT_Values.emptyIconContainerArray;
            this.mTexturesInactive = GT_Values.emptyIconContainerArray;
            this.mTextures = this.mTexturesInactive;
        }
    }

    @Override
    public ITexture[] getTexture(Block aBlock, byte aSide, boolean isActive, int aRenderPass) {
        return new ITexture[]{TextureFactory.of(this.mTextures[GT_Values.FACING_ROTATIONS[this.mFacing][aSide]], GT_Util.getRGBaArray(this.mRGBa)), TextureFactory.of((this.mActive ? this.mTexturesActive : this.mTexturesInactive)[GT_Values.FACING_ROTATIONS[this.mFacing][aSide]])};
    }

    public int getFluidInputCount() {
        return 7;
    }

    public int getFluidOutputCount() {
        return 3;
    }

    @Override
    public void setLightValue(byte aLightValue) {
    }

    public String func_145825_b() {
        String name = this.getCustomName();
        if (name != null) {
            return name;
        }
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(this.getMultiTileEntityRegistryID());
        return tRegistry == null ? this.getClass().getName() : tRegistry.getLocal(this.getMultiTileEntityID());
    }

    public boolean func_70300_a(EntityPlayer aPlayer) {
        return this.playerOwnsThis(aPlayer, false) && this.mTickTimer > 40L && this.getTileEntityOffset(0, 0, 0) == this && aPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 64.0 && this.allowInteraction((Entity)aPlayer);
    }

    @Override
    public boolean isLiquidInput(byte aSide) {
        return aSide != this.mFacing;
    }

    @Override
    public boolean isLiquidOutput(byte aSide) {
        return aSide != this.mFacing;
    }

    @Override
    protected IFluidTank[] getFluidTanks(byte aSide) {
        boolean fluidInput = this.isLiquidInput(aSide);
        boolean fluidOutput = this.isLiquidOutput(aSide);
        if (fluidInput && fluidOutput) {
            IFluidTank[] rTanks = new IFluidTank[this.mTanksInput.length + this.mTanksOutput.length];
            System.arraycopy(this.mTanksInput, 0, rTanks, 0, this.mTanksInput.length);
            System.arraycopy(this.mTanksOutput, 0, rTanks, this.mTanksInput.length, this.mTanksOutput.length);
            return rTanks;
        }
        if (fluidInput) {
            return this.mTanksInput;
        }
        if (fluidOutput) {
            return this.mTanksOutput;
        }
        return GT_Values.emptyFluidTank;
    }

    @Override
    public IFluidTank getFluidTankFillable(byte aSide, FluidStack aFluidToFill) {
        if (!this.isLiquidInput(aSide)) {
            return null;
        }
        for (FluidTankGT tankGT : this.mTanksInput) {
            if (!tankGT.contains(aFluidToFill)) continue;
            return tankGT;
        }
        for (FluidTankGT fluidTankGT : this.mTanksInput) {
            if (!fluidTankGT.isEmpty()) continue;
            return fluidTankGT;
        }
        return null;
    }

    @Override
    protected IFluidTank getFluidTankDrainable(byte aSide, FluidStack aFluidToDrain) {
        if (!this.isLiquidOutput(aSide)) {
            return null;
        }
        for (FluidTankGT fluidTankGT : this.mTanksOutput) {
            if (!(aFluidToDrain == null ? fluidTankGT.has() : fluidTankGT.contains(aFluidToDrain))) continue;
            return fluidTankGT;
        }
        return null;
    }

    @Override
    public boolean isEnetInput() {
        return true;
    }

    @Override
    public boolean isEnetOutput() {
        return true;
    }

    @Override
    public boolean isUniversalEnergyStored(long aEnergyAmount) {
        return this.getUniversalEnergyStored() >= aEnergyAmount;
    }

    @Override
    public long getUniversalEnergyStored() {
        return this.mStoredEnergy;
    }

    @Override
    public long getUniversalEnergyCapacity() {
        return 0L;
    }

    @Override
    public long getOutputAmperage() {
        return 1L;
    }

    @Override
    public long getOutputVoltage() {
        return 1L;
    }

    @Override
    public long getInputAmperage() {
        return 1L;
    }

    @Override
    public long getInputVoltage() {
        return 1L;
    }

    public boolean isEnergyInputSide(byte aSide) {
        return true;
    }

    public boolean isEnergyOutputSide(byte aSide) {
        return true;
    }

    @Override
    public boolean inputEnergyFrom(byte aSide) {
        if (aSide == 6) {
            return true;
        }
        if (aSide >= 0 && aSide < 6) {
            if (this.func_145837_r()) {
                return false;
            }
            if (!this.getCoverInfoAtSide(aSide).letsEnergyIn()) {
                return false;
            }
            if (this.isEnetInput()) {
                return this.isEnergyInputSide(aSide);
            }
        }
        return false;
    }

    @Override
    public boolean outputsEnergyTo(byte aSide) {
        if (aSide == 6) {
            return true;
        }
        if (aSide >= 0 && aSide < 6) {
            if (this.func_145837_r()) {
                return false;
            }
            if (!this.getCoverInfoAtSide(aSide).letsEnergyOut()) {
                return false;
            }
            if (this.isEnetOutput()) {
                return this.isEnergyOutputSide(aSide);
            }
        }
        return false;
    }

    @Override
    public boolean hasInventoryBeenModified() {
        return this.mInventoryChanged;
    }

    public void markOutputInventoryBeenModified() {
        this.mOutputInventoryChanged = true;
    }

    public boolean hasOutputInventoryBeenModified() {
        return this.mOutputInventoryChanged;
    }

    @Override
    public boolean func_94041_b(int aSlot, ItemStack aStack) {
        return false;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }
}

