/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.gtnewhorizon.gtnhlib.util.map.ItemStackMap;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.multitileentity.multiblock.base.MultiBlockController;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.GT_MetaTileEntity_Hatch_OutputBus_ME;
import gregtech.common.tileentities.machines.GT_MetaTileEntity_Hatch_Output_ME;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.MutableTriple;

public class GT_ParallelHelper {
    private GT_MetaTileEntity_MultiBlockBase mMachineMeta;
    private MultiBlockController mMachineMulti;
    private GT_Recipe mRecipe;
    private long mAvailableEUt;
    private int mCurrentParallel = 0;
    private int mMaxParallel = 1;
    private int mBatchModifier = 1;
    private ItemStack[] mItemInputs;
    private ItemStack[] mItemOutputs;
    private FluidStack[] mFluidInputs;
    private FluidStack[] mFluidOutputs;
    private boolean mVoidProtection;
    private boolean mConsume;
    private boolean mBatchMode;
    private boolean mCalculateOutputs;
    private boolean mBuilt;
    private float mDurationMultiplier;
    private float mEUtModifier = 1.0f;

    public GT_ParallelHelper enableVoidProtection(GT_MetaTileEntity_MultiBlockBase aMachineMeta) {
        this.mVoidProtection = true;
        this.mMachineMeta = aMachineMeta;
        return this;
    }

    public GT_ParallelHelper enableVoidProtection(MultiBlockController aMachineMulti) {
        this.mVoidProtection = true;
        this.mMachineMulti = aMachineMulti;
        return this;
    }

    public GT_ParallelHelper setRecipe(GT_Recipe aRecipe) {
        this.mRecipe = aRecipe;
        return this;
    }

    public GT_ParallelHelper setItemInputs(ItemStack ... aItemInputs) {
        this.mItemInputs = aItemInputs;
        return this;
    }

    public GT_ParallelHelper setFluidInputs(FluidStack ... aFluidInputs) {
        this.mFluidInputs = aFluidInputs;
        return this;
    }

    public GT_ParallelHelper setAvailableEUt(long aAvailableEUt) {
        this.mAvailableEUt = aAvailableEUt;
        return this;
    }

    public GT_ParallelHelper setEUtModifier(float aEUtModifier) {
        this.mEUtModifier = aEUtModifier;
        return this;
    }

    public GT_ParallelHelper enableConsumption() {
        this.mConsume = true;
        return this;
    }

    public GT_ParallelHelper setMaxParallel(int aMaxParallel) {
        this.mMaxParallel = aMaxParallel;
        return this;
    }

    public GT_ParallelHelper enableBatchMode(int aBatchModifier) {
        this.mBatchMode = true;
        this.mBatchModifier = aBatchModifier;
        return this;
    }

    public GT_ParallelHelper enableOutputCalculation() {
        this.mCalculateOutputs = true;
        return this;
    }

    public GT_ParallelHelper build() {
        if (this.mBuilt) {
            throw new IllegalStateException("Tried to build twice");
        }
        this.mBuilt = true;
        this.determineParallel();
        return this;
    }

    public int getCurrentParallel() {
        if (!this.mBuilt) {
            throw new IllegalStateException("Tried to get parallels before building");
        }
        return this.mCurrentParallel;
    }

    public float getDurationMultiplier() {
        if (!this.mBuilt) {
            throw new IllegalStateException("Tried to get duration multiplier before building");
        }
        if (this.mBatchMode) {
            return this.mDurationMultiplier;
        }
        return 1.0f;
    }

    public ItemStack[] getItemOutputs() {
        if (!this.mBuilt || !this.mCalculateOutputs) {
            throw new IllegalStateException("Tried to get item outputs before building or without enabling calculation of outputs");
        }
        return this.mItemOutputs;
    }

    public FluidStack[] getFluidOutputs() {
        if (!this.mBuilt || !this.mCalculateOutputs) {
            throw new IllegalStateException("Tried to get fluid outputs before building or without enabling calculation of outputs");
        }
        return this.mFluidOutputs;
    }

    /*
     * WARNING - void declaration
     */
    protected void determineParallel() {
        if ((long)this.mRecipe.mEUt > this.mAvailableEUt) {
            return;
        }
        ItemStack[] tItemInputs = null;
        FluidStack[] tFluidInputs = null;
        boolean tMEOutputBus = false;
        boolean tMEOutputHatch = false;
        long tCurrentUsage = 0L;
        if (this.mConsume) {
            tItemInputs = this.mItemInputs;
            tFluidInputs = this.mFluidInputs;
        } else {
            int i;
            if (this.mItemInputs == null) {
                tItemInputs = new ItemStack[]{};
            } else {
                tItemInputs = new ItemStack[this.mItemInputs.length];
                for (i = 0; i < this.mItemInputs.length; ++i) {
                    tItemInputs[i] = this.mItemInputs[i].func_77946_l();
                }
            }
            if (this.mFluidInputs == null) {
                this.mFluidInputs = new FluidStack[0];
            } else {
                tFluidInputs = new FluidStack[this.mFluidInputs.length];
                for (i = 0; i < this.mFluidInputs.length; ++i) {
                    tFluidInputs[i] = this.mFluidInputs[i].copy();
                }
            }
        }
        if (this.mBatchMode) {
            this.mMaxParallel *= this.mBatchModifier;
        }
        if (this.mVoidProtection) {
            for (GT_MetaTileEntity_Hatch gT_MetaTileEntity_Hatch : this.mMachineMeta.mOutputBusses) {
                if (!(gT_MetaTileEntity_Hatch instanceof GT_MetaTileEntity_Hatch_OutputBus_ME)) continue;
                tMEOutputBus = true;
                break;
            }
            for (GT_MetaTileEntity_Hatch gT_MetaTileEntity_Hatch : this.mMachineMeta.mOutputHatches) {
                if (!(gT_MetaTileEntity_Hatch instanceof GT_MetaTileEntity_Hatch_Output_ME)) continue;
                tMEOutputHatch = true;
                break;
            }
            if (!tMEOutputBus) {
                this.mMaxParallel = Math.min(this.calculateMaxParallelsForBusses(), this.mMaxParallel);
            }
            if (!tMEOutputHatch) {
                this.mMaxParallel = Math.min(this.calculateMaxParallelsForHatches(), this.mMaxParallel);
            }
        }
        float tRecipeEUt = (float)this.mRecipe.mEUt * this.mEUtModifier;
        while (this.mCurrentParallel < this.mMaxParallel / this.mBatchModifier && (float)tCurrentUsage < (float)this.mAvailableEUt - tRecipeEUt && this.mRecipe.isRecipeInputEqual(true, false, tFluidInputs, tItemInputs)) {
            tCurrentUsage = (long)((float)tCurrentUsage + tRecipeEUt);
            ++this.mCurrentParallel;
        }
        if (this.mBatchMode) {
            void var8_13;
            boolean bl = false;
            while (var8_13 < this.mCurrentParallel * (this.mBatchModifier - 1) && this.mRecipe.isRecipeInputEqual(false, false, tFluidInputs, tItemInputs)) {
                this.mRecipe.isRecipeInputEqual(true, false, tFluidInputs, tItemInputs);
                ++var8_13;
            }
            this.mDurationMultiplier = 1.0f + (float)var8_13 / (float)this.mCurrentParallel;
            this.mCurrentParallel += var8_13;
        }
        if (this.mCalculateOutputs) {
            if (this.mRecipe.mOutputs != null) {
                void var8_15;
                this.mItemOutputs = new ItemStack[this.mRecipe.mOutputs.length];
                boolean bl = false;
                while (var8_15 < this.mRecipe.mOutputs.length) {
                    if (this.mRecipe.getOutputChance((int)var8_15) >= XSTR.XSTR_INSTANCE.nextInt(10000)) {
                        if (this.mRecipe.getOutput((int)var8_15) == null) {
                            this.mItemOutputs[var8_15] = null;
                        } else {
                            ItemStack tItem = this.mRecipe.getOutput((int)var8_15).func_77946_l();
                            tItem.field_77994_a *= this.mCurrentParallel;
                            this.mItemOutputs[var8_15] = tItem;
                        }
                    }
                    ++var8_15;
                }
            }
            if (this.mRecipe.mFluidOutputs != null) {
                void var8_17;
                this.mFluidOutputs = new FluidStack[this.mRecipe.mFluidOutputs.length];
                boolean bl = false;
                while (var8_17 < this.mRecipe.mFluidOutputs.length) {
                    if (this.mRecipe.getFluidOutput((int)var8_17) == null) {
                        this.mFluidOutputs[var8_17] = null;
                    } else {
                        FluidStack tFluid = this.mRecipe.getFluidOutput((int)var8_17).copy();
                        tFluid.amount *= this.mCurrentParallel;
                        this.mFluidOutputs[var8_17] = tFluid;
                    }
                    ++var8_17;
                }
            }
        }
    }

    private int calculateMaxParallelsForHatches() {
        if (this.mMachineMeta != null && this.mMachineMeta.mOutputHatches.size() >= this.mRecipe.mFluidOutputs.length) {
            HashMap<FluidStack, Integer> tFluidOutputMap = new HashMap<FluidStack, Integer>();
            HashMap<FluidStack, MutablePair> tParallels = new HashMap<FluidStack, MutablePair>();
            for (FluidStack aY : this.mRecipe.mFluidOutputs) {
                if (aY == null) continue;
                tFluidOutputMap.merge(aY, aY.amount, Integer::sum);
                tParallels.put(aY, new MutablePair((Object)0, (Object)0));
            }
            if (tFluidOutputMap.isEmpty()) {
                return this.mMaxParallel;
            }
            for (GT_MetaTileEntity_Hatch_Output tHatch : this.mMachineMeta.mOutputHatches) {
                int tSpaceLeft = tHatch.getCapacity() - tHatch.getFluidAmount();
                if (tSpaceLeft <= 0 || tHatch.mMode == 0 && tHatch.getFluidAmount() == 0) continue;
                String tLockedFluidName = tHatch.getLockedFluidName();
                for (Map.Entry entry : tParallels.entrySet()) {
                    FluidStack tFluidOutput = (FluidStack)entry.getKey();
                    if (!GT_ModHandler.isSteam(tFluidOutput) ? !tHatch.outputsLiquids() || tHatch.isFluidLocked() && tLockedFluidName != null && !tLockedFluidName.equals(tFluidOutput.getFluid().getName()) : !tHatch.outputsSteam()) continue;
                    if (tHatch.getFluidAmount() != 0 && !GT_Utility.areFluidsEqual(tHatch.getFluid(), tFluidOutput)) continue;
                    MutablePair tParallel = (MutablePair)entry.getValue();
                    Integer tCraftSize = (Integer)tFluidOutputMap.get(tFluidOutput);
                    MutablePair mutablePair = tParallel;
                    Integer.valueOf((Integer)mutablePair.left + ((Integer)tParallel.right + tSpaceLeft) / tCraftSize);
                    mutablePair.left = mutablePair.left;
                    tParallel.right = ((Integer)tParallel.right + tSpaceLeft) % tCraftSize;
                }
            }
            PriorityQueue<MutableTriple> aParallelQueue = new PriorityQueue<MutableTriple>(Comparator.comparing(MutableTriple::getLeft));
            for (Map.Entry entry : tParallels.entrySet()) {
                aParallelQueue.add(new MutableTriple(((MutablePair)entry.getValue()).left, ((MutablePair)entry.getValue()).right, entry.getKey()));
            }
            for (GT_MetaTileEntity_Hatch_Output tHatch : this.mMachineMeta.mOutputHatches) {
                if (tHatch.getFluidAmount() > 0 || tHatch.mMode != 0) continue;
                MutableTriple tParallel = aParallelQueue.poll();
                assert (tParallel != null);
                Integer tCraftSize = (Integer)tFluidOutputMap.get(tParallel.right);
                int tSpaceLeft = tHatch.getCapacity();
                MutableTriple mutableTriple = tParallel;
                Integer.valueOf((Integer)mutableTriple.left + ((Integer)tParallel.middle + tSpaceLeft) / tCraftSize);
                mutableTriple.left = mutableTriple.left;
                tParallel.middle = ((Integer)tParallel.middle + tSpaceLeft) % tCraftSize;
                aParallelQueue.add(tParallel);
            }
            return (Integer)((MutableTriple)aParallelQueue.element()).left;
        }
        return 0;
    }

    private int calculateMaxParallelsForBusses() {
        ItemStackMap tItemOutputMap = new ItemStackMap();
        ItemStackMap tParallels = new ItemStackMap();
        int tSlotsFree = 0;
        for (ItemStack tItem : this.mRecipe.mOutputs) {
            tItemOutputMap.merge(tItem, tItem.field_77994_a, Integer::sum);
            tParallels.put(tItem, new MutablePair((Object)0, (Object)0));
        }
        if (tItemOutputMap.isEmpty()) {
            return this.mMaxParallel;
        }
        if (this.mRecipe.mOutputs.length > 0 && this.mMachineMeta != null) {
            for (GT_MetaTileEntity_Hatch gT_MetaTileEntity_Hatch : this.mMachineMeta.mOutputBusses) {
                if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(gT_MetaTileEntity_Hatch)) continue;
                IGregTechTileEntity tBusInv = gT_MetaTileEntity_Hatch.getBaseMetaTileEntity();
                for (int i = 0; i < tBusInv.func_70302_i_(); ++i) {
                    MutablePair tParallel;
                    ItemStack tBusStack = gT_MetaTileEntity_Hatch.func_70301_a(i);
                    if (tBusStack == null) {
                        ++tSlotsFree;
                        continue;
                    }
                    int tMaxBusStackSize = tBusStack.func_77976_d();
                    if (tBusStack.field_77994_a >= tMaxBusStackSize) continue;
                    int tSpaceLeft = tMaxBusStackSize - tBusStack.field_77994_a;
                    Integer tCraftSize = (Integer)tItemOutputMap.get(tBusStack);
                    if (tCraftSize == null) continue;
                    MutablePair mutablePair = tParallel = (MutablePair)tParallels.get(tBusStack);
                    Integer.valueOf((Integer)mutablePair.left + ((Integer)tParallel.right + tSpaceLeft) / tCraftSize);
                    mutablePair.left = mutablePair.left;
                    tParallel.right = ((Integer)tParallel.right + tSpaceLeft) % tCraftSize;
                }
            }
            PriorityQueue<MutableTriple> aParallelQueue = new PriorityQueue<MutableTriple>(Comparator.comparing(MutableTriple::getLeft));
            for (Map.Entry entry : tParallels.entrySet()) {
                aParallelQueue.add(new MutableTriple(((MutablePair)entry.getValue()).left, ((MutablePair)entry.getValue()).right, entry.getKey()));
            }
            while (tSlotsFree > 0) {
                MutableTriple mutableTriple = aParallelQueue.poll();
                assert (mutableTriple != null);
                Integer tCraftSize = (Integer)tItemOutputMap.get(mutableTriple.right);
                int tStackSize = ((ItemStack)mutableTriple.right).func_77976_d();
                MutableTriple mutableTriple2 = mutableTriple;
                Integer.valueOf((Integer)mutableTriple2.left + ((Integer)mutableTriple.middle + tStackSize) / tCraftSize);
                mutableTriple2.left = mutableTriple2.left;
                mutableTriple.middle = ((Integer)mutableTriple.middle + tStackSize) % tCraftSize;
                aParallelQueue.add(mutableTriple);
                --tSlotsFree;
            }
            return (Integer)((MutableTriple)aParallelQueue.element()).left;
        }
        return 0;
    }
}

