/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHeatingCoil;
import gregtech.api.util.GT_LanguageManager;
import gregtech.common.blocks.GT_Block_Casings_Abstract;
import gregtech.common.blocks.GT_Item_Casings5;
import gregtech.common.blocks.GT_Material_Casings;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class GT_Block_Casings5
extends GT_Block_Casings_Abstract
implements IHeatingCoil {
    private Consumer<IHeatingCoil> callback = coil -> {};

    public GT_Block_Casings5() {
        super(GT_Item_Casings5.class, "gt.blockcasings5", GT_Material_Casings.INSTANCE, 16);
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".0.name", "Cupronickel Coil Block");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".1.name", "Kanthal Coil Block");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".2.name", "Nichrome Coil Block");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".3.name", "TPV-Alloy Coil Block");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".4.name", "HSS-G Coil Block");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".5.name", "Naquadah Coil Block");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".6.name", "Naquadah Alloy Coil Block");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".7.name", "Electrum Flux Coil Block");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".8.name", "Awakened Draconium Coil Block");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".9.name", "HSS-S Coil Block");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".10.name", "Trinium Coil Block");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".11.name", "Infinity Coil Block");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".12.name", "Hypogen Coil Block");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".13.name", "Eternal Coil Block");
        ItemList.Casing_Coil_Cupronickel.set(new ItemStack((Block)this, 1, 0));
        ItemList.Casing_Coil_Kanthal.set(new ItemStack((Block)this, 1, 1));
        ItemList.Casing_Coil_Nichrome.set(new ItemStack((Block)this, 1, 2));
        ItemList.Casing_Coil_TungstenSteel.set(new ItemStack((Block)this, 1, 3));
        ItemList.Casing_Coil_HSSG.set(new ItemStack((Block)this, 1, 4));
        ItemList.Casing_Coil_Naquadah.set(new ItemStack((Block)this, 1, 5));
        ItemList.Casing_Coil_NaquadahAlloy.set(new ItemStack((Block)this, 1, 6));
        ItemList.Casing_Coil_ElectrumFlux.set(new ItemStack((Block)this, 1, 7));
        ItemList.Casing_Coil_AwakenedDraconium.set(new ItemStack((Block)this, 1, 8));
        ItemList.Casing_Coil_HSSS.set(new ItemStack((Block)this, 1, 9));
        ItemList.Casing_Coil_Trinium.set(new ItemStack((Block)this, 1, 10));
        ItemList.Casing_Coil_Infinity.set(new ItemStack((Block)this, 1, 11));
        ItemList.Casing_Coil_Hypogen.set(new ItemStack((Block)this, 1, 12));
        ItemList.Casing_Coil_Eternal.set(new ItemStack((Block)this, 1, 13));
    }

    @Override
    public int getTextureIndex(int aMeta) {
        return 0x80 | aMeta;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int aSide, int aMeta) {
        switch (aMeta) {
            case 0: {
                return Textures.BlockIcons.MACHINE_COIL_CUPRONICKEL.getIcon();
            }
            case 1: {
                return Textures.BlockIcons.MACHINE_COIL_KANTHAL.getIcon();
            }
            case 2: {
                return Textures.BlockIcons.MACHINE_COIL_NICHROME.getIcon();
            }
            case 3: {
                return Textures.BlockIcons.MACHINE_COIL_TUNGSTENSTEEL.getIcon();
            }
            case 4: {
                return Textures.BlockIcons.MACHINE_COIL_HSSG.getIcon();
            }
            case 5: {
                return Textures.BlockIcons.MACHINE_COIL_NAQUADAH.getIcon();
            }
            case 6: {
                return Textures.BlockIcons.MACHINE_COIL_NAQUADAHALLOY.getIcon();
            }
            case 7: {
                return Textures.BlockIcons.MACHINE_COIL_ELECTRUMFLUX.getIcon();
            }
            case 8: {
                return Textures.BlockIcons.MACHINE_COIL_AWAKENEDDRACONIUM.getIcon();
            }
            case 9: {
                return Textures.BlockIcons.MACHINE_COIL_HSSS.getIcon();
            }
            case 10: {
                return Textures.BlockIcons.MACHINE_COIL_TRINIUM.getIcon();
            }
            case 11: {
                return Textures.BlockIcons.MACHINE_COIL_INFINITY.getIcon();
            }
            case 12: {
                return Textures.BlockIcons.MACHINE_COIL_HYPOGEN.getIcon();
            }
            case 13: {
                return Textures.BlockIcons.MACHINE_COIL_ETERNAL.getIcon();
            }
        }
        return Textures.BlockIcons.MACHINE_COIL_CUPRONICKEL.getIcon();
    }

    public static HeatingCoilLevel getCoilHeatFromDamage(int meta) {
        switch (meta) {
            case 0: {
                return HeatingCoilLevel.LV;
            }
            case 1: {
                return HeatingCoilLevel.MV;
            }
            case 2: {
                return HeatingCoilLevel.HV;
            }
            case 3: {
                return HeatingCoilLevel.EV;
            }
            case 4: {
                return HeatingCoilLevel.IV;
            }
            case 5: {
                return HeatingCoilLevel.ZPM;
            }
            case 6: {
                return HeatingCoilLevel.UV;
            }
            case 7: {
                return HeatingCoilLevel.UEV;
            }
            case 8: {
                return HeatingCoilLevel.UIV;
            }
            case 9: {
                return HeatingCoilLevel.LuV;
            }
            case 10: {
                return HeatingCoilLevel.UHV;
            }
            case 11: {
                return HeatingCoilLevel.UMV;
            }
            case 12: {
                return HeatingCoilLevel.UXV;
            }
            case 13: {
                return HeatingCoilLevel.MAX;
            }
        }
        return HeatingCoilLevel.None;
    }

    public static int getMetaFromCoilHeat(HeatingCoilLevel level) {
        switch (level) {
            case LV: {
                return 0;
            }
            case MV: {
                return 1;
            }
            case HV: {
                return 2;
            }
            case EV: {
                return 3;
            }
            case IV: {
                return 4;
            }
            case ZPM: {
                return 5;
            }
            case UV: {
                return 6;
            }
            case UEV: {
                return 7;
            }
            case UIV: {
                return 8;
            }
            case LuV: {
                return 9;
            }
            case UHV: {
                return 10;
            }
            case UMV: {
                return 11;
            }
            case UXV: {
                return 12;
            }
            case MAX: {
                return 13;
            }
        }
        return 0;
    }

    @Override
    public HeatingCoilLevel getCoilHeat(int meta) {
        this.getOnCoilCheck().accept(this);
        return GT_Block_Casings5.getCoilHeatFromDamage(meta);
    }

    @Override
    public void setOnCoilCheck(Consumer<IHeatingCoil> callback) {
        this.callback = callback;
    }

    @Override
    public Consumer<IHeatingCoil> getOnCoilCheck() {
        return this.callback;
    }
}

