/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.google.common.io.ByteArrayDataInput;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.ITextureBuilder;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_CoverBehaviorBase;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class GT_Cover_FluidStorageMonitor
extends GT_CoverBehaviorBase<FluidStorageData> {
    private static final IIconContainer[] icons = new IIconContainer[]{Textures.BlockIcons.OVERLAY_FLUID_STORAGE_MONITOR0, Textures.BlockIcons.OVERLAY_FLUID_STORAGE_MONITOR1, Textures.BlockIcons.OVERLAY_FLUID_STORAGE_MONITOR2, Textures.BlockIcons.OVERLAY_FLUID_STORAGE_MONITOR3, Textures.BlockIcons.OVERLAY_FLUID_STORAGE_MONITOR4, Textures.BlockIcons.OVERLAY_FLUID_STORAGE_MONITOR5, Textures.BlockIcons.OVERLAY_FLUID_STORAGE_MONITOR6, Textures.BlockIcons.OVERLAY_FLUID_STORAGE_MONITOR7, Textures.BlockIcons.OVERLAY_FLUID_STORAGE_MONITOR8, Textures.BlockIcons.OVERLAY_FLUID_STORAGE_MONITOR9, Textures.BlockIcons.OVERLAY_FLUID_STORAGE_MONITOR10, Textures.BlockIcons.OVERLAY_FLUID_STORAGE_MONITOR11, Textures.BlockIcons.OVERLAY_FLUID_STORAGE_MONITOR12, Textures.BlockIcons.OVERLAY_FLUID_STORAGE_MONITOR13, Textures.BlockIcons.OVERLAY_FLUID_STORAGE_MONITOR14};

    public GT_Cover_FluidStorageMonitor() {
        super(FluidStorageData.class);
    }

    @Override
    public FluidStorageData createDataObject(int aLegacyData) {
        return new FluidStorageData();
    }

    @Override
    public FluidStorageData createDataObject() {
        return new FluidStorageData();
    }

    @Override
    protected FluidStorageData doCoverThingsImpl(byte aSide, byte aInputRedstone, int aCoverID, FluidStorageData aCoverVariable, ICoverable aTileEntity, long aTimer) {
        FluidTankInfo tank;
        FluidTankInfo[] tanks = GT_Cover_FluidStorageMonitor.getValidFluidTankInfos(aTileEntity, aCoverVariable.side);
        if (tanks == null) {
            return aCoverVariable.disable().issueCoverUpdateIfNeeded(aTileEntity, aSide);
        }
        assert (0 < tanks.length);
        if (aCoverVariable.slot < 0 || tanks.length <= aCoverVariable.slot) {
            aCoverVariable.setSlot(0);
        }
        if ((tank = tanks[aCoverVariable.slot]) == null) {
            return aCoverVariable.setNullTank().issueCoverUpdateIfNeeded(aTileEntity, aSide);
        }
        return aCoverVariable.setFluid(tank.fluid).setScale(GT_Cover_FluidStorageMonitor.getTankScale(tank)).issueCoverUpdateIfNeeded(aTileEntity, aSide);
    }

    @Override
    protected ITexture getSpecialCoverFGTextureImpl(byte aSide, int aCoverID, FluidStorageData aCoverVariable, ICoverable aTileEntity) {
        return this.getSpecialCoverTextureImpl(aSide, aCoverID, aCoverVariable, aTileEntity);
    }

    @Override
    protected ITexture getSpecialCoverTextureImpl(byte aSide, int aCoverID, final FluidStorageData aCoverVariable, ICoverable aTileEntity) {
        if (aCoverVariable.slot == -1 || aCoverVariable.fluid == null || aCoverVariable.scale == 0) {
            return TextureFactory.of(Textures.BlockIcons.OVERLAY_FLUID_STORAGE_MONITOR0);
        }
        IIconContainer fluidIcon = new IIconContainer(){

            @Override
            public IIcon getIcon() {
                return aCoverVariable.fluid.getStillIcon();
            }

            @Override
            public IIcon getOverlayIcon() {
                return null;
            }

            @Override
            public ResourceLocation getTextureFile() {
                return TextureMap.field_110575_b;
            }
        };
        short[] fluidRGBA = this.colorToRGBA(aCoverVariable.fluid.getColor());
        ITextureBuilder fluidTextureBuilder = TextureFactory.builder().addIcon(fluidIcon).setRGBA(fluidRGBA);
        if (aCoverVariable.fluid.getLuminosity() > 0) {
            fluidTextureBuilder.glow();
        }
        return TextureFactory.of(fluidTextureBuilder.build(), TextureFactory.of(icons[aCoverVariable.scale]));
    }

    @Override
    protected boolean onCoverRightClickImpl(byte aSide, int aCoverID, FluidStorageData aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer == null || aPlayer.field_70170_p == null || aPlayer.field_70170_p.field_72995_K) {
            return false;
        }
        ItemStack heldItem = aPlayer.func_70694_bm();
        if (aPlayer.func_70093_af() || heldItem == null) {
            return false;
        }
        FluidTankInfo[] tanks = GT_Cover_FluidStorageMonitor.getValidFluidTankInfos(aTileEntity, aCoverVariable.side);
        if (tanks == null) {
            return false;
        }
        if (aCoverVariable.slot < 0 || tanks.length <= aCoverVariable.slot) {
            return false;
        }
        FluidTankInfo tank = tanks[aCoverVariable.slot];
        if (tank == null) {
            return false;
        }
        IFluidHandler tankHandler = (IFluidHandler)aTileEntity;
        ItemStack heldItemSizedOne = GT_Utility.copyAmount(1L, heldItem);
        if (heldItemSizedOne == null || heldItemSizedOne.field_77994_a <= 0) {
            return false;
        }
        ItemStack result = GT_Cover_FluidStorageMonitor.fillToTank(heldItemSizedOne, tankHandler, aCoverVariable.side);
        if (result != null) {
            GT_Cover_FluidStorageMonitor.replaceHeldItemStack(aPlayer, heldItem, result);
            return true;
        }
        result = GT_Cover_FluidStorageMonitor.fillToContainer(heldItemSizedOne, tank, tankHandler, aCoverVariable.side);
        if (result != null) {
            GT_Cover_FluidStorageMonitor.replaceHeldItemStack(aPlayer, heldItem, result);
            return true;
        }
        return false;
    }

    protected static ItemStack fillToTank(@Nonnull ItemStack container, @Nonnull IFluidHandler tank, ForgeDirection side) {
        FluidStack fluidToFill = GT_Utility.getFluidForFilledItem(container, true);
        if (fluidToFill == null || fluidToFill.getFluid() == null || fluidToFill.amount <= 0) {
            return null;
        }
        if (!tank.canFill(side, fluidToFill.getFluid())) {
            return null;
        }
        if (container.func_77973_b() instanceof IFluidContainerItem) {
            IFluidContainerItem containerItem = (IFluidContainerItem)container.func_77973_b();
            int filled = tank.fill(side, fluidToFill, true);
            if (filled == 0) {
                return null;
            }
            containerItem.drain(container, filled, true);
            return container;
        }
        int filled = tank.fill(side, fluidToFill, false);
        if (filled != fluidToFill.amount) {
            return null;
        }
        tank.fill(side, fluidToFill, true);
        return GT_Utility.getContainerForFilledItem(container, false);
    }

    protected static ItemStack fillToContainer(@Nonnull ItemStack container, @Nonnull FluidTankInfo tankInfo, @Nonnull IFluidHandler tank, ForgeDirection side) {
        if (tankInfo.fluid == null || tankInfo.fluid.getFluid() == null || tankInfo.fluid.amount <= 0) {
            return null;
        }
        if (!tank.canDrain(side, tankInfo.fluid.getFluid())) {
            return null;
        }
        if (container.func_77973_b() instanceof IFluidContainerItem) {
            IFluidContainerItem containerItem = (IFluidContainerItem)container.func_77973_b();
            int filled = Math.min(Optional.ofNullable(tank.drain(side, new FluidStack(tankInfo.fluid.getFluid(), containerItem.getCapacity(container)), false)).filter(fs -> GT_Utility.areFluidsEqual(fs, tankInfo.fluid)).map(fs -> fs.amount).orElse(0), containerItem.fill(container, new FluidStack(tankInfo.fluid.getFluid(), containerItem.getCapacity(container)), false));
            if (filled == 0) {
                return null;
            }
            containerItem.fill(container, new FluidStack(tankInfo.fluid.getFluid(), filled), true);
            tank.drain(side, new FluidStack(tankInfo.fluid.getFluid(), filled), true);
            return container;
        }
        ItemStack filledContainer = GT_Utility.fillFluidContainer(tankInfo.fluid, container, false, false);
        if (filledContainer == null) {
            return null;
        }
        FluidStack filledFluid = GT_Utility.getFluidForFilledItem(filledContainer, false);
        if (filledFluid == null || filledFluid.getFluid() == null || filledFluid.amount <= 0) {
            return null;
        }
        if (Optional.ofNullable(tank.drain(side, filledFluid, false)).filter(fs -> GT_Utility.areFluidsEqual(fs, filledFluid)).map(fs -> fs.amount).orElse(0) != filledFluid.amount) {
            return null;
        }
        tank.drain(side, filledFluid, true);
        return filledContainer;
    }

    protected static void replaceHeldItemStack(@Nonnull EntityPlayer player, @Nonnull ItemStack heldItem, @Nonnull ItemStack result) {
        --heldItem.field_77994_a;
        GT_Utility.addItemToPlayerInventory(player, result);
        player.field_71069_bz.func_75142_b();
    }

    @Override
    protected FluidStorageData onCoverScrewdriverClickImpl(byte aSide, int aCoverID, FluidStorageData aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.func_70093_af()) {
            aCoverVariable.setSide(ForgeDirection.values()[(aCoverVariable.side.ordinal() + 1) % ForgeDirection.values().length]).setSlot(0);
            GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("SIDE", "Side: ") + aCoverVariable.side.name());
            return aCoverVariable;
        }
        FluidTankInfo[] tanks = GT_Cover_FluidStorageMonitor.getValidFluidTankInfos(aTileEntity, aCoverVariable.side);
        if (tanks == null) {
            return aCoverVariable.disable();
        }
        assert (0 < tanks.length);
        if (aCoverVariable.slot < 0 || tanks.length <= aCoverVariable.slot) {
            aCoverVariable.setSlot(0);
        } else {
            aCoverVariable.setSlot((aCoverVariable.slot + tanks.length + (aPlayer.func_70093_af() ? -1 : 1)) % tanks.length);
        }
        GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("053", "Slot: ") + aCoverVariable.slot);
        return aCoverVariable;
    }

    @Override
    protected boolean isDataNeededOnClientImpl(byte aSide, int aCoverID, FluidStorageData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsFluidInImpl(byte aSide, int aCoverID, FluidStorageData aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsFluidOutImpl(byte aSide, int aCoverID, FluidStorageData aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected int getTickRateImpl(byte aSide, int aCoverID, FluidStorageData aCoverVariable, ICoverable aTileEntity) {
        return 10;
    }

    protected static FluidTankInfo[] getValidFluidTankInfos(@Nullable ICoverable tileEntity, @Nonnull ForgeDirection side) {
        FluidTankInfo[] tanks;
        if (tileEntity instanceof IFluidHandler && (tanks = ((IFluidHandler)tileEntity).getTankInfo(side)) != null && 0 < tanks.length) {
            return tanks;
        }
        return null;
    }

    protected static int getTankScale(@Nonnull FluidTankInfo tank) {
        if (tank.fluid == null || tank.capacity <= 0) {
            return 0;
        }
        return (int)Math.ceil((double)tank.fluid.amount / (double)tank.capacity * (double)(icons.length - 1));
    }

    protected short[] colorToRGBA(int color) {
        return new short[]{(short)(color >> 16 & 0xFF), (short)(color >> 8 & 0xFF), (short)(color & 0xFF), 255};
    }

    protected static class Util {
        protected Util() {
        }

        public static int getFluidID(@Nullable Fluid fluid) {
            return fluid == null ? -1 : fluid.getID();
        }

        public static String getFluidName(@Nullable Fluid fluid) {
            return fluid == null ? "" : fluid.getName();
        }

        public static Fluid getFluid(int id) {
            return id == -1 ? null : FluidRegistry.getFluid((int)id);
        }

        public static Fluid getFluid(String name) {
            return name.isEmpty() ? null : FluidRegistry.getFluid((String)name);
        }

        public static boolean areFluidsEqual(@Nullable Fluid a, @Nullable Fluid b) {
            return Util.getFluidID(a) == Util.getFluidID(b);
        }
    }

    public static class FluidStorageData
    implements ISerializableObject {
        private ForgeDirection side;
        private int slot;
        private Fluid fluid;
        private int scale;
        private boolean dirty;

        public FluidStorageData() {
            this(ForgeDirection.UNKNOWN, 0, null, 0, false);
        }

        public FluidStorageData(ForgeDirection side, int slot, Fluid fluid, int scale, boolean dirty) {
            this.side = side;
            this.slot = slot;
            this.fluid = fluid;
            this.scale = scale;
            this.dirty = dirty;
        }

        public FluidStorageData setSide(ForgeDirection side) {
            this.side = side;
            return this;
        }

        public FluidStorageData setSlot(int slot) {
            if (this.slot != slot) {
                if (this.slot == -1 || slot == -1) {
                    this.dirty = true;
                }
                this.slot = slot;
            }
            return this;
        }

        public FluidStorageData disable() {
            this.setSlot(-1);
            return this;
        }

        public FluidStorageData setFluid(@Nullable Fluid fluid) {
            if (!Util.areFluidsEqual(this.fluid, fluid)) {
                this.fluid = fluid;
                this.dirty = true;
            }
            return this;
        }

        public FluidStorageData setFluid(@Nullable FluidStack fluidStack) {
            Fluid fluid = fluidStack == null ? null : fluidStack.getFluid();
            return this.setFluid(fluid);
        }

        public FluidStorageData setScale(int scale) {
            if (this.scale != scale) {
                this.scale = scale;
                this.dirty = true;
            }
            return this;
        }

        public FluidStorageData setNullTank() {
            return this.setFluid((Fluid)null).setScale(0);
        }

        public FluidStorageData issueCoverUpdateIfNeeded(ICoverable tileEntity, byte side) {
            if (this.dirty) {
                tileEntity.issueCoverUpdate(side);
                this.dirty = false;
            }
            return this;
        }

        @Override
        @Nonnull
        public ISerializableObject copy() {
            return new FluidStorageData(this.side, this.slot, this.fluid, this.scale, this.dirty);
        }

        @Override
        public void loadDataFromNBT(NBTBase aNBT) {
            NBTTagCompound tag = (NBTTagCompound)aNBT;
            this.side = ForgeDirection.getOrientation((int)tag.func_74771_c("side"));
            this.slot = tag.func_74762_e("slot");
            this.fluid = Util.getFluid(tag.func_74779_i("fluidName"));
            this.scale = tag.func_74762_e("scale");
            this.dirty = tag.func_74767_n("dirty");
        }

        @Override
        @Nonnull
        public NBTBase saveDataToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("side", (byte)this.side.ordinal());
            tag.func_74768_a("slot", this.slot);
            tag.func_74778_a("fluidName", Util.getFluidName(this.fluid));
            tag.func_74768_a("scale", this.scale);
            tag.func_74757_a("dirty", this.dirty);
            return tag;
        }

        @Override
        @Nonnull
        public ISerializableObject readFromPacket(ByteArrayDataInput aBuf, @Nullable EntityPlayerMP aPlayer) {
            ForgeDirection side = ForgeDirection.getOrientation((int)aBuf.readByte());
            int slot = aBuf.readInt();
            Fluid fluid = Util.getFluid(aBuf.readInt());
            int scale = aBuf.readInt();
            boolean dirty = aBuf.readBoolean();
            return new FluidStorageData(side, slot, fluid, scale, dirty);
        }

        @Override
        public void writeToByteBuf(ByteBuf aBuf) {
            aBuf.writeByte(this.side.ordinal());
            aBuf.writeInt(this.slot);
            aBuf.writeInt(Util.getFluidID(this.fluid));
            aBuf.writeInt(this.scale);
            aBuf.writeBoolean(this.dirty);
        }
    }
}

