/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.modularui.widget;

import com.gtnewhorizons.modularui.api.widget.ISyncedWidget;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import com.gtnewhorizons.modularui.common.widget.MultiChildWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.gui.modularui.IDataFollowerWidget;
import java.io.IOException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;

public abstract class DataControllerWidget<T>
extends MultiChildWidget
implements ISyncedWidget {
    private final Supplier<T> dataGetter;
    private final Function<T, Boolean> dataSetter;
    protected T lastData;
    private boolean needsUpdate;

    public DataControllerWidget(Supplier<T> dataGetter, Function<T, Boolean> dataSetter) {
        this.dataGetter = dataGetter;
        this.dataSetter = dataSetter;
    }

    protected T getLastData() {
        return this.lastData;
    }

    public void onPostInit() {
        super.onPostInit();
        this.lastData = this.dataGetter.get();
        if (NetworkUtils.isClient()) {
            this.updateChildren(true);
        }
    }

    public void detectAndSendChanges(boolean init) {
        T actualValue = this.dataGetter.get();
        if (actualValue == null) {
            this.getWindow().tryClose();
            return;
        }
        if (init || !actualValue.equals(this.getLastData())) {
            this.lastData = actualValue;
            this.syncDataToClient(actualValue);
        }
    }

    protected void syncDataToClient(T data) {
        this.syncToClient(0, buffer -> this.writeToPacket((PacketBuffer)buffer, data));
    }

    protected void syncDataToServer(T data) {
        this.syncToServer(0, buffer -> this.writeToPacket((PacketBuffer)buffer, data));
        this.updateChildren();
    }

    public void readOnClient(int id, PacketBuffer buf) throws IOException {
        if (id == 0) {
            this.lastData = this.readFromPacket(buf);
            this.dataSetter.apply(this.getLastData());
            this.updateChildren();
        }
    }

    public void readOnServer(int id, PacketBuffer buf) throws IOException {
        if (id == 0) {
            this.lastData = this.readFromPacket(buf);
            if (this.dataSetter.apply(this.getLastData()).booleanValue()) {
                this.markForUpdate();
            } else {
                this.getWindow().closeWindow();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateChildren(boolean postInit) {
        for (Widget child : this.getChildren()) {
            if (!(child instanceof IDataFollowerWidget)) continue;
            ((IDataFollowerWidget)child).updateState(this.getLastData());
            if (!postInit) continue;
            ((IDataFollowerWidget)child).onPostInit();
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateChildren() {
        this.updateChildren(false);
    }

    protected abstract void writeToPacket(PacketBuffer var1, T var2);

    protected abstract T readFromPacket(PacketBuffer var1) throws IOException;

    public void markForUpdate() {
        this.needsUpdate = true;
    }

    public void unMarkForUpdate() {
        this.needsUpdate = false;
    }

    public boolean isMarkedForUpdate() {
        return this.needsUpdate;
    }

    public <U, W extends Widget> DataControllerWidget<T> addFollower(W widget, Function<T, U> dataToStateGetter, BiFunction<T, U, T> dataUpdater, Consumer<W> applyForWidget) {
        ((IDataFollowerWidget)widget).setDataToStateGetter(dataToStateGetter);
        ((IDataFollowerWidget)widget).setStateSetter(state -> {
            Object newData = dataUpdater.apply(this.getLastData(), state);
            this.lastData = newData;
            this.dataSetter.apply(this.getLastData());
            this.syncDataToServer(newData);
        });
        applyForWidget.accept(widget);
        this.addChild(widget);
        return this;
    }
}

