/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.debug;

import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizon.structurelib.util.Vec3Impl;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.CycleButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.MultiChildWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GT_Mod;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.gui.modularui.GUITextureSet;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddGregtechLogo;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.render.TextureFactory;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class GT_MetaTileEntity_AdvDebugStructureWriter
extends GT_MetaTileEntity_TieredMachineBlock
implements IAddGregtechLogo,
IAddUIWidgets {
    private static final HashMap<GT_MetaTileEntity_AdvDebugStructureWriter, BoundHighlighter> bondingBoxes = new HashMap(1);
    private final BoundHighlighter boundingBox = new BoundHighlighter();
    private final short[] numbers = new short[6];
    private boolean transpose = false;
    private boolean showHighlightBox = true;
    private String[] result = new String[]{"Undefined"};

    public GT_MetaTileEntity_AdvDebugStructureWriter(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 0, "", new ITexture[0]);
    }

    public GT_MetaTileEntity_AdvDebugStructureWriter(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_AdvDebugStructureWriter(this.mName, this.mTier, "", this.mTextures);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1], aSide != aFacing ? TextureFactory.of(TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TELEPORTER_ACTIVE).glow().build()) : TextureFactory.of(TextureFactory.builder().addIcon(Textures.BlockIcons.STRUCTURE_MARK).glow().build())};
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return null;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity iGregTechTileEntity, int i, byte b, ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity iGregTechTileEntity, int i, byte b, ItemStack itemStack) {
        return false;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        for (int i = 0; i < this.numbers.length; ++i) {
            aNBT.func_74777_a("eData" + i, this.numbers[i]);
        }
        aNBT.func_74757_a("Transpose", this.transpose);
        aNBT.func_74757_a("HighlightBox", this.showHighlightBox);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        for (int i = 0; i < this.numbers.length; ++i) {
            this.numbers[i] = aNBT.func_74765_d("eData" + i);
        }
        this.transpose = aNBT.func_74767_n("Transpose");
        this.showHighlightBox = aNBT.func_74767_n("HighlightBox");
    }

    @Override
    public boolean isSimpleMachine() {
        return false;
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        bondingBoxes.put(this, this.boundingBox);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            ExtendedFacing writerFacing = ExtendedFacing.of((ForgeDirection)ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getFrontFacing()));
            double[] abc = new double[3];
            double[] xyz = new double[3];
            this.boundingBox.dim = aBaseMetaTileEntity.getWorld().field_73011_w.field_76574_g;
            this.boundingBox.showHighlightBox = this.showHighlightBox;
            abc[0] = (double)(-this.numbers[0]) - 0.5;
            abc[1] = (double)(-this.numbers[1]) - 0.5;
            abc[2] = (double)(-this.numbers[2]) - 0.5;
            writerFacing.getWorldOffset(abc, xyz);
            this.boundingBox.pos1 = new Vec3Impl(aBaseMetaTileEntity.getXCoord() + (int)(xyz[0] + 0.5), aBaseMetaTileEntity.getYCoord() + (int)(xyz[1] + 0.5), aBaseMetaTileEntity.getZCoord() + (int)(xyz[2] + 0.5));
            abc[0] = (double)(-this.numbers[0] + this.numbers[3]) - 0.5;
            abc[1] = (double)(-this.numbers[1] + this.numbers[4]) - 0.5;
            abc[2] = (double)(-this.numbers[2] + this.numbers[5]) - 0.5;
            writerFacing.getWorldOffset(abc, xyz);
            this.boundingBox.pos2 = new Vec3Impl(aBaseMetaTileEntity.getXCoord() + (int)(xyz[0] + 0.5), aBaseMetaTileEntity.getYCoord() + (int)(xyz[1] + 0.5), aBaseMetaTileEntity.getZCoord() + (int)(xyz[2] + 0.5));
        }
    }

    @Override
    public void onRemoval() {
        bondingBoxes.remove(this);
    }

    @Override
    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        this.printStructure(aPlayer);
        aBaseMetaTileEntity.disableWorking();
    }

    public void printStructure(EntityPlayer aPlayer) {
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        String pseudoJavaCode = StructureUtility.getPseudoJavaCode((World)aBaseMetaTileEntity.getWorld(), (ExtendedFacing)ExtendedFacing.of((ForgeDirection)ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getFrontFacing())), (int)aBaseMetaTileEntity.getXCoord(), (int)aBaseMetaTileEntity.getYCoord(), (int)aBaseMetaTileEntity.getZCoord(), (int)this.numbers[0], (int)this.numbers[1], (int)this.numbers[2], te -> te.getClass().getCanonicalName(), (int)this.numbers[3], (int)this.numbers[4], (int)this.numbers[5], (boolean)this.transpose);
        GT_Mod.GT_FML_LOGGER.info(pseudoJavaCode);
        this.result = pseudoJavaCode.split("\\n");
        aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation(StatCollector.func_74838_a((String)"GT5U.machines.advdebugstructurewriter.printed"), new Object[0]));
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GT_UIInfos.openGTTileEntityUI(aBaseMetaTileEntity, aPlayer);
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    @Override
    public boolean isElectric() {
        return false;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public String[] getDescription() {
        return new String[]{StatCollector.func_74838_a((String)"GT5U.machines.advdebugstructurewriter.tooltip"), StatCollector.func_74838_a((String)"GT5U.machines.advdebugstructurewriter.tooltip.1"), StatCollector.func_74838_a((String)"GT5U.machines.advdebugstructurewriter.tooltip.2")};
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        return this.result;
    }

    @Override
    public boolean useModularUI() {
        return true;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_SCREEN_BLACK).setSize(90, 112).setPos(43, 4))).widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (this.getBaseMetaTileEntity().isServerSide()) {
                this.printStructure(widget.getContext().getPlayer());
            }
        }).setBackground(new IDrawable[]{GT_UITextures.BUTTON_STANDARD, GT_UITextures.OVERLAY_BUTTON_PRINT}).setSize(18, 18).setPos(11, 128).addTooltip(StatCollector.func_74838_a((String)"GT5U.machines.advdebugstructurewriter.gui.print.tooltip")))).widget(new CycleButtonWidget().setToggle(() -> this.transpose, aBoolean -> {
            this.transpose = aBoolean;
        }).setVariableBackground(new UITexture[]{GT_UITextures.BUTTON_STANDARD_TOGGLE}).setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_TRANSPOSE).setSize(18, 18).setPos(32, 128).addTooltip(StatCollector.func_74838_a((String)"GT5U.machines.advdebugstructurewriter.gui.transpose.tooltip")))).widget(new CycleButtonWidget().setToggle(() -> this.showHighlightBox, aBoolean -> {
            this.showHighlightBox = aBoolean;
        }).setVariableBackground(new UITexture[]{GT_UITextures.BUTTON_STANDARD_TOGGLE}).setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_BOUNDING_BOX).setSize(18, 18).setPos(53, 128).addTooltip(StatCollector.func_74838_a((String)"GT5U.machines.advdebugstructurewriter.gui.highlight.tooltip")))).widget(new MultiChildWidget().addChild(new TextWidget(StatCollector.func_74838_a((String)"GT5U.machines.advdebugstructurewriter.gui.origin")).setDefaultColor(0xF0F0FF).setPos(0, 0)).addChild(TextWidget.dynamicString(() -> "A: " + this.numbers[0]).setDefaultColor(0xF0F0FF).setPos(0, 10)).addChild(TextWidget.dynamicString(() -> "B: " + this.numbers[1]).setDefaultColor(0xF0F0FF).setPos(0, 18)).addChild(TextWidget.dynamicString(() -> "C: " + this.numbers[2]).setDefaultColor(0xF0F0FF).setPos(0, 26)).addChild(new TextWidget(StatCollector.func_74838_a((String)"GT5U.machines.advdebugstructurewriter.gui.size")).setDefaultColor(0xF0F0FF).setPos(0, 52)).addChild(TextWidget.dynamicString(() -> "A: " + this.numbers[3]).setDefaultColor(0xF0F0FF).setPos(0, 62)).addChild(TextWidget.dynamicString(() -> "B: " + this.numbers[4]).setDefaultColor(0xF0F0FF).setPos(0, 70)).addChild(TextWidget.dynamicString(() -> "C: " + this.numbers[5]).setDefaultColor(0xF0F0FF).setPos(0, 78)).setPos(46, 8));
        this.addChangeNumberButtons(builder, (IDrawable)GT_UITextures.OVERLAY_BUTTON_MINUS_LARGE, -512, -64, 7);
        this.addChangeNumberButtons(builder, (IDrawable)GT_UITextures.OVERLAY_BUTTON_MINUS_SMALL, -16, -1, 25);
        this.addChangeNumberButtons(builder, (IDrawable)GT_UITextures.OVERLAY_BUTTON_PLUS_SMALL, 16, 1, 133);
        this.addChangeNumberButtons(builder, (IDrawable)GT_UITextures.OVERLAY_BUTTON_PLUS_LARGE, 512, 64, 151);
    }

    private void addChangeNumberButtons(ModularWindow.Builder builder, IDrawable overlay, int addNumberShift, int addNumber, int xPos) {
        int[] yPos = new int[]{4, 22, 40, 62, 80, 98};
        int i = 0;
        while (i < yPos.length) {
            int index = i++;
            builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
                int n = index;
                this.numbers[n] = (short)(this.numbers[n] + (clickData.shift ? addNumberShift : addNumber));
            }).setBackground(new IDrawable[]{GT_UITextures.BUTTON_STANDARD, overlay}).setSize(18, 18).setPos(xPos, yPos[index]));
        }
    }

    @Override
    public GUITextureSet getGUITextureSet() {
        return new GUITextureSet().setGregTechLogo(GT_UITextures.PICTURE_GT_LOGO_17x17_TRANSPARENT_GRAY);
    }

    @Override
    public void addGregTechLogo(ModularWindow.Builder builder) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)this.getGUITextureSet().getGregTechLogo()).setSize(17, 17).setPos(113, 96));
    }

    @Override
    public boolean doesBindPlayerInventory() {
        return false;
    }

    private static class BoundHighlighter {
        public Vec3Impl pos1;
        public Vec3Impl pos2;
        public boolean showHighlightBox;
        public int dim;

        private BoundHighlighter() {
        }

        @SideOnly(value=Side.CLIENT)
        private void renderHighlightedBlock(RenderWorldLastEvent event) {
            if (this.pos1 == null || this.pos2 == null || !this.showHighlightBox) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            int dimension = mc.field_71441_e.field_73011_w.field_76574_g;
            if (dimension != this.dim) {
                this.pos1 = null;
                this.pos2 = null;
                return;
            }
            EntityClientPlayerMP p = mc.field_71439_g;
            double doubleX = p.field_70142_S + (p.field_70165_t - p.field_70142_S) * (double)event.partialTicks;
            double doubleY = p.field_70137_T + (p.field_70163_u - p.field_70137_T) * (double)event.partialTicks;
            double doubleZ = p.field_70136_U + (p.field_70161_v - p.field_70136_U) * (double)event.partialTicks;
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)1048575);
            GL11.glLineWidth((float)3.0f);
            GL11.glTranslated((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
            GL11.glDisable((int)2929);
            GL11.glDisable((int)3553);
            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            BoundHighlighter.renderHighLightedArenaOutline(this.pos1.get0(), this.pos1.get1(), this.pos1.get2(), this.pos2.get0(), this.pos2.get1(), this.pos2.get2());
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }

        @SideOnly(value=Side.CLIENT)
        static void renderHighLightedArenaOutline(double x1, double y1, double z1, double x2, double y2, double z2) {
            GL11.glBegin((int)3);
            GL11.glVertex3d((double)x1, (double)y1, (double)z1);
            GL11.glVertex3d((double)x1, (double)y2, (double)z1);
            GL11.glVertex3d((double)x1, (double)y2, (double)z2);
            GL11.glVertex3d((double)x1, (double)y1, (double)z2);
            GL11.glVertex3d((double)x1, (double)y1, (double)z1);
            GL11.glVertex3d((double)x2, (double)y1, (double)z1);
            GL11.glVertex3d((double)x2, (double)y2, (double)z1);
            GL11.glVertex3d((double)x2, (double)y2, (double)z2);
            GL11.glVertex3d((double)x2, (double)y1, (double)z2);
            GL11.glVertex3d((double)x2, (double)y1, (double)z1);
            GL11.glVertex3d((double)x1, (double)y1, (double)z1);
            GL11.glVertex3d((double)x2, (double)y1, (double)z1);
            GL11.glVertex3d((double)x2, (double)y1, (double)z2);
            GL11.glVertex3d((double)x1, (double)y1, (double)z2);
            GL11.glVertex3d((double)x1, (double)y2, (double)z2);
            GL11.glVertex3d((double)x2, (double)y2, (double)z2);
            GL11.glVertex3d((double)x2, (double)y2, (double)z1);
            GL11.glVertex3d((double)x2, (double)y1, (double)z1);
            GL11.glVertex3d((double)x1, (double)y1, (double)z1);
            GL11.glVertex3d((double)x2, (double)y1, (double)z1);
            GL11.glVertex3d((double)x2, (double)y2, (double)z1);
            GL11.glVertex3d((double)x1, (double)y2, (double)z1);
            GL11.glVertex3d((double)x1, (double)y2, (double)z2);
            GL11.glVertex3d((double)x2, (double)y2, (double)z2);
            GL11.glVertex3d((double)x2, (double)y1, (double)z2);
            GL11.glVertex3d((double)x1, (double)y1, (double)z2);
            GL11.glEnd();
        }
    }

    public static class ForgeEventHandler {
        public ForgeEventHandler() {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void onRenderWorldLast(RenderWorldLastEvent e) {
            for (BoundHighlighter boundingBox : bondingBoxes.values()) {
                boundingBox.renderHighlightedBlock(e);
            }
        }
    }
}

