/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidHandler;

public class GT_MetaTileEntity_Pump
extends GT_MetaTileEntity_Hatch {
    private static final ItemStack MINING_PIPE = GT_ModHandler.getIC2Item("miningPipe", 0L);
    private static final Block MINING_PIPE_BLOCK = GT_Utility.getBlockFromStack(MINING_PIPE);
    private static final Block MINING_PIPE_TIP_BLOCK = GT_Utility.getBlockFromStack(GT_ModHandler.getIC2Item("miningPipeTip", 0L));
    public ArrayDeque<ChunkPosition> mPumpList = new ArrayDeque();
    public boolean wasPumping = false;
    public int mPumpTimer = 0;
    public int mPumpCountBelow = 0;
    public Block mPrimaryPumpedBlock = null;
    public Block mSecondaryPumpedBlock = null;
    private int radiusConfig = GT_MetaTileEntity_Pump.getMaxDistanceForTier(this.mTier);
    private boolean mRetractDone = false;
    private boolean mDisallowRetract = true;
    private FakePlayer mFakePlayer = null;

    public static int getMaxDistanceForTier(int aTier) {
        return 10 * (int)Math.pow(1.6, aTier);
    }

    public static long getEuUsagePerTier(int aTier) {
        return 16L * (long)Math.pow(4.0, aTier);
    }

    public GT_MetaTileEntity_Pump(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 3, new String[]{"The best way to empty Oceans! Outputs on top", GT_MetaTileEntity_Pump.getEuUsagePerTier(aTier) + " EU/operation, " + GT_Utility.safeInt(8L / (long)Math.pow(2.0, aTier)) + " sec per bucket, no stuttering", "Maximum pumping area: " + (GT_MetaTileEntity_Pump.getMaxDistanceForTier(aTier) * 2 + 1) + "x" + (GT_MetaTileEntity_Pump.getMaxDistanceForTier(aTier) * 2 + 1), "Use Screwdriver to regulate pumping area", "Use Soft Mallet to disable and retract the pipe", "Disable the bottom pump to retract the pipe!", "Use Soldering Iron to auto retract the pipe when hitting a rock"}, new ITexture[0]);
    }

    public GT_MetaTileEntity_Pump(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    public GT_MetaTileEntity_Pump(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Pump(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        boolean wasPumping;
        boolean bl = wasPumping = this.wasPumping || !this.mPumpList.isEmpty();
        if (GT_Values.debugBlockPump) {
            GT_Log.out.println("PUMP: NBT:Save - WasPumping - " + wasPumping + " blocks (" + this.mPrimaryPumpedBlock + ", " + this.mSecondaryPumpedBlock + ")");
        }
        super.saveNBTData(aNBT);
        aNBT.func_74778_a("mPumpedBlock1", this.mPrimaryPumpedBlock == null ? "" : Block.field_149771_c.func_148750_c((Object)this.mPrimaryPumpedBlock));
        aNBT.func_74778_a("mPumpedBlock2", this.mSecondaryPumpedBlock == null ? "" : Block.field_149771_c.func_148750_c((Object)this.mSecondaryPumpedBlock));
        aNBT.func_74757_a("wasPumping", wasPumping);
        aNBT.func_74768_a("radiusConfig", this.radiusConfig);
        aNBT.func_74757_a("mRetractDone", this.mRetractDone);
        aNBT.func_74757_a("mDisallowRetract", this.mDisallowRetract);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.wasPumping = aNBT.func_74767_n("wasPumping");
        if (aNBT.func_74764_b("radiusConfig")) {
            this.radiusConfig = aNBT.func_74762_e("radiusConfig");
        }
        this.mPrimaryPumpedBlock = Block.func_149684_b((String)aNBT.func_74779_i("mPumpedBlock1"));
        this.mSecondaryPumpedBlock = Block.func_149684_b((String)aNBT.func_74779_i("mPumpedBlock2"));
        this.mRetractDone = aNBT.func_74767_n("mRetractDone");
        this.mDisallowRetract = aNBT.func_74767_n("mDisallowRetract");
        if (GT_Values.debugBlockPump) {
            GT_Log.out.println("PUMP: NBT:Load - WasPumping - " + this.wasPumping + "(" + aNBT.func_74779_i("mPumpedBlock1") + ") " + this.mPrimaryPumpedBlock);
        }
    }

    @Override
    public void setItemNBT(NBTTagCompound aNBT) {
        super.setItemNBT(aNBT);
        aNBT.func_74768_a("radiusConfig", this.radiusConfig);
        aNBT.func_74757_a("mDisallowRetract", this.mDisallowRetract);
    }

    @Override
    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        super.onScrewdriverRightClick(aSide, aPlayer, aX, aY, aZ);
        int max = this.getMaxPumpableDistance();
        if (aPlayer.func_70093_af()) {
            if (this.radiusConfig >= 0) {
                --this.radiusConfig;
            }
            if (this.radiusConfig < 0) {
                this.radiusConfig = max;
            }
        } else {
            if (this.radiusConfig <= max) {
                ++this.radiusConfig;
            }
            if (this.radiusConfig > max) {
                this.radiusConfig = 0;
            }
        }
        GT_Utility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"GT5U.machines.workareaset") + " " + (this.radiusConfig * 2 + 1) + "x" + (this.radiusConfig * 2 + 1));
        this.clearQueue(false);
    }

    @Override
    public boolean onSolderingToolRightClick(byte aSide, byte aWrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (super.onSolderingToolRightClick(aSide, aWrenchingSide, aPlayer, aX, aY, aZ)) {
            return true;
        }
        this.mDisallowRetract = !this.mDisallowRetract;
        GT_Utility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)(this.mDisallowRetract ? "GT5U.machines.autoretract.disabled" : "GT5U.machines.autoretract.enabled")));
        return true;
    }

    @Override
    public boolean doesFillContainers() {
        return true;
    }

    @Override
    public boolean doesEmptyContainers() {
        return false;
    }

    @Override
    public boolean canTankBeFilled() {
        return false;
    }

    @Override
    public boolean canTankBeEmptied() {
        return true;
    }

    @Override
    public boolean displaysItemStack() {
        return true;
    }

    @Override
    public boolean displaysStackSize() {
        return false;
    }

    @Override
    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return false;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.getBaseMetaTileEntity().isServerSide()) {
            int tFilledAmount;
            FluidStack tDrained;
            IFluidHandler tTank;
            IGregTechTileEntity tTileEntity;
            --this.mPumpTimer;
            if (this.getBaseMetaTileEntity() instanceof BaseTileEntity) {
                ((BaseTileEntity)((Object)this.getBaseMetaTileEntity())).ignoreUnloadedChunks = false;
            }
            this.doTickProfilingInThisTick = true;
            this.mPumpCountBelow = 0;
            for (int i = 1; i < 21 && (tTileEntity = this.getBaseMetaTileEntity().getIGregTechTileEntityAtSideAndDistance((byte)0, i)) != null && tTileEntity.getMetaTileEntity() instanceof GT_MetaTileEntity_Pump; ++i) {
                this.getBaseMetaTileEntity().setActive(tTileEntity.isActive());
                ++this.mPumpCountBelow;
                --((GT_MetaTileEntity_Pump)tTileEntity.getMetaTileEntity()).mPumpTimer;
            }
            if (GT_Values.debugBlockPump && this.mPumpCountBelow != 0) {
                GT_Log.out.println("PUMP: Detected " + this.mPumpCountBelow + " pumps below this pump.");
            }
            if (this.mPumpCountBelow <= 0) {
                if (this.getBaseMetaTileEntity().isAllowedToWork()) {
                    this.mRetractDone = false;
                    if (this.getBaseMetaTileEntity().isUniversalEnergyStored(this.getEuUsagePerAction()) && (this.mFluid == null || this.mFluid.amount + 1000 <= this.getCapacity())) {
                        boolean tMovedOneDown = false;
                        if (this.mPumpList.isEmpty() && this.getBaseMetaTileEntity().getTimer() % 100L == 0L) {
                            if (!this.wasPumping) {
                                tMovedOneDown = this.moveOneDown();
                                if (!tMovedOneDown) {
                                    if (this.canMoveDown(this.getBaseMetaTileEntity().getXCoord(), Math.max(this.getYOfPumpHead() - 1, 1), this.getBaseMetaTileEntity().getZCoord())) {
                                        if (GT_Values.debugBlockPump) {
                                            GT_Log.out.println("PUMP: No pipe left. Idle for a little longer.");
                                        }
                                        this.mPumpTimer = 160;
                                    } else {
                                        this.getBaseMetaTileEntity().disableWorking();
                                        if (GT_Values.debugBlockPump) {
                                            GT_Log.out.println("PUMP: Can't move. Retracting in next few ticks");
                                        }
                                    }
                                } else if (GT_Values.debugBlockPump) {
                                    GT_Log.out.println("PUMP: Moved down");
                                }
                            } else if (GT_Values.debugBlockPump) {
                                GT_Log.out.println("PUMP: Was pumping, didn't move down");
                            }
                        }
                        int x = this.getBaseMetaTileEntity().getXCoord();
                        int z = this.getBaseMetaTileEntity().getZCoord();
                        if (!this.hasValidFluid()) {
                            int y = this.getYOfPumpHead();
                            if (GT_Values.debugBlockPump && this.mPrimaryPumpedBlock != null) {
                                GT_Log.out.println("PUMP: Had an invalid pump block. Trying to find a fluid at Y: " + y + " Previous blocks 1: " + this.mPrimaryPumpedBlock + " 2: " + this.mSecondaryPumpedBlock);
                            }
                            this.checkForFluidToPump(x, y - 1, z);
                            this.checkForFluidToPump(x, y, z + 1);
                            this.checkForFluidToPump(x, y, z - 1);
                            this.checkForFluidToPump(x + 1, y, z);
                            this.checkForFluidToPump(x - 1, y, z);
                            this.clearQueue(false);
                            if (this.hasValidFluid()) {
                                this.wasPumping = true;
                            }
                        } else if (this.getYOfPumpHead() < this.getBaseMetaTileEntity().getYCoord()) {
                            if (tMovedOneDown || this.wasPumping || this.mPumpList.isEmpty() && this.getBaseMetaTileEntity().getTimer() % 200L == 100L || this.getBaseMetaTileEntity().getTimer() % 72000L == 100L) {
                                if (GT_Values.debugBlockPump) {
                                    GT_Log.out.println("PUMP: Rebuilding pump list - Size " + this.mPumpList.size() + " WasPumping: " + this.wasPumping + " Timer " + this.getBaseMetaTileEntity().getTimer());
                                }
                                int yPump = this.getBaseMetaTileEntity().getYCoord() - 1;
                                int yHead = this.getYOfPumpHead();
                                this.rebuildPumpQueue(x, yPump, z, yHead);
                                if (GT_Values.debugBlockPump) {
                                    GT_Log.out.println("PUMP: Rebuilt pump list - Size " + this.mPumpList.size());
                                }
                            }
                            if (!tMovedOneDown && this.mPumpTimer <= 0) {
                                while (!this.mPumpList.isEmpty()) {
                                    ChunkPosition pos = this.mPumpList.pollLast();
                                    if (!this.consumeFluid(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c)) continue;
                                    break;
                                }
                                this.mPumpTimer = GT_Utility.safeInt(160L / (long)Math.pow(2.0, this.mTier));
                                this.mPumpTimer = this.mPumpTimer == 0 ? 1 : this.mPumpTimer;
                            }
                        } else {
                            this.clearQueue(false);
                        }
                    } else if (GT_Values.debugBlockPump) {
                        GT_Log.out.println("PUMP: Not enough energy? Free space?");
                    }
                } else if (!this.mRetractDone && aTick % 5L == 0L && (this.mInventory[0] == null || this.mInventory[0].field_77994_a == 0 || GT_Utility.areStacksEqual(this.mInventory[0], MINING_PIPE) && this.mInventory[0].field_77994_a < this.mInventory[0].func_77976_d())) {
                    int tHeadY = this.getYOfPumpHead();
                    if (tHeadY < this.getBaseMetaTileEntity().getYCoord()) {
                        int tXCoord = this.getBaseMetaTileEntity().getXCoord();
                        int tZCoord = this.getBaseMetaTileEntity().getZCoord();
                        this.getBaseMetaTileEntity().getWorld().func_147468_f(tXCoord, tHeadY, tZCoord);
                        if (tHeadY < this.getBaseMetaTileEntity().getYCoord() - 1) {
                            this.getBaseMetaTileEntity().getWorld().func_147449_b(tXCoord, tHeadY + 1, tZCoord, MINING_PIPE_TIP_BLOCK);
                        }
                        if (this.mInventory[0] == null) {
                            ItemStack copy = MINING_PIPE.func_77946_l();
                            copy.field_77994_a = 1;
                            this.func_70299_a(0, copy);
                        } else {
                            ++this.mInventory[0].field_77994_a;
                        }
                        if (GT_Values.debugBlockPump) {
                            GT_Log.out.println("PUMP: Retracted one pipe");
                        }
                    } else {
                        this.mRetractDone = true;
                        if (GT_Values.debugBlockPump) {
                            GT_Log.out.println("PUMP: Retract done");
                        }
                    }
                }
                if (!this.mDisallowRetract) {
                    this.getBaseMetaTileEntity().setActive(!this.mPumpList.isEmpty());
                }
            }
            if (this.mFluid != null && aTick % 20L == 0L && (tTank = aBaseMetaTileEntity.getITankContainerAtSide((byte)1)) != null && (tDrained = this.drain(1000, false)) != null && (tFilledAmount = tTank.fill(ForgeDirection.DOWN, tDrained, false)) > 0) {
                tTank.fill(ForgeDirection.DOWN, this.drain(tFilledAmount, true), true);
            }
        }
    }

    private int getMaxPumpableDistance() {
        return GT_MetaTileEntity_Pump.getMaxDistanceForTier(this.mTier);
    }

    private long getEuUsagePerAction() {
        return GT_MetaTileEntity_Pump.getEuUsagePerTier(this.mTier);
    }

    private boolean hasValidFluid() {
        return this.mPrimaryPumpedBlock != null && this.mSecondaryPumpedBlock != null;
    }

    private boolean moveOneDown() {
        int z;
        if (this.mInventory[0] == null || this.mInventory[0].field_77994_a < 1 || !GT_Utility.areStacksEqual(this.mInventory[0], MINING_PIPE)) {
            if (GT_Values.debugBlockPump) {
                GT_Log.out.println("PUMP: No mining pipes");
            }
            return false;
        }
        int yHead = this.getYOfPumpHead();
        if (yHead <= 1) {
            if (GT_Values.debugBlockPump) {
                GT_Log.out.println("PUMP: At bottom");
            }
            return false;
        }
        int x = this.getBaseMetaTileEntity().getXCoord();
        if (!this.consumeFluid(x, yHead - 1, z = this.getBaseMetaTileEntity().getZCoord()) && !this.getBaseMetaTileEntity().getBlock(x, yHead - 1, z).isAir((IBlockAccess)this.getBaseMetaTileEntity().getWorld(), x, yHead - 1, z)) {
            if (GT_Values.debugBlockPump) {
                GT_Log.out.println("PUMP: Did not consume fluid, or non-airblock found");
            }
            return false;
        }
        if (!GT_Utility.setBlockByFakePlayer(this.getFakePlayer(this.getBaseMetaTileEntity()), x, yHead - 1, z, MINING_PIPE_TIP_BLOCK, 0, false)) {
            if (GT_Values.debugBlockPump) {
                GT_Log.out.println("PUMP: Could not set block below to new tip");
            }
            return false;
        }
        if (yHead != this.getBaseMetaTileEntity().getYCoord()) {
            this.getBaseMetaTileEntity().getWorld().func_147449_b(x, yHead, z, MINING_PIPE_BLOCK);
        }
        this.getBaseMetaTileEntity().func_70298_a(0, 1);
        if (GT_Values.debugBlockPump) {
            GT_Log.out.println("PUMP: Using 1 pipe");
        }
        return true;
    }

    private int getYOfPumpHead() {
        int y = this.getBaseMetaTileEntity().getYCoord() - 1;
        int x = this.getBaseMetaTileEntity().getXCoord();
        int z = this.getBaseMetaTileEntity().getZCoord();
        while (y > 0) {
            Block curBlock = this.getBaseMetaTileEntity().getBlock(x, y, z);
            if (curBlock == MINING_PIPE_BLOCK) {
                --y;
                continue;
            }
            if (curBlock != MINING_PIPE_TIP_BLOCK) break;
            Block nextBlock = this.getBaseMetaTileEntity().getBlock(x, y - 1, z);
            if (nextBlock == MINING_PIPE_BLOCK || nextBlock == MINING_PIPE_TIP_BLOCK) {
                this.clearQueue(true);
                this.getBaseMetaTileEntity().getWorld().func_147449_b(x, y, z, MINING_PIPE_BLOCK);
                if (GT_Values.debugBlockPump) {
                    GT_Log.out.println("PUMP: Hit pipes already in place, trying to merge");
                }
            }
            --y;
        }
        if (this.getBaseMetaTileEntity().getBlock(x, y, z) != MINING_PIPE_TIP_BLOCK) {
            if (y != this.getBaseMetaTileEntity().getYCoord() - 1 && this.getBaseMetaTileEntity().getBlock(x, y + 1, z) == MINING_PIPE_BLOCK) {
                this.clearQueue(true);
                this.getBaseMetaTileEntity().getWorld().func_147449_b(x, y + 1, z, MINING_PIPE_TIP_BLOCK);
                if (GT_Values.debugBlockPump) {
                    GT_Log.out.println("PUMP: Did not find a tip at bottom, setting last pipe as tip");
                }
            }
            return y + 1;
        }
        return y;
    }

    private void clearQueue(boolean checkPumping) {
        this.wasPumping = checkPumping ? !this.mPumpList.isEmpty() : false;
        this.mPumpList.clear();
    }

    private void rebuildPumpQueue(int aX, int yStart, int aZ, int yEnd) {
        int mDist = this.radiusConfig;
        this.doTickProfilingInThisTick = false;
        ArrayDeque<ChunkPosition> fluidsToSearch = new ArrayDeque<ChunkPosition>();
        ArrayDeque<ChunkPosition> fluidsFound = new ArrayDeque<ChunkPosition>();
        HashSet<ChunkPosition> checked = new HashSet<ChunkPosition>();
        this.clearQueue(false);
        for (int aY = yStart; this.mPumpList.isEmpty() && aY >= yEnd; --aY) {
            fluidsToSearch.add(new ChunkPosition(aX, aY, aZ));
            while (!fluidsToSearch.isEmpty()) {
                for (ChunkPosition tPos : fluidsToSearch) {
                    if (tPos.field_151329_a < aX + mDist) {
                        this.queueFluid(tPos.field_151329_a + 1, tPos.field_151327_b, tPos.field_151328_c, fluidsFound, checked);
                    }
                    if (tPos.field_151329_a > aX - mDist) {
                        this.queueFluid(tPos.field_151329_a - 1, tPos.field_151327_b, tPos.field_151328_c, fluidsFound, checked);
                    }
                    if (tPos.field_151328_c < aZ + mDist) {
                        this.queueFluid(tPos.field_151329_a, tPos.field_151327_b, tPos.field_151328_c + 1, fluidsFound, checked);
                    }
                    if (tPos.field_151328_c > aZ - mDist) {
                        this.queueFluid(tPos.field_151329_a, tPos.field_151327_b, tPos.field_151328_c - 1, fluidsFound, checked);
                    }
                    this.queueFluid(tPos.field_151329_a, tPos.field_151327_b + 1, tPos.field_151328_c, this.mPumpList, checked);
                }
                this.mPumpList.addAll(fluidsFound);
                fluidsToSearch = fluidsFound;
                fluidsFound = new ArrayDeque();
            }
            this.mPumpList.remove(new ChunkPosition(aX, aY, aZ));
        }
    }

    private boolean queueFluid(int aX, int aY, int aZ, ArrayDeque<ChunkPosition> fluidsFound, Set<ChunkPosition> checked) {
        Block aBlock;
        ChunkPosition tCoordinate = new ChunkPosition(aX, aY, aZ);
        if (checked.add(tCoordinate) && !fluidsFound.contains(tCoordinate) && (this.mPrimaryPumpedBlock == (aBlock = this.getBaseMetaTileEntity().getBlock(aX, aY, aZ)) || this.mSecondaryPumpedBlock == aBlock)) {
            fluidsFound.addFirst(tCoordinate);
            return true;
        }
        return false;
    }

    private void checkForFluidToPump(int aX, int aY, int aZ) {
        if (this.hasValidFluid()) {
            return;
        }
        Block aBlock = this.getBaseMetaTileEntity().getBlock(aX, aY, aZ);
        if (aBlock != null) {
            if (aBlock == Blocks.field_150355_j || aBlock == Blocks.field_150358_i) {
                this.mPrimaryPumpedBlock = Blocks.field_150355_j;
                this.mSecondaryPumpedBlock = Blocks.field_150358_i;
                return;
            }
            if (aBlock == Blocks.field_150353_l || aBlock == Blocks.field_150356_k) {
                this.mPrimaryPumpedBlock = Blocks.field_150353_l;
                this.mSecondaryPumpedBlock = Blocks.field_150356_k;
                return;
            }
            if (aBlock instanceof IFluidBlock) {
                this.mPrimaryPumpedBlock = aBlock;
                this.mSecondaryPumpedBlock = aBlock;
                return;
            }
        }
        this.mPrimaryPumpedBlock = null;
        this.mSecondaryPumpedBlock = null;
    }

    private boolean canMoveDown(int aX, int aY, int aZ) {
        if (!GT_Utility.eraseBlockByFakePlayer(this.getFakePlayer(this.getBaseMetaTileEntity()), aX, aY, aZ, true)) {
            return false;
        }
        Block aBlock = this.getBaseMetaTileEntity().getBlock(aX, aY, aZ);
        return aBlock != null && (aBlock == Blocks.field_150355_j || aBlock == Blocks.field_150358_i || aBlock == Blocks.field_150353_l || aBlock == Blocks.field_150356_k || aBlock instanceof IFluidBlock || aBlock.isAir((IBlockAccess)this.getBaseMetaTileEntity().getWorld(), aX, aY, aZ));
    }

    private boolean consumeFluid(int aX, int aY, int aZ) {
        if (!GT_Utility.eraseBlockByFakePlayer(this.getFakePlayer(this.getBaseMetaTileEntity()), aX, aY, aZ, true)) {
            return false;
        }
        Block aBlock = this.getBaseMetaTileEntity().getBlock(aX, aY, aZ);
        if (aBlock != null && (this.mPrimaryPumpedBlock == aBlock || this.mSecondaryPumpedBlock == aBlock)) {
            boolean isWaterOrLava;
            boolean bl = isWaterOrLava = this.mPrimaryPumpedBlock == Blocks.field_150355_j || this.mPrimaryPumpedBlock == Blocks.field_150353_l;
            if (isWaterOrLava && this.getBaseMetaTileEntity().getMetaID(aX, aY, aZ) != 0) {
                if (GT_Values.debugBlockPump) {
                    GT_Log.out.println("PUMP: Water/Lava - Not a source block");
                }
            } else if (this.mFluid == null) {
                this.mFluid = this.mPrimaryPumpedBlock == Blocks.field_150355_j ? GT_ModHandler.getWater(1000L) : (this.mPrimaryPumpedBlock == Blocks.field_150353_l ? GT_ModHandler.getLava(1000L) : ((IFluidBlock)aBlock).drain(this.getBaseMetaTileEntity().getWorld(), aX, aY, aZ, true));
            } else if (GT_ModHandler.isWater(this.mFluid) || GT_ModHandler.isLava(this.mFluid) || this.mFluid.isFluidEqual(((IFluidBlock)aBlock).drain(this.getBaseMetaTileEntity().getWorld(), aX, aY, aZ, false))) {
                if (!isWaterOrLava) {
                    this.getBaseMetaTileEntity().getWorld().func_147468_f(aX, aY, aZ);
                }
                this.mFluid.amount += 1000;
            } else {
                if (GT_Values.debugBlockPump) {
                    GT_Log.out.println("PUMP: Couldn't consume " + aBlock);
                }
                return false;
            }
            this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(this.getEuUsagePerAction(), true);
            this.getBaseMetaTileEntity().getWorld().func_147465_d(aX, aY, aZ, Blocks.field_150350_a, 0, 2);
            return true;
        }
        return false;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GT_UIInfos.openGTTileEntityUI(aBaseMetaTileEntity, aPlayer);
        return true;
    }

    @Override
    public ArrayList<String> getSpecialDebugInfo(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, int aLogLevel, ArrayList<String> aList) {
        aList.addAll(Arrays.asList(EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"GT5U.machines.pump") + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.machines.workarea") + ": " + EnumChatFormatting.GREEN + (this.radiusConfig * 2 + 1) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.machines.blocks"), "Primary pumping fluid:   " + (this.mPrimaryPumpedBlock != null ? this.mPrimaryPumpedBlock.func_149732_F() : "None"), "Secondary pumping fluid: " + (this.mSecondaryPumpedBlock != null ? this.mSecondaryPumpedBlock.func_149732_F() : "None"), "Pumps below: " + this.mPumpCountBelow, "Queue size: " + this.mPumpList.size(), "Pump head at Y: " + this.getYOfPumpHead(), "Pump timer: " + this.mPumpTimer, "Meta Entity Timer: " + this.getBaseMetaTileEntity().getTimer()));
        return aList;
    }

    @Override
    public boolean isSimpleMachine() {
        return false;
    }

    @Override
    public boolean isOverclockerUpgradable() {
        return false;
    }

    @Override
    public boolean isTransformerUpgradable() {
        return false;
    }

    @Override
    public boolean isElectric() {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    @Override
    public boolean isEnetInput() {
        return true;
    }

    @Override
    public boolean isInputFacing(byte aSide) {
        return true;
    }

    @Override
    public boolean isOutputFacing(byte aSide) {
        return false;
    }

    @Override
    public boolean isTeleporterCompatible() {
        return false;
    }

    @Override
    public long getMinimumStoredEU() {
        return GT_Values.V[this.mTier] * 16L;
    }

    @Override
    public long maxEUStore() {
        return GT_Values.V[this.mTier] * 64L;
    }

    @Override
    public long maxEUInput() {
        return GT_Values.V[this.mTier];
    }

    @Override
    public long maxSteamStore() {
        return this.maxEUStore();
    }

    @Override
    public long maxAmperesIn() {
        return 2L;
    }

    @Override
    public int getStackDisplaySlot() {
        return 2;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public int getCapacity() {
        return 16000 * this.mTier;
    }

    @Override
    public int getTankPressure() {
        return 100;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1], aSide == 0 || aSide == 1 ? TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT) : TextureFactory.of(Textures.BlockIcons.OVERLAY_ADV_PUMP)};
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return this.getTexturesInactive(aBaseTexture);
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{TextureFactory.of(Textures.BlockIcons.OVERLAY_ADV_PUMP), TextureFactory.of(Textures.BlockIcons.OVERLAY_ADV_PUMP), TextureFactory.of(Textures.BlockIcons.OVERLAY_ADV_PUMP), TextureFactory.of(Textures.BlockIcons.OVERLAY_ADV_PUMP)};
    }

    protected FakePlayer getFakePlayer(IGregTechTileEntity aBaseTile) {
        if (this.mFakePlayer == null) {
            this.mFakePlayer = GT_Utility.getFakePlayer(aBaseTile);
        }
        this.mFakePlayer.func_70029_a(aBaseTile.getWorld());
        this.mFakePlayer.func_70107_b((double)aBaseTile.getXCoord(), (double)aBaseTile.getYCoord(), (double)aBaseTile.getZCoord());
        return this.mFakePlayer;
    }

    @Override
    public String[] getInfoData() {
        return new String[]{EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"GT5U.machines.pump") + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.machines.workarea") + ": " + EnumChatFormatting.GREEN + (this.radiusConfig * 2 + 1) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.machines.blocks")};
    }

    @Override
    public boolean useModularUI() {
        return true;
    }
}

