/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.MachineType;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.power.BasicMachineEUPower;
import gregtech.common.power.Power;
import java.util.Arrays;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_Massfabricator
extends GT_MetaTileEntity_BasicMachine {
    public static int sUUAperUUM = 1;
    public static int sUUASpeedBonus = 4;
    public static int sDurationMultiplier = 3215;
    public static boolean sRequiresUUA = false;
    protected final long EUt;

    public GT_MetaTileEntity_Massfabricator(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, MachineType.MATTER_FABRICATOR.tooltipDescription(), 1, 1, "Massfabricator.png", "", TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_MASSFAB_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_SIDE_MASSFAB_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_MASSFAB), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_SIDE_MASSFAB_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_MASSFAB_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MASSFAB_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_MASSFAB), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MASSFAB_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_MASSFAB_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TOP_MASSFAB_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_MASSFAB), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TOP_MASSFAB_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_MASSFAB_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_BOTTOM_MASSFAB_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_MASSFAB), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_BOTTOM_MASSFAB_GLOW).glow().build()));
        this.EUt = GT_Values.V[1] * (long)Math.pow(2.0, this.mTier + 2);
    }

    public GT_MetaTileEntity_Massfabricator(String aName, int aTier, String aDescription, ITexture[][][] aTextures, String aGUIName, String aNEIName) {
        super(aName, aTier, 1, aDescription, aTextures, 1, 1, aGUIName, aNEIName);
        this.EUt = GT_Values.V[1] * (long)Math.pow(2.0, this.mTier + 2);
    }

    public GT_MetaTileEntity_Massfabricator(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures, String aGUIName, String aNEIName) {
        super(aName, aTier, 1, aDescription, aTextures, 1, 1, aGUIName, aNEIName);
        this.EUt = GT_Values.V[1] * (long)Math.pow(2.0, this.mTier + 2);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Massfabricator(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures, this.mGUIName, this.mNEIName);
    }

    @Override
    public boolean allowSelectCircuit() {
        return true;
    }

    @Override
    protected Power buildPower() {
        return new MassfabricatorPower(this.mTier, this.mAmperage);
    }

    @Override
    public void onConfigLoad(GT_Config aConfig) {
        super.onConfigLoad(aConfig);
        sDurationMultiplier = aConfig.get((Object)ConfigCategories.machineconfig, "Massfabricator.UUM_Duration_Multiplier", sDurationMultiplier);
        sUUAperUUM = aConfig.get((Object)ConfigCategories.machineconfig, "Massfabricator.UUA_per_UUM", sUUAperUUM);
        sUUASpeedBonus = aConfig.get((Object)ConfigCategories.machineconfig, "Massfabricator.UUA_Speed_Bonus", sUUASpeedBonus);
        sRequiresUUA = aConfig.get((Object)ConfigCategories.machineconfig, "Massfabricator.UUA_Requirement", sRequiresUUA);
        Materials.UUAmplifier.mChemicalFormula = "Mass Fabricator Eff/Speed Bonus: x" + sUUASpeedBonus;
    }

    @Override
    public long maxAmperesIn() {
        return 10L;
    }

    @Override
    public long maxEUStore() {
        return GT_Values.V[this.mTier] * 512L;
    }

    @Override
    public int checkRecipe() {
        FluidStack tFluid = this.getDrainableStack();
        if (tFluid == null || tFluid.amount < this.getCapacity()) {
            this.mOutputFluid = Materials.UUMatter.getFluid(1L);
            this.calculateOverclockedNess((int)this.EUt, this.containsUUA(this.getFillableStack()) ? sDurationMultiplier / sUUASpeedBonus : sDurationMultiplier);
            if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                return 1;
            }
            tFluid = this.getFillableStack();
            if (this.containsUUA(tFluid)) {
                tFluid.amount -= sUUAperUUM;
                return 2;
            }
            return sRequiresUUA || Arrays.stream(this.getAllInputs()).anyMatch(s -> ItemList.Circuit_Integrated.isStackEqual(s, true, true)) ? 1 : 2;
        }
        return 0;
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeList() {
        return GT_Recipe.GT_Recipe_Map.sMassFabFakeRecipes;
    }

    @Override
    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return aFluid.isFluidEqual(Materials.UUAmplifier.getFluid(1L));
    }

    @Override
    public int getCapacity() {
        return Math.max(sUUAperUUM, 1000);
    }

    private boolean containsUUA(FluidStack aFluid) {
        return aFluid != null && aFluid.amount >= sUUAperUUM && aFluid.isFluidEqual(Materials.UUAmplifier.getFluid(1L));
    }

    protected class MassfabricatorPower
    extends BasicMachineEUPower {
        protected MassfabricatorPower(byte tier, int amperage) {
            super(tier, amperage);
        }

        @Override
        public void computePowerUsageAndDuration(int euPerTick, int duration) {
            this.originalVoltage = this.computeVoltageForEuRate(euPerTick);
            if (GT_MetaTileEntity_Massfabricator.this.mTier == 0) {
                long xMaxProgresstime = (long)duration << 1;
                if (xMaxProgresstime > 0x7FFFFFFEL) {
                    this.recipeEuPerTick = 0x7FFFFFFE;
                    this.recipeDuration = 0x7FFFFFFE;
                } else {
                    this.recipeEuPerTick = (int)(GT_Values.V[1] << 2);
                    this.recipeDuration = (int)xMaxProgresstime;
                }
            } else {
                long xEUt = GT_MetaTileEntity_Massfabricator.this.EUt;
                long tempEUt = GT_Values.V[1];
                this.recipeDuration = duration;
                while (tempEUt <= GT_Values.V[GT_MetaTileEntity_Massfabricator.this.mTier - 1]) {
                    tempEUt <<= 2;
                    this.recipeDuration >>= 1;
                    if (this.recipeDuration != 0) continue;
                    xEUt = (long)((double)xEUt / 1.1);
                }
                if (xEUt > 0x7FFFFFFEL) {
                    this.recipeEuPerTick = 0x7FFFFFFE;
                    this.recipeDuration = 0x7FFFFFFE;
                } else {
                    this.recipeEuPerTick = (int)xEUt;
                    if (this.recipeEuPerTick == 0) {
                        this.recipeEuPerTick = 1;
                    }
                    if (this.recipeDuration == 0) {
                        this.recipeDuration = 1;
                    }
                }
            }
            this.wasOverclocked = this.checkIfOverclocked();
        }

        @Override
        public String getVoltageString() {
            long voltage = GT_Values.V[1];
            String voltageDescription = GT_Utility.formatNumbers(voltage) + " EU";
            voltageDescription = voltageDescription + GT_Utility.getTierNameWithParentheses(voltage);
            return voltageDescription;
        }

        @Override
        public String getAmperageString() {
            long amperage = (long)this.originalVoltage / GT_Values.V[1];
            int denominator = 1;
            for (int i = 1; i < GT_MetaTileEntity_Massfabricator.this.mTier; ++i) {
                if ((amperage >>= 1) != 0L) continue;
                denominator <<= 1;
            }
            if (amperage > 0L) {
                return GT_Utility.formatNumbers(amperage);
            }
            return "1/" + denominator;
        }
    }
}

