/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multiblock;

import com.google.common.primitives.Ints;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizon.structurelib.util.Vec3Impl;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.forge.ItemStackHandler;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.MultiChildWidget;
import com.gtnewhorizons.modularui.common.widget.SlotGroup;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.fluid.FluidTankGT;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.logic.ComplexParallelProcessingLogic;
import gregtech.api.multitileentity.enums.GT_MultiTileCasing;
import gregtech.api.multitileentity.multiblock.base.ComplexParallelController;
import gregtech.api.multitileentity.multiblock.base.MultiBlockPart;
import gregtech.api.multitileentity.multiblock.casing.Glasses;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.ArrayUtils;

public class AdvChemicalReactor
extends ComplexParallelController<AdvChemicalReactor> {
    private static IStructureDefinition<AdvChemicalReactor> STRUCTURE_DEFINITION = null;
    protected static final String STRUCTURE_PIECE_T1 = "T1";
    protected static final Vec3Impl STRUCTURE_OFFSET = new Vec3Impl(3, 1, 0);
    protected static final int PROCESS_WINDOW_BASE_ID = 100;
    protected static final int ITEM_WHITELIST_SLOTS = 8;
    protected static final int FLUID_WHITELIST_SLOTS = 8;
    protected static final int MAX_PROCESSES = 4;
    protected int numberOfProcessors = 4;
    protected HeatingCoilLevel coilTier;
    protected final ArrayList<HashSet<String>> processWhitelists = new ArrayList(4);
    protected final ArrayList<ItemStackHandler> processWhitelistInventoryHandlers = new ArrayList(4);
    protected final ArrayList<ArrayList<IFluidTank>> processFluidWhiteLists = new ArrayList(4);
    protected boolean wasWhitelistOpened = false;

    public AdvChemicalReactor() {
        for (int i = 0; i < 4; ++i) {
            this.processWhitelists.add(null);
            this.processWhitelistInventoryHandlers.add(new ItemStackHandler(8));
            ArrayList<FluidTankGT> processFluidTanks = new ArrayList<FluidTankGT>(8);
            for (int j = 0; j < 8; ++j) {
                processFluidTanks.add(new FluidTankGT());
            }
            this.processFluidWhiteLists.add(processFluidTanks);
        }
        this.processingLogic = new ComplexParallelProcessingLogic(this.getRecipeMap(), 4);
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GT_Recipe.GT_Recipe_Map_LargeChemicalReactor.sChemicalRecipes;
    }

    @Override
    public void readMultiTileNBT(NBTTagCompound nbt) {
        super.readMultiTileNBT(nbt);
        NBTTagCompound processWhiteLists = nbt.func_74775_l("whiteLists");
        long capacity = 1000L;
        if (nbt.func_74764_b("gt.tankcap")) {
            capacity = Ints.saturatedCast((long)nbt.func_74763_f("gt.tankcap"));
        }
        for (int i = 0; i < 4; ++i) {
            NBTTagList fluidList;
            this.registerInventory("processInventory" + i, "processInventory" + i, 8, 0);
            this.registerFluidInventory("processInventory" + i, "processInventory" + i, 8, capacity, (long)this.maxParallel * 2L, 0);
            if (processWhiteLists == null) continue;
            NBTTagCompound itemList = processWhiteLists.func_74775_l("items" + i);
            if (itemList != null) {
                this.processWhitelistInventoryHandlers.get(i).deserializeNBT(itemList);
            }
            if ((fluidList = processWhiteLists.func_150295_c("fluids" + i, 10)) == null) continue;
            for (int j = 0; j < fluidList.func_74745_c(); ++j) {
                NBTTagCompound fluid = fluidList.func_150305_b(j);
                if (fluid == null) continue;
                short index = fluid.func_74765_d("s");
                FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluid);
                if (fluidStack == null) continue;
                this.processFluidWhiteLists.get(i).get(index).fill(fluidStack, true);
            }
        }
    }

    @Override
    public void writeMultiTileNBT(NBTTagCompound nbt) {
        super.writeMultiTileNBT(nbt);
        NBTTagCompound processWhiteLists = new NBTTagCompound();
        for (int i = 0; i < 4; ++i) {
            processWhiteLists.func_74782_a("items" + i, (NBTBase)this.processWhitelistInventoryHandlers.get(i).serializeNBT());
            NBTTagList fluidList = new NBTTagList();
            for (int j = 0; j < 8; ++j) {
                FluidStack fluidStack = this.processFluidWhiteLists.get(i).get(j).getFluid();
                if (fluidStack == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74774_a("s", (byte)j);
                fluidStack.writeToNBT(tag);
                fluidList.func_74742_a((NBTBase)tag);
            }
            processWhiteLists.func_74782_a("fluids" + i, (NBTBase)fluidList);
        }
        nbt.func_74782_a("whiteLists", (NBTBase)processWhiteLists);
    }

    @Override
    public short getCasingRegistryID() {
        return 0;
    }

    @Override
    public int getCasingMeta() {
        return GT_MultiTileCasing.Chemical.getId();
    }

    @Override
    public GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Chemical Reactor").addInfo("Controller block for the Advanced Chemical Reactor").addInfo("Does not lose efficiency when overclocked").addInfo("Accepts fluids instead of fluid cells").addInfo("Can do multiple different recipes at once").addInfo("By using the whitelist filter a recipe can push its output").addInfo("to a different recipes input to chain them").addInfo(GT_Values.Authorminecraft7771).addSeparator().beginStructureBlock(5, 3, 3, false).addController("Front center").addCasingInfoExactly("PTFE Pipe Machine Casing", 8, false).addCasingInfoExactly("Heating Coils", 3, true).addCasingInfoExactly("EV+ Glass", 3, true).addCasingInfoExactly("Motor Casing", 3, true).addCasingInfoExactly("Chemical Casing", 27, false).toolTipFinisher("Gregtech");
        return tt;
    }

    @Override
    public Vec3Impl getStartingStructureOffset() {
        return STRUCTURE_OFFSET;
    }

    @Override
    public boolean checkMachine() {
        this.setCoilTier(HeatingCoilLevel.None);
        this.setMaxComplexParallels(4);
        this.buildState.startBuilding(this.getStartingStructureOffset());
        boolean result = this.checkPiece(STRUCTURE_PIECE_T1, this.buildState.stopBuilding());
        return result && super.checkMachine();
    }

    public void construct(ItemStack trigger, boolean hintsOnly) {
        this.buildState.startBuilding(this.getStartingStructureOffset());
        this.buildPiece(STRUCTURE_PIECE_T1, trigger, hintsOnly, this.buildState.stopBuilding());
    }

    @Override
    public IStructureDefinition<AdvChemicalReactor> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_T1, StructureUtility.transpose((String[][])new String[][]{{"CPCPC", "CCCCC", "CPCPC"}, {"CGC~C", "GWWWC", "CGCCC"}, {"CPCPC", "CTTTC", "CPCPC"}})).addElement('C', this.addMultiTileCasing("gt.multitileentity.casings", this.getCasingMeta(), MultiBlockPart.FLUID_IN | MultiBlockPart.ITEM_IN | MultiBlockPart.FLUID_OUT | MultiBlockPart.ITEM_OUT | MultiBlockPart.ENERGY_IN)).addElement('P', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings8, (int)1)).addElement('T', this.addMotorCasings(0)).addElement('W', GT_StructureUtility.ofCoil(AdvChemicalReactor::setCoilTier, AdvChemicalReactor::getCoilTier)).addElement('G', Glasses.chainAllGlasses()).build();
        }
        return STRUCTURE_DEFINITION;
    }

    @Override
    protected FluidStack[] getInputFluids(int index) {
        if (index < 0 || index >= 4) {
            return null;
        }
        if (this.separateInputs) {
            return (FluidStack[])ArrayUtils.addAll((Object[])this.getFluidInputsForTankArray("processInventory" + index), (Object[])FluidTankGT.getFluidsFromTanks(this.inputTanks));
        }
        return super.getInputFluids(index);
    }

    @Override
    protected ItemStack[] getInputItems(int index) {
        if (index < 0 || index >= 4) {
            return null;
        }
        if (this.separateInputs) {
            return (ItemStack[])ArrayUtils.addAll((Object[])this.getItemInputsForInventory("processInventory" + index), (Object[])this.inputInventory.getStacks().toArray(new ItemStack[0]));
        }
        return super.getInputItems(index);
    }

    @Override
    protected void outputItems(int index) {
        ComplexParallelProcessingLogic processingLogic = this.getComplexProcessingLogic();
        if (processingLogic != null && index >= 0 && index < this.maxComplexParallels) {
            for (int i = 0; i < 4; ++i) {
                if (this.processWhitelists.get(i) == null) {
                    this.generateWhitelist(i);
                }
                int outputIndex = i;
                this.outputItems((IItemHandlerModifiable)this.multiBlockInputInventory.get("processInventory" + i), (ItemStack[])Arrays.stream(processingLogic.getOutputItems(index)).filter(itemStack -> this.processWhitelists.get(outputIndex).contains(this.getWhitelistString((ItemStack)itemStack))).toArray(ItemStack[]::new));
            }
            if (processingLogic.getOutputItems(index) != null && processingLogic.getOutputItems(index).length > 0) {
                this.outputItems(processingLogic.getOutputItems(index));
            }
        }
    }

    @Override
    protected void outputFluids(int index) {
        ComplexParallelProcessingLogic processingLogic = this.getComplexProcessingLogic();
        if (processingLogic != null && index >= 0 && index < this.maxComplexParallels) {
            for (int i = 0; i < 4; ++i) {
                if (this.processWhitelists.get(i) == null) {
                    this.generateWhitelist(i);
                }
                int outputIndex = i;
                this.outputFluids((FluidTankGT[])this.multiBlockInputTank.get("processInventory" + i), (FluidStack[])Arrays.stream(processingLogic.getOutputFluids(index)).filter(fluidStack -> this.processWhitelists.get(outputIndex).contains(this.getWhitelistString((FluidStack)fluidStack))).toArray(FluidStack[]::new));
            }
            if (processingLogic.getOutputFluids(index) != null && processingLogic.getOutputFluids(index).length > 0) {
                this.outputFluids(processingLogic.getOutputFluids(index));
            }
        }
    }

    @Override
    protected MultiChildWidget createMainPage(IWidgetBuilder<?> builder) {
        MultiChildWidget child = super.createMainPage(builder);
        for (int i = 0; i < 4; ++i) {
            int processIndex = i;
            child.addChild(new ButtonWidget().setPlayClickSound(true).setOnClick((clickData, widget) -> {
                if (!widget.isClient()) {
                    widget.getContext().openSyncedWindow(100 + processIndex);
                }
            }).setBackground(new IDrawable[]{GT_UITextures.BUTTON_STANDARD, GT_UITextures.OVERLAY_BUTTON_WHITELIST}).setSize(18, 18).setPos(20 * i + 18, 18));
        }
        return child;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        for (int i = 0; i < 4; ++i) {
            int processIndex = i;
            buildContext.addSyncedWindow(100 + i, player -> this.createProcessConfigWindow(player, processIndex));
        }
        buildContext.addCloseListener(() -> {
            if (this.wasWhitelistOpened) {
                for (int i = 0; i < 4; ++i) {
                    this.processWhitelists.set(i, null);
                }
                this.wasWhitelistOpened = false;
            }
        });
    }

    protected ModularWindow createProcessConfigWindow(EntityPlayer player, int processIndex) {
        this.wasWhitelistOpened = true;
        ModularWindow.Builder builder = ModularWindow.builder((int)86, (int)100);
        builder.widget(new TextWidget("Process " + processIndex).setTextAlignment(Alignment.Center).setPos(13, 7));
        builder.setBackground(new IDrawable[]{GT_UITextures.BACKGROUND_SINGLEBLOCK_DEFAULT});
        builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)((IItemHandlerModifiable)this.processWhitelistInventoryHandlers.get(processIndex)), (int)4).startFromSlot(0).endAtSlot(7).phantom(true).background(new IDrawable[]{this.getGUITextureSet().getItemSlot()}).build().setPos(7, 19));
        builder.widget(SlotGroup.ofFluidTanks((List)this.processFluidWhiteLists.get(processIndex), (int)4).startFromSlot(0).endAtSlot(7).phantom(true).build().setPos(7, 55));
        return builder.build();
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.multiblock.advchemicalreactor";
    }

    @Override
    public String getLocalName() {
        return "Advanced Chemical Reactor";
    }

    public void setCoilTier(HeatingCoilLevel coilTier) {
        this.coilTier = coilTier;
    }

    public HeatingCoilLevel getCoilTier() {
        return this.coilTier;
    }

    @Override
    protected boolean hasPerfectOverclock() {
        return true;
    }

    protected void generateWhitelist(int processIndex) {
        HashSet<String> whitelist = new HashSet<String>();
        for (ItemStack itemStack : this.processWhitelistInventoryHandlers.get(processIndex).getStacks()) {
            if (itemStack == null) continue;
            whitelist.add(this.getWhitelistString(itemStack));
        }
        for (IFluidTank tank : this.processFluidWhiteLists.get(processIndex)) {
            if (tank.getFluid() == null) continue;
            whitelist.add(this.getWhitelistString(tank.getFluid()));
        }
        this.processWhitelists.set(processIndex, whitelist);
    }

    protected String getWhitelistString(ItemStack itemStack) {
        if (itemStack != null) {
            return itemStack.func_77977_a();
        }
        return null;
    }

    protected String getWhitelistString(FluidStack fluidStack) {
        if (fluidStack != null) {
            return fluidStack.getUnlocalizedName();
        }
        return null;
    }
}

