/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.storage;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.parts.IPart;
import appeng.api.storage.IExternalStorageHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.util.item.AEItemStack;
import appeng.util.item.ItemList;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.objects.AE2DigitalChestHandler;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.storage.GT_MetaTileEntity_QuantumChest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class GT_MetaTileEntity_DigitalChestBase
extends GT_MetaTileEntity_TieredMachineBlock
implements IMEMonitor<IAEItemStack>,
IAddUIWidgets {
    protected boolean mVoidOverflow = false;
    protected boolean mDisableFilter;
    private Map<IMEMonitorHandlerReceiver<IAEItemStack>, Object> listeners = null;

    public GT_MetaTileEntity_DigitalChestBase(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 3, new String[]{"This Chest stores " + GT_Utility.formatNumbers(GT_MetaTileEntity_DigitalChestBase.commonSizeCompute(aTier)) + " Blocks", "Use a screwdriver to enable", "voiding items on overflow", "Will keep its contents when harvested"}, new ITexture[0]);
    }

    protected static int commonSizeCompute(int tier) {
        int n;
        switch (tier) {
            case 1: {
                n = 4000000;
                break;
            }
            case 2: {
                n = 8000000;
                break;
            }
            case 3: {
                n = 16000000;
                break;
            }
            case 4: {
                n = 32000000;
                break;
            }
            case 5: {
                n = 64000000;
                break;
            }
            case 6: {
                n = 128000000;
                break;
            }
            case 7: {
                n = 256000000;
                break;
            }
            case 8: {
                n = 512000000;
                break;
            }
            case 9: {
                n = 1024000000;
                break;
            }
            case 10: {
                n = 0x7FFFFFF8;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    public GT_MetaTileEntity_DigitalChestBase(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    public GT_MetaTileEntity_DigitalChestBase(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    @Override
    public void addAdditionalTooltipInformation(ItemStack stack, List<String> tooltip) {
        if (stack.func_77942_o() && stack.field_77990_d.func_74764_b("mItemStack")) {
            ItemStack tContents = ItemStack.func_77949_a((NBTTagCompound)stack.field_77990_d.func_74775_l("mItemStack"));
            int tSize = stack.field_77990_d.func_74762_e("mItemCount");
            if (tContents != null && tSize > 0) {
                tooltip.add(GT_LanguageManager.addStringLocalization("TileEntity_CHEST_INFO", "Contains Item: ", !GregTech_API.sPostloadFinished) + EnumChatFormatting.YELLOW + tContents.func_82833_r() + EnumChatFormatting.GRAY);
                tooltip.add(GT_LanguageManager.addStringLocalization("TileEntity_CHEST_AMOUNT", "Item Amount: ", !GregTech_API.sPostloadFinished) + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(tSize) + EnumChatFormatting.GRAY);
            }
        }
    }

    public static void registerAEIntegration() {
        AEApi.instance().registries().externalStorage().addExternalStorageInterface((IExternalStorageHandler)new AE2DigitalChestHandler());
    }

    public void addListener(IMEMonitorHandlerReceiver<IAEItemStack> imeMonitorHandlerReceiver, Object o) {
        if (this.listeners == null) {
            this.listeners = new HashMap<IMEMonitorHandlerReceiver<IAEItemStack>, Object>();
        }
        this.listeners.put(imeMonitorHandlerReceiver, o);
    }

    public void removeListener(IMEMonitorHandlerReceiver<IAEItemStack> imeMonitorHandlerReceiver) {
        if (this.listeners == null) {
            this.listeners = new HashMap<IMEMonitorHandlerReceiver<IAEItemStack>, Object>();
        }
        this.listeners.remove(imeMonitorHandlerReceiver);
    }

    public AccessRestriction getAccess() {
        return AccessRestriction.READ_WRITE;
    }

    public boolean isPrioritized(IAEItemStack iaeItemStack) {
        ItemStack s = this.getItemStack();
        if (s == null || iaeItemStack == null) {
            return false;
        }
        return iaeItemStack.isSameType(s);
    }

    public boolean canAccept(IAEItemStack iaeItemStack) {
        ItemStack s = this.getItemStack();
        if (s == null || iaeItemStack == null) {
            return true;
        }
        return iaeItemStack.isSameType(s);
    }

    public int getPriority() {
        return 0;
    }

    public int getSlot() {
        return 0;
    }

    public boolean validForPass(int i) {
        return true;
    }

    protected abstract ItemStack getItemStack();

    protected abstract void setItemStack(ItemStack var1);

    public IItemList<IAEItemStack> getAvailableItems(IItemList out) {
        ItemStack storedStack = this.getItemStack();
        if (storedStack != null) {
            AEItemStack s = AEItemStack.create((ItemStack)storedStack);
            s.setStackSize((long)this.getItemCount());
            out.add((IAEStack)s);
        }
        return out;
    }

    public IItemList<IAEItemStack> getStorageList() {
        ItemList res = new ItemList();
        ItemStack storedStack = this.getItemStack();
        if (storedStack != null) {
            AEItemStack s = AEItemStack.create((ItemStack)storedStack);
            s.setStackSize((long)this.getItemCount());
            res.add((IAEStack)s);
        }
        return res;
    }

    protected abstract int getItemCount();

    @Override
    public abstract void setItemCount(int var1);

    @Override
    public int getMaxItemCount() {
        return GT_MetaTileEntity_DigitalChestBase.commonSizeCompute(this.mTier);
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return new ITexture[0][0][0];
    }

    public IAEItemStack injectItems(IAEItemStack input, Actionable mode, BaseActionSource src) {
        if (this.getBaseMetaTileEntity() == null) {
            return input;
        }
        ItemStack inputStack = input.getItemStack();
        int maxCapacity = this.getMaxItemCount();
        int itemCount = this.getItemCount();
        long toAdd = input.getStackSize();
        ItemStack storedStack = this.getItemStack();
        if (storedStack != null && !GT_Utility.areStacksEqual(storedStack, inputStack)) {
            return input;
        }
        long notAdded = (long)itemCount + toAdd - (long)maxCapacity;
        if (mode == Actionable.MODULATE) {
            int newCount = (int)Math.min((long)maxCapacity, (long)itemCount + toAdd);
            if (storedStack == null) {
                this.setItemStack(inputStack.func_77946_l());
            }
            this.setItemCount(newCount);
            this.getBaseMetaTileEntity().func_70296_d();
        }
        if (this.mVoidOverflow || notAdded <= 0L) {
            return null;
        }
        return (IAEItemStack)input.copy().setStackSize(notAdded);
    }

    public IAEItemStack extractItems(IAEItemStack request, Actionable mode, BaseActionSource src) {
        if (request.isSameType(this.getItemStack())) {
            if (this.getBaseMetaTileEntity() == null) {
                return null;
            }
            if (mode != Actionable.SIMULATE) {
                this.getBaseMetaTileEntity().func_70296_d();
            }
            if (request.getStackSize() >= (long)this.getItemCount()) {
                AEItemStack result = AEItemStack.create((ItemStack)this.getItemStack());
                result.setStackSize((long)this.getItemCount());
                if (mode != Actionable.SIMULATE) {
                    this.setItemCount(0);
                }
                return result;
            }
            if (mode != Actionable.SIMULATE) {
                this.setItemCount(this.getItemCount() - (int)request.getStackSize());
            }
            return request.copy();
        }
        return null;
    }

    public StorageChannel getChannel() {
        return StorageChannel.ITEMS;
    }

    @Override
    public final void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.mVoidOverflow = !this.mVoidOverflow;
        GT_Utility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)(this.mVoidOverflow ? "GT5U.machines.digitalchest.voidoverflow.enabled" : "GT5U.machines.digitalchest.voidoverflow.disabled")));
    }

    @Override
    public boolean onSolderingToolRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (super.onSolderingToolRightClick(side, wrenchingSide, aPlayer, aX, aY, aZ)) {
            return true;
        }
        this.mDisableFilter = !this.mDisableFilter;
        GT_Utility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)(this.mDisableFilter ? "GT5U.machines.digitalchest.inputfilter.disabled" : "GT5U.machines.digitalchest.inputfilter.enabled")));
        return true;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        if (this.getBaseMetaTileEntity().isServerSide() && this.getBaseMetaTileEntity().isAllowedToWork()) {
            if (this.getItemCount() <= 0) {
                this.setItemStack(null);
                this.setItemCount(0);
            }
            if (this.getItemStack() == null && this.mInventory[0] != null) {
                this.setItemStack(this.mInventory[0].func_77946_l());
            }
            int count = this.getItemCount();
            ItemStack stack = this.getItemStack();
            int savedCount = count;
            if (this.mInventory[0] != null && (count < this.getMaxItemCount() || this.mVoidOverflow) && GT_Utility.areStacksEqual(this.mInventory[0], stack)) {
                if ((count += this.mInventory[0].field_77994_a) <= this.getMaxItemCount()) {
                    this.mInventory[0] = null;
                } else {
                    if (this.mVoidOverflow) {
                        this.mInventory[0] = null;
                    } else {
                        this.mInventory[0].field_77994_a = count - this.getMaxItemCount();
                    }
                    count = this.getMaxItemCount();
                }
            }
            if (this.mInventory[1] == null && stack != null) {
                this.mInventory[1] = stack.func_77946_l();
                this.mInventory[1].field_77994_a = Math.min(stack.func_77976_d(), count);
                count -= this.mInventory[1].field_77994_a;
            } else if (count > 0 && GT_Utility.areStacksEqual(this.mInventory[1], stack) && this.mInventory[1].func_77976_d() > this.mInventory[1].field_77994_a) {
                int tmp = Math.min(count, this.mInventory[1].func_77976_d() - this.mInventory[1].field_77994_a);
                this.mInventory[1].field_77994_a += tmp;
                count -= tmp;
            }
            this.setItemCount(count);
            if (stack != null) {
                this.mInventory[2] = stack.func_77946_l();
                this.mInventory[2].field_77994_a = Math.min(stack.func_77976_d(), count);
            } else {
                this.mInventory[2] = null;
            }
            if (GregTech_API.mAE2) {
                this.notifyListeners(count - savedCount, stack);
            }
            if (count != savedCount) {
                this.getBaseMetaTileEntity().func_70296_d();
            }
        }
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GT_UIInfos.openGTTileEntityUI(aBaseMetaTileEntity, aPlayer);
        return true;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return aIndex != 2;
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public int getProgresstime() {
        return this.getItemCount() + (this.mInventory[0] == null ? 0 : this.mInventory[0].field_77994_a) + (this.mInventory[1] == null ? 0 : this.mInventory[1].field_77994_a);
    }

    @Override
    public int maxProgresstime() {
        return this.getMaxItemCount();
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        if (this.getItemStack() == null) {
            return new String[]{EnumChatFormatting.BLUE + this.chestName() + EnumChatFormatting.RESET, "Stored Items:", EnumChatFormatting.GOLD + "No Items" + EnumChatFormatting.RESET, EnumChatFormatting.GREEN + "0" + EnumChatFormatting.RESET + " " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(this.getMaxItemCount()) + EnumChatFormatting.RESET};
        }
        return new String[]{EnumChatFormatting.BLUE + this.chestName() + EnumChatFormatting.RESET, "Stored Items:", EnumChatFormatting.GOLD + this.getItemStack().func_82833_r() + EnumChatFormatting.RESET, EnumChatFormatting.GREEN + GT_Utility.formatNumbers(this.getItemCount()) + EnumChatFormatting.RESET + " " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(this.getMaxItemCount()) + EnumChatFormatting.RESET};
    }

    @Override
    public ItemStack[] getStoredItemData() {
        return this.mInventory;
    }

    protected abstract String chestName();

    private void notifyListeners(int count, ItemStack stack) {
        if (this.listeners == null) {
            this.listeners = new HashMap<IMEMonitorHandlerReceiver<IAEItemStack>, Object>();
            return;
        }
        if (count == 0 || stack == null) {
            return;
        }
        ItemList change = new ItemList();
        AEItemStack s = AEItemStack.create((ItemStack)stack);
        s.setStackSize((long)count);
        change.add((IAEItemStack)s);
        this.listeners.forEach((l, o) -> {
            if (l.isValid(o)) {
                l.postChange((IBaseMonitor)this, (Iterable)change, null);
            } else {
                this.removeListener((IMEMonitorHandlerReceiver<IAEItemStack>)l);
            }
        });
    }

    private boolean hasActiveMEConnection() {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return false;
        }
        for (Map.Entry<IMEMonitorHandlerReceiver<IAEItemStack>, Object> e : this.listeners.entrySet()) {
            IGridNode n;
            if (!(e.getKey() instanceof IPart) || (n = ((IPart)e.getKey()).getGridNode()) == null || !n.isActive()) continue;
            return true;
        }
        this.listeners.clear();
        return false;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mItemCount", this.getItemCount());
        if (this.getItemStack() != null) {
            aNBT.func_74782_a("mItemStack", (NBTBase)this.getItemStack().func_77955_b(new NBTTagCompound()));
        }
        aNBT.func_74757_a("mVoidOverflow", this.mVoidOverflow);
        aNBT.func_74757_a("mDisableFilter", this.mDisableFilter);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        if (aNBT.func_74764_b("mItemCount")) {
            this.setItemCount(aNBT.func_74762_e("mItemCount"));
        }
        if (aNBT.func_74764_b("mItemStack")) {
            this.setItemStack(ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)aNBT.func_74781_a("mItemStack"))));
        }
        this.mVoidOverflow = aNBT.func_74767_n("mVoidOverflow");
        this.mDisableFilter = aNBT.func_74767_n("mDisableFilter");
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        if (GregTech_API.mAE2 && GT_Values.disableDigitalChestsExternalAccess && this.hasActiveMEConnection()) {
            return false;
        }
        return aIndex == 1;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        if (GregTech_API.mAE2 && GT_Values.disableDigitalChestsExternalAccess && this.hasActiveMEConnection()) {
            return false;
        }
        if (aIndex != 0) {
            return false;
        }
        if (this.mInventory[0] != null && !GT_Utility.areStacksEqual(this.mInventory[0], aStack)) {
            return false;
        }
        if (this.mDisableFilter) {
            return true;
        }
        if (this.getItemStack() == null) {
            return this.mInventory[1] == null || GT_Utility.areStacksEqual(this.mInventory[1], aStack);
        }
        return GT_Utility.areStacksEqual(this.getItemStack(), aStack);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side != aFacing) {
            return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][colorIndex + 1]};
        }
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][colorIndex + 1], TextureFactory.of(Textures.BlockIcons.OVERLAY_SCHEST), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_SCHEST_GLOW).glow().build()};
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_150297_b("itemType", 10)) {
            currenttip.add("Item Count: " + GT_Utility.parseNumberToString(tag.func_74762_e("itemCount")));
            currenttip.add("Item Type: " + ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("itemType")).func_82833_r());
        } else {
            currenttip.add("Chest Empty");
        }
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        ItemStack is = this.getItemStack();
        if (GT_Utility.isStackInvalid(is)) {
            return;
        }
        int realItemCount = this.getItemCount();
        if (GT_Utility.isStackValid(this.mInventory[1]) && GT_Utility.areStacksEqual(this.mInventory[1], is)) {
            realItemCount += this.mInventory[1].field_77994_a;
        }
        tag.func_74768_a("itemCount", realItemCount);
        tag.func_74782_a("itemType", (NBTBase)is.func_77955_b(new NBTTagCompound()));
    }

    @Override
    public boolean useModularUI() {
        return true;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_SCREEN_BLACK).setPos(7, 16).setSize(71, 45))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 0).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GT_UITextures.OVERLAY_SLOT_IN}).setPos(79, 16))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 1).setAccess(true, false).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GT_UITextures.OVERLAY_SLOT_OUT}).setPos(79, 52))).widget(SlotWidget.phantom((IItemHandlerModifiable)this.inventoryHandler, (int)2).disableInteraction().setBackground(new IDrawable[]{GT_UITextures.TRANSPARENT}).setPos(59, 42))).widget(new TextWidget("Item Amount").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(10, 20))).widget(TextWidget.dynamicString(() -> GT_Utility.parseNumberToString(this instanceof GT_MetaTileEntity_QuantumChest ? ((GT_MetaTileEntity_QuantumChest)this).mItemCount : 0)).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(10, 30));
    }
}

