/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.GregTech_API;
import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_RecipeConstants;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Proxy;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ProcessingGem
implements IOreRecipeRegistrator {
    public ProcessingGem() {
        OrePrefixes.gem.add(this);
        OrePrefixes.gemChipped.add(this);
        OrePrefixes.gemExquisite.add(this);
        OrePrefixes.gemFlawed.add(this);
        OrePrefixes.gemFlawless.add(this);
    }

    @Override
    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        long aMaterialMass = aMaterial.getMass();
        boolean aNoSmashing = aMaterial.contains(SubTag.NO_SMASHING);
        boolean aNoWorking = aMaterial.contains(SubTag.NO_WORKING);
        boolean aNoSmelting = aMaterial.contains(SubTag.NO_SMELTING);
        boolean aSpecialRecipeReq = aMaterial.contains(SubTag.MORTAR_GRINDABLE) && GregTech_API.sRecipeFile.get((Object)ConfigCategories.Tools.mortar, aMaterial.mName, true);
        boolean aFuelPower = aMaterial.mFuelPower > 0;
        switch (aPrefix) {
            case gem: {
                if (aFuelPower) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack)).noItemOutputs().noFluidInputs().noFluidOutputs().metadata(GT_RecipeConstants.FUEL_VALUE, aMaterial.mFuelPower * 2).metadata(GT_RecipeConstants.FUEL_TYPE, aMaterial.mFuelType).duration(0).eut(0).addTo(GT_RecipeConstants.Fuel);
                }
                if (!OrePrefixes.block.isIgnored(aMaterial) && GT_OreDictUnificator.get(OrePrefixes.block, aMaterial, 1L) != null && aMaterial != Materials.Iridium) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(9L, aStack)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.block, aMaterial, 1L)).noFluidInputs().noFluidOutputs().duration(300).eut(2).addTo(GT_Recipe.GT_Recipe_Map.sCompressorRecipes);
                }
                if (!aNoSmelting) {
                    GT_ModHandler.addSmeltingRecipe(GT_Utility.copyAmount(1L, aStack), GT_OreDictUnificator.get(OrePrefixes.ingot, aMaterial.mSmeltInto, 1L));
                }
                if (aNoSmashing) {
                    if (GT_OreDictUnificator.get(OrePrefixes.gemFlawed, aMaterial, 1L) != null) {
                        GT_Values.RA.stdBuilder().itemInputs(aStack).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gemFlawed, aMaterial, 2L)).noFluidInputs().noFluidOutputs().duration(64).eut(16).addTo(GT_Recipe.GT_Recipe_Map.sHammerRecipes);
                    }
                } else {
                    if (GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L) != null && aMaterial != Materials.Iridium) {
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L)).noFluidInputs().noFluidOutputs().duration(Math.max(aMaterialMass, 1L)).eut(GT_Utility.calculateRecipeEU(aMaterial, 16)).addTo(GT_Recipe.GT_Recipe_Map.sHammerRecipes);
                    }
                    if (GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L) != null) {
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), GT_Utility.getIntegratedCircuit(1)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L)).noFluidInputs().noFluidOutputs().duration((int)Math.max(aMaterialMass * 2L, 1L)).eut(GT_Utility.calculateRecipeEU(aMaterial, 24)).addTo(GT_Recipe.GT_Recipe_Map.sBenderRecipes);
                    }
                    if (GT_OreDictUnificator.get(OrePrefixes.plateDouble, aMaterial, 1L) != null) {
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(2L, aStack), GT_Utility.getIntegratedCircuit(2)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.plateDouble, aMaterial, 1L)).noFluidInputs().noFluidOutputs().duration(Math.max(aMaterialMass * 2L, 1L)).eut(GT_Utility.calculateRecipeEU(aMaterial, 96)).addTo(GT_Recipe.GT_Recipe_Map.sBenderRecipes);
                    }
                    if (GT_OreDictUnificator.get(OrePrefixes.plateTriple, aMaterial, 1L) != null) {
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(3L, aStack), GT_Utility.getIntegratedCircuit(3)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.plateTriple, aMaterial, 1L)).noFluidInputs().noFluidOutputs().duration(Math.max(aMaterialMass * 3L, 1L)).eut(GT_Utility.calculateRecipeEU(aMaterial, 96)).addTo(GT_Recipe.GT_Recipe_Map.sBenderRecipes);
                    }
                    if (GT_OreDictUnificator.get(OrePrefixes.plateQuadruple, aMaterial, 1L) != null) {
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(4L, aStack), GT_Utility.getIntegratedCircuit(4)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.plateQuadruple, aMaterial, 1L)).noFluidInputs().noFluidOutputs().duration(Math.max(aMaterialMass * 4L, 1L)).eut(GT_Utility.calculateRecipeEU(aMaterial, 96)).addTo(GT_Recipe.GT_Recipe_Map.sBenderRecipes);
                    }
                    if (GT_OreDictUnificator.get(OrePrefixes.plateQuintuple, aMaterial, 1L) != null) {
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(5L, aStack), GT_Utility.getIntegratedCircuit(5)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.plateQuintuple, aMaterial, 1L)).noFluidInputs().noFluidOutputs().duration(Math.max(aMaterialMass * 5L, 1L)).eut(GT_Utility.calculateRecipeEU(aMaterial, 96)).addTo(GT_Recipe.GT_Recipe_Map.sBenderRecipes);
                    }
                    if (GT_OreDictUnificator.get(OrePrefixes.plateDense, aMaterial, 1L) != null) {
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(9L, aStack), GT_Utility.getIntegratedCircuit(9)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.plateDense, aMaterial, 1L)).noFluidInputs().noFluidOutputs().duration(Math.max(aMaterialMass * 9L, 1L)).eut(GT_Utility.calculateRecipeEU(aMaterial, 96)).addTo(GT_Recipe.GT_Recipe_Map.sBenderRecipes);
                    }
                }
                if (aNoWorking) {
                    if ((long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV && GT_OreDictUnificator.get(OrePrefixes.stick, aMaterial, 1L) != null && GT_OreDictUnificator.get(OrePrefixes.dustSmall, aMaterial, 1L) != null) {
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.stick, aMaterial, 1L), GT_OreDictUnificator.get(OrePrefixes.dustSmall, aMaterial, 2L)).noFluidInputs().noFluidOutputs().duration((int)Math.max(aMaterialMass, 1L) * 1).eut(GT_Utility.calculateRecipeEU(aMaterial, 16)).addTo(GT_Recipe.GT_Recipe_Map.sLatheRecipes);
                    }
                } else if (aMaterial.mUnificatable && aMaterial.mMaterialInto == aMaterial) {
                    if (GT_OreDictUnificator.get(OrePrefixes.gemFlawless, aMaterial, 1L) != null) {
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(3L, aStack), ItemList.Block_Powderbarrel.get(16L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gemFlawless, aMaterial, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 2L)).noFluidInputs().noFluidOutputs().duration(20).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sImplosionRecipes);
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(3L, aStack), GT_ModHandler.getIC2Item("dynamite", 4L, null)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gemFlawless, aMaterial, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 2L)).noFluidInputs().noFluidOutputs().duration(20).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sImplosionRecipes);
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(3L, aStack), new ItemStack(Blocks.field_150335_W, 8)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gemFlawless, aMaterial, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 2L)).noFluidInputs().noFluidOutputs().duration(20).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sImplosionRecipes);
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(3L, aStack), GT_ModHandler.getIC2Item("industrialTnt", 2L)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gemFlawless, aMaterial, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 2L)).noFluidInputs().noFluidOutputs().duration(20).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sImplosionRecipes);
                    }
                    GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.gem, aMaterial, 2L), GT_Proxy.tBits, new Object[]{"h", "X", Character.valueOf('X'), OrePrefixes.gemFlawless.get(aMaterial)});
                    if (aMaterial.contains(SubTag.SMELTING_TO_GEM)) {
                        GT_ModHandler.addCraftingRecipe(GT_Utility.copyAmount(1L, aStack), GT_Proxy.tBits, new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), OrePrefixes.nugget.get(aMaterial)});
                    }
                    if (aSpecialRecipeReq) {
                        GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.dust, aMaterial, 1L), GT_Proxy.tBits, new Object[]{"X", "m", Character.valueOf('X'), OrePrefixes.gem.get(aMaterial)});
                    }
                }
                switch (aMaterial.mName) {
                    case "NULL": {
                        break;
                    }
                    case "Coal": 
                    case "Charcoal": {
                        if (!GregTech_API.sRecipeFile.get((Object)ConfigCategories.Recipes.disabledrecipes, "torchesFromCoal", false)) break;
                        GT_ModHandler.removeRecipeDelayed(GT_Utility.copyAmount(1L, aStack), null, null, new ItemStack(Items.field_151055_y, 1, 0));
                        break;
                    }
                    case "CertusQuartz": {
                        GT_Values.RA.stdBuilder().itemInputs(aStack).itemOutputs(GT_ModHandler.getModItem(Mods.AppliedEnergistics2.ID, "item.ItemMultiMaterial", 1L, 1)).noFluidInputs().noFluidOutputs().duration(2000).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sElectrolyzerRecipes);
                    }
                }
                for (ItemStack is : OreDictionary.getOres((String)("craftingLens" + aMaterial.mColor.mName.replace(" ", "")))) {
                    if (GT_OreDictUnificator.get(OrePrefixes.gemFlawless, aMaterial, 1L) == null) continue;
                    is.field_77994_a = 0;
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(3L, aStack), is).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gemFlawless, aMaterial, 1L)).noFluidInputs().noFluidOutputs().duration(1200).eut(TierEU.RECIPE_HV).addTo(GT_Recipe.GT_Recipe_Map.sLaserEngraverRecipes);
                }
                break;
            }
            case gemChipped: {
                if (aFuelPower) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack)).noItemOutputs().noFluidInputs().noFluidOutputs().metadata(GT_RecipeConstants.FUEL_VALUE, aMaterial.mFuelPower / 2).metadata(GT_RecipeConstants.FUEL_TYPE, aMaterial.mFuelType).duration(0).eut(0).addTo(GT_RecipeConstants.Fuel);
                }
                if (!aNoWorking) {
                    if (GT_OreDictUnificator.get(OrePrefixes.bolt, aMaterial, 1L) != null && GT_OreDictUnificator.get(OrePrefixes.dustTiny, aMaterial, 1L) != null) {
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.bolt, aMaterial, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, aMaterial, 1L)).noFluidInputs().noFluidOutputs().duration((int)Math.max(aMaterialMass, 1L) * 1).eut(8).addTo(GT_Recipe.GT_Recipe_Map.sLatheRecipes);
                    }
                    if (aMaterial.mUnificatable && aMaterial.mMaterialInto == aMaterial) {
                        if (GT_OreDictUnificator.get(OrePrefixes.gemFlawed, aMaterial, 1L) != null) {
                            GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(3L, aStack), ItemList.Block_Powderbarrel.get(16L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gemFlawed, aMaterial, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 2L)).noFluidInputs().noFluidOutputs().duration(20).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sImplosionRecipes);
                            GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(3L, aStack), GT_ModHandler.getIC2Item("dynamite", 4L, null)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gemFlawed, aMaterial, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 2L)).noFluidInputs().noFluidOutputs().duration(20).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sImplosionRecipes);
                            GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(3L, aStack), new ItemStack(Blocks.field_150335_W, 8)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gemFlawed, aMaterial, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 2L)).noFluidInputs().noFluidOutputs().duration(20).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sImplosionRecipes);
                            GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(3L, aStack), GT_ModHandler.getIC2Item("industrialTnt", 2L)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gemFlawed, aMaterial, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 2L)).noFluidInputs().noFluidOutputs().duration(20).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sImplosionRecipes);
                        }
                        GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.gemChipped, aMaterial, 2L), GT_Proxy.tBits, new Object[]{"h", "X", Character.valueOf('X'), OrePrefixes.gemFlawed.get(aMaterial)});
                        if (aSpecialRecipeReq) {
                            GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.dustSmall, aMaterial, 1L), GT_Proxy.tBits, new Object[]{"X", "m", Character.valueOf('X'), OrePrefixes.gemChipped.get(aMaterial)});
                        }
                    }
                }
                for (ItemStack is : OreDictionary.getOres((String)("craftingLens" + aMaterial.mColor.mName.replace(" ", "")))) {
                    is.field_77994_a = 0;
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(3L, aStack), is).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gemFlawed, aMaterial, 1L)).noFluidInputs().noFluidOutputs().duration(600).eut(30).addTo(GT_Recipe.GT_Recipe_Map.sLaserEngraverRecipes);
                }
                break;
            }
            case gemExquisite: {
                if (aFuelPower) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack)).noItemOutputs().noFluidInputs().noFluidOutputs().metadata(GT_RecipeConstants.FUEL_VALUE, aMaterial.mFuelPower * 8).metadata(GT_RecipeConstants.FUEL_TYPE, aMaterial.mFuelType).duration(0).eut(0).addTo(GT_RecipeConstants.Fuel);
                }
                if (!aNoWorking && aMaterial.mUnificatable && aMaterial.mMaterialInto == aMaterial && aSpecialRecipeReq) {
                    GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.dust, aMaterial, 4L), GT_Proxy.tBits, new Object[]{"X", "m", Character.valueOf('X'), OrePrefixes.gemExquisite.get(aMaterial)});
                }
                GT_Values.RA.stdBuilder().itemInputs(aStack).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gemFlawless, aMaterial, 2L)).noFluidInputs().noFluidOutputs().duration(64).eut(16).addTo(GT_Recipe.GT_Recipe_Map.sHammerRecipes);
                break;
            }
            case gemFlawed: {
                if (aFuelPower) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack)).noItemOutputs().noFluidInputs().noFluidOutputs().metadata(GT_RecipeConstants.FUEL_VALUE, aMaterial.mFuelPower).metadata(GT_RecipeConstants.FUEL_TYPE, aMaterial.mFuelType).duration(0).eut(0).addTo(GT_RecipeConstants.Fuel);
                }
                if (!aNoWorking) {
                    if (GT_OreDictUnificator.get(OrePrefixes.bolt, aMaterial, 1L) != null && GT_OreDictUnificator.get(OrePrefixes.dustSmall, aMaterial, 1L) != null) {
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.bolt, aMaterial, 2L), GT_OreDictUnificator.get(OrePrefixes.dustSmall, aMaterial, 1L)).noFluidInputs().noFluidOutputs().duration((int)Math.max(aMaterialMass, 1L) * 1).eut(12).addTo(GT_Recipe.GT_Recipe_Map.sLatheRecipes);
                    }
                    if (aMaterial.mUnificatable && aMaterial.mMaterialInto == aMaterial) {
                        if (GT_OreDictUnificator.get(OrePrefixes.gem, aMaterial, 1L) != null) {
                            GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(3L, aStack), ItemList.Block_Powderbarrel.get(16L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gem, aMaterial, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 2L)).noFluidInputs().noFluidOutputs().duration(20).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sImplosionRecipes);
                            GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(3L, aStack), GT_ModHandler.getIC2Item("dynamite", 4L, null)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gem, aMaterial, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 2L)).noFluidInputs().noFluidOutputs().duration(20).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sImplosionRecipes);
                            GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(3L, aStack), new ItemStack(Blocks.field_150335_W, 8)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gem, aMaterial, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 2L)).noFluidInputs().noFluidOutputs().duration(20).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sImplosionRecipes);
                            GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(3L, aStack), GT_ModHandler.getIC2Item("industrialTnt", 2L)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gem, aMaterial, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 2L)).noFluidInputs().noFluidOutputs().duration(20).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sImplosionRecipes);
                        }
                        GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.gemFlawed, aMaterial, 2L), GT_Proxy.tBits, new Object[]{"h", "X", Character.valueOf('X'), OrePrefixes.gem.get(aMaterial)});
                        if (aSpecialRecipeReq) {
                            GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.dustSmall, aMaterial, 2L), GT_Proxy.tBits, new Object[]{"X", "m", Character.valueOf('X'), OrePrefixes.gemFlawed.get(aMaterial)});
                        }
                    }
                }
                GT_Values.RA.stdBuilder().itemInputs(aStack).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gemChipped, aMaterial, 2L)).noFluidInputs().noFluidOutputs().duration(64).eut(16).addTo(GT_Recipe.GT_Recipe_Map.sHammerRecipes);
                for (ItemStack is : OreDictionary.getOres((String)("craftingLens" + aMaterial.mColor.mName.replace(" ", "")))) {
                    is.field_77994_a = 0;
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(3L, aStack), is).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gem, aMaterial, 1L)).noFluidInputs().noFluidOutputs().duration(600).eut(TierEU.RECIPE_MV).addTo(GT_Recipe.GT_Recipe_Map.sLaserEngraverRecipes);
                }
                break;
            }
            case gemFlawless: {
                if (aFuelPower) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack)).noItemOutputs().noFluidInputs().noFluidOutputs().metadata(GT_RecipeConstants.FUEL_VALUE, aMaterial.mFuelPower * 4).metadata(GT_RecipeConstants.FUEL_TYPE, aMaterial.mFuelType).duration(0).eut(0).addTo(GT_RecipeConstants.Fuel);
                }
                if (!aNoWorking) {
                    if (GT_OreDictUnificator.get(OrePrefixes.stickLong, aMaterial, 1L) != null && GT_OreDictUnificator.get(OrePrefixes.dust, aMaterial, 1L) != null) {
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.stickLong, aMaterial, 1L), GT_OreDictUnificator.getDust(aMaterial, aPrefix.mMaterialAmount - OrePrefixes.stickLong.mMaterialAmount)).noFluidInputs().noFluidOutputs().duration((int)Math.max(aMaterialMass * 5L, 1L) * 1).eut(16).addTo(GT_Recipe.GT_Recipe_Map.sLatheRecipes);
                    }
                    if (aMaterial.mUnificatable && aMaterial.mMaterialInto == aMaterial) {
                        if (GT_OreDictUnificator.get(OrePrefixes.gemExquisite, aMaterial, 1L) != null) {
                            GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(3L, aStack), ItemList.Block_Powderbarrel.get(16L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gemExquisite, aMaterial, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 2L)).noFluidInputs().noFluidOutputs().duration(20).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sImplosionRecipes);
                            GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(3L, aStack), GT_ModHandler.getIC2Item("dynamite", 4L, null)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gemExquisite, aMaterial, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 2L)).noFluidInputs().noFluidOutputs().duration(20).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sImplosionRecipes);
                            GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(3L, aStack), new ItemStack(Blocks.field_150335_W, 8)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gemExquisite, aMaterial, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 2L)).noFluidInputs().noFluidOutputs().duration(20).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sImplosionRecipes);
                            GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(3L, aStack), GT_ModHandler.getIC2Item("industrialTnt", 2L)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gemExquisite, aMaterial, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 2L)).noFluidInputs().noFluidOutputs().duration(20).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sImplosionRecipes);
                        }
                        GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.gemFlawless, aMaterial, 2L), GT_Proxy.tBits, new Object[]{"h", "X", Character.valueOf('X'), OrePrefixes.gemExquisite.get(aMaterial)});
                        if (aSpecialRecipeReq) {
                            GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.dust, aMaterial, 2L), GT_Proxy.tBits, new Object[]{"X", "m", Character.valueOf('X'), OrePrefixes.gemFlawless.get(aMaterial)});
                        }
                    }
                }
                GT_Values.RA.stdBuilder().itemInputs(aStack).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gem, aMaterial, 2L)).noFluidInputs().noFluidOutputs().duration(64).eut(16).addTo(GT_Recipe.GT_Recipe_Map.sHammerRecipes);
                for (ItemStack is : OreDictionary.getOres((String)("craftingLens" + aMaterial.mColor.mName.replace(" ", "")))) {
                    is.field_77994_a = 0;
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(3L, aStack), is).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gemExquisite, aMaterial, 1L)).noFluidInputs().noFluidOutputs().duration(2400).eut(2000).addTo(GT_Recipe.GT_Recipe_Map.sLaserEngraverRecipes);
                }
                break;
            }
        }
    }
}

