/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.interfaces;

import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.common.misc.GlobalEnergyWorldSavedData;
import gregtech.common.misc.GlobalVariableStorage;
import java.math.BigInteger;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;

public interface IGlobalWirelessEnergy {
    default public void joinUserNetwork(String user_uuid_0, String user_uuid_1) {
        GlobalVariableStorage.GlobalEnergyTeam.put(user_uuid_0, user_uuid_1);
    }

    default public void strongCheckOrAddUser(EntityPlayer user) {
        this.strongCheckOrAddUser(user.func_110124_au().toString(), user.getDisplayName());
    }

    default public void strongCheckOrAddUser(UUID user_uuid, String user_name) {
        this.strongCheckOrAddUser(user_uuid.toString(), user_name);
    }

    default public void strongCheckOrAddUser(String user_uuid, String user_name) {
        GlobalVariableStorage.GlobalEnergyTeam.putIfAbsent(user_uuid, user_uuid);
        GlobalVariableStorage.GlobalEnergy.putIfAbsent(user_uuid, BigInteger.ZERO);
        if (!GlobalVariableStorage.GlobalEnergyName.getOrDefault(user_uuid, "").equals(user_name)) {
            String old_name = GlobalVariableStorage.GlobalEnergyName.get(user_uuid);
            GlobalVariableStorage.GlobalEnergyName.remove(old_name);
        }
        GlobalVariableStorage.GlobalEnergyName.put(user_name, user_uuid);
        GlobalVariableStorage.GlobalEnergyName.put(user_uuid, user_name);
    }

    default public boolean addEUToGlobalEnergyMap(String userUUID, BigInteger EU) {
        try {
            GlobalEnergyWorldSavedData.INSTANCE.func_76185_a();
        }
        catch (Exception exception) {
            System.out.println("COULD NOT MARK GLOBAL ENERGY AS DIRTY IN ADD EU");
            exception.printStackTrace();
        }
        String teamUUID = GlobalVariableStorage.GlobalEnergyTeam.getOrDefault(userUUID, userUUID);
        BigInteger totalEU = GlobalVariableStorage.GlobalEnergy.getOrDefault(teamUUID, BigInteger.ZERO);
        totalEU = totalEU.add(EU);
        if (totalEU.signum() >= 0) {
            GlobalVariableStorage.GlobalEnergy.put(teamUUID, totalEU);
            return true;
        }
        return false;
    }

    default public boolean addEUToGlobalEnergyMap(UUID user_uuid, BigInteger EU) {
        return this.addEUToGlobalEnergyMap(user_uuid.toString(), EU);
    }

    default public boolean addEUToGlobalEnergyMap(UUID user_uuid, long EU) {
        return this.addEUToGlobalEnergyMap(user_uuid.toString(), BigInteger.valueOf(EU));
    }

    default public boolean addEUToGlobalEnergyMap(UUID user_uuid, int EU) {
        return this.addEUToGlobalEnergyMap(user_uuid.toString(), BigInteger.valueOf(EU));
    }

    default public boolean addEUToGlobalEnergyMap(String user_uuid, long EU) {
        return this.addEUToGlobalEnergyMap(user_uuid, BigInteger.valueOf(EU));
    }

    default public boolean addEUToGlobalEnergyMap(String user_uuid, int EU) {
        return this.addEUToGlobalEnergyMap(user_uuid, BigInteger.valueOf(EU));
    }

    default public BigInteger getUserEU(String user_uuid) {
        return GlobalVariableStorage.GlobalEnergy.getOrDefault(GlobalVariableStorage.GlobalEnergyTeam.getOrDefault(user_uuid, user_uuid), BigInteger.ZERO);
    }

    default public void setUserEU(String user_uuid, BigInteger EU) {
        try {
            GlobalEnergyWorldSavedData.INSTANCE.func_76185_a();
        }
        catch (Exception exception) {
            System.out.println("COULD NOT MARK GLOBAL ENERGY AS DIRTY IN SET EU");
            exception.printStackTrace();
        }
        GlobalVariableStorage.GlobalEnergy.put(GlobalVariableStorage.GlobalEnergyTeam.get(user_uuid), EU);
    }

    default public String GetUsernameFromUUID(String uuid) {
        return GlobalVariableStorage.GlobalEnergyName.getOrDefault(GlobalVariableStorage.GlobalEnergyTeam.getOrDefault(uuid, ""), "");
    }

    default public String getUUIDFromUsername(String username) {
        return GlobalVariableStorage.GlobalEnergyTeam.getOrDefault(GlobalVariableStorage.GlobalEnergyName.getOrDefault(username, ""), "");
    }

    default public String getRawUUIDFromUsername(String username) {
        return GlobalVariableStorage.GlobalEnergyName.getOrDefault(username, "");
    }

    public static void clearGlobalEnergyInformationMaps() {
        GlobalVariableStorage.GlobalEnergy.clear();
        GlobalVariableStorage.GlobalEnergyName.clear();
        GlobalVariableStorage.GlobalEnergyTeam.clear();
    }

    default public String processInitialSettings(IGregTechTileEntity machine) {
        String UUID2 = machine.getOwnerUuid().toString();
        String name = machine.getOwnerName();
        this.strongCheckOrAddUser(UUID2, name);
        return UUID2;
    }
}

