/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import com.google.common.io.ByteArrayDataInput;
import gregtech.api.net.GT_Packet_New;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_Utility;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import net.minecraft.world.IBlockAccess;

public class GT_Packet_Sound
extends GT_Packet_New {
    private int mX;
    private int mZ;
    private short mY;
    private String mSoundName;
    private float mSoundStrength;
    private float mSoundPitch;

    public GT_Packet_Sound() {
        super(true);
    }

    public GT_Packet_Sound(String aSoundName, float aSoundStrength, float aSoundPitch, int aX, short aY, int aZ) {
        super(false);
        this.mX = aX;
        this.mY = aY;
        this.mZ = aZ;
        this.mSoundName = aSoundName;
        this.mSoundStrength = aSoundStrength;
        this.mSoundPitch = aSoundPitch;
    }

    @Override
    public void encode(ByteBuf aOut) {
        try (ByteBufOutputStream byteOutputStream = new ByteBufOutputStream(aOut);){
            byteOutputStream.writeUTF(this.mSoundName);
            byteOutputStream.writeFloat(this.mSoundStrength);
            byteOutputStream.writeFloat(this.mSoundPitch);
            byteOutputStream.writeInt(this.mX);
            byteOutputStream.writeShort((int)this.mY);
            byteOutputStream.writeInt(this.mZ);
        }
        catch (IOException e) {
            e.printStackTrace(GT_Log.err);
        }
    }

    @Override
    public GT_Packet_New decode(ByteArrayDataInput aData) {
        return new GT_Packet_Sound(aData.readUTF(), aData.readFloat(), aData.readFloat(), aData.readInt(), aData.readShort(), aData.readInt());
    }

    @Override
    public void process(IBlockAccess aWorld) {
        GT_Utility.doSoundAtClient(this.mSoundName, 1, this.mSoundStrength, this.mSoundPitch, (double)this.mX, (double)this.mY, (double)this.mZ);
    }

    @Override
    public byte getPacketID() {
        return 1;
    }
}

