/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizons.modularui.api.drawable.FallbackableUITexture;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import gregtech.api.gui.modularui.FallbackableSteamTexture;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.gui.modularui.SteamTexture;
import gregtech.api.recipe.BasicUIProperties;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.common.gui.modularui.UIHelper;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class BasicUIPropertiesBuilder {
    private int maxItemInputs;
    private int maxItemOutputs;
    private int maxFluidInputs;
    private int maxFluidOutputs;
    private BasicUIProperties.SlotOverlayGetter<IDrawable> slotOverlays = (index, isFluid, isOutput, isSpecial) -> null;
    private BasicUIProperties.SlotOverlayGetter<SteamTexture> slotOverlaysSteam = (index, isFluid, isOutput, isSpecial) -> null;
    @Nullable
    private FallbackableUITexture progressBarTexture;
    @Nullable
    private FallbackableSteamTexture progressBarTextureSteam;
    private ProgressBar.Direction progressBarDirection = ProgressBar.Direction.RIGHT;
    private Size progressBarSize = new Size(20, 18);
    private Pos2d progressBarPos = new Pos2d(78, 24);
    private boolean useProgressBar = true;
    private boolean useSpecialSlot;
    private final ImmutableList.Builder<Rectangle> neiTransferRect = ImmutableList.builder();
    @Nullable
    private String neiTransferRectId;
    private final ImmutableList.Builder<Pair<IDrawable, Pair<Size, Pos2d>>> specialTextures = ImmutableList.builder();
    private final ImmutableList.Builder<Pair<SteamTexture, Pair<Size, Pos2d>>> specialTexturesSteam = ImmutableList.builder();
    private IDrawable logo = GT_UITextures.PICTURE_GT_LOGO_17x17_TRANSPARENT;
    private Size logoSize = new Size(17, 17);
    private Pos2d logoPos = new Pos2d(152, 63);
    private IntFunction<List<Pos2d>> itemInputPositionsGetter = UIHelper::getItemInputPositions;
    private IntFunction<List<Pos2d>> itemOutputPositionsGetter = UIHelper::getItemOutputPositions;
    private Supplier<Pos2d> specialItemPositionGetter = UIHelper::getSpecialItemPosition;
    private IntFunction<List<Pos2d>> fluidInputPositionsGetter = UIHelper::getFluidInputPositions;
    private IntFunction<List<Pos2d>> fluidOutputPositionsGetter = UIHelper::getFluidOutputPositions;
    private int amperage = 1;

    BasicUIPropertiesBuilder() {
    }

    public BasicUIProperties build() {
        if (this.maxItemInputs == 0 && this.maxItemOutputs == 0 && this.maxFluidInputs == 0 && this.maxFluidOutputs == 0) {
            throw new IllegalArgumentException("Set either of max I/O count");
        }
        Object builtNEITransferRect = this.neiTransferRect.build();
        if (builtNEITransferRect.isEmpty()) {
            builtNEITransferRect = Collections.singletonList(new Rectangle(this.progressBarPos.x - 8, this.progressBarPos.y, this.progressBarSize.width + 16, this.progressBarSize.height));
        }
        return new BasicUIProperties(this.maxItemInputs, this.maxItemOutputs, this.maxFluidInputs, this.maxFluidOutputs, this.slotOverlays, this.slotOverlaysSteam, this.progressBarTexture, this.progressBarTextureSteam, this.progressBarDirection, this.progressBarSize, this.progressBarPos, this.useProgressBar, this.useSpecialSlot, (List<Rectangle>)builtNEITransferRect, this.neiTransferRectId, (List<Pair<IDrawable, Pair<Size, Pos2d>>>)this.specialTextures.build(), (List<Pair<SteamTexture, Pair<Size, Pos2d>>>)this.specialTexturesSteam.build(), this.logo, this.logoSize, this.logoPos, this.itemInputPositionsGetter, this.itemOutputPositionsGetter, this.specialItemPositionGetter, this.fluidInputPositionsGetter, this.fluidOutputPositionsGetter, this.amperage);
    }

    public BasicUIPropertiesBuilder maxItemInputs(int maxItemInputs) {
        this.maxItemInputs = maxItemInputs;
        return this;
    }

    public BasicUIPropertiesBuilder maxItemOutputs(int maxItemOutputs) {
        this.maxItemOutputs = maxItemOutputs;
        return this;
    }

    public BasicUIPropertiesBuilder maxFluidInputs(int maxFluidInputs) {
        this.maxFluidInputs = maxFluidInputs;
        return this;
    }

    public BasicUIPropertiesBuilder maxFluidOutputs(int maxFluidOutputs) {
        this.maxFluidOutputs = maxFluidOutputs;
        return this;
    }

    public BasicUIPropertiesBuilder slotOverlays(BasicUIProperties.SlotOverlayGetter<IDrawable> slotOverlays) {
        this.slotOverlays = slotOverlays;
        return this;
    }

    public BasicUIPropertiesBuilder slotOverlaysSteam(BasicUIProperties.SlotOverlayGetter<SteamTexture> slotOverlaysSteam) {
        this.slotOverlaysSteam = slotOverlaysSteam;
        return this;
    }

    public BasicUIPropertiesBuilder progressBarTexture(@Nullable FallbackableUITexture progressBarTexture) {
        this.progressBarTexture = progressBarTexture;
        return this;
    }

    public BasicUIPropertiesBuilder progressBarTextureSteam(@Nullable FallbackableSteamTexture progressBarTextureSteam) {
        this.progressBarTextureSteam = progressBarTextureSteam;
        return this;
    }

    public BasicUIPropertiesBuilder progressBarDirection(ProgressBar.Direction progressBarDirection) {
        this.progressBarDirection = progressBarDirection;
        return this;
    }

    public BasicUIPropertiesBuilder progressBarSize(Size progressBarSize) {
        this.progressBarSize = progressBarSize;
        return this;
    }

    public BasicUIPropertiesBuilder progressBarPos(Pos2d progressBarPos) {
        this.progressBarPos = progressBarPos;
        return this;
    }

    public BasicUIPropertiesBuilder useProgressBar(boolean useProgressBar) {
        this.useProgressBar = useProgressBar;
        return this;
    }

    public BasicUIPropertiesBuilder useSpecialSlot(boolean useSpecialSlot) {
        this.useSpecialSlot = useSpecialSlot;
        return this;
    }

    public BasicUIPropertiesBuilder addNEITransferRect(Rectangle neiTransferRect) {
        this.neiTransferRect.add((Object)neiTransferRect);
        return this;
    }

    BasicUIPropertiesBuilder neiTransferRect(List<Rectangle> neiTransferRect) {
        this.neiTransferRect.addAll(neiTransferRect);
        return this;
    }

    public BasicUIPropertiesBuilder neiTransferRectId(@Nullable String neiTransferRectId) {
        this.neiTransferRectId = neiTransferRectId;
        return this;
    }

    public BasicUIPropertiesBuilder addSpecialTexture(Size size, Pos2d pos, IDrawable texture) {
        this.specialTextures.add((Object)new ImmutablePair((Object)texture, (Object)new ImmutablePair((Object)size, (Object)pos)));
        return this;
    }

    BasicUIPropertiesBuilder specialTextures(List<Pair<IDrawable, Pair<Size, Pos2d>>> specialTextures) {
        this.specialTextures.addAll(specialTextures);
        return this;
    }

    public BasicUIPropertiesBuilder addSpecialTextureSteam(Size size, Pos2d pos, SteamTexture texture) {
        this.specialTexturesSteam.add((Object)new ImmutablePair((Object)texture, (Object)new ImmutablePair((Object)size, (Object)pos)));
        return this;
    }

    BasicUIPropertiesBuilder specialTexturesSteam(List<Pair<SteamTexture, Pair<Size, Pos2d>>> specialTextures) {
        this.specialTexturesSteam.addAll(specialTextures);
        return this;
    }

    public BasicUIPropertiesBuilder logo(IDrawable logo) {
        this.logo = logo;
        return this;
    }

    public BasicUIPropertiesBuilder logoSize(Size logoSize) {
        this.logoSize = logoSize;
        return this;
    }

    public BasicUIPropertiesBuilder logoPos(Pos2d logoPos) {
        this.logoPos = logoPos;
        return this;
    }

    public BasicUIPropertiesBuilder itemInputPositionsGetter(IntFunction<List<Pos2d>> itemInputPositionsGetter) {
        this.itemInputPositionsGetter = itemInputPositionsGetter;
        return this;
    }

    public BasicUIPropertiesBuilder itemOutputPositionsGetter(IntFunction<List<Pos2d>> itemOutputPositionsGetter) {
        this.itemOutputPositionsGetter = itemOutputPositionsGetter;
        return this;
    }

    public BasicUIPropertiesBuilder specialItemPositionGetter(Supplier<Pos2d> specialItemPositionGetter) {
        this.specialItemPositionGetter = specialItemPositionGetter;
        return this;
    }

    public BasicUIPropertiesBuilder fluidInputPositionsGetter(IntFunction<List<Pos2d>> fluidInputPositionsGetter) {
        this.fluidInputPositionsGetter = fluidInputPositionsGetter;
        return this;
    }

    public BasicUIPropertiesBuilder fluidOutputPositionsGetter(IntFunction<List<Pos2d>> fluidOutputPositionsGetter) {
        this.fluidOutputPositionsGetter = fluidOutputPositionsGetter;
        return this;
    }

    public BasicUIPropertiesBuilder amperage(int amperage) {
        this.amperage = amperage;
        return this;
    }
}

