/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import codechicken.translocator.TileLiquidTranslocator;
import cpw.mods.fml.common.Optional;
import gregtech.GT_Mod;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.ParticleFX;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.objects.XSTR;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_CoverBehaviorBase;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import gregtech.api.util.WorldSpawnedEventBuilder;
import gregtech.common.GT_Client;
import gregtech.common.covers.CoverInfo;
import gregtech.common.covers.GT_Cover_Drain;
import gregtech.common.covers.GT_Cover_FluidRegulator;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import org.apache.commons.lang3.tuple.MutableTriple;
import tconstruct.smeltery.logic.FaucetLogic;

public class GT_MetaPipeEntity_Fluid
extends MetaPipeEntity {
    protected static final EnumMap<ForgeDirection, EnumMap<Border, ForgeDirection>> FACE_BORDER_MAP = new EnumMap(ForgeDirection.class);
    protected static final Map<Integer, IIconContainer> RESTR_TEXTURE_MAP;
    public final float mThickNess;
    public final Materials mMaterial;
    public final int mCapacity;
    public final int mHeatResistance;
    public final int mPipeAmount;
    public final boolean mGasProof;
    public final FluidStack[] mFluids;
    public byte mLastReceivedFrom = 0;
    public byte oLastReceivedFrom = 0;
    public byte mDisableInput = 0;

    public GT_MetaPipeEntity_Fluid(int aID, String aName, String aNameRegional, float aThickNess, Materials aMaterial, int aCapacity, int aHeatResistance, boolean aGasProof) {
        this(aID, aName, aNameRegional, aThickNess, aMaterial, aCapacity, aHeatResistance, aGasProof, 1);
    }

    public GT_MetaPipeEntity_Fluid(int aID, String aName, String aNameRegional, float aThickNess, Materials aMaterial, int aCapacity, int aHeatResistance, boolean aGasProof, int aFluidTypes) {
        super(aID, aName, aNameRegional, 0, false);
        this.mThickNess = aThickNess;
        this.mMaterial = aMaterial;
        this.mCapacity = aCapacity;
        this.mGasProof = aGasProof;
        this.mHeatResistance = aHeatResistance;
        this.mPipeAmount = aFluidTypes;
        this.mFluids = new FluidStack[this.mPipeAmount];
        this.addInfo(aID);
    }

    @Deprecated
    public GT_MetaPipeEntity_Fluid(String aName, float aThickNess, Materials aMaterial, int aCapacity, int aHeatResistance, boolean aGasProof) {
        this(aName, aThickNess, aMaterial, aCapacity, aHeatResistance, aGasProof, 1);
    }

    public GT_MetaPipeEntity_Fluid(String aName, float aThickNess, Materials aMaterial, int aCapacity, int aHeatResistance, boolean aGasProof, int aFluidTypes) {
        super(aName, 0);
        this.mThickNess = aThickNess;
        this.mMaterial = aMaterial;
        this.mCapacity = aCapacity;
        this.mGasProof = aGasProof;
        this.mHeatResistance = aHeatResistance;
        this.mPipeAmount = aFluidTypes;
        this.mFluids = new FluidStack[this.mPipeAmount];
    }

    @Override
    public byte getTileEntityBaseType() {
        return (byte)(this.mMaterial == null ? 4 : 4 + Math.max(0, Math.min(3, this.mMaterial.mToolQuality)));
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaPipeEntity_Fluid(this.mName, this.mThickNess, this.mMaterial, this.mCapacity, this.mHeatResistance, this.mGasProof, this.mPipeAmount);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, int aConnections, int colorIndex, boolean aConnected, boolean redstoneLevel) {
        if (side == ForgeDirection.UNKNOWN) {
            return Textures.BlockIcons.ERROR_RENDERING;
        }
        float tThickNess = this.getThickNess();
        if (this.mDisableInput == 0) {
            return new ITexture[]{aConnected ? GT_MetaPipeEntity_Fluid.getBaseTexture(tThickNess, this.mPipeAmount, this.mMaterial, colorIndex) : TextureFactory.of(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipe.mTextureIndex], Dyes.getModulation(colorIndex, this.mMaterial.mRGBa))};
        }
        int borderMask = 0;
        for (Border border : Border.values()) {
            if (!this.isInputDisabledAtSide(GT_MetaPipeEntity_Fluid.getSideAtBorder(side, border))) continue;
            borderMask |= border.mask;
        }
        return new ITexture[]{aConnected ? GT_MetaPipeEntity_Fluid.getBaseTexture(tThickNess, this.mPipeAmount, this.mMaterial, colorIndex) : TextureFactory.of(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipe.mTextureIndex], Dyes.getModulation(colorIndex, this.mMaterial.mRGBa)), GT_MetaPipeEntity_Fluid.getRestrictorTexture(borderMask)};
    }

    protected static ITexture getBaseTexture(float aThickNess, int aPipeAmount, Materials aMaterial, int colorIndex) {
        if (aPipeAmount >= 9) {
            return TextureFactory.of(aMaterial.mIconSet.mTextures[OrePrefixes.pipeNonuple.mTextureIndex], Dyes.getModulation(colorIndex, aMaterial.mRGBa));
        }
        if (aPipeAmount >= 4) {
            return TextureFactory.of(aMaterial.mIconSet.mTextures[OrePrefixes.pipeQuadruple.mTextureIndex], Dyes.getModulation(colorIndex, aMaterial.mRGBa));
        }
        if (aThickNess < 0.124f) {
            return TextureFactory.of(aMaterial.mIconSet.mTextures[OrePrefixes.pipe.mTextureIndex], Dyes.getModulation(colorIndex, aMaterial.mRGBa));
        }
        if (aThickNess < 0.374f) {
            return TextureFactory.of(aMaterial.mIconSet.mTextures[OrePrefixes.pipeTiny.mTextureIndex], Dyes.getModulation(colorIndex, aMaterial.mRGBa));
        }
        if (aThickNess < 0.499f) {
            return TextureFactory.of(aMaterial.mIconSet.mTextures[OrePrefixes.pipeSmall.mTextureIndex], Dyes.getModulation(colorIndex, aMaterial.mRGBa));
        }
        if (aThickNess < 0.749f) {
            return TextureFactory.of(aMaterial.mIconSet.mTextures[OrePrefixes.pipeMedium.mTextureIndex], Dyes.getModulation(colorIndex, aMaterial.mRGBa));
        }
        if (aThickNess < 0.874f) {
            return TextureFactory.of(aMaterial.mIconSet.mTextures[OrePrefixes.pipeLarge.mTextureIndex], Dyes.getModulation(colorIndex, aMaterial.mRGBa));
        }
        return TextureFactory.of(aMaterial.mIconSet.mTextures[OrePrefixes.pipeHuge.mTextureIndex], Dyes.getModulation(colorIndex, aMaterial.mRGBa));
    }

    @Deprecated
    protected static ITexture getRestrictorTexture(byte borderMask) {
        return GT_MetaPipeEntity_Fluid.getRestrictorTexture((int)borderMask);
    }

    protected static ITexture getRestrictorTexture(int borderMask) {
        IIconContainer restrictorIcon = RESTR_TEXTURE_MAP.get(borderMask);
        return restrictorIcon != null ? TextureFactory.of(restrictorIcon) : null;
    }

    @Override
    public void onValueUpdate(byte aValue) {
        this.mDisableInput = aValue;
    }

    @Override
    public byte getUpdateData() {
        return this.mDisableInput;
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return false;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return false;
    }

    @Override
    public final boolean renderInside(ForgeDirection side) {
        return false;
    }

    @Override
    public int getProgresstime() {
        return this.getFluidAmount();
    }

    @Override
    public int maxProgresstime() {
        return this.getCapacity();
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        for (int i = 0; i < this.mPipeAmount; ++i) {
            if (this.mFluids[i] == null) continue;
            aNBT.func_74782_a("mFluid" + (i == 0 ? "" : Integer.valueOf(i)), (NBTBase)this.mFluids[i].writeToNBT(new NBTTagCompound()));
        }
        aNBT.func_74774_a("mLastReceivedFrom", this.mLastReceivedFrom);
        if (GT_Mod.gregtechproxy.gt6Pipe) {
            aNBT.func_74774_a("mConnections", this.mConnections);
            aNBT.func_74774_a("mDisableInput", this.mDisableInput);
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        for (int i = 0; i < this.mPipeAmount; ++i) {
            this.mFluids[i] = FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT.func_74775_l("mFluid" + (i == 0 ? "" : Integer.valueOf(i))));
        }
        this.mLastReceivedFrom = aNBT.func_74771_c("mLastReceivedFrom");
        if (GT_Mod.gregtechproxy.gt6Pipe) {
            this.mConnections = aNBT.func_74771_c("mConnections");
            this.mDisableInput = aNBT.func_74771_c("mDisableInput");
        }
    }

    @Override
    public void onEntityCollidedWithBlock(World aWorld, int aX, int aY, int aZ, Entity aEntity) {
        if ((((BaseMetaPipeEntity)this.getBaseMetaTileEntity()).mConnections & 0xFFFFFF80) == 0 && aEntity instanceof EntityLivingBase) {
            for (FluidStack tFluid : this.mFluids) {
                if (tFluid == null) continue;
                int tTemperature = tFluid.getFluid().getTemperature(tFluid);
                if (tTemperature > 320 && !this.isCoverOnSide((BaseMetaPipeEntity)this.getBaseMetaTileEntity(), (EntityLivingBase)aEntity)) {
                    GT_Utility.applyHeatDamage((EntityLivingBase)aEntity, (float)(tTemperature - 300) / 50.0f);
                    break;
                }
                if (tTemperature >= 260 || this.isCoverOnSide((BaseMetaPipeEntity)this.getBaseMetaTileEntity(), (EntityLivingBase)aEntity)) continue;
                GT_Utility.applyFrostDamage((EntityLivingBase)aEntity, (float)(270 - tTemperature) / 25.0f);
                break;
            }
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && aTick % 5L == 0L) {
            this.mLastReceivedFrom = (byte)(this.mLastReceivedFrom & 0x3F);
            if (this.mLastReceivedFrom == 63) {
                this.mLastReceivedFrom = 0;
            }
            if (!GT_Mod.gregtechproxy.gt6Pipe || this.mCheckConnections) {
                this.checkConnections();
            }
            boolean shouldDistribute = this.oLastReceivedFrom == this.mLastReceivedFrom;
            int j = aBaseMetaTileEntity.getRandomNumber(this.mPipeAmount);
            for (int i = 0; i < this.mPipeAmount; ++i) {
                int index = (i + j) % this.mPipeAmount;
                if (this.mFluids[index] != null && this.mFluids[index].amount <= 0) {
                    this.mFluids[index] = null;
                }
                if (this.mFluids[index] == null) continue;
                if (this.checkEnvironment(index, aBaseMetaTileEntity)) {
                    return;
                }
                if (!shouldDistribute) continue;
                this.distributeFluid(index, aBaseMetaTileEntity);
                this.mLastReceivedFrom = 0;
            }
            this.oLastReceivedFrom = this.mLastReceivedFrom;
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean checkEnvironment(int index, IGregTechTileEntity aBaseMetaTileEntity) {
        tFluid = this.mFluids[index];
        if (tFluid != null && tFluid.amount > 0) {
            block14: {
                tTemperature = tFluid.getFluid().getTemperature(tFluid);
                if (tTemperature > this.mHeatResistance) {
                    if (aBaseMetaTileEntity.getRandomNumber(100) == 0) {
                        GT_Log.exp.println("Set Pipe to Fire due to to low heat resistance at " + aBaseMetaTileEntity.getXCoord() + " | " + aBaseMetaTileEntity.getYCoord() + " | " + aBaseMetaTileEntity.getZCoord() + " DIMID: " + aBaseMetaTileEntity.getWorld().field_73011_w.field_76574_g);
                        aBaseMetaTileEntity.setToFire();
                        return true;
                    }
                    aBaseMetaTileEntity.setOnFire();
                    GT_Log.exp.println("Set Blocks around Pipe to Fire due to to low heat resistance at " + aBaseMetaTileEntity.getXCoord() + " | " + aBaseMetaTileEntity.getYCoord() + " | " + aBaseMetaTileEntity.getZCoord() + " DIMID: " + aBaseMetaTileEntity.getWorld().field_73011_w.field_76574_g);
                }
                if (!this.mGasProof && tFluid.getFluid().isGaseous(tFluid)) {
                    tFluid.amount -= 5;
                    this.sendSound((byte)9);
                    if (tTemperature > 320) {
                        try {
                            for (EntityLivingBase tLiving : this.getBaseMetaTileEntity().getWorld().func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(this.getBaseMetaTileEntity().getXCoord() - 2), (double)(this.getBaseMetaTileEntity().getYCoord() - 2), (double)(this.getBaseMetaTileEntity().getZCoord() - 2), (double)(this.getBaseMetaTileEntity().getXCoord() + 3), (double)(this.getBaseMetaTileEntity().getYCoord() + 3), (double)(this.getBaseMetaTileEntity().getZCoord() + 3)))) {
                                GT_Utility.applyHeatDamage(tLiving, (float)(tTemperature - 300) / 25.0f);
                            }
                        }
                        catch (Throwable e) {
                            if (!GT_Values.D1) ** GOTO lbl35
                            e.printStackTrace(GT_Log.err);
                        }
                    } else if (tTemperature < 260) {
                        try {
                            for (EntityLivingBase tLiving : this.getBaseMetaTileEntity().getWorld().func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(this.getBaseMetaTileEntity().getXCoord() - 2), (double)(this.getBaseMetaTileEntity().getYCoord() - 2), (double)(this.getBaseMetaTileEntity().getZCoord() - 2), (double)(this.getBaseMetaTileEntity().getXCoord() + 3), (double)(this.getBaseMetaTileEntity().getYCoord() + 3), (double)(this.getBaseMetaTileEntity().getZCoord() + 3)))) {
                                GT_Utility.applyFrostDamage(tLiving, (float)(270 - tTemperature) / 12.5f);
                            }
                        }
                        catch (Throwable e) {
                            if (!GT_Values.D1) break block14;
                            e.printStackTrace(GT_Log.err);
                        }
                    }
                }
            }
            if (tFluid.amount <= 0) {
                this.mFluids[index] = null;
            }
        }
        return false;
    }

    private void distributeFluid(int index, IGregTechTileEntity aBaseMetaTileEntity) {
        FluidStack tFluid = this.mFluids[index];
        if (tFluid == null) {
            return;
        }
        ArrayList<MutableTriple> tTanks = new ArrayList<MutableTriple>();
        int amount = tFluid.amount;
        byte tOffset = (byte)this.getBaseMetaTileEntity().getRandomNumber(6);
        for (byte i : GT_Values.ALL_VALID_SIDES) {
            IGregTechTileEntity gTank;
            ForgeDirection side = ForgeDirection.getOrientation((int)((i + tOffset) % 6));
            ForgeDirection oppositeSide = side.getOpposite();
            IFluidHandler tTank = aBaseMetaTileEntity.getITankContainerAtSide(side);
            IGregTechTileEntity iGregTechTileEntity = gTank = tTank instanceof IGregTechTileEntity ? (IGregTechTileEntity)tTank : null;
            if (!this.isConnectedAtSide(side) || tTank == null || (this.mLastReceivedFrom & side.flag) != 0 || !this.getBaseMetaTileEntity().getCoverInfoAtSide(side).letsFluidOut(tFluid.getFluid()) || gTank != null && !gTank.getCoverInfoAtSide(oppositeSide).letsFluidIn(tFluid.getFluid())) continue;
            if (tTank.fill(oppositeSide, tFluid, false) > 0) {
                tTanks.add(new MutableTriple((Object)tTank, (Object)oppositeSide, (Object)0));
            }
            tFluid.amount = amount;
        }
        double tAmount = Math.max(1, Math.min(this.mCapacity * 10, tFluid.amount));
        FluidStack maxFluid = tFluid.copy();
        maxFluid.amount = Integer.MAX_VALUE;
        double availableCapacity = 0.0;
        for (MutableTriple tEntry : tTanks) {
            tEntry.right = ((IFluidHandler)tEntry.left).fill((ForgeDirection)tEntry.middle, maxFluid, false);
            availableCapacity += (double)((Integer)tEntry.right).intValue();
        }
        for (MutableTriple tEntry : tTanks) {
            if (availableCapacity > tAmount) {
                tEntry.right = (int)Math.floor((double)((Integer)tEntry.right).intValue() * tAmount / availableCapacity);
            }
            if ((Integer)tEntry.right == 0) {
                tEntry.right = (int)Math.min(1.0, tAmount);
            }
            if ((Integer)tEntry.right <= 0) continue;
            int tFilledAmount = ((IFluidHandler)tEntry.left).fill((ForgeDirection)tEntry.middle, this.drainFromIndex((Integer)tEntry.right, false, index), false);
            if (tFilledAmount > 0) {
                ((IFluidHandler)tEntry.left).fill((ForgeDirection)tEntry.middle, this.drainFromIndex(tFilledAmount, true, index), true);
            }
            if (this.mFluids[index] != null && this.mFluids[index].amount > 0) continue;
            return;
        }
    }

    @Override
    public boolean onWrenchRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer entityPlayer, float aX, float aY, float aZ) {
        if (GT_Mod.gregtechproxy.gt6Pipe) {
            ForgeDirection tSide = GT_Utility.determineWrenchingSide(side, aX, aY, aZ);
            byte tMask = (byte)tSide.flag;
            if (entityPlayer.func_70093_af()) {
                if (this.isInputDisabledAtSide(tSide)) {
                    this.mDisableInput = (byte)(this.mDisableInput & ~tMask);
                    GT_Utility.sendChatToPlayer(entityPlayer, GT_Utility.trans("212", "Input enabled"));
                    if (!this.isConnectedAtSide(tSide)) {
                        this.connect(tSide);
                    }
                } else {
                    this.mDisableInput = (byte)(this.mDisableInput | tMask);
                    GT_Utility.sendChatToPlayer(entityPlayer, GT_Utility.trans("213", "Input disabled"));
                }
            } else if (!this.isConnectedAtSide(tSide)) {
                if (this.connect(tSide) > 0) {
                    GT_Utility.sendChatToPlayer(entityPlayer, GT_Utility.trans("214", "Connected"));
                }
            } else {
                this.disconnect(tSide);
                GT_Utility.sendChatToPlayer(entityPlayer, GT_Utility.trans("215", "Disconnected"));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean letsIn(GT_CoverBehavior coverBehavior, ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return coverBehavior.letsFluidIn(side, aCoverID, aCoverVariable, null, aTileEntity);
    }

    @Override
    public boolean letsOut(GT_CoverBehavior coverBehavior, ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return coverBehavior.letsFluidOut(side, aCoverID, aCoverVariable, null, aTileEntity);
    }

    @Override
    public boolean letsIn(GT_CoverBehaviorBase<?> coverBehavior, ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return coverBehavior.letsFluidIn(side, aCoverID, aCoverVariable, null, aTileEntity);
    }

    @Override
    public boolean letsOut(GT_CoverBehaviorBase<?> coverBehavior, ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return coverBehavior.letsFluidOut(side, aCoverID, aCoverVariable, null, aTileEntity);
    }

    @Override
    public boolean letsIn(CoverInfo coverInfo) {
        return coverInfo.letsFluidIn(null);
    }

    @Override
    public boolean letsOut(CoverInfo coverInfo) {
        return coverInfo.letsFluidOut(null);
    }

    @Override
    public boolean canConnect(ForgeDirection side, TileEntity tileEntity) {
        FluidTankInfo[] tInfo;
        IFluidHandler fTileEntity;
        IGregTechTileEntity gTileEntity;
        if (tileEntity == null) {
            return false;
        }
        ForgeDirection tSide = side.getOpposite();
        IGregTechTileEntity baseMetaTile = this.getBaseMetaTileEntity();
        if (baseMetaTile == null) {
            return false;
        }
        GT_CoverBehaviorBase<?> coverBehavior = baseMetaTile.getCoverBehaviorAtSideNew(side);
        IGregTechTileEntity iGregTechTileEntity = gTileEntity = tileEntity instanceof IGregTechTileEntity ? (IGregTechTileEntity)tileEntity : null;
        if (coverBehavior instanceof GT_Cover_Drain || Mods.TinkerConstruct.isModLoaded() && this.isTConstructFaucet(tileEntity)) {
            return true;
        }
        IFluidHandler iFluidHandler = fTileEntity = tileEntity instanceof IFluidHandler ? (IFluidHandler)tileEntity : null;
        if (fTileEntity != null && (tInfo = fTileEntity.getTankInfo(tSide)) != null) {
            return tInfo.length > 0 || Mods.Translocator.isModLoaded() && this.isTranslocator(tileEntity) || gTileEntity != null && gTileEntity.getCoverBehaviorAtSideNew(tSide) instanceof GT_Cover_FluidRegulator;
        }
        return false;
    }

    @Optional.Method(modid="TConstruct")
    private boolean isTConstructFaucet(TileEntity tTileEntity) {
        return tTileEntity instanceof FaucetLogic;
    }

    @Optional.Method(modid="Translocator")
    private boolean isTranslocator(TileEntity tTileEntity) {
        return tTileEntity instanceof TileLiquidTranslocator;
    }

    @Override
    public boolean getGT6StyleConnection() {
        return GT_Mod.gregtechproxy.gt6Pipe;
    }

    @Override
    public void doSound(byte aIndex, double aX, double aY, double aZ) {
        super.doSound(aIndex, aX, aY, aZ);
        if (aIndex == 9) {
            GT_Utility.doSoundAtClient(SoundResource.RANDOM_FIZZ, 5, 1.0f, aX, aY, aZ);
            ((WorldSpawnedEventBuilder.ParticleEventBuilder)new WorldSpawnedEventBuilder.ParticleEventBuilder().setIdentifier((Enum)ParticleFX.CLOUD)).setWorld(this.getBaseMetaTileEntity().getWorld()).times(6, (x, i) -> x.setMotion((double)ForgeDirection.getOrientation((int)i.intValue()).offsetX / 5.0, (double)ForgeDirection.getOrientation((int)i.intValue()).offsetY / 5.0, (double)ForgeDirection.getOrientation((int)i.intValue()).offsetZ / 5.0).setPosition(aX - 0.5 + (double)XSTR.XSTR_INSTANCE.nextFloat(), aY - 0.5 + (double)XSTR.XSTR_INSTANCE.nextFloat(), aZ - 0.5 + (double)XSTR.XSTR_INSTANCE.nextFloat()).run());
        }
    }

    @Override
    public final int getCapacity() {
        return this.mCapacity * 20 * this.mPipeAmount;
    }

    @Override
    public FluidTankInfo getInfo() {
        for (FluidStack tFluid : this.mFluids) {
            if (tFluid == null) continue;
            return new FluidTankInfo(tFluid, this.mCapacity * 20);
        }
        return new FluidTankInfo(null, this.mCapacity * 20);
    }

    @Override
    public FluidTankInfo[] getTankInfo(ForgeDirection side) {
        if (this.getCapacity() <= 0 && !this.getBaseMetaTileEntity().hasSteamEngineUpgrade()) {
            return new FluidTankInfo[0];
        }
        ArrayList<FluidTankInfo> tList = new ArrayList<FluidTankInfo>();
        for (FluidStack tFluid : this.mFluids) {
            tList.add(new FluidTankInfo(tFluid, this.mCapacity * 20));
        }
        return tList.toArray(new FluidTankInfo[this.mPipeAmount]);
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public final FluidStack getFluid() {
        for (FluidStack tFluid : this.mFluids) {
            if (tFluid == null) continue;
            return tFluid;
        }
        return null;
    }

    @Override
    public final int getFluidAmount() {
        int rAmount = 0;
        for (FluidStack tFluid : this.mFluids) {
            if (tFluid == null) continue;
            rAmount += tFluid.amount;
        }
        return rAmount;
    }

    @Override
    public final int fill_default(ForgeDirection side, FluidStack aFluid, boolean doFill) {
        if (aFluid == null || aFluid.getFluid().getID() <= 0) {
            return 0;
        }
        int index = -1;
        for (int i = 0; i < this.mPipeAmount; ++i) {
            if (this.mFluids[i] != null && this.mFluids[i].isFluidEqual(aFluid)) {
                index = i;
                break;
            }
            if (this.mFluids[i] != null && this.mFluids[i].getFluid().getID() > 0 || index >= 0) continue;
            index = i;
        }
        return this.fill_default_intoIndex(side, aFluid, doFill, index);
    }

    private int fill_default_intoIndex(ForgeDirection side, FluidStack aFluid, boolean doFill, int index) {
        if (index < 0 || index >= this.mPipeAmount) {
            return 0;
        }
        if (aFluid == null || aFluid.getFluid().getID() <= 0) {
            return 0;
        }
        int ordinalSide = side.ordinal();
        if (this.mFluids[index] == null || this.mFluids[index].getFluid().getID() <= 0) {
            if (aFluid.amount * this.mPipeAmount <= this.getCapacity()) {
                if (doFill) {
                    this.mFluids[index] = aFluid.copy();
                    this.mLastReceivedFrom = (byte)(this.mLastReceivedFrom | 1 << ordinalSide);
                }
                return aFluid.amount;
            }
            if (doFill) {
                this.mFluids[index] = aFluid.copy();
                this.mLastReceivedFrom = (byte)(this.mLastReceivedFrom | 1 << ordinalSide);
                this.mFluids[index].amount = this.getCapacity() / this.mPipeAmount;
            }
            return this.getCapacity() / this.mPipeAmount;
        }
        if (!this.mFluids[index].isFluidEqual(aFluid)) {
            return 0;
        }
        int space = this.getCapacity() / this.mPipeAmount - this.mFluids[index].amount;
        if (aFluid.amount <= space) {
            if (doFill) {
                this.mFluids[index].amount += aFluid.amount;
                this.mLastReceivedFrom = (byte)(this.mLastReceivedFrom | 1 << ordinalSide);
            }
            return aFluid.amount;
        }
        if (doFill) {
            this.mFluids[index].amount = this.getCapacity() / this.mPipeAmount;
            this.mLastReceivedFrom = (byte)(this.mLastReceivedFrom | 1 << ordinalSide);
        }
        return space;
    }

    @Override
    public final FluidStack drain(int maxDrain, boolean doDrain) {
        for (int i = 0; i < this.mPipeAmount; ++i) {
            FluidStack drained = this.drainFromIndex(maxDrain, doDrain, i);
            if (drained == null) continue;
            return drained;
        }
        return null;
    }

    private FluidStack drainFromIndex(int maxDrain, boolean doDrain, int index) {
        if (index < 0 || index >= this.mPipeAmount) {
            return null;
        }
        if (this.mFluids[index] == null) {
            return null;
        }
        if (this.mFluids[index].amount <= 0) {
            this.mFluids[index] = null;
            return null;
        }
        int used = maxDrain;
        if (this.mFluids[index].amount < used) {
            used = this.mFluids[index].amount;
        }
        if (doDrain) {
            this.mFluids[index].amount -= used;
        }
        FluidStack drained = this.mFluids[index].copy();
        drained.amount = used;
        if (this.mFluids[index].amount <= 0) {
            this.mFluids[index] = null;
        }
        return drained;
    }

    @Override
    public int getTankPressure() {
        return this.getFluidAmount() - this.getCapacity() / 2;
    }

    @Override
    public String[] getDescription() {
        ArrayList<String> descriptions = new ArrayList<String>();
        descriptions.add(EnumChatFormatting.BLUE + "Fluid Capacity: %%%" + GT_Utility.formatNumbers((long)this.mCapacity * 20L) + "%%% L/sec" + EnumChatFormatting.GRAY);
        descriptions.add(EnumChatFormatting.RED + "Heat Limit: %%%" + GT_Utility.formatNumbers(this.mHeatResistance) + "%%% K" + EnumChatFormatting.GRAY);
        if (!this.mGasProof) {
            descriptions.add(EnumChatFormatting.DARK_GREEN + "Cannot handle gas" + EnumChatFormatting.GRAY);
        }
        if (this.mPipeAmount != 1) {
            descriptions.add(EnumChatFormatting.AQUA + "Pipe Amount: %%%" + this.mPipeAmount + EnumChatFormatting.GRAY);
        }
        return descriptions.toArray(new String[0]);
    }

    @Override
    public float getThickNess() {
        if (GT_Mod.instance.isClientSide() && (GT_Client.hideValue & 1) != 0) {
            return 0.0625f;
        }
        return this.mThickNess;
    }

    @Override
    public boolean isLiquidInput(ForgeDirection side) {
        return !this.isInputDisabledAtSide(side);
    }

    @Override
    public boolean isLiquidOutput(ForgeDirection side) {
        return true;
    }

    public boolean isInputDisabledAtSide(ForgeDirection side) {
        return (this.mDisableInput & side.flag) != 0;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World aWorld, int aX, int aY, int aZ) {
        if (GT_Mod.instance.isClientSide() && (GT_Client.hideValue & 2) != 0) {
            return AxisAlignedBB.func_72330_a((double)aX, (double)aY, (double)aZ, (double)(aX + 1), (double)(aY + 1), (double)(aZ + 1));
        }
        return this.getActualCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ);
    }

    private AxisAlignedBB getActualCollisionBoundingBoxFromPool(World aWorld, int aX, int aY, int aZ) {
        byte tConn;
        float tSpace;
        float tSide0 = tSpace = (1.0f - this.mThickNess) / 2.0f;
        float tSide1 = 1.0f - tSpace;
        float tSide2 = tSpace;
        float tSide3 = 1.0f - tSpace;
        float tSide4 = tSpace;
        float tSide5 = 1.0f - tSpace;
        if (this.getBaseMetaTileEntity().getCoverIDAtSide(ForgeDirection.DOWN) != 0) {
            tSide4 = 0.0f;
            tSide2 = 0.0f;
            tSide0 = 0.0f;
            tSide5 = 1.0f;
            tSide3 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide(ForgeDirection.UP) != 0) {
            tSide4 = 0.0f;
            tSide2 = 0.0f;
            tSide5 = 1.0f;
            tSide3 = 1.0f;
            tSide1 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide(ForgeDirection.NORTH) != 0) {
            tSide4 = 0.0f;
            tSide2 = 0.0f;
            tSide0 = 0.0f;
            tSide5 = 1.0f;
            tSide1 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide(ForgeDirection.SOUTH) != 0) {
            tSide4 = 0.0f;
            tSide0 = 0.0f;
            tSide5 = 1.0f;
            tSide3 = 1.0f;
            tSide1 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide(ForgeDirection.WEST) != 0) {
            tSide4 = 0.0f;
            tSide2 = 0.0f;
            tSide0 = 0.0f;
            tSide3 = 1.0f;
            tSide1 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide(ForgeDirection.EAST) != 0) {
            tSide2 = 0.0f;
            tSide0 = 0.0f;
            tSide5 = 1.0f;
            tSide3 = 1.0f;
            tSide1 = 1.0f;
        }
        if (((tConn = ((BaseMetaPipeEntity)this.getBaseMetaTileEntity()).mConnections) & ForgeDirection.DOWN.flag) != 0) {
            tSide0 = 0.0f;
        }
        if ((tConn & ForgeDirection.UP.flag) != 0) {
            tSide1 = 1.0f;
        }
        if ((tConn & ForgeDirection.NORTH.flag) != 0) {
            tSide2 = 0.0f;
        }
        if ((tConn & ForgeDirection.SOUTH.flag) != 0) {
            tSide3 = 1.0f;
        }
        if ((tConn & ForgeDirection.WEST.flag) != 0) {
            tSide4 = 0.0f;
        }
        if ((tConn & ForgeDirection.EAST.flag) != 0) {
            tSide5 = 1.0f;
        }
        return AxisAlignedBB.func_72330_a((double)((float)aX + tSide4), (double)((float)aY + tSide0), (double)((float)aZ + tSide2), (double)((float)aX + tSide5), (double)((float)aY + tSide1), (double)((float)aZ + tSide3));
    }

    @Override
    public void addCollisionBoxesToList(World aWorld, int aX, int aY, int aZ, AxisAlignedBB inputAABB, List<AxisAlignedBB> outputAABB, Entity collider) {
        AxisAlignedBB aabb;
        super.addCollisionBoxesToList(aWorld, aX, aY, aZ, inputAABB, outputAABB, collider);
        if (GT_Mod.instance.isClientSide() && (GT_Client.hideValue & 2) != 0 && inputAABB.func_72326_a(aabb = this.getActualCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ))) {
            outputAABB.add(aabb);
        }
    }

    @Override
    public FluidStack drain(ForgeDirection side, FluidStack aFluid, boolean doDrain) {
        if (aFluid == null) {
            return null;
        }
        for (int i = 0; i < this.mFluids.length; ++i) {
            FluidStack f = this.mFluids[i];
            if (f == null || !f.isFluidEqual(aFluid)) continue;
            return this.drainFromIndex(aFluid.amount, doDrain, i);
        }
        return null;
    }

    private static EnumMap<Border, ForgeDirection> borderMap(ForgeDirection topSide, ForgeDirection bottomSide, ForgeDirection leftSide, ForgeDirection rightSide) {
        EnumMap<Border, ForgeDirection> sideMap = new EnumMap<Border, ForgeDirection>(Border.class);
        sideMap.put(Border.TOP, topSide);
        sideMap.put(Border.BOTTOM, bottomSide);
        sideMap.put(Border.LEFT, leftSide);
        sideMap.put(Border.RIGHT, rightSide);
        return sideMap;
    }

    protected static ForgeDirection getSideAtBorder(ForgeDirection side, Border border) {
        return FACE_BORDER_MAP.get(side).get((Object)border);
    }

    static {
        FACE_BORDER_MAP.put(ForgeDirection.DOWN, GT_MetaPipeEntity_Fluid.borderMap(ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST));
        FACE_BORDER_MAP.put(ForgeDirection.UP, GT_MetaPipeEntity_Fluid.borderMap(ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST));
        FACE_BORDER_MAP.put(ForgeDirection.NORTH, GT_MetaPipeEntity_Fluid.borderMap(ForgeDirection.UP, ForgeDirection.DOWN, ForgeDirection.EAST, ForgeDirection.WEST));
        FACE_BORDER_MAP.put(ForgeDirection.SOUTH, GT_MetaPipeEntity_Fluid.borderMap(ForgeDirection.UP, ForgeDirection.DOWN, ForgeDirection.WEST, ForgeDirection.EAST));
        FACE_BORDER_MAP.put(ForgeDirection.WEST, GT_MetaPipeEntity_Fluid.borderMap(ForgeDirection.UP, ForgeDirection.DOWN, ForgeDirection.NORTH, ForgeDirection.SOUTH));
        FACE_BORDER_MAP.put(ForgeDirection.EAST, GT_MetaPipeEntity_Fluid.borderMap(ForgeDirection.UP, ForgeDirection.DOWN, ForgeDirection.SOUTH, ForgeDirection.NORTH));
        RESTR_TEXTURE_MAP = new HashMap<Integer, IIconContainer>();
        RESTR_TEXTURE_MAP.put(Border.TOP.mask, Textures.BlockIcons.PIPE_RESTRICTOR_UP);
        RESTR_TEXTURE_MAP.put(Border.BOTTOM.mask, Textures.BlockIcons.PIPE_RESTRICTOR_DOWN);
        RESTR_TEXTURE_MAP.put(Border.TOP.mask | Border.BOTTOM.mask, Textures.BlockIcons.PIPE_RESTRICTOR_UD);
        RESTR_TEXTURE_MAP.put(Border.LEFT.mask, Textures.BlockIcons.PIPE_RESTRICTOR_LEFT);
        RESTR_TEXTURE_MAP.put(Border.TOP.mask | Border.LEFT.mask, Textures.BlockIcons.PIPE_RESTRICTOR_UL);
        RESTR_TEXTURE_MAP.put(Border.BOTTOM.mask | Border.LEFT.mask, Textures.BlockIcons.PIPE_RESTRICTOR_DL);
        RESTR_TEXTURE_MAP.put(Border.TOP.mask | Border.BOTTOM.mask | Border.LEFT.mask, Textures.BlockIcons.PIPE_RESTRICTOR_NR);
        RESTR_TEXTURE_MAP.put(Border.RIGHT.mask, Textures.BlockIcons.PIPE_RESTRICTOR_RIGHT);
        RESTR_TEXTURE_MAP.put(Border.TOP.mask | Border.RIGHT.mask, Textures.BlockIcons.PIPE_RESTRICTOR_UR);
        RESTR_TEXTURE_MAP.put(Border.BOTTOM.mask | Border.RIGHT.mask, Textures.BlockIcons.PIPE_RESTRICTOR_DR);
        RESTR_TEXTURE_MAP.put(Border.TOP.mask | Border.BOTTOM.mask | Border.RIGHT.mask, Textures.BlockIcons.PIPE_RESTRICTOR_NL);
        RESTR_TEXTURE_MAP.put(Border.LEFT.mask | Border.RIGHT.mask, Textures.BlockIcons.PIPE_RESTRICTOR_LR);
        RESTR_TEXTURE_MAP.put(Border.TOP.mask | Border.LEFT.mask | Border.RIGHT.mask, Textures.BlockIcons.PIPE_RESTRICTOR_ND);
        RESTR_TEXTURE_MAP.put(Border.BOTTOM.mask | Border.LEFT.mask | Border.RIGHT.mask, Textures.BlockIcons.PIPE_RESTRICTOR_NU);
        RESTR_TEXTURE_MAP.put(Border.TOP.mask | Border.BOTTOM.mask | Border.LEFT.mask | Border.RIGHT.mask, Textures.BlockIcons.PIPE_RESTRICTOR);
    }

    protected static enum Border {
        TOP,
        BOTTOM,
        LEFT,
        RIGHT;

        public final int mask = 1 << this.ordinal();
    }
}

