/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity.base;

import gregtech.GT_Mod;
import gregtech.api.multitileentity.base.MultiTileEntity;
import gregtech.api.multitileentity.interfaces.IMultiTileEntity;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_Util;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TickableMultiTileEntity
extends MultiTileEntity
implements IMultiTileEntity.IMTE_OnNeighborBlockChange {
    public boolean isRunningTick = false;
    public boolean blockUpdated = false;
    protected long timer = 0L;
    private boolean sendClientData = false;

    public TickableMultiTileEntity() {
        super(true);
    }

    @Override
    public final void func_145845_h() {
        this.isRunningTick = true;
        boolean isServerSide = this.isServerSide();
        try {
            if (this.timer++ == 0L) {
                this.func_70296_d();
                GT_Util.markChunkDirty(this);
                this.onFirstTick(isServerSide);
            }
            if (this.isDead()) {
                return;
            }
            this.onPreTick(this.timer, isServerSide);
            super.func_145845_h();
            if (!isServerSide && this.needsUpdate) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.needsUpdate = false;
            }
            this.onTick(this.timer, isServerSide);
            if (isServerSide && this.timer > 2L && this.sendClientData) {
                this.sendClientData(null);
            }
            this.onPostTick(this.timer, isServerSide);
        }
        catch (Throwable e) {
            GT_Mod.GT_FML_LOGGER.error("UpdateEntity Failed", e);
            e.printStackTrace(GT_Log.err);
            try {
                this.onTickFailed(this.timer, isServerSide);
            }
            catch (Throwable e2) {
                GT_Mod.GT_FML_LOGGER.error("UpdateEntity:onTickFailed Failed", e);
            }
        }
        this.isRunningTick = false;
    }

    @Override
    public void sendClientData(EntityPlayerMP aPlayer) {
        if (this.sendClientData) {
            super.sendClientData(aPlayer);
            this.sendClientData = false;
        }
    }

    public void onFirstTick(boolean isServerSide) {
        if (isServerSide) {
            this.checkDropCover();
        } else {
            this.requestCoverDataIfNeeded();
        }
    }

    public void onPreTick(long aTick, boolean isServerSide) {
    }

    public void onTick(long tick, boolean isServerSide) {
    }

    public void onPostTick(long aTick, boolean isServerSide) {
    }

    public void onTickFailed(long aTimer, boolean isServerSide) {
    }

    @Override
    public void onNeighborBlockChange(World aWorld, Block aBlock) {
        this.blockUpdated = true;
    }

    @Override
    public void issueClientUpdate() {
        this.sendClientData = true;
    }

    @Override
    public byte getComparatorValue(ForgeDirection side) {
        return 0;
    }
}

