/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects.blockupdate;

import gregtech.api.objects.XSTR;
import gregtech.api.objects.blockupdate.Cooldown;

public class RandomCooldown
extends Cooldown {
    private int minLengthInTicks;
    private int maxLengthInTicks;

    public RandomCooldown(int aMinLengthInTicks, int aMaxLengthInTicks) {
        super(aMinLengthInTicks);
        if (aMinLengthInTicks <= 0) {
            throw new IllegalArgumentException("min length should be a positive non-zero number");
        }
        if (aMaxLengthInTicks <= 0) {
            throw new IllegalArgumentException("max length should be a positive non-zero number");
        }
        if (aMinLengthInTicks > aMaxLengthInTicks) {
            throw new IllegalArgumentException("min length should be less or equal to max length");
        }
        this.minLengthInTicks = aMinLengthInTicks;
        this.maxLengthInTicks = aMaxLengthInTicks;
    }

    @Override
    public void set(long currTickTime) {
        super.set(currTickTime);
        this.lengthInTicks = this.minLengthInTicks + XSTR.XSTR_INSTANCE.nextInt(this.maxLengthInTicks - this.minLengthInTicks + 1);
    }
}

