/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_AbstractMultiFurnace;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class GT_MetaTileEntity_MultiFurnace
extends GT_MetaTileEntity_AbstractMultiFurnace<GT_MetaTileEntity_MultiFurnace>
implements ISurvivalConstructable {
    private int mLevel = 0;
    private int mCostDiscount = 1;
    private static final int CASING_INDEX = 11;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<GT_MetaTileEntity_MultiFurnace> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"ccc", "cmc", "ccc"}, {"CCC", "C-C", "CCC"}, {"b~b", "bbb", "bbb"}})).addElement('c', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings1, (int)11)).addElement('m', GT_HatchElement.Muffler.newAny(11, 2)).addElement('C', GT_StructureUtility.ofCoil(GT_MetaTileEntity_AbstractMultiFurnace::setCoilLevel, GT_MetaTileEntity_AbstractMultiFurnace::getCoilLevel)).addElement('b', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.buildHatchAdder().atLeast(GT_HatchElement.Maintenance, GT_HatchElement.InputBus, GT_HatchElement.OutputBus, GT_HatchElement.Energy).casingIndex(11).dot(1).build(), StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings1, (int)11)})).build();

    public GT_MetaTileEntity_MultiFurnace(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_MultiFurnace(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_MultiFurnace(this.mName);
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Furnace").addInfo("Controller Block for the Multi Smelter").addInfo("Smelts up to 8-8192 items at once").addInfo("Items smelted increases with coil tier").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 3, 3, true).addController("Front bottom").addCasingInfoRange("Heat Proof Machine Casing", 8, 14, false).addOtherStructurePart("Heating Coils", "Middle layer").addEnergyHatch("Any bottom casing", 1).addMaintenanceHatch("Any bottom casing", 1).addMufflerHatch("Top Middle", 2).addInputBus("Any bottom casing", 1).addOutputBus("Any bottom casing", 1).toolTipFinisher("Gregtech");
        return tt;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, ForgeDirection facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        if (sideDirection != facingDirection) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11]};
        }
        if (active) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER_ACTIVE_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER_GLOW).extFacing().glow().build()};
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.furnaceRecipes;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return GT_Mod.gregtechproxy.mPollutionMultiSmelterPerSecond;
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        ArrayList<ItemStack> tInputList = this.getStoredInputs();
        if (tInputList.isEmpty()) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        int mVolatage = GT_Utility.safeInt(this.getMaxInputVoltage());
        int tMaxParallel = this.mLevel;
        int tCurrentParallel = 0;
        ArrayList<ItemStack> smeltedOutputs = new ArrayList<ItemStack>();
        ArrayList<Integer> outputStackSizes = new ArrayList<Integer>();
        for (ItemStack item : tInputList) {
            ItemStack smeltedOutput = GT_ModHandler.getSmeltingOutput(item, false, null);
            if (smeltedOutput != null) {
                smeltedOutputs.add(smeltedOutput);
                if (item.field_77994_a <= tMaxParallel - tCurrentParallel) {
                    tCurrentParallel += item.field_77994_a;
                    outputStackSizes.add(smeltedOutput.field_77994_a * item.field_77994_a);
                    item.field_77994_a = 0;
                } else {
                    int remainingStackSize = tCurrentParallel + item.field_77994_a - tMaxParallel;
                    outputStackSizes.add(smeltedOutput.field_77994_a * (item.field_77994_a - remainingStackSize));
                    item.field_77994_a = remainingStackSize;
                    break;
                }
            }
            if (tCurrentParallel != tMaxParallel) continue;
            break;
        }
        this.mOutputItems = new ItemStack[smeltedOutputs.size()];
        for (int i = 0; i < this.mOutputItems.length; ++i) {
            ItemStack tNewStack = (ItemStack)smeltedOutputs.get(i);
            tNewStack.field_77994_a = (Integer)outputStackSizes.get(i);
            this.mOutputItems[i] = tNewStack;
        }
        if (this.mOutputItems.length > 0) {
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            this.calculateOverclockedNessMultiInternal(4L, 512, 1, mVolatage, false);
            if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                return CheckRecipeResultRegistry.NO_RECIPE;
            }
            this.mEUt = GT_Utility.safeInt((long)this.mEUt * (long)(this.mLevel / 8) / (long)this.mCostDiscount, 1);
            if (this.mEUt == 0x7FFFFFFE) {
                return CheckRecipeResultRegistry.NO_RECIPE;
            }
            if (this.mEUt > 0) {
                this.mEUt = -this.mEUt;
            }
        }
        this.updateSlots();
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    @Override
    public IStructureDefinition<GT_MetaTileEntity_MultiFurnace> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mLevel = 0;
        this.mCostDiscount = 1;
        this.replaceDeprecatedCoils(aBaseMetaTileEntity);
        this.setCoilLevel(HeatingCoilLevel.None);
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 1, 2, 0)) {
            return false;
        }
        if (this.getCoilLevel() == HeatingCoilLevel.None) {
            return false;
        }
        if (this.mMaintenanceHatches.size() != 1) {
            return false;
        }
        this.mLevel = this.getCoilLevel().getHeat() < 9000L ? 8 * this.getCoilLevel().getLevel() : 1 << this.getCoilLevel().getTier();
        this.mCostDiscount = this.getCoilLevel().getCostDiscount();
        return true;
    }

    private void replaceDeprecatedCoils(IGregTechTileEntity aBaseMetaTileEntity) {
        int xDir = aBaseMetaTileEntity.getBackFacing().offsetX;
        int zDir = aBaseMetaTileEntity.getBackFacing().offsetZ;
        int tX = aBaseMetaTileEntity.getXCoord() + xDir;
        short tY = aBaseMetaTileEntity.getYCoord();
        int tZ = aBaseMetaTileEntity.getZCoord() + zDir;
        for (int xPos = tX - 1; xPos <= tX + 1; ++xPos) {
            for (int zPos = tZ - 1; zPos <= tZ + 1; ++zPos) {
                byte tUsedMeta;
                if (xPos == tX && zPos == tZ || (tUsedMeta = aBaseMetaTileEntity.getMetaID(xPos, tY + 1, zPos)) < 12 || tUsedMeta > 14 || aBaseMetaTileEntity.getBlock(xPos, tY + 1, zPos) != GregTech_API.sBlockCasings1) continue;
                aBaseMetaTileEntity.getWorld().func_147465_d(xPos, tY + 1, zPos, GregTech_API.sBlockCasings5, tUsedMeta - 12, 3);
            }
        }
    }

    @Override
    public String[] getInfoData() {
        int mPollutionReduction = 0;
        for (GT_MetaTileEntity_Hatch_Muffler tHatch : GT_Utility.filterValidMTEs(this.mMufflerHatches)) {
            mPollutionReduction = Math.max(tHatch.calculatePollutionReduction(100), mPollutionReduction);
        }
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (GT_MetaTileEntity_Hatch_Energy tHatch : GT_Utility.filterValidMTEs(this.mEnergyHatches)) {
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + ": " + EnumChatFormatting.RED + GT_Utility.formatNumbers(-this.mEUt) + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.mei") + ": " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(this.getMaxInputVoltage()) + EnumChatFormatting.RESET + " EU/t(*2A) " + StatCollector.func_74838_a((String)"GT5U.machines.tier") + ": " + EnumChatFormatting.YELLOW + GT_Values.VN[GT_Utility.getTier(this.getMaxInputVoltage())] + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %", StatCollector.func_74838_a((String)"GT5U.MS.multismelting") + ": " + EnumChatFormatting.GREEN + this.mLevel + EnumChatFormatting.RESET + " Discount: (EU/t) / " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(this.mCostDiscount) + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.multiblock.pollution") + ": " + EnumChatFormatting.GREEN + mPollutionReduction + EnumChatFormatting.RESET + " %"};
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 1, 2, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 1, 2, 0, elementBudget, env, false, true);
    }
}

