/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.logic;

import gregtech.api.interfaces.tileentity.IRecipeLockable;
import gregtech.api.logic.AbstractProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SingleRecipeCheck;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_ParallelHelper;
import gregtech.api.util.GT_Recipe;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ProcessingLogic
extends AbstractProcessingLogic<ProcessingLogic> {
    protected IRecipeLockable recipeLockableMachine;
    protected ItemStack specialSlotItem;
    protected ItemStack[] inputItems;
    protected FluidStack[] inputFluids;
    protected boolean isRecipeLocked;

    @Nonnull
    public ProcessingLogic setInputItems(ItemStack ... itemInputs) {
        this.inputItems = itemInputs;
        return (ProcessingLogic)this.getThis();
    }

    @Nonnull
    public ProcessingLogic setInputItems(List<ItemStack> itemOutputs) {
        this.inputItems = itemOutputs.toArray(new ItemStack[0]);
        return (ProcessingLogic)this.getThis();
    }

    @Nonnull
    public ProcessingLogic setInputFluids(FluidStack ... fluidInputs) {
        this.inputFluids = fluidInputs;
        return (ProcessingLogic)this.getThis();
    }

    @Nonnull
    public ProcessingLogic setInputFluids(List<FluidStack> fluidInputs) {
        this.inputFluids = fluidInputs.toArray(new FluidStack[0]);
        return (ProcessingLogic)this.getThis();
    }

    public ProcessingLogic setSpecialSlotItem(ItemStack specialSlotItem) {
        this.specialSlotItem = specialSlotItem;
        return (ProcessingLogic)this.getThis();
    }

    public ProcessingLogic setRecipeLocking(IRecipeLockable recipeLockableMachine, boolean isRecipeLocked) {
        this.recipeLockableMachine = recipeLockableMachine;
        this.isRecipeLocked = isRecipeLocked;
        return (ProcessingLogic)this.getThis();
    }

    @Override
    public ProcessingLogic clear() {
        this.inputItems = null;
        this.inputFluids = null;
        this.specialSlotItem = null;
        this.outputItems = null;
        this.outputFluids = null;
        this.calculatedEut = 0L;
        this.duration = 0;
        this.calculatedParallels = 0;
        return (ProcessingLogic)this.getThis();
    }

    @Override
    @Nonnull
    public CheckRecipeResult process() {
        RecipeMap<?> recipeMap = this.preProcess();
        if (this.inputItems == null) {
            this.inputItems = new ItemStack[0];
        }
        if (this.inputFluids == null) {
            this.inputFluids = new FluidStack[0];
        }
        if (this.isRecipeLocked && this.recipeLockableMachine != null && this.recipeLockableMachine.getSingleRecipeCheck() != null) {
            SingleRecipeCheck singleRecipeCheck = this.recipeLockableMachine.getSingleRecipeCheck();
            if (singleRecipeCheck.checkRecipeInputs(false, 1, this.inputItems, this.inputFluids) == 0) {
                return CheckRecipeResultRegistry.NO_RECIPE;
            }
            return this.validateAndCalculateRecipe((GT_Recipe)this.recipeLockableMachine.getSingleRecipeCheck().getRecipe()).checkRecipeResult;
        }
        Stream<GT_Recipe> matchedRecipes = this.findRecipeMatches(recipeMap);
        Iterable recipeIterable = matchedRecipes::iterator;
        CheckRecipeResult checkRecipeResult = CheckRecipeResultRegistry.NO_RECIPE;
        for (GT_Recipe matchedRecipe : recipeIterable) {
            CalculationResult foundResult = this.validateAndCalculateRecipe(matchedRecipe);
            if (foundResult.successfullyConsumedInputs) {
                return foundResult.checkRecipeResult;
            }
            if (foundResult.checkRecipeResult == CheckRecipeResultRegistry.NO_RECIPE) continue;
            checkRecipeResult = foundResult.checkRecipeResult;
        }
        return checkRecipeResult;
    }

    @Nonnull
    private CalculationResult validateAndCalculateRecipe(@Nonnull GT_Recipe recipe) {
        CheckRecipeResult result = this.validateRecipe(recipe);
        if (!result.wasSuccessful()) {
            return CalculationResult.ofFailure(result);
        }
        GT_ParallelHelper helper = this.createParallelHelper(recipe);
        GT_OverclockCalculator calculator = this.createOverclockCalculator(recipe);
        helper.setCalculator(calculator);
        helper.build();
        if (!helper.getResult().wasSuccessful()) {
            return CalculationResult.ofFailure(helper.getResult());
        }
        return CalculationResult.ofSuccess(this.applyRecipe(recipe, helper, calculator, result));
    }

    @Nonnull
    protected Stream<GT_Recipe> findRecipeMatches(@Nullable RecipeMap<?> map) {
        if (map == null) {
            return Stream.empty();
        }
        return map.findRecipeQuery().items(this.inputItems).fluids(this.inputFluids).specialSlot(this.specialSlotItem).cachedRecipe(this.lastRecipe).findAll();
    }

    @Nonnull
    protected GT_ParallelHelper createParallelHelper(@Nonnull GT_Recipe recipe) {
        return new GT_ParallelHelper().setRecipe(recipe).setItemInputs(this.inputItems).setFluidInputs(this.inputFluids).setAvailableEUt(this.availableVoltage * this.availableAmperage).setMachine(this.machine, this.protectItems, this.protectFluids).setRecipeLocked(this.recipeLockableMachine, this.isRecipeLocked).setMaxParallel(this.maxParallel).setEUtModifier(this.euModifier).enableBatchMode(this.batchSize).setConsumption(true).setOutputCalculation(true);
    }

    protected static final class CalculationResult {
        public final boolean successfullyConsumedInputs;
        public final CheckRecipeResult checkRecipeResult;

        public static CalculationResult ofSuccess(CheckRecipeResult checkRecipeResult) {
            return new CalculationResult(true, checkRecipeResult);
        }

        public static CalculationResult ofFailure(CheckRecipeResult checkRecipeResult) {
            return new CalculationResult(false, checkRecipeResult);
        }

        private CalculationResult(boolean successfullyConsumedInputs, CheckRecipeResult checkRecipeResult) {
            this.successfullyConsumedInputs = successfullyConsumedInputs;
            this.checkRecipeResult = checkRecipeResult;
        }
    }
}

