/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.fluid.FluidStackTank;
import com.gtnewhorizons.modularui.common.widget.CycleButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.FluidSlotWidget;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.gui.modularui.SteamTexture;
import gregtech.api.interfaces.ICleanroom;
import gregtech.api.interfaces.IConfigurationCircuitSupport;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddGregtechLogo;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IOverclockDescriptionProvider;
import gregtech.api.interfaces.tileentity.RecipeMapWorkable;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicTank;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.overclockdescriber.EUOverclockDescriber;
import gregtech.api.objects.overclockdescriber.OverclockDescriber;
import gregtech.api.recipe.BasicUIProperties;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_ClientPreference;
import gregtech.api.util.GT_CoverBehaviorBase;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_RecipeConstants;
import gregtech.api.util.GT_TooltipDataCache;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.GT_Waila;
import gregtech.api.util.ISerializableObject;
import gregtech.common.gui.modularui.UIHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.tuple.Pair;

public abstract class GT_MetaTileEntity_BasicMachine
extends GT_MetaTileEntity_BasicTank
implements RecipeMapWorkable,
IConfigurationCircuitSupport,
IOverclockDescriptionProvider,
IAddGregtechLogo,
IAddUIWidgets {
    protected static final int DID_NOT_FIND_RECIPE = 0;
    protected static final int FOUND_RECIPE_BUT_DID_NOT_MEET_REQUIREMENTS = 1;
    protected static final int FOUND_AND_SUCCESSFULLY_USED_RECIPE = 2;
    public static final int OTHER_SLOT_COUNT = 5;
    public final ItemStack[] mOutputItems;
    public final int mInputSlotCount;
    public final int mAmperage;
    public boolean mAllowInputFromOutputSide = false;
    public boolean mFluidTransfer = false;
    public boolean mItemTransfer = false;
    public boolean mHasBeenUpdated = false;
    public boolean mStuttering = false;
    public boolean mCharge = false;
    public boolean mDecharge = false;
    public boolean mDisableFilter = true;
    public boolean mDisableMultiStack = true;
    public int mProgresstime = 0;
    public int mMaxProgresstime = 0;
    public int mEUt = 0;
    public int mOutputBlocked = 0;
    public ForgeDirection mMainFacing = ForgeDirection.WEST;
    public FluidStack mOutputFluid;
    protected final OverclockDescriber overclockDescriber;
    protected GT_Recipe mLastRecipe = null;
    private FluidStack mFluidOut;
    protected final FluidStackTank fluidOutputTank = new FluidStackTank(() -> this.mFluidOut, fluidStack -> {
        this.mFluidOut = fluidStack;
    }, this::getCapacity);

    public GT_MetaTileEntity_BasicMachine(int aID, String aName, String aNameRegional, int aTier, int aAmperage, String aDescription, int aInputSlotCount, int aOutputSlotCount, ITexture ... aOverlays) {
        super(aID, aName, aNameRegional, aTier, 5 + aInputSlotCount + aOutputSlotCount + 1, aDescription, aOverlays);
        this.mInputSlotCount = Math.max(0, aInputSlotCount);
        this.mOutputItems = new ItemStack[Math.max(0, aOutputSlotCount)];
        this.mAmperage = aAmperage;
        this.overclockDescriber = this.createOverclockDescriber();
    }

    public GT_MetaTileEntity_BasicMachine(int aID, String aName, String aNameRegional, int aTier, int aAmperage, String[] aDescription, int aInputSlotCount, int aOutputSlotCount, ITexture ... aOverlays) {
        super(aID, aName, aNameRegional, aTier, 5 + aInputSlotCount + aOutputSlotCount + 1, aDescription, aOverlays);
        this.mInputSlotCount = Math.max(0, aInputSlotCount);
        this.mOutputItems = new ItemStack[Math.max(0, aOutputSlotCount)];
        this.mAmperage = aAmperage;
        this.overclockDescriber = this.createOverclockDescriber();
    }

    public GT_MetaTileEntity_BasicMachine(String aName, int aTier, int aAmperage, String[] aDescription, ITexture[][][] aTextures, int aInputSlotCount, int aOutputSlotCount) {
        super(aName, aTier, 5 + aInputSlotCount + aOutputSlotCount + 1, aDescription, aTextures);
        this.mInputSlotCount = Math.max(0, aInputSlotCount);
        this.mOutputItems = new ItemStack[Math.max(0, aOutputSlotCount)];
        this.mAmperage = aAmperage;
        this.overclockDescriber = this.createOverclockDescriber();
    }

    protected OverclockDescriber createOverclockDescriber() {
        return new EUOverclockDescriber(this.mTier, this.mAmperage);
    }

    protected boolean isValidMainFacing(ForgeDirection side) {
        return (side.flag & (ForgeDirection.UP.flag | ForgeDirection.DOWN.flag | ForgeDirection.UNKNOWN.flag)) == 0;
    }

    public boolean setMainFacing(ForgeDirection side) {
        if (!this.isValidMainFacing(side)) {
            return false;
        }
        this.mMainFacing = side;
        if (this.getBaseMetaTileEntity().getFrontFacing() == this.mMainFacing) {
            this.getBaseMetaTileEntity().setFrontFacing(side.getOpposite());
        }
        this.onFacingChange();
        this.onMachineBlockUpdate();
        return true;
    }

    @Override
    public void onFacingChange() {
        IGregTechTileEntity te;
        super.onFacingChange();
        if (this.mMainFacing == ForgeDirection.UNKNOWN && (te = this.getBaseMetaTileEntity()) != null && te.getWorld().field_72995_K) {
            this.mMainFacing = te.getFrontFacing();
            te.setFrontFacing(te.getBackFacing());
        }
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[14][17][];
        aTextures = Arrays.copyOf(aTextures, 14);
        for (int i = 0; i < aTextures.length; ++i) {
            if (aTextures[i] == null) continue;
            for (int c = -1; c < 16; c = (int)((byte)(c + 1))) {
                if (rTextures[i][c + 1] != null) continue;
                rTextures[i][c + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][c + 1], aTextures[i]};
            }
        }
        for (byte c = -1; c < 16; c = (byte)(c + 1)) {
            if (rTextures[0][c + 1] == null) {
                rTextures[0][c + 1] = this.getSideFacingActive(c);
            }
            if (rTextures[1][c + 1] == null) {
                rTextures[1][c + 1] = this.getSideFacingInactive(c);
            }
            if (rTextures[2][c + 1] == null) {
                rTextures[2][c + 1] = this.getFrontFacingActive(c);
            }
            if (rTextures[3][c + 1] == null) {
                rTextures[3][c + 1] = this.getFrontFacingInactive(c);
            }
            if (rTextures[4][c + 1] == null) {
                rTextures[4][c + 1] = this.getTopFacingActive(c);
            }
            if (rTextures[5][c + 1] == null) {
                rTextures[5][c + 1] = this.getTopFacingInactive(c);
            }
            if (rTextures[6][c + 1] == null) {
                rTextures[6][c + 1] = this.getBottomFacingActive(c);
            }
            if (rTextures[7][c + 1] == null) {
                rTextures[7][c + 1] = this.getBottomFacingInactive(c);
            }
            if (rTextures[8][c + 1] == null) {
                rTextures[8][c + 1] = this.getBottomFacingPipeActive(c);
            }
            if (rTextures[9][c + 1] == null) {
                rTextures[9][c + 1] = this.getBottomFacingPipeInactive(c);
            }
            if (rTextures[10][c + 1] == null) {
                rTextures[10][c + 1] = this.getTopFacingPipeActive(c);
            }
            if (rTextures[11][c + 1] == null) {
                rTextures[11][c + 1] = this.getTopFacingPipeInactive(c);
            }
            if (rTextures[12][c + 1] == null) {
                rTextures[12][c + 1] = this.getSideFacingPipeActive(c);
            }
            if (rTextures[13][c + 1] != null) continue;
            rTextures[13][c + 1] = this.getSideFacingPipeInactive(c);
        }
        return rTextures;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, ForgeDirection facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        int textureIndex;
        if ((this.mMainFacing.flag & (ForgeDirection.UP.flag | ForgeDirection.DOWN.flag)) != 0) {
            if (sideDirection == facingDirection) {
                textureIndex = active ? 2 : 3;
            } else {
                int n;
                switch (sideDirection) {
                    case DOWN: {
                        if (active) {
                            n = 6;
                            break;
                        }
                        n = 7;
                        break;
                    }
                    case UP: {
                        if (active) {
                            n = 4;
                            break;
                        }
                        n = 5;
                        break;
                    }
                    default: {
                        n = active ? 0 : 1;
                    }
                }
                textureIndex = n;
            }
        } else if (sideDirection == this.mMainFacing) {
            textureIndex = active ? 2 : 3;
        } else if (this.showPipeFacing() && sideDirection == facingDirection) {
            int n;
            switch (sideDirection) {
                case DOWN: {
                    if (active) {
                        n = 8;
                        break;
                    }
                    n = 9;
                    break;
                }
                case UP: {
                    if (active) {
                        n = 10;
                        break;
                    }
                    n = 11;
                    break;
                }
                default: {
                    n = active ? 12 : 13;
                }
            }
            textureIndex = n;
        } else {
            int n;
            switch (sideDirection) {
                case DOWN: {
                    if (active) {
                        n = 6;
                        break;
                    }
                    n = 7;
                    break;
                }
                case UP: {
                    if (active) {
                        n = 4;
                        break;
                    }
                    n = 5;
                    break;
                }
                default: {
                    n = active ? 0 : 1;
                }
            }
            textureIndex = n;
        }
        return this.mTextures[textureIndex][colorIndex + 1];
    }

    @Override
    public boolean isSimpleMachine() {
        return false;
    }

    @Override
    public boolean isOverclockerUpgradable() {
        return false;
    }

    @Override
    public boolean isTransformerUpgradable() {
        return false;
    }

    @Override
    public boolean isElectric() {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return aIndex > 0 && super.isValidSlot(aIndex) && aIndex != this.getCircuitSlot() && aIndex != 5 + this.mInputSlotCount + this.mOutputItems.length;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return ((facing.flag | this.mMainFacing.flag) & ~(ForgeDirection.UP.flag | ForgeDirection.DOWN.flag | ForgeDirection.UNKNOWN.flag)) != 0;
    }

    @Override
    public boolean isEnetInput() {
        return true;
    }

    @Override
    public boolean isInputFacing(ForgeDirection side) {
        return side != this.mMainFacing;
    }

    @Override
    public boolean isOutputFacing(ForgeDirection side) {
        return false;
    }

    @Override
    public boolean isTeleporterCompatible() {
        return false;
    }

    @Override
    public boolean isLiquidInput(ForgeDirection side) {
        return side != this.mMainFacing && (this.mAllowInputFromOutputSide || side != this.getBaseMetaTileEntity().getFrontFacing());
    }

    @Override
    public boolean isLiquidOutput(ForgeDirection side) {
        return side != this.mMainFacing;
    }

    @Override
    public long getMinimumStoredEU() {
        return GT_Values.V[this.mTier] * 16L;
    }

    @Override
    public long maxEUStore() {
        return GT_Values.V[this.mTier] * 64L;
    }

    @Override
    public long maxEUInput() {
        return GT_Values.V[this.mTier];
    }

    @Override
    public long maxSteamStore() {
        return this.maxEUStore();
    }

    @Override
    public long maxAmperesIn() {
        return (long)this.mEUt * 2L / GT_Values.V[this.mTier] + 1L;
    }

    @Override
    public int getInputSlot() {
        return 5;
    }

    @Override
    public int getOutputSlot() {
        return 5 + this.mInputSlotCount;
    }

    public int getSpecialSlotIndex() {
        return 3;
    }

    @Override
    public int getStackDisplaySlot() {
        return 2;
    }

    @Override
    public int rechargerSlotStartIndex() {
        return 1;
    }

    @Override
    public int dechargerSlotStartIndex() {
        return 1;
    }

    @Override
    public int rechargerSlotCount() {
        return this.mCharge ? 1 : 0;
    }

    @Override
    public int dechargerSlotCount() {
        return this.mDecharge ? 1 : 0;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public int getProgresstime() {
        return this.mProgresstime;
    }

    @Override
    public int maxProgresstime() {
        return this.mMaxProgresstime;
    }

    @Override
    public int increaseProgress(int aProgress) {
        this.mProgresstime += aProgress;
        return this.mMaxProgresstime - this.mProgresstime;
    }

    @Override
    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return this.getFillableStack() != null || this.getRecipeMap() != null && this.getRecipeMap().containsInput(aFluid);
    }

    @Override
    public boolean isFluidChangingAllowed() {
        return true;
    }

    @Override
    public boolean doesFillContainers() {
        return false;
    }

    @Override
    public boolean doesEmptyContainers() {
        return false;
    }

    @Override
    public boolean canTankBeFilled() {
        return true;
    }

    @Override
    public boolean canTankBeEmptied() {
        return true;
    }

    @Override
    public boolean displaysItemStack() {
        return true;
    }

    @Override
    public boolean displaysStackSize() {
        return true;
    }

    @Override
    public FluidStack getDrainableStack() {
        return this.mFluidOut;
    }

    @Override
    public FluidStack setDrainableStack(FluidStack aFluid) {
        this.func_70296_d();
        this.mFluidOut = aFluid;
        return this.mFluidOut;
    }

    @Override
    public boolean isDrainableStackSeparate() {
        return true;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        if (!GT_Mod.gregtechproxy.mForceFreeFace) {
            GT_UIInfos.openGTTileEntityUI(aBaseMetaTileEntity, aPlayer);
            return true;
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (!aBaseMetaTileEntity.getAirAtSide(side)) continue;
            GT_UIInfos.openGTTileEntityUI(aBaseMetaTileEntity, aPlayer);
            return true;
        }
        GT_Utility.sendChatToPlayer(aPlayer, "No free Side!");
        return true;
    }

    @Override
    public void initDefaultModes(NBTTagCompound aNBT) {
        GT_ClientPreference tPreference;
        this.mMainFacing = ForgeDirection.UNKNOWN;
        if (!this.getBaseMetaTileEntity().getWorld().field_72995_K && (tPreference = GT_Mod.gregtechproxy.getClientPreference(this.getBaseMetaTileEntity().getOwnerUuid())) != null) {
            this.mDisableFilter = !tPreference.isSingleBlockInitialFilterEnabled();
            this.mDisableMultiStack = !tPreference.isSingleBlockInitialMultiStackEnabled();
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("mFluidTransfer", this.mFluidTransfer);
        aNBT.func_74757_a("mItemTransfer", this.mItemTransfer);
        aNBT.func_74757_a("mHasBeenUpdated", this.mHasBeenUpdated);
        aNBT.func_74757_a("mAllowInputFromOutputSide", this.mAllowInputFromOutputSide);
        aNBT.func_74757_a("mDisableFilter", this.mDisableFilter);
        aNBT.func_74757_a("mDisableMultiStack", this.mDisableMultiStack);
        aNBT.func_74768_a("mEUt", this.mEUt);
        aNBT.func_74768_a("mMainFacing", this.mMainFacing.ordinal());
        aNBT.func_74768_a("mProgresstime", this.mProgresstime);
        aNBT.func_74768_a("mMaxProgresstime", this.mMaxProgresstime);
        if (this.mOutputFluid != null) {
            aNBT.func_74782_a("mOutputFluid", (NBTBase)this.mOutputFluid.writeToNBT(new NBTTagCompound()));
        }
        if (this.mFluidOut != null) {
            aNBT.func_74782_a("mFluidOut", (NBTBase)this.mFluidOut.writeToNBT(new NBTTagCompound()));
        }
        for (int i = 0; i < this.mOutputItems.length; ++i) {
            if (this.mOutputItems[i] == null) continue;
            GT_Utility.saveItem(aNBT, "mOutputItem" + i, this.mOutputItems[i]);
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mFluidTransfer = aNBT.func_74767_n("mFluidTransfer");
        this.mItemTransfer = aNBT.func_74767_n("mItemTransfer");
        this.mHasBeenUpdated = aNBT.func_74767_n("mHasBeenUpdated");
        this.mAllowInputFromOutputSide = aNBT.func_74767_n("mAllowInputFromOutputSide");
        this.mDisableFilter = aNBT.func_74767_n("mDisableFilter");
        this.mDisableMultiStack = aNBT.func_74767_n("mDisableMultiStack");
        this.mEUt = aNBT.func_74762_e("mEUt");
        this.mMainFacing = ForgeDirection.getOrientation((int)aNBT.func_74762_e("mMainFacing"));
        this.mProgresstime = aNBT.func_74762_e("mProgresstime");
        this.mMaxProgresstime = aNBT.func_74762_e("mMaxProgresstime");
        this.mOutputFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT.func_74775_l("mOutputFluid"));
        this.mFluidOut = FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT.func_74775_l("mFluidOut"));
        for (int i = 0; i < this.mOutputItems.length; ++i) {
            this.mOutputItems[i] = GT_Utility.loadItem(aNBT, "mOutputItem" + i);
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide()) {
            this.mCharge = aBaseMetaTileEntity.getStoredEU() / 2L > aBaseMetaTileEntity.getEUCapacity() / 3L;
            this.mDecharge = aBaseMetaTileEntity.getStoredEU() < aBaseMetaTileEntity.getEUCapacity() / 3L;
            this.doDisplayThings();
            boolean tSucceeded = false;
            if (this.mMaxProgresstime > 0 && (this.mProgresstime >= 0 || aBaseMetaTileEntity.isAllowedToWork())) {
                this.func_70296_d();
                aBaseMetaTileEntity.setActive(true);
                if (this.mProgresstime < 0 || this.drainEnergyForProcess(this.mEUt)) {
                    if (++this.mProgresstime >= this.mMaxProgresstime) {
                        for (int i = 0; i < this.mOutputItems.length; ++i) {
                            for (int j = 0; j < this.mOutputItems.length && !aBaseMetaTileEntity.addStackToSlot(this.getOutputSlot() + (j + i) % this.mOutputItems.length, this.mOutputItems[i]); ++j) {
                            }
                        }
                        if (this.mOutputFluid != null) {
                            if (this.getDrainableStack() == null) {
                                this.setDrainableStack(this.mOutputFluid.copy());
                            } else if (this.mOutputFluid.isFluidEqual(this.getDrainableStack())) {
                                this.getDrainableStack().amount += this.mOutputFluid.amount;
                            }
                        }
                        Arrays.fill(this.mOutputItems, null);
                        this.mOutputFluid = null;
                        this.mEUt = 0;
                        this.mProgresstime = 0;
                        this.mMaxProgresstime = 0;
                        this.mStuttering = false;
                        tSucceeded = true;
                        this.endProcess();
                    }
                    if (this.mProgresstime > 5) {
                        this.mStuttering = false;
                    }
                } else if (!this.mStuttering) {
                    this.stutterProcess();
                    if (this.canHaveInsufficientEnergy()) {
                        this.mProgresstime = -100;
                    }
                    this.mStuttering = true;
                }
            } else {
                aBaseMetaTileEntity.setActive(false);
            }
            boolean tRemovedOutputFluid = false;
            if (this.doesAutoOutputFluids() && this.getDrainableStack() != null && aBaseMetaTileEntity.getFrontFacing() != this.mMainFacing && (tSucceeded || aTick % 20L == 0L)) {
                int tFilledAmount;
                FluidStack tDrained;
                IFluidHandler tTank = aBaseMetaTileEntity.getITankContainerAtSide(aBaseMetaTileEntity.getFrontFacing());
                if (tTank != null && (tDrained = this.drain(1000, false)) != null && (tFilledAmount = tTank.fill(aBaseMetaTileEntity.getBackFacing(), tDrained, false)) > 0) {
                    tTank.fill(aBaseMetaTileEntity.getBackFacing(), this.drain(tFilledAmount, true), true);
                }
                if (this.getDrainableStack() == null) {
                    tRemovedOutputFluid = true;
                }
            }
            if (this.doesAutoOutput() && !this.isOutputEmpty() && aBaseMetaTileEntity.getFrontFacing() != this.mMainFacing && (tSucceeded || this.mOutputBlocked % 300 == 1 || aBaseMetaTileEntity.hasInventoryBeenModified() || aTick % 600L == 0L)) {
                TileEntity tTileEntity2 = aBaseMetaTileEntity.getTileEntityAtSide(aBaseMetaTileEntity.getFrontFacing());
                long tStoredEnergy = aBaseMetaTileEntity.getUniversalEnergyStored();
                int tMaxStacks = (int)(tStoredEnergy / 64L);
                if (tMaxStacks > this.mOutputItems.length) {
                    tMaxStacks = this.mOutputItems.length;
                }
                GT_Utility.moveMultipleItemStacks(aBaseMetaTileEntity, tTileEntity2, aBaseMetaTileEntity.getFrontFacing(), aBaseMetaTileEntity.getBackFacing(), null, false, (byte)64, (byte)1, (byte)64, (byte)1, tMaxStacks);
            }
            if (this.mOutputBlocked != 0) {
                this.mOutputBlocked = this.isOutputEmpty() ? 0 : ++this.mOutputBlocked;
            }
            if (this.allowToCheckRecipe()) {
                if (this.mMaxProgresstime <= 0 && aBaseMetaTileEntity.isAllowedToWork() && (tRemovedOutputFluid || tSucceeded || aBaseMetaTileEntity.hasInventoryBeenModified() || aTick % 600L == 0L || aBaseMetaTileEntity.hasWorkJustBeenEnabled()) && this.hasEnoughEnergyToCheckRecipe()) {
                    if (this.checkRecipe() == 2) {
                        int i;
                        if (this.getSpecialSlot() != null && this.getSpecialSlot().field_77994_a <= 0) {
                            this.mInventory[this.getSpecialSlotIndex()] = null;
                        }
                        int j = i + this.mInputSlotCount;
                        for (i = this.getInputSlot(); i < j; ++i) {
                            if (this.mInventory[i] == null || this.mInventory[i].field_77994_a > 0) continue;
                            this.mInventory[i] = null;
                        }
                        for (i = 0; i < this.mOutputItems.length; ++i) {
                            this.mOutputItems[i] = GT_Utility.copyOrNull(this.mOutputItems[i]);
                            if (this.mOutputItems[i] != null && this.mOutputItems[i].field_77994_a > 64) {
                                this.mOutputItems[i].field_77994_a = 64;
                            }
                            this.mOutputItems[i] = GT_OreDictUnificator.get(true, this.mOutputItems[i]);
                        }
                        if (this.mFluid != null && this.mFluid.amount <= 0) {
                            this.mFluid = null;
                        }
                        this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
                        if (GT_Utility.isDebugItem(this.mInventory[this.dechargerSlotStartIndex()])) {
                            this.mMaxProgresstime = 1;
                            this.mEUt = 1;
                        }
                        this.startProcess();
                    } else {
                        this.mMaxProgresstime = 0;
                        Arrays.fill(this.mOutputItems, null);
                        this.mOutputFluid = null;
                    }
                }
            } else if (!this.mStuttering) {
                this.stutterProcess();
                this.mStuttering = true;
            }
        }
        aBaseMetaTileEntity.setErrorDisplayID(aBaseMetaTileEntity.getErrorDisplayID() & 0xFFFFFF80);
    }

    protected void doDisplayThings() {
        if (!this.isValidMainFacing(this.mMainFacing) && this.isValidMainFacing(this.getBaseMetaTileEntity().getFrontFacing())) {
            this.mMainFacing = this.getBaseMetaTileEntity().getFrontFacing();
        }
        if (this.isValidMainFacing(this.mMainFacing) && !this.mHasBeenUpdated) {
            this.mHasBeenUpdated = true;
            this.getBaseMetaTileEntity().setFrontFacing(this.getBaseMetaTileEntity().getBackFacing());
        }
    }

    protected boolean hasEnoughEnergyToCheckRecipe() {
        return this.getBaseMetaTileEntity().isUniversalEnergyStored(this.getMinimumStoredEU() / 2L);
    }

    protected boolean drainEnergyForProcess(long aEUt) {
        return this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(aEUt, false);
    }

    protected void calculateCustomOverclock(GT_Recipe recipe) {
        GT_OverclockCalculator calculator = this.overclockDescriber.createCalculator(new GT_OverclockCalculator().setRecipeEUt(recipe.mEUt).setDuration(recipe.mDuration).setOneTickDiscount(true), recipe);
        calculator.calculate();
        this.mEUt = (int)calculator.getConsumption();
        this.mMaxProgresstime = calculator.getDuration();
    }

    protected void calculateOverclockedNess(int eut, int duration) {
        GT_OverclockCalculator calculator = new GT_OverclockCalculator().setRecipeEUt(eut).setEUt(GT_Values.V[this.mTier] * (long)this.mAmperage).setDuration(duration).setOneTickDiscount(true).calculate();
        this.mEUt = (int)calculator.getConsumption();
        this.mMaxProgresstime = calculator.getDuration();
    }

    protected ItemStack getSpecialSlot() {
        return this.mInventory[this.getSpecialSlotIndex()];
    }

    protected ItemStack getOutputAt(int aIndex) {
        return this.mInventory[this.getOutputSlot() + aIndex];
    }

    protected ItemStack[] getAllOutputs() {
        ItemStack[] rOutputs = new ItemStack[this.mOutputItems.length];
        for (int i = 0; i < this.mOutputItems.length; ++i) {
            rOutputs[i] = this.getOutputAt(i);
        }
        return rOutputs;
    }

    protected boolean canOutput(GT_Recipe aRecipe) {
        return aRecipe != null && (aRecipe.mNeedsEmptyOutput ? this.isOutputEmpty() && this.getDrainableStack() == null : this.canOutput(aRecipe.getFluidOutput(0)) && this.canOutput(aRecipe.mOutputs));
    }

    protected boolean canOutput(ItemStack ... aOutputs) {
        if (aOutputs == null) {
            return true;
        }
        ItemStack[] tOutputSlots = this.getAllOutputs();
        for (int i = 0; i < tOutputSlots.length && i < aOutputs.length; ++i) {
            if (tOutputSlots[i] == null || aOutputs[i] == null || GT_Utility.areStacksEqual(tOutputSlots[i], aOutputs[i], false) && tOutputSlots[i].field_77994_a + aOutputs[i].field_77994_a <= tOutputSlots[i].func_77976_d()) continue;
            ++this.mOutputBlocked;
            return false;
        }
        return true;
    }

    protected boolean canOutput(FluidStack aOutput) {
        if (aOutput == null) {
            return true;
        }
        FluidStack drainableStack = this.getDrainableStack();
        if (drainableStack != null && !drainableStack.isFluidEqual(aOutput)) {
            return false;
        }
        return (drainableStack != null ? drainableStack.amount : 0) + aOutput.amount <= this.getCapacity();
    }

    protected ItemStack getInputAt(int aIndex) {
        return this.mInventory[this.getInputSlot() + aIndex];
    }

    protected ItemStack[] getAllInputs() {
        int tRealInputSlotCount = this.mInputSlotCount + (this.allowSelectCircuit() ? 1 : 0);
        ItemStack[] rInputs = new ItemStack[tRealInputSlotCount];
        for (int i = 0; i < this.mInputSlotCount; ++i) {
            rInputs[i] = this.getInputAt(i);
        }
        if (this.allowSelectCircuit()) {
            rInputs[this.mInputSlotCount] = this.func_70301_a(this.getCircuitSlot());
        }
        return rInputs;
    }

    protected boolean isOutputEmpty() {
        boolean rIsEmpty = true;
        for (ItemStack tOutputSlotContent : this.getAllOutputs()) {
            if (tOutputSlotContent == null) continue;
            rIsEmpty = false;
            break;
        }
        return rIsEmpty;
    }

    @Override
    public void onValueUpdate(byte aValue) {
        this.mMainFacing = ForgeDirection.getOrientation((int)aValue);
    }

    @Override
    public byte getUpdateData() {
        return (byte)this.mMainFacing.ordinal();
    }

    @Override
    public void doSound(byte aIndex, double aX, double aY, double aZ) {
        super.doSound(aIndex, aX, aY, aZ);
        if (aIndex == 8) {
            GT_Utility.doSoundAtClient(SoundResource.IC2_MACHINES_INTERRUPT_ONE, 100, 1.0f, aX, aY, aZ);
        }
    }

    public boolean doesAutoOutput() {
        return this.mItemTransfer;
    }

    public boolean doesAutoOutputFluids() {
        return this.mFluidTransfer;
    }

    public boolean allowToCheckRecipe() {
        return true;
    }

    public boolean showPipeFacing() {
        return true;
    }

    public void startProcess() {
    }

    public void endProcess() {
    }

    public void abortProcess() {
    }

    public void stutterProcess() {
        if (this.useStandardStutterSound()) {
            this.sendSound((byte)8);
        }
    }

    public boolean canHaveInsufficientEnergy() {
        return true;
    }

    public boolean useStandardStutterSound() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        return new String[]{"Progress:", EnumChatFormatting.GREEN + GT_Utility.formatNumbers(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s", "Stored Energy:", EnumChatFormatting.GREEN + GT_Utility.formatNumbers(this.getBaseMetaTileEntity().getStoredEU()) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(this.getBaseMetaTileEntity().getEUCapacity()) + EnumChatFormatting.RESET + " EU", "Probably uses: " + EnumChatFormatting.RED + GT_Utility.formatNumbers(this.mEUt) + EnumChatFormatting.RESET + " EU/t at " + EnumChatFormatting.RED + GT_Utility.formatNumbers(this.mEUt == 0 ? 0L : (long)this.mAmperage) + EnumChatFormatting.RESET + " A"};
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (side == this.getBaseMetaTileEntity().getFrontFacing() || side == this.mMainFacing) {
            if (aPlayer.func_70093_af()) {
                this.mDisableFilter = !this.mDisableFilter;
                GT_Utility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)("GT5U.hatch.disableFilter." + this.mDisableFilter)));
            } else {
                this.mAllowInputFromOutputSide = !this.mAllowInputFromOutputSide;
                GT_Utility.sendChatToPlayer(aPlayer, this.mAllowInputFromOutputSide ? GT_Utility.trans("095", "Input from Output Side allowed") : GT_Utility.trans("096", "Input from Output Side forbidden"));
            }
        }
    }

    @Override
    public boolean onSolderingToolRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer entityPlayer, float aX, float aY, float aZ) {
        if (!entityPlayer.func_70093_af()) {
            return false;
        }
        boolean click = super.onSolderingToolRightClick(side, wrenchingSide, entityPlayer, aX, aY, aZ);
        if (click) {
            return true;
        }
        if (wrenchingSide != this.mMainFacing) {
            return false;
        }
        this.mDisableMultiStack = !this.mDisableMultiStack;
        GT_Utility.sendChatToPlayer(entityPlayer, StatCollector.func_74838_a((String)("GT5U.hatch.disableMultiStack." + this.mDisableMultiStack)));
        return true;
    }

    @Override
    public boolean allowCoverOnSide(ForgeDirection side, GT_ItemStack aCoverID) {
        if (side != this.mMainFacing) {
            return true;
        }
        GT_CoverBehaviorBase<?> tBehavior = GregTech_API.getCoverBehaviorNew(aCoverID.toStack());
        return tBehavior.isGUIClickable(side, GT_Utility.stackToInt(aCoverID.toStack()), (ISerializableObject)tBehavior.createDataObject(), this.getBaseMetaTileEntity());
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return side != this.mMainFacing && aIndex >= this.getOutputSlot() && aIndex < this.getOutputSlot() + this.mOutputItems.length;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        int i;
        if (side == this.mMainFacing || aIndex < this.getInputSlot() || aIndex >= this.getInputSlot() + this.mInputSlotCount || !this.mAllowInputFromOutputSide && side == aBaseMetaTileEntity.getFrontFacing()) {
            return false;
        }
        int j = i + this.mInputSlotCount;
        for (i = this.getInputSlot(); i < j; ++i) {
            if (!GT_Utility.areStacksEqual(GT_OreDictUnificator.get(aStack), this.mInventory[i]) || !this.mDisableMultiStack) continue;
            return i == aIndex;
        }
        return this.mDisableFilter || this.allowPutStackValidated(aBaseMetaTileEntity, aIndex, side, aStack);
    }

    protected boolean allowPutStackValidated(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return !this.mDisableMultiStack || this.mInventory[aIndex] == null;
    }

    @Override
    public boolean allowSelectCircuit() {
        return false;
    }

    protected final ItemStack[] appendSelectedCircuit(ItemStack ... inputs) {
        ItemStack circuit;
        if (this.allowSelectCircuit() && (circuit = this.func_70301_a(this.getCircuitSlot())) != null) {
            ItemStack[] result = Arrays.copyOf(inputs, inputs.length + 1);
            result[inputs.length] = circuit;
            return result;
        }
        return inputs;
    }

    @Override
    public int getCircuitSlot() {
        return 4;
    }

    @Override
    public int getCircuitGUISlot() {
        return 3;
    }

    @Override
    public List<ItemStack> getConfigurationCircuits() {
        return GregTech_API.getConfigurationCircuitList(this.mTier);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return null;
    }

    public int checkRecipe() {
        return this.checkRecipe(false);
    }

    public static boolean isValidForLowGravity(GT_Recipe tRecipe, int dimId) {
        return DimensionManager.getProvider((int)dimId).getClass().getName().contains("Orbit") || DimensionManager.getProvider((int)dimId).getClass().getName().endsWith("Space") || DimensionManager.getProvider((int)dimId).getClass().getName().endsWith("Asteroids") || DimensionManager.getProvider((int)dimId).getClass().getName().endsWith("SS") || DimensionManager.getProvider((int)dimId).getClass().getName().contains("SpaceStation");
    }

    public int checkRecipe(boolean skipOC) {
        int i;
        RecipeMap<?> tMap = this.getRecipeMap();
        if (tMap == null) {
            return 0;
        }
        GT_Recipe tRecipe = tMap.findRecipeQuery().items(this.getAllInputs()).fluids(this.getFillableStack()).specialSlot(this.getSpecialSlot()).voltage(GT_Values.V[this.mTier]).cachedRecipe(this.mLastRecipe).find();
        if (tRecipe == null) {
            return 0;
        }
        if (tRecipe.getMetadataOrDefault(GT_RecipeConstants.EXPLODE, false).booleanValue() && this.getBaseMetaTileEntity() != null) {
            this.getBaseMetaTileEntity().doExplosion(GT_Values.V[this.mTier] * 4L);
            return 0;
        }
        if (tRecipe.getMetadataOrDefault(GT_RecipeConstants.ON_FIRE, false).booleanValue() && this.getBaseMetaTileEntity() != null) {
            this.getBaseMetaTileEntity().setOnFire();
            return 0;
        }
        if (GT_Mod.gregtechproxy.mLowGravProcessing && (tRecipe.mSpecialValue == -100 || tRecipe.mSpecialValue == -300) && !GT_MetaTileEntity_BasicMachine.isValidForLowGravity(tRecipe, this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g)) {
            return 1;
        }
        if (tRecipe.mCanBeBuffered) {
            this.mLastRecipe = tRecipe;
        }
        if (!this.canOutput(tRecipe)) {
            ++this.mOutputBlocked;
            return 1;
        }
        ICleanroom cleanroom = this.getCleanroom();
        if (!(tRecipe.mSpecialValue != -200 && tRecipe.mSpecialValue != -300 || cleanroom != null && cleanroom.isValidCleanroom() && cleanroom.getCleanness() != 0)) {
            return 1;
        }
        if (!tRecipe.isRecipeInputEqual(true, new FluidStack[]{this.getFillableStack()}, this.getAllInputs())) {
            return 1;
        }
        for (i = 0; i < this.mOutputItems.length; ++i) {
            if (this.getBaseMetaTileEntity().getRandomNumber(10000) >= tRecipe.getOutputChance(i)) continue;
            this.mOutputItems[i] = tRecipe.getOutput(i);
        }
        if (tRecipe.mSpecialValue == -200 || tRecipe.mSpecialValue == -300) {
            assert (cleanroom != null);
            for (i = 0; i < this.mOutputItems.length; ++i) {
                if (this.mOutputItems[i] == null || this.getBaseMetaTileEntity().getRandomNumber(10000) <= cleanroom.getCleanness()) continue;
                if (GT_Values.debugCleanroom) {
                    GT_Log.out.println("BasicMachine: Voiding output due to cleanness failure. Cleanness = " + cleanroom.getCleanness());
                }
                this.mOutputItems[i] = null;
            }
        }
        this.mOutputFluid = tRecipe.getFluidOutput(0);
        if (!skipOC) {
            this.calculateCustomOverclock(tRecipe);
            if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                return 1;
            }
        }
        return 2;
    }

    public ITexture[] getSideFacingActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getSideFacingInactive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getFrontFacingActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getFrontFacingInactive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getTopFacingActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getTopFacingInactive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getBottomFacingActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getBottomFacingInactive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getBottomFacingPipeActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    public ITexture[] getBottomFacingPipeInactive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    public ITexture[] getTopFacingPipeActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    public ITexture[] getTopFacingPipeInactive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    public ITexture[] getSideFacingPipeActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    public ITexture[] getSideFacingPipeInactive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_74767_n("stutteringSingleBlock")) {
            currenttip.add("Status: insufficient energy");
        } else {
            boolean isActive = tag.func_74767_n("isActiveSingleBlock");
            if (isActive) {
                int mEUt = tag.func_74762_e("eut");
                if (!this.isSteampowered()) {
                    if (mEUt > 0) {
                        currenttip.add(StatCollector.func_74837_a((String)"GT5U.waila.energy.use_with_amperage", (Object[])new Object[]{GT_Utility.formatNumbers(mEUt), GT_Utility.getAmperageForTier(mEUt, (byte)this.getInputTier()), GT_Utility.getColoredTierNameFromTier((byte)this.getInputTier())}));
                    } else if (mEUt < 0) {
                        currenttip.add(StatCollector.func_74837_a((String)"GT5U.waila.energy.produce_with_amperage", (Object[])new Object[]{GT_Utility.formatNumbers(-mEUt), GT_Utility.getAmperageForTier(-mEUt, (byte)this.getOutputTier()), GT_Utility.getColoredTierNameFromTier((byte)this.getOutputTier())}));
                    }
                } else if (mEUt > 0) {
                    currenttip.add(StatCollector.func_74837_a((String)"GT5U.waila.energy.use", (Object[])new Object[]{GT_Utility.formatNumbers(mEUt), GT_Utility.getColoredTierNameFromVoltage(mEUt)}));
                } else if (mEUt < 0) {
                    currenttip.add(StatCollector.func_74837_a((String)"GT5U.waila.energy.produce", (Object[])new Object[]{GT_Utility.formatNumbers(-mEUt), GT_Utility.getColoredTierNameFromVoltage(-mEUt)}));
                }
            }
            currenttip.add(GT_Waila.getMachineProgressString(isActive, tag.func_74762_e("maxProgressSingleBlock"), tag.func_74762_e("progressSingleBlock")));
        }
        currenttip.add(String.format("Machine Facing: %s", ForgeDirection.getOrientation((int)tag.func_74762_e("mainFacingSingleBlock")).name()));
        currenttip.add(String.format("Output Facing: %s", ForgeDirection.getOrientation((int)tag.func_74762_e("outputFacingSingleBlock")).name()));
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74768_a("progressSingleBlock", this.mProgresstime);
        tag.func_74768_a("maxProgressSingleBlock", this.mMaxProgresstime);
        tag.func_74768_a("mainFacingSingleBlock", this.mMainFacing.ordinal());
        tag.func_74757_a("stutteringSingleBlock", this.mStuttering);
        IGregTechTileEntity tileEntity = this.getBaseMetaTileEntity();
        if (tileEntity != null) {
            tag.func_74757_a("isActiveSingleBlock", tileEntity.isActive());
            tag.func_74768_a("outputFacingSingleBlock", tileEntity.getFrontFacing().ordinal());
            if (tileEntity.isActive()) {
                tag.func_74768_a("eut", this.mEUt);
            }
        }
    }

    @Override
    @Nonnull
    public OverclockDescriber getOverclockDescriber() {
        return this.overclockDescriber;
    }

    @Override
    public boolean useModularUI() {
        return this.getRecipeMap() != null;
    }

    @Override
    public int getCircuitSlotX() {
        return 153;
    }

    @Override
    public int getCircuitSlotY() {
        return 63;
    }

    @Override
    public void addGregTechLogo(ModularWindow.Builder builder) {
        if (this.getRecipeMap() != null) {
            this.getRecipeMap().getFrontend().addGregTechLogo(builder, new Pos2d(0, 0));
        } else {
            builder.widget(new DrawableWidget().setDrawable((IDrawable)this.getGUITextureSet().getGregTechLogo()).setSize(17, 17).setPos(152, 63));
        }
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        if (!this.isSteampowered()) {
            builder.widget((Widget)this.createFluidAutoOutputButton());
            builder.widget((Widget)this.createItemAutoOutputButton());
        }
        BasicUIProperties uiProperties = this.getUIProperties();
        this.addIOSlots(builder, uiProperties);
        builder.widget((Widget)this.createChargerSlot(79, 62));
        this.addProgressBar(builder, uiProperties);
        builder.widget((Widget)this.createErrorStatusArea(builder, (IDrawable)(this.isSteampowered() ? GT_UITextures.PICTURE_STALLED_STEAM : GT_UITextures.PICTURE_STALLED_ELECTRICITY)));
    }

    protected BasicUIProperties getUIProperties() {
        if (this.getRecipeMap() != null) {
            BasicUIProperties originalProperties = this.getRecipeMap().getFrontend().getUIProperties();
            return originalProperties.toBuilder().maxItemInputs(this.mInputSlotCount).maxItemOutputs(this.mOutputItems.length).maxFluidInputs(Math.min(originalProperties.maxFluidInputs, 1)).maxFluidOutputs(Math.min(originalProperties.maxFluidOutputs, 1)).build();
        }
        return BasicUIProperties.builder().maxItemInputs(this.mInputSlotCount).maxItemOutputs(this.mOutputItems.length).maxFluidInputs(this.getCapacity() != 0 ? 1 : 0).maxFluidOutputs(0).build();
    }

    protected void addIOSlots(ModularWindow.Builder builder, BasicUIProperties uiProperties) {
        UIHelper.forEachSlots((i, backgrounds, pos) -> builder.widget((Widget)this.createItemInputSlot(i, backgrounds, pos)), (i, backgrounds, pos) -> builder.widget((Widget)this.createItemOutputSlot(i, backgrounds, pos)), (i, backgrounds, pos) -> builder.widget((Widget)this.createSpecialSlot(backgrounds, pos, uiProperties)), (i, backgrounds, pos) -> builder.widget((Widget)this.createFluidInputSlot(backgrounds, pos)), (i, backgrounds, pos) -> builder.widget((Widget)this.createFluidOutputSlot(backgrounds, pos)), (IDrawable)this.getGUITextureSet().getItemSlot(), (IDrawable)this.getGUITextureSet().getFluidSlot(), uiProperties, uiProperties.maxItemInputs, uiProperties.maxItemOutputs, uiProperties.maxFluidInputs, uiProperties.maxFluidOutputs, this.getSteamVariant(), Pos2d.ZERO);
    }

    protected void addProgressBar(ModularWindow.Builder builder, BasicUIProperties uiProperties) {
        boolean isSteamPowered = this.isSteampowered();
        RecipeMap<?> recipeMap = this.getRecipeMap();
        if (!isSteamPowered && uiProperties.progressBarTexture == null) {
            if (recipeMap != null) {
                throw new RuntimeException("Missing progressbar texture for " + recipeMap.unlocalizedName);
            }
            return;
        }
        if (isSteamPowered && uiProperties.progressBarTextureSteam == null) {
            if (recipeMap != null) {
                throw new RuntimeException("Missing steam progressbar texture for " + recipeMap.unlocalizedName);
            }
            return;
        }
        builder.widget(this.setNEITransferRect(new ProgressBar().setProgress(() -> Float.valueOf(this.maxProgresstime() != 0 ? (float)this.getProgresstime() / (float)this.maxProgresstime() : 0.0f)).setTexture(isSteamPowered ? uiProperties.progressBarTextureSteam.get(this.getSteamVariant()) : uiProperties.progressBarTexture.get(), uiProperties.progressBarImageSize).setDirection(uiProperties.progressBarDirection).setPos(uiProperties.progressBarPos).setSize(uiProperties.progressBarSize), uiProperties.neiTransferRectId));
        this.addProgressBarSpecialTextures(builder, uiProperties);
    }

    protected SlotWidget createItemInputSlot(int index, IDrawable[] backgrounds, Pos2d pos) {
        return (SlotWidget)new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, this.getInputSlot() + index).setAccess(true, true).setBackground(backgrounds).setPos(pos);
    }

    protected SlotWidget createItemOutputSlot(int index, IDrawable[] backgrounds, Pos2d pos) {
        return (SlotWidget)new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, this.getOutputSlot() + index).setAccess(true, false).setBackground(backgrounds).setPos(pos);
    }

    protected SlotWidget createSpecialSlot(IDrawable[] backgrounds, Pos2d pos, BasicUIProperties uiProperties) {
        return (SlotWidget)new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, this.getSpecialSlotIndex()).setAccess(true, true).disableShiftInsert().setGTTooltip(() -> this.mTooltipCache.getData(uiProperties.useSpecialSlot ? "GT5U.machines.special_slot.tooltip" : "GT5U.machines.unused_slot.tooltip", new Object[0])).setTooltipShowUpDelay(5).setBackground(backgrounds).setPos(pos);
    }

    protected FluidSlotWidget createFluidInputSlot(IDrawable[] backgrounds, Pos2d pos) {
        return (FluidSlotWidget)new FluidSlotWidget((IFluidTank)this.fluidTank).setBackground(backgrounds).setPos(pos);
    }

    protected FluidSlotWidget createFluidOutputSlot(IDrawable[] backgrounds, Pos2d pos) {
        return (FluidSlotWidget)new FluidSlotWidget((IFluidTank)this.fluidOutputTank).setInteraction(true, false).setBackground(backgrounds).setPos(pos);
    }

    @Override
    protected SlotWidget createChargerSlot(int x, int y) {
        if (this.isSteampowered()) {
            return (SlotWidget)this.createChargerSlot(x, y, "GT5U.machines.unused_slot.tooltip", new String[0]).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot()});
        }
        return super.createChargerSlot(x, y);
    }

    protected CycleButtonWidget createItemAutoOutputButton() {
        return (CycleButtonWidget)new CycleButtonWidget().setToggle(() -> this.mItemTransfer, val -> {
            this.mItemTransfer = val;
        }).setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_AUTOOUTPUT_ITEM).setVariableBackground(new UITexture[]{GT_UITextures.BUTTON_STANDARD_TOGGLE}).setGTTooltip(() -> this.mTooltipCache.getData("GT5U.machines.item_transfer.tooltip", new Object[0])).setTooltipShowUpDelay(5).setPos(25, 62).setSize(18, 18);
    }

    protected CycleButtonWidget createFluidAutoOutputButton() {
        return (CycleButtonWidget)new CycleButtonWidget().setToggle(() -> this.mFluidTransfer, val -> {
            this.mFluidTransfer = val;
        }).setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_AUTOOUTPUT_FLUID).setVariableBackground(new UITexture[]{GT_UITextures.BUTTON_STANDARD_TOGGLE}).setGTTooltip(() -> this.mTooltipCache.getData("GT5U.machines.fluid_transfer.tooltip", new Object[0])).setTooltipShowUpDelay(5).setPos(7, 62).setSize(18, 18);
    }

    protected Widget setNEITransferRect(Widget widget, String transferRectID) {
        if (GT_Utility.isStringInvalid(transferRectID)) {
            return widget;
        }
        String transferRectTooltip = this.isSteampowered() ? StatCollector.func_74837_a((String)"GT5U.machines.nei_transfer.steam.tooltip", (Object[])new Object[]{this.overclockDescriber.getTierString()}) : StatCollector.func_74837_a((String)"GT5U.machines.nei_transfer.voltage.tooltip", (Object[])new Object[]{this.overclockDescriber.getTierString()});
        widget.setNEITransferRect(transferRectID, new Object[]{this.overclockDescriber}, transferRectTooltip);
        return widget;
    }

    protected void addProgressBarSpecialTextures(ModularWindow.Builder builder, BasicUIProperties uiProperties) {
        if (this.isSteampowered()) {
            for (Pair<SteamTexture, Pair<Size, Pos2d>> specialTexture : uiProperties.specialTexturesSteam) {
                builder.widget(new DrawableWidget().setDrawable((IDrawable)((SteamTexture)specialTexture.getLeft()).get(this.getSteamVariant())).setSize((Size)((Pair)specialTexture.getRight()).getLeft()).setPos((Pos2d)((Pair)specialTexture.getRight()).getRight()));
            }
        } else {
            for (Pair<IDrawable, Pair<Size, Pos2d>> specialTexture : uiProperties.specialTextures) {
                builder.widget(new DrawableWidget().setDrawable((IDrawable)specialTexture.getLeft()).setSize((Size)((Pair)specialTexture.getRight()).getLeft()).setPos((Pos2d)((Pair)specialTexture.getRight()).getRight()));
            }
        }
    }

    protected DrawableWidget createErrorStatusArea(ModularWindow.Builder builder, IDrawable picture) {
        return (DrawableWidget)new DrawableWidget().setDrawable(picture).setTooltipShowUpDelay(5).setEnabled(widget -> !widget.getTooltip().isEmpty()).dynamicTooltip(this::getErrorDescriptions).dynamicTooltipShift(this::getErrorDescriptionsShift).setPos(79, 44).setSize(18, 18).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(() -> this.mStuttering, val -> {
            this.mStuttering = val;
        }), (IWidgetBuilder)builder, (widget, val) -> widget.notifyTooltipChange()).attachSyncer((FakeSyncWidget)new FakeSyncWidget.IntegerSyncer(() -> this.getBaseMetaTileEntity().getErrorDisplayID(), val -> this.getBaseMetaTileEntity().setErrorDisplayID((int)val)), (IWidgetBuilder)builder, (widget, val) -> widget.notifyTooltipChange());
    }

    protected List<String> getErrorDescriptions() {
        GT_TooltipDataCache.TooltipData tooltip = this.getErrorTooltip();
        return tooltip != null ? tooltip.text : Collections.emptyList();
    }

    protected List<String> getErrorDescriptionsShift() {
        GT_TooltipDataCache.TooltipData tooltip = this.getErrorTooltip();
        return tooltip != null ? tooltip.shiftText : Collections.emptyList();
    }

    protected GT_TooltipDataCache.TooltipData getErrorTooltip() {
        if (this.isSteampowered() && (this.getBaseMetaTileEntity().getErrorDisplayID() & 0x40) != 0) {
            return this.mTooltipCache.getData("GT5U.machines.stalled_vent.tooltip", new Object[0]);
        }
        if (this.mStuttering) {
            return this.mTooltipCache.getData("GT5U.machines.stalled_stuttering.tooltip", StatCollector.func_74838_a((String)("GT5U.machines.powersource." + (this.isSteampowered() ? "steam" : "power"))));
        }
        return null;
    }

    protected static int getCapacityForTier(int tier) {
        int n;
        switch (tier) {
            case 0: {
                n = 8000;
                break;
            }
            case 1: {
                n = 16000;
                break;
            }
            case 2: {
                n = 32000;
                break;
            }
            case 3: {
                n = 64000;
                break;
            }
            case 4: {
                n = 128000;
                break;
            }
            default: {
                n = 256000;
            }
        }
        return n;
    }
}

