/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects;

import gregtech.api.util.GT_Utility;
import gregtech.api.util.item.ItemHolder;
import it.unimi.dsi.fastutil.Hash;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class GT_ItemStack
extends ItemHolder {
    public static final Hash.Strategy<ItemStack> ITEMSTACK_HASH_STRATEGY2 = new Hash.Strategy<ItemStack>(){

        public int hashCode(ItemStack o) {
            return o.func_77973_b().hashCode() * 38197 + Items.field_151008_G.getDamage(o);
        }

        public boolean equals(ItemStack a, ItemStack b) {
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            return a.func_77973_b() == b.func_77973_b() && Items.field_151008_G.getDamage(a) == Items.field_151008_G.getDamage(b);
        }
    };
    public final Item mItem;
    public final byte mStackSize;
    public final short mMetaData;

    public GT_ItemStack(Item aItem, long aStackSize, long aMetaData) {
        super(new ItemStack(aItem, 1, (int)aMetaData));
        this.mItem = aItem;
        this.mStackSize = (byte)aStackSize;
        this.mMetaData = (short)aMetaData;
    }

    public GT_ItemStack(ItemStack aStack) {
        this(aStack, false);
    }

    public GT_ItemStack(ItemStack aStack, boolean wildcard) {
        this(aStack == null ? null : aStack.func_77973_b(), aStack == null ? 0L : (long)aStack.field_77994_a, aStack == null ? 0L : (wildcard ? 32767L : (long)Items.field_151008_G.getDamage(aStack)));
    }

    public GT_ItemStack(int aHashCode) {
        this(GT_Utility.intToStack(aHashCode));
    }

    public final ItemStack toStack() {
        if (this.mItem == null) {
            return null;
        }
        return new ItemStack(this.mItem, 1, (int)this.mMetaData);
    }

    public final boolean isStackEqual(ItemStack aStack) {
        return GT_Utility.areStacksEqual(this.toStack(), aStack);
    }

    public final boolean isStackEqual(GT_ItemStack aStack) {
        return GT_Utility.areStacksEqual(this.toStack(), aStack.toStack());
    }

    @Override
    public boolean equals(Object aStack) {
        if (aStack == this) {
            return true;
        }
        if (aStack instanceof GT_ItemStack) {
            return ((GT_ItemStack)aStack).mItem == this.mItem && ((GT_ItemStack)aStack).mMetaData == this.mMetaData;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return GT_Utility.stackToInt(this.toStack());
    }

    public static ItemStack internalCopyStack(ItemStack aStack) {
        return GT_ItemStack.internalCopyStack(aStack, false);
    }

    public static ItemStack internalCopyStack(ItemStack aStack, boolean wildcard) {
        return new ItemStack(aStack.func_77973_b(), 1, wildcard ? Short.MAX_VALUE : Items.field_151008_G.getDamage(aStack));
    }
}

