/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.enums.GT_Values;
import gregtech.api.util.GT_Recipe;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class GT_OverclockCalculator {
    private static final double LOG2 = Math.log(2.0);
    private long recipeVoltage = 0L;
    private long recipeAmperage = 1L;
    private long machineVoltage = 0L;
    private long machineAmperage = 1L;
    private int duration = 0;
    private int parallel = 1;
    private int recipeHeat = 0;
    private int machineHeat = 0;
    private double durationDecreasePerHeatOC = 4.0;
    private boolean heatOC;
    private boolean heatDiscount;
    private double heatDiscountExponent = 0.95;
    private double eutDiscount = 1.0;
    private double speedBoost = 1.0;
    private double eutIncreasePerOC = 4.0;
    private double durationDecreasePerOC = 2.0;
    private boolean oneTickDiscount;
    private boolean laserOC;
    private double laserOCPenalty = 0.3;
    private boolean amperageOC;
    private boolean limitOverclocks;
    private int maxOverclocks;
    private int overclockCount;
    private int heatOverclockCount;
    private Supplier<Double> durationUnderOneTickSupplier;
    private boolean noOverclock;
    private boolean calculated;
    private static final int HEAT_DISCOUNT_THRESHOLD = 900;
    private static final int HEAT_PERFECT_OVERCLOCK_THRESHOLD = 1800;

    public static GT_OverclockCalculator ofNoOverclock(@Nonnull GT_Recipe recipe) {
        return GT_OverclockCalculator.ofNoOverclock(recipe.mEUt, recipe.mDuration);
    }

    public static GT_OverclockCalculator ofNoOverclock(long eut, int duration) {
        return new GT_OverclockCalculator().setRecipeEUt(eut).setDuration(duration).setEUt(eut).setNoOverclock(true);
    }

    @Nonnull
    public GT_OverclockCalculator setRecipeEUt(long recipeEUt) {
        this.recipeVoltage = recipeEUt;
        return this;
    }

    @Nonnull
    public GT_OverclockCalculator setEUt(long machineVoltage) {
        this.machineVoltage = machineVoltage;
        return this;
    }

    @Nonnull
    public GT_OverclockCalculator setDuration(int duration) {
        this.duration = duration;
        return this;
    }

    @Nonnull
    public GT_OverclockCalculator setAmperage(long machineAmperage) {
        this.machineAmperage = machineAmperage;
        return this;
    }

    @Nonnull
    public GT_OverclockCalculator setRecipeAmperage(long recipeAmperage) {
        this.recipeAmperage = recipeAmperage;
        return this;
    }

    @Nonnull
    public GT_OverclockCalculator enablePerfectOC() {
        this.durationDecreasePerOC = 4.0;
        return this;
    }

    @Nonnull
    public GT_OverclockCalculator setHeatOC(boolean heatOC) {
        this.heatOC = heatOC;
        return this;
    }

    @Nonnull
    public GT_OverclockCalculator setHeatDiscount(boolean heatDiscount) {
        this.heatDiscount = heatDiscount;
        return this;
    }

    @Nonnull
    public GT_OverclockCalculator setRecipeHeat(int recipeHeat) {
        this.recipeHeat = recipeHeat;
        return this;
    }

    @Nonnull
    public GT_OverclockCalculator setMachineHeat(int machineHeat) {
        this.machineHeat = machineHeat;
        return this;
    }

    @Nonnull
    public GT_OverclockCalculator setEUtDiscount(float aEUtDiscount) {
        this.eutDiscount = aEUtDiscount;
        return this;
    }

    @Nonnull
    public GT_OverclockCalculator setSpeedBoost(float aSpeedBoost) {
        this.speedBoost = aSpeedBoost;
        return this;
    }

    @Nonnull
    public GT_OverclockCalculator setParallel(int aParallel) {
        this.parallel = aParallel;
        return this;
    }

    @Nonnull
    public GT_OverclockCalculator setHeatDiscountMultiplier(float heatDiscountExponent) {
        this.heatDiscountExponent = heatDiscountExponent;
        return this;
    }

    @Deprecated
    @Nonnull
    public GT_OverclockCalculator setHeatPerfectOC(int heatPerfectOC) {
        return this.setHeatPerfectOC(Math.pow(2.0, heatPerfectOC));
    }

    @Nonnull
    public GT_OverclockCalculator setHeatPerfectOC(double heatPerfectOC) {
        if (heatPerfectOC <= 0.0) {
            throw new IllegalArgumentException("Heat OC can't be a negative number or zero");
        }
        this.durationDecreasePerHeatOC = heatPerfectOC;
        return this;
    }

    @Deprecated
    @Nonnull
    public GT_OverclockCalculator setEUtIncreasePerOC(int eutIncreasePerOC) {
        return this.setEUtIncreasePerOC(Math.pow(2.0, eutIncreasePerOC));
    }

    @Nonnull
    public GT_OverclockCalculator setEUtIncreasePerOC(double eutIncreasePerOC) {
        if (eutIncreasePerOC <= 0.0) {
            throw new IllegalArgumentException("EUt increase can't be a negative number or zero");
        }
        this.eutIncreasePerOC = eutIncreasePerOC;
        return this;
    }

    @Deprecated
    @Nonnull
    public GT_OverclockCalculator setDurationDecreasePerOC(int durationDecreasePerOC) {
        return this.setDurationDecreasePerOC(Math.pow(2.0, durationDecreasePerOC));
    }

    @Nonnull
    public GT_OverclockCalculator setDurationDecreasePerOC(double durationDecreasePerOC) {
        if (durationDecreasePerOC <= 0.0) {
            throw new IllegalArgumentException("Duration decrease can't be a negative number or zero");
        }
        this.durationDecreasePerOC = durationDecreasePerOC;
        return this;
    }

    @Nonnull
    public GT_OverclockCalculator setOneTickDiscount(boolean oneTickDiscount) {
        this.oneTickDiscount = oneTickDiscount;
        return this;
    }

    @Nonnull
    public GT_OverclockCalculator limitOverclockCount(int maxOverclocks) {
        this.limitOverclocks = true;
        this.maxOverclocks = maxOverclocks;
        return this;
    }

    @Nonnull
    public GT_OverclockCalculator setLaserOC(boolean laserOC) {
        this.laserOC = laserOC;
        return this;
    }

    @Nonnull
    public GT_OverclockCalculator setAmperageOC(boolean amperageOC) {
        this.amperageOC = amperageOC;
        return this;
    }

    @Nonnull
    public GT_OverclockCalculator setLaserOCPenalty(double laserOCPenalty) {
        this.laserOCPenalty = laserOCPenalty;
        return this;
    }

    @Nonnull
    public GT_OverclockCalculator setDurationUnderOneTickSupplier(Supplier<Double> supplier) {
        this.durationUnderOneTickSupplier = supplier;
        return this;
    }

    @Nonnull
    public GT_OverclockCalculator setNoOverclock(boolean noOverclock) {
        this.noOverclock = noOverclock;
        return this;
    }

    @Nonnull
    public GT_OverclockCalculator calculate() {
        if (this.calculated) {
            throw new IllegalStateException("Tried to calculate overclocks twice");
        }
        this.calculateOverclock();
        this.calculated = true;
        return this;
    }

    private void calculateOverclock() {
        this.duration = (int)Math.ceil((double)this.duration * this.speedBoost);
        if (this.noOverclock) {
            this.recipeVoltage = this.calculateFinalRecipeEUt(this.calculateHeatDiscountMultiplier());
            return;
        }
        if (this.laserOC && this.amperageOC) {
            throw new IllegalStateException("Tried to calculate overclock with both laser and amperage overclocking");
        }
        double heatDiscountMultiplier = this.calculateHeatDiscountMultiplier();
        if (this.heatOC) {
            this.heatOverclockCount = this.calculateAmountOfHeatOverclocks();
        }
        double recipePowerTier = this.calculateRecipePowerTier(heatDiscountMultiplier);
        double machinePowerTier = this.calculateMachinePowerTier();
        this.overclockCount = this.calculateAmountOfNeededOverclocks(machinePowerTier, recipePowerTier);
        if (!this.amperageOC) {
            this.overclockCount = Math.min(this.overclockCount, this.calculateRecipeToMachineVoltageDifference());
        }
        this.overclockCount = Math.max(this.overclockCount, 0);
        this.overclockCount = this.limitOverclocks ? Math.min(this.maxOverclocks, this.overclockCount) : this.overclockCount;
        this.heatOverclockCount = Math.min(this.heatOverclockCount, this.overclockCount);
        this.recipeVoltage = (long)Math.floor((double)this.recipeVoltage * Math.pow(this.eutIncreasePerOC, this.overclockCount));
        this.duration = (int)Math.floor((double)this.duration / Math.pow(this.durationDecreasePerOC, this.overclockCount - this.heatOverclockCount));
        this.duration = (int)Math.floor((double)this.duration / Math.pow(this.durationDecreasePerHeatOC, this.heatOverclockCount));
        if (this.oneTickDiscount) {
            this.recipeVoltage = (long)Math.floor((double)this.recipeVoltage / Math.pow(this.durationDecreasePerOC, (int)(machinePowerTier - recipePowerTier - (double)this.overclockCount)));
            if (this.recipeVoltage < 1L) {
                this.recipeVoltage = 1L;
            }
        }
        if (this.laserOC) {
            this.calculateLaserOC();
        }
        if (this.duration < 1) {
            this.duration = 1;
        }
        this.recipeVoltage = this.calculateFinalRecipeEUt(heatDiscountMultiplier);
    }

    private double calculateRecipePowerTier(double heatDiscountMultiplier) {
        return this.calculatePowerTier((double)(this.recipeVoltage * (long)this.parallel) * this.eutDiscount * heatDiscountMultiplier * (double)this.recipeAmperage);
    }

    private double calculateMachinePowerTier() {
        return this.calculatePowerTier(this.machineVoltage * (this.amperageOC ? this.machineAmperage : Math.min(this.machineAmperage, (long)this.parallel)));
    }

    private int calculateRecipeToMachineVoltageDifference() {
        return (int)(Math.ceil(this.calculatePowerTier(this.machineVoltage)) - Math.ceil(this.calculatePowerTier(this.recipeVoltage)));
    }

    private double calculatePowerTier(double voltage) {
        return 1.0 + Math.max(0.0, Math.log(voltage) / LOG2 - 5.0) / 2.0;
    }

    private long calculateFinalRecipeEUt(double heatDiscountMultiplier) {
        return (long)Math.ceil((double)this.recipeVoltage * this.eutDiscount * heatDiscountMultiplier * (double)this.parallel * (double)this.recipeAmperage);
    }

    private int calculateAmountOfHeatOverclocks() {
        return Math.min((this.machineHeat - this.recipeHeat) / 1800, this.calculateAmountOfOverclocks(this.calculateMachinePowerTier(), this.calculateRecipePowerTier(this.calculateHeatDiscountMultiplier())));
    }

    private int calculateAmountOfOverclocks(double machinePowerTier, double recipePowerTier) {
        return (int)(machinePowerTier - recipePowerTier);
    }

    private int calculateAmountOfNeededOverclocks(double machinePowerTier, double recipePowerTier) {
        return (int)Math.min((double)this.calculateAmountOfOverclocks(machinePowerTier, recipePowerTier), Math.ceil(Math.log(this.duration) / Math.log(this.durationDecreasePerOC)));
    }

    private double calculateHeatDiscountMultiplier() {
        int heatDiscounts = this.heatDiscount ? (this.machineHeat - this.recipeHeat) / 900 : 0;
        return Math.pow(this.heatDiscountExponent, heatDiscounts);
    }

    private void calculateLaserOC() {
        long inputEut = this.machineVoltage * this.machineAmperage;
        double currentPenalty = this.eutIncreasePerOC + this.laserOCPenalty;
        while ((double)inputEut > (double)this.recipeVoltage * currentPenalty && (double)this.recipeVoltage * currentPenalty > 0.0 && this.duration > 1) {
            this.duration = (int)((double)this.duration / this.durationDecreasePerOC);
            this.recipeVoltage = (long)((double)this.recipeVoltage * currentPenalty);
            currentPenalty += this.laserOCPenalty;
        }
    }

    public long getConsumption() {
        if (!this.calculated) {
            throw new IllegalStateException("Tried to get consumption before calculating");
        }
        return this.recipeVoltage;
    }

    public int getDuration() {
        if (!this.calculated) {
            throw new IllegalStateException("Tried to get duration before calculating");
        }
        return this.duration;
    }

    public int getPerformedOverclocks() {
        if (!this.calculated) {
            throw new IllegalStateException("Tried to get performed overclocks before calculating");
        }
        return this.overclockCount;
    }

    public double calculateDurationUnderOneTick() {
        if (this.durationUnderOneTickSupplier != null) {
            return this.durationUnderOneTickSupplier.get();
        }
        if (this.noOverclock) {
            return this.duration;
        }
        int normalOverclocks = this.calculateAmountOfOverclocks(this.calculateMachinePowerTier(), this.calculateRecipePowerTier(this.calculateHeatDiscountMultiplier()));
        normalOverclocks = this.limitOverclocks ? Math.min(normalOverclocks, this.maxOverclocks) : normalOverclocks;
        int heatOverclocks = Math.min(this.calculateAmountOfHeatOverclocks(), normalOverclocks);
        return (double)this.duration * this.speedBoost / (Math.pow(this.durationDecreasePerOC, normalOverclocks - heatOverclocks) * Math.pow(this.durationDecreasePerHeatOC, heatOverclocks));
    }

    public long calculateEUtConsumptionUnderOneTick(int originalMaxParallel, int currentParallel) {
        if (this.noOverclock) {
            return this.recipeVoltage;
        }
        double heatDiscountMultiplier = this.calculateHeatDiscountMultiplier();
        double parallelMultiplierFromOverclocks = (double)currentParallel / (double)originalMaxParallel;
        double amountOfParallelHeatOverclocks = Math.min(Math.log(parallelMultiplierFromOverclocks) / Math.log(this.durationDecreasePerHeatOC), (double)this.calculateAmountOfHeatOverclocks());
        double amountOfParallelOverclocks = Math.log(parallelMultiplierFromOverclocks) / Math.log(this.durationDecreasePerOC) - amountOfParallelHeatOverclocks * (this.durationDecreasePerHeatOC - this.durationDecreasePerOC);
        double machineTier = this.calculateMachinePowerTier();
        double recipeTier = this.calculateRecipePowerTier(heatDiscountMultiplier);
        double amountOfTotalOverclocks = this.calculateAmountOfOverclocks(machineTier, recipeTier);
        if (this.recipeVoltage <= GT_Values.V[0]) {
            amountOfTotalOverclocks = Math.min(amountOfTotalOverclocks, (double)this.calculateRecipeToMachineVoltageDifference());
        }
        amountOfTotalOverclocks = this.limitOverclocks ? Math.min(amountOfTotalOverclocks, (double)this.maxOverclocks) : amountOfTotalOverclocks;
        return (long)Math.ceil((double)this.recipeVoltage * Math.pow(this.eutIncreasePerOC, amountOfParallelOverclocks + amountOfParallelHeatOverclocks) * Math.pow(this.eutIncreasePerOC, amountOfTotalOverclocks - (amountOfParallelOverclocks + amountOfParallelHeatOverclocks)) * (double)originalMaxParallel * this.eutDiscount * (double)this.recipeAmperage * heatDiscountMultiplier);
    }
}

