/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.world;

import gregtech.api.GregTech_API;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public abstract class GT_Worldgen {
    public final String mWorldGenName;
    public final boolean mEnabled;
    private final Map<String, Boolean> mDimensionMap = new ConcurrentHashMap<String, Boolean>();

    public GT_Worldgen(String aName, List aList, boolean aDefault) {
        this.mWorldGenName = aName;
        this.mEnabled = GregTech_API.sWorldgenFile.get((Object)"worldgen", this.mWorldGenName, aDefault);
        if (this.mEnabled) {
            aList.add(this);
        }
    }

    public boolean executeWorldgen(World aWorld, Random aRandom, String aBiome, int aDimensionType, int aChunkX, int aChunkZ, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider) {
        return false;
    }

    public int executeWorldgenChunkified(World aWorld, Random aRandom, String aBiome, int aDimensionType, int aChunkX, int aChunkZ, int seedX, int seedZ, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider) {
        return 4;
    }

    public boolean executeCavegen(World aWorld, Random aRandom, String aBiome, int aDimensionType, int aChunkX, int aChunkZ, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider) {
        return false;
    }

    public boolean isGenerationAllowed(World aWorld, int aDimensionType, int aAllowedDimensionType) {
        return this.isGenerationAllowed(aWorld.field_73011_w.func_80007_l(), aDimensionType, aAllowedDimensionType);
    }

    public boolean isGenerationAllowed(String aDimName, int aDimensionType, int aAllowedDimensionType) {
        if (!(aDimName.equalsIgnoreCase("Overworld") || aDimName.equalsIgnoreCase("Nether") || aDimName.equalsIgnoreCase("The End") || aDimName.equalsIgnoreCase("Twilight Forest") || aDimName.equalsIgnoreCase("Underdark"))) {
            return false;
        }
        Boolean tAllowed = this.mDimensionMap.get(aDimName);
        if (tAllowed == null) {
            boolean tValue = GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), aDimName, aDimensionType == aAllowedDimensionType);
            this.mDimensionMap.put(aDimName, tValue);
            return tValue;
        }
        return tAllowed;
    }
}

