/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.net.GT_Packet_SendOregenPattern;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GT_Log;
import gregtech.api.world.GT_Worldgen;
import gregtech.common.GT_Worldgen_GT_Ore_Layer;
import gregtech.common.blocks.GT_TileEntity_Ores;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.event.world.WorldEvent;

public class GT_Worldgenerator
implements IWorldGenerator {
    private static int mEndAsteroidProbability = 300;
    private static int mSize = 100;
    private static int endMinSize = 50;
    private static int endMaxSize = 200;
    private static boolean endAsteroids = true;
    public static List<Runnable> mList = new ArrayList<Runnable>();
    public static HashSet<Long> ProcChunks = new HashSet();
    public static GT_Worldgen_GT_Ore_Layer noOresInVein = new GT_Worldgen_GT_Ore_Layer("NoOresInVein", false, 0, 255, 0, 255, 16, false, false, false, Materials.Aluminium, Materials.Aluminium, Materials.Aluminium, Materials.Aluminium);
    public static Hashtable<Long, GT_Worldgen_GT_Ore_Layer> validOreveins = new Hashtable(1024);
    public boolean mIsGenerating = false;
    public static final Object listLock = new Object();
    public static OregenPattern oregenPattern = OregenPattern.AXISSYMMETRICAL;

    public GT_Worldgenerator() {
        endAsteroids = GregTech_API.sWorldgenFile.get((Object)"endasteroids", "GenerateAsteroids", true);
        endMinSize = GregTech_API.sWorldgenFile.get((Object)"endasteroids", "AsteroidMinSize", 50);
        endMaxSize = GregTech_API.sWorldgenFile.get((Object)"endasteroids", "AsteroidMaxSize", 200);
        mEndAsteroidProbability = GregTech_API.sWorldgenFile.get((Object)"endasteroids", "AsteroidProbability", 300);
        GameRegistry.registerWorldGenerator((IWorldGenerator)this, (int)0x3FFFFFFF);
        if (GT_Values.debugWorldGen) {
            GT_Log.out.println("GT_Worldgenerator created");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(Random aRandom, int aX, int aZ, World aWorld, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider) {
        Object object = listLock;
        synchronized (object) {
            mList.add(new WorldGenContainer(new XSTR(Math.abs(aRandom.nextInt()) + 1), aX, aZ, aWorld.field_73011_w.field_76574_g, aWorld, aChunkGenerator, aChunkProvider, aWorld.func_72807_a((int)(aX * 16 + 8), (int)(aZ * 16 + 8)).field_76791_y));
            if (GT_Values.debugWorldGen) {
                GT_Log.out.println("ADD WorldSeed:" + aWorld.func_72905_C() + " DimId" + aWorld.field_73011_w.field_76574_g + " chunk x:" + aX + " z:" + aZ + " SIZE: " + mList.size());
            }
        }
        if (!this.mIsGenerating) {
            this.mIsGenerating = true;
            int mList_sS = mList.size();
            mList_sS = Math.min(mList_sS, 5);
            for (int i = 0; i < mList_sS; ++i) {
                WorldGenContainer toRun = (WorldGenContainer)mList.get(0);
                if (GT_Values.debugWorldGen) {
                    GT_Log.out.println("RUN WorldSeed:" + aWorld.func_72905_C() + " DimId" + aWorld.field_73011_w.field_76574_g + " chunk x:" + toRun.mX + " z:" + toRun.mZ + " SIZE: " + mList.size() + " i: " + i);
                }
                Object object2 = listLock;
                synchronized (object2) {
                    mList.remove(0);
                }
                toRun.run();
            }
            this.mIsGenerating = false;
        }
    }

    public static boolean isOreChunk(int chunkX, int chunkZ) {
        if (oregenPattern == OregenPattern.EQUAL_SPACING) {
            return Math.floorMod(chunkX, 3) == 1 && Math.floorMod(chunkZ, 3) == 1;
        }
        return Math.abs(chunkX) % 3 == 1 && Math.abs(chunkZ) % 3 == 1;
    }

    public static class WorldGenContainer
    implements Runnable {
        public final Random mRandom;
        public final int mX;
        public final int mZ;
        public final int mDimensionType;
        public final World mWorld;
        public final IChunkProvider mChunkGenerator;
        public final IChunkProvider mChunkProvider;
        public final String mBiome;
        public static ArrayList<NearbySeeds> seedList = new ArrayList();

        public WorldGenContainer(Random aRandom, int aX, int aZ, int aDimensionType, World aWorld, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider, String aBiome) {
            this.mRandom = aRandom;
            this.mX = aX;
            this.mZ = aZ;
            this.mDimensionType = aDimensionType;
            this.mWorld = aWorld;
            this.mChunkGenerator = aChunkGenerator;
            this.mChunkProvider = aChunkProvider;
            this.mBiome = aBiome;
        }

        public void worldGenFindVein(int oreseedX, int oreseedZ) {
            long oreveinSeed = this.mWorld.func_72905_C() << 16 ^ (((long)this.mWorld.field_73011_w.field_76574_g & 0xFFL) << 56 | ((long)oreseedX & 0xFFFFFFFL) << 28 | (long)oreseedZ & 0xFFFFFFFL);
            XSTR oreveinRNG = new XSTR(oreveinSeed);
            int oreveinPercentageRoll = oreveinRNG.nextInt(100);
            boolean noOrePlacedCount = false;
            String tDimensionName = "";
            if (GT_Values.debugOrevein) {
                tDimensionName = this.mWorld.field_73011_w.func_80007_l();
            }
            if (GT_Values.debugOrevein) {
                GT_Log.out.println(" Finding oreveins for oreveinSeed=" + oreveinSeed + " mX=" + this.mX + " mZ=" + this.mZ + " oreseedX=" + oreseedX + " oreseedZ=" + oreseedZ + " worldSeed=" + this.mWorld.func_72905_C());
            }
            if (!validOreveins.containsKey(oreveinSeed)) {
                if (oreveinPercentageRoll < GT_Values.oreveinPercentage && GT_Worldgen_GT_Ore_Layer.sWeight > 0 && GT_Worldgen_GT_Ore_Layer.sList.size() > 0) {
                    int i;
                    int placementAttempts = 0;
                    boolean oreveinFound = false;
                    block12: for (i = 0; i < GT_Values.oreveinAttempts && !oreveinFound && placementAttempts < GT_Values.oreveinMaxPlacementAttempts; ++i) {
                        int tRandomWeight = oreveinRNG.nextInt(GT_Worldgen_GT_Ore_Layer.sWeight);
                        for (GT_Worldgen_GT_Ore_Layer tWorldGen : GT_Worldgen_GT_Ore_Layer.sList) {
                            if ((tRandomWeight -= tWorldGen.mWeight) > 0) continue;
                            try {
                                int placementResult = tWorldGen.executeWorldgenChunkified(this.mWorld, new XSTR(oreveinSeed ^ (long)tWorldGen.mPrimaryMeta), this.mBiome, this.mDimensionType, this.mX * 16, this.mZ * 16, oreseedX * 16, oreseedZ * 16, this.mChunkGenerator, this.mChunkProvider);
                                switch (placementResult) {
                                    case 4: {
                                        if (GT_Values.debugOrevein) {
                                            GT_Log.out.println(" Added near oreveinSeed=" + oreveinSeed + " " + tWorldGen.mWorldGenName + " tries at oremix=" + i + " placementAttempts=" + placementAttempts + " dimensionName=" + tDimensionName);
                                        }
                                        validOreveins.put(oreveinSeed, tWorldGen);
                                        oreveinFound = true;
                                        break;
                                    }
                                    case 2: {
                                        ++placementAttempts;
                                        break;
                                    }
                                    case 3: {
                                        if (GT_Values.debugOrevein) {
                                            GT_Log.out.println(" Added far oreveinSeed=" + oreveinSeed + " " + tWorldGen.mWorldGenName + " tries at oremix=" + i + " placementAttempts=" + placementAttempts + " dimensionName=" + tDimensionName);
                                        }
                                        validOreveins.put(oreveinSeed, tWorldGen);
                                        oreveinFound = true;
                                        break;
                                    }
                                    case 5: {
                                        if (GT_Values.debugOrevein) {
                                            GT_Log.out.println(" No overlap and air block in test spot=" + oreveinSeed + " " + tWorldGen.mWorldGenName + " tries at oremix=" + i + " placementAttempts=" + placementAttempts + " dimensionName=" + tDimensionName);
                                        }
                                        ++placementAttempts;
                                    }
                                }
                                continue block12;
                            }
                            catch (Throwable e) {
                                if (GT_Values.debugOrevein) {
                                    GT_Log.out.println("Exception occurred on oreVein" + tWorldGen + " oreveinSeed=" + oreveinSeed + " mX=" + this.mX + " mZ=" + this.mZ + " oreseedX=" + oreseedX + " oreseedZ=" + oreseedZ);
                                }
                                e.printStackTrace(GT_Log.err);
                            }
                        }
                    }
                    if (!oreveinFound && this.mX == oreseedX && this.mZ == oreseedZ) {
                        if (GT_Values.debugOrevein) {
                            GT_Log.out.println(" Empty oreveinSeed=" + oreveinSeed + " mX=" + this.mX + " mZ=" + this.mZ + " oreseedX=" + oreseedX + " oreseedZ=" + oreseedZ + " tries at oremix=" + i + " placementAttempts=" + placementAttempts + " dimensionName=" + tDimensionName);
                        }
                        validOreveins.put(oreveinSeed, noOresInVein);
                    }
                } else if (oreveinPercentageRoll >= GT_Values.oreveinPercentage) {
                    if (GT_Values.debugOrevein) {
                        GT_Log.out.println(" Skipped oreveinSeed=" + oreveinSeed + " mX=" + this.mX + " mZ=" + this.mZ + " oreseedX=" + oreseedX + " oreseedZ=" + oreseedZ + " RNG=" + oreveinPercentageRoll + " %=" + GT_Values.oreveinPercentage + " dimensionName=" + tDimensionName);
                    }
                    validOreveins.put(oreveinSeed, noOresInVein);
                }
            } else {
                if (GT_Values.debugOrevein) {
                    GT_Log.out.print(" Valid oreveinSeed=" + oreveinSeed + " validOreveins.size()=" + validOreveins.size() + " ");
                }
                GT_Worldgen_GT_Ore_Layer tWorldGen = validOreveins.get(oreveinSeed);
                oreveinRNG.setSeed(oreveinSeed ^ (long)tWorldGen.mPrimaryMeta);
                int placementResult = tWorldGen.executeWorldgenChunkified(this.mWorld, oreveinRNG, this.mBiome, this.mDimensionType, this.mX * 16, this.mZ * 16, oreseedX * 16, oreseedZ * 16, this.mChunkGenerator, this.mChunkProvider);
                switch (placementResult) {
                    case 2: {
                        if (!GT_Values.debugOrevein) break;
                        GT_Log.out.println(" No ore in bottom layer");
                        break;
                    }
                    case 3: {
                        if (!GT_Values.debugOrevein) break;
                        GT_Log.out.println(" No overlap");
                    }
                }
            }
        }

        @Override
        public void run() {
            long startTime = System.nanoTime();
            Chunk tChunk = this.mWorld.func_72964_e(this.mX, this.mZ);
            try {
                for (GT_Worldgen tWorldGen : GregTech_API.sWorldgenList) {
                    tWorldGen.executeWorldgen(this.mWorld, this.mRandom, this.mBiome, this.mDimensionType, this.mX * 16, this.mZ * 16, this.mChunkGenerator, this.mChunkProvider);
                }
            }
            catch (Throwable e) {
                e.printStackTrace(GT_Log.err);
            }
            long leftOverTime = System.nanoTime();
            int oreveinMaxSize = this.mWorld.field_73011_w.func_80007_l().equals("Underdark") ? 32 : 32;
            int wXbox = this.mX - oreveinMaxSize / 16;
            int eXbox = this.mX + (oreveinMaxSize / 16 + 1);
            int nZbox = this.mZ - oreveinMaxSize / 16;
            int sZbox = this.mZ + (oreveinMaxSize / 16 + 1);
            for (int x = wXbox; x < eXbox; ++x) {
                for (int z = nZbox; z < sZbox; ++z) {
                    if (!GT_Worldgenerator.isOreChunk(x, z)) continue;
                    if (GT_Values.debugWorldGen) {
                        GT_Log.out.println("Adding seed x=" + x + " z=" + z);
                    }
                    seedList.add(new NearbySeeds(x, z));
                }
            }
            while (seedList.size() != 0) {
                if (GT_Values.debugWorldGen) {
                    GT_Log.out.println("Processing seed x=" + WorldGenContainer.seedList.get((int)0).mX + " z=" + WorldGenContainer.seedList.get((int)0).mZ);
                }
                this.worldGenFindVein(WorldGenContainer.seedList.get((int)0).mX, WorldGenContainer.seedList.get((int)0).mZ);
                seedList.remove(0);
            }
            long oregenTime = System.nanoTime();
            int tDimensionType = this.mWorld.field_73011_w.field_76574_g;
            if (tDimensionType == 1 && endAsteroids) {
                XSTR random = new XSTR(this.mWorld.func_72905_C() + (long)(this.mX * this.mX) * 91777L + (long)(this.mZ * this.mZ) * 137413L + (long)(this.mX * this.mZ) * 1853L + (long)this.mX * 3L + (long)this.mZ * 17L);
                if (mEndAsteroidProbability <= 1 || random.nextInt(mEndAsteroidProbability) == 0) {
                    this.generateAsteroid(this.mWorld, random, this.mX, this.mZ);
                }
            }
            if (tChunk != null) {
                tChunk.field_76643_l = true;
            }
            long endTime = System.nanoTime();
            long duration = endTime - startTime;
            if (GT_Values.debugWorldGen) {
                GT_Log.out.println(" Oregen took " + (oregenTime - leftOverTime) + " Leftover gen took " + (leftOverTime - startTime) + " Worldgen took " + duration + " nanoseconds");
            }
        }

        private void generateAsteroid(World world, Random random, int chunkX, int chunkZ) {
            short primaryMeta = 0;
            short secondaryMeta = 0;
            short betweenMeta = 0;
            short sporadicMeta = 0;
            if (GT_Worldgen_GT_Ore_Layer.sWeight > 0 && GT_Worldgen_GT_Ore_Layer.sList.size() > 0) {
                boolean temp = true;
                block2: for (int i = 0; i < GT_Values.oreveinAttempts && temp; ++i) {
                    int tRandomWeight = random.nextInt(GT_Worldgen_GT_Ore_Layer.sWeight);
                    for (GT_Worldgen_GT_Ore_Layer tWorldGen : GT_Worldgen_GT_Ore_Layer.sList) {
                        if ((tRandomWeight -= tWorldGen.mWeight) > 0) continue;
                        try {
                            if (!tWorldGen.mEndAsteroid) continue;
                            primaryMeta = tWorldGen.mPrimaryMeta;
                            secondaryMeta = tWorldGen.mSecondaryMeta;
                            betweenMeta = tWorldGen.mBetweenMeta;
                            sporadicMeta = tWorldGen.mSporadicMeta;
                            temp = false;
                            continue block2;
                        }
                        catch (Throwable e) {
                            e.printStackTrace(GT_Log.err);
                        }
                    }
                }
            }
            int tX = chunkX * 16 + random.nextInt(16);
            int tY = 50 + random.nextInt(150);
            int tZ = chunkZ * 16 + random.nextInt(16);
            mSize = endMinSize + random.nextInt(endMaxSize - endMinSize + 1);
            if (world.func_147439_a(tX, tY, tZ).isAir((IBlockAccess)world, tX, tY, tZ)) {
                float randomRadian = random.nextFloat() * (float)Math.PI;
                double xBase = (float)(tX + 8) + MathHelper.func_76126_a((float)randomRadian) * (float)mSize / 8.0f;
                double xFactor = (float)(tX + 8) - MathHelper.func_76126_a((float)randomRadian) * (float)mSize / 8.0f;
                double zBase = (float)(tZ + 8) + MathHelper.func_76134_b((float)randomRadian) * (float)mSize / 8.0f;
                double zFactor = (float)(tZ + 8) - MathHelper.func_76134_b((float)randomRadian) * (float)mSize / 8.0f;
                double yBase = tY + random.nextInt(3) - 2;
                double yFactor = tY + random.nextInt(3) - 2;
                for (int i = 0; i <= mSize; ++i) {
                    double xCenter = xBase + (xFactor - xBase) * (double)i / (double)mSize;
                    double yCenter = yBase + (yFactor - yBase) * (double)i / (double)mSize;
                    double zCenter = zBase + (zFactor - zBase) * (double)i / (double)mSize;
                    double randomDistance = random.nextDouble() * (double)mSize / 16.0;
                    double halfLength = (double)(MathHelper.func_76126_a((float)((float)i * (float)Math.PI / (float)mSize)) + 1.0f) * randomDistance + 1.0;
                    double halfHeight = (double)(MathHelper.func_76126_a((float)((float)i * (float)Math.PI / (float)mSize)) + 1.0f) * randomDistance + 1.0;
                    int tMinX = MathHelper.func_76128_c((double)(xCenter - halfLength / 2.0));
                    int tMinY = MathHelper.func_76128_c((double)(yCenter - halfHeight / 2.0));
                    int tMinZ = MathHelper.func_76128_c((double)(zCenter - halfLength / 2.0));
                    int tMaxX = MathHelper.func_76128_c((double)(xCenter + halfLength / 2.0));
                    int tMaxY = MathHelper.func_76128_c((double)(yCenter + halfHeight / 2.0));
                    int tMaxZ = MathHelper.func_76128_c((double)(zCenter + halfLength / 2.0));
                    for (int eX = tMinX; eX <= tMaxX; ++eX) {
                        double xChance = ((double)eX + 0.5 - xCenter) / (halfLength / 2.0);
                        if (!(xChance * xChance < 1.0)) continue;
                        for (int eY = tMinY; eY <= tMaxY; ++eY) {
                            double yChance = ((double)eY + 0.5 - yCenter) / (halfHeight / 2.0);
                            if (!(xChance * xChance + yChance * yChance < 1.0)) continue;
                            for (int eZ = tMinZ; eZ <= tMaxZ; ++eZ) {
                                double zChance = ((double)eZ + 0.5 - zCenter) / (halfLength / 2.0);
                                if (xChance * xChance + yChance * yChance + zChance * zChance >= 1.0 || !world.func_147439_a(tX, tY, tZ).isAir((IBlockAccess)world, tX, tY, tZ)) continue;
                                int ranOre = random.nextInt(50);
                                if (ranOre < 3) {
                                    GT_TileEntity_Ores.setOreBlock(world, eX, eY, eZ, primaryMeta, false);
                                    continue;
                                }
                                if (ranOre < 6) {
                                    GT_TileEntity_Ores.setOreBlock(world, eX, eY, eZ, secondaryMeta, false);
                                    continue;
                                }
                                if (ranOre < 8) {
                                    GT_TileEntity_Ores.setOreBlock(world, eX, eY, eZ, betweenMeta, false);
                                    continue;
                                }
                                if (ranOre < 10) {
                                    GT_TileEntity_Ores.setOreBlock(world, eX, eY, eZ, sporadicMeta, false);
                                    continue;
                                }
                                world.func_147465_d(eX, eY, eZ, Blocks.field_150377_bs, 0, 0);
                            }
                        }
                    }
                }
            }
        }

        static class NearbySeeds {
            public int mX;
            public int mZ;

            NearbySeeds(int x, int z) {
                this.mX = x;
                this.mZ = z;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof NearbySeeds)) {
                    return false;
                }
                NearbySeeds that = (NearbySeeds)o;
                if (this.mX != that.mX) {
                    return false;
                }
                return this.mZ == that.mZ;
            }

            public int hashCode() {
                int result = this.mX;
                result = 31 * result + this.mZ;
                return result;
            }
        }
    }

    public static enum OregenPattern {
        AXISSYMMETRICAL,
        EQUAL_SPACING;

    }

    public static class OregenPatternSavedData
    extends WorldSavedData {
        private static final String NAME = "GregTech_OregenPattern";
        private static final String KEY = "oregenPattern";

        public OregenPatternSavedData(String p_i2141_1_) {
            super(p_i2141_1_);
        }

        public static void loadData(World world) {
            oregenPattern = world.func_72912_H().func_82573_f() == 0L ? OregenPattern.values()[OregenPattern.values().length - 1] : OregenPattern.AXISSYMMETRICAL;
            WorldSavedData instance = world.field_72988_C.func_75742_a(OregenPatternSavedData.class, NAME);
            if (instance == null) {
                instance = new OregenPatternSavedData(NAME);
                world.field_72988_C.func_75745_a(NAME, instance);
            }
            instance.func_76185_a();
        }

        @SubscribeEvent
        public void onWorldLoad(WorldEvent.Load event) {
            World world = event.world;
            if (!world.field_72995_K && world.field_73011_w.field_76574_g == 0) {
                OregenPatternSavedData.loadData(world);
            }
        }

        @SubscribeEvent
        public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            EntityPlayer entityPlayer = event.player;
            if (entityPlayer instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)entityPlayer;
                GT_Values.NW.sendToPlayer(new GT_Packet_SendOregenPattern(oregenPattern), player);
            }
        }

        public void func_76184_a(NBTTagCompound p_76184_1_) {
            if (p_76184_1_.func_74764_b(KEY)) {
                int ordinal = p_76184_1_.func_74771_c(KEY);
                ordinal = MathHelper.func_76125_a((int)ordinal, (int)0, (int)(OregenPattern.values().length - 1));
                oregenPattern = OregenPattern.values()[ordinal];
            }
        }

        public void func_76187_b(NBTTagCompound p_76187_1_) {
            p_76187_1_.func_74774_a(KEY, (byte)oregenPattern.ordinal());
        }
    }
}

