/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render.items;

import com.mitchej123.hodgepodge.textures.IPatchedTextureAtlasSprite;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Mods;
import gregtech.api.enums.Textures;
import gregtech.api.items.GT_MetaGenerated_Item;
import gregtech.api.util.GT_Utility;
import gregtech.common.render.GT_RenderUtil;
import gregtech.loaders.ExtraIcons;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class GT_GeneratedItem_Renderer
implements IItemRenderer {
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON || type == IItemRenderer.ItemRenderType.INVENTORY || type == IItemRenderer.ItemRenderType.ENTITY;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type == IItemRenderer.ItemRenderType.ENTITY && helper == IItemRenderer.ItemRendererHelper.ENTITY_BOBBING || helper == IItemRenderer.ItemRendererHelper.ENTITY_ROTATION && Minecraft.func_71410_x().field_71474_y.field_74347_j;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack aStack, Object ... data) {
        long tCharge;
        Long[] tStats;
        short aMetaData = (short)aStack.func_77960_j();
        Item item = aStack.func_77973_b();
        if (!(item instanceof GT_MetaGenerated_Item)) {
            return;
        }
        GT_MetaGenerated_Item aItem = (GT_MetaGenerated_Item)item;
        GL11.glEnable((int)3042);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        IIcon tIcon = aItem.mIconList[aMetaData - aItem.mOffset].length > 1 ? ((tStats = aItem.mElectricStats.get(aMetaData)) != null && tStats[3] < 0L ? ((tCharge = aItem.getRealCharge(aStack)) <= 0L ? aItem.mIconList[aMetaData - aItem.mOffset][1] : (tCharge >= tStats[0] ? aItem.mIconList[aMetaData - aItem.mOffset][8] : aItem.mIconList[aMetaData - aItem.mOffset][7 - (int)Math.max(0L, Math.min(5L, (tStats[0] - tCharge) * 6L / tStats[0]))])) : aItem.mIconList[aMetaData - aItem.mOffset][0]) : aItem.mIconList[aMetaData - aItem.mOffset][0];
        if (tIcon == null) {
            tIcon = Textures.ItemIcons.RENDERING_ERROR.getIcon();
        }
        this.markNeedsAnimationUpdate(tIcon);
        ItemList largeFluidCell = GT_GeneratedItem_Renderer.getLargeFluidCell(aStack);
        if (largeFluidCell != null) {
            this.renderLargeFluidCellExtraParts(type, largeFluidCell, aStack);
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110576_c);
        GL11.glBlendFunc((int)770, (int)771);
        GT_RenderUtil.renderItem(type, tIcon);
        GL11.glDisable((int)3042);
    }

    @Nullable
    private static ItemList getLargeFluidCell(ItemStack stack) {
        if (GT_GeneratedItem_Renderer.isSame(ItemList.Large_Fluid_Cell_Steel, stack)) {
            return ItemList.Large_Fluid_Cell_Steel;
        }
        if (GT_GeneratedItem_Renderer.isSame(ItemList.Large_Fluid_Cell_Aluminium, stack)) {
            return ItemList.Large_Fluid_Cell_Aluminium;
        }
        if (GT_GeneratedItem_Renderer.isSame(ItemList.Large_Fluid_Cell_TungstenSteel, stack)) {
            return ItemList.Large_Fluid_Cell_TungstenSteel;
        }
        if (GT_GeneratedItem_Renderer.isSame(ItemList.Large_Fluid_Cell_StainlessSteel, stack)) {
            return ItemList.Large_Fluid_Cell_StainlessSteel;
        }
        if (GT_GeneratedItem_Renderer.isSame(ItemList.Large_Fluid_Cell_Titanium, stack)) {
            return ItemList.Large_Fluid_Cell_Titanium;
        }
        if (GT_GeneratedItem_Renderer.isSame(ItemList.Large_Fluid_Cell_Chrome, stack)) {
            return ItemList.Large_Fluid_Cell_Chrome;
        }
        if (GT_GeneratedItem_Renderer.isSame(ItemList.Large_Fluid_Cell_Iridium, stack)) {
            return ItemList.Large_Fluid_Cell_Iridium;
        }
        if (GT_GeneratedItem_Renderer.isSame(ItemList.Large_Fluid_Cell_Osmium, stack)) {
            return ItemList.Large_Fluid_Cell_Osmium;
        }
        if (GT_GeneratedItem_Renderer.isSame(ItemList.Large_Fluid_Cell_Neutronium, stack)) {
            return ItemList.Large_Fluid_Cell_Neutronium;
        }
        return null;
    }

    private void renderLargeFluidCellExtraParts(IItemRenderer.ItemRenderType type, ItemList item, ItemStack stack) {
        IIcon iIcon;
        switch (item) {
            case Large_Fluid_Cell_Steel: {
                iIcon = ExtraIcons.steelLargeCellInner;
                break;
            }
            case Large_Fluid_Cell_Aluminium: {
                iIcon = ExtraIcons.aluminiumLargeCellInner;
                break;
            }
            case Large_Fluid_Cell_StainlessSteel: {
                iIcon = ExtraIcons.stainlesssteelLargeCellInner;
                break;
            }
            case Large_Fluid_Cell_Titanium: {
                iIcon = ExtraIcons.titaniumLargeCellInner;
                break;
            }
            case Large_Fluid_Cell_TungstenSteel: {
                iIcon = ExtraIcons.tungstensteelLargeCellInner;
                break;
            }
            case Large_Fluid_Cell_Iridium: {
                iIcon = ExtraIcons.iridiumLargeCellInner;
                break;
            }
            case Large_Fluid_Cell_Osmium: {
                iIcon = ExtraIcons.osmiumLargeCellInner;
                break;
            }
            case Large_Fluid_Cell_Chrome: {
                iIcon = ExtraIcons.chromiumLargeCellInner;
                break;
            }
            case Large_Fluid_Cell_Neutronium: {
                iIcon = ExtraIcons.neutroniumLargeCellInner;
                break;
            }
            default: {
                iIcon = Textures.ItemIcons.RENDERING_ERROR.getIcon();
            }
        }
        IIcon inner = iIcon;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110576_c);
        this.markNeedsAnimationUpdate(inner);
        GT_RenderUtil.renderItem(type, inner);
        FluidStack fluidStack = GT_Utility.getFluidForFilledItem(stack, true);
        if (fluidStack != null && fluidStack.getFluid() != null) {
            IIcon fluidIcon = fluidStack.getFluid().getIcon(fluidStack);
            if (fluidIcon == null) {
                fluidIcon = Textures.ItemIcons.RENDERING_ERROR.getIcon();
            }
            int fluidColor = fluidStack.getFluid().getColor(fluidStack);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            this.markNeedsAnimationUpdate(fluidIcon);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDepthFunc((int)514);
            GL11.glColor3ub((byte)((byte)(fluidColor >> 16)), (byte)((byte)(fluidColor >> 8)), (byte)((byte)fluidColor));
            GT_RenderUtil.renderItem(type, fluidIcon);
            GL11.glColor3ub((byte)-1, (byte)-1, (byte)-1);
            GL11.glDepthFunc((int)515);
        }
    }

    private static boolean isSame(ItemList item, ItemStack stack) {
        ItemStack internal = item.getInternalStack_unsafe();
        if (GT_Utility.isStackInvalid(internal)) {
            return false;
        }
        return internal.func_77973_b() == stack.func_77973_b() && internal.func_77960_j() == stack.func_77960_j();
    }

    protected void markNeedsAnimationUpdate(IIcon icon) {
        if (Mods.HodgePodge.isModLoaded() && icon instanceof IPatchedTextureAtlasSprite) {
            ((IPatchedTextureAtlasSprite)icon).markNeedsAnimationUpdate();
        }
    }
}

