/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity;

import com.cricketcraft.chisel.api.IFacade;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IDebugableBlock;
import gregtech.api.interfaces.tileentity.IDebugableTileEntity;
import gregtech.api.metatileentity.BaseTileEntity;
import gregtech.api.metatileentity.CoverableTileEntity;
import gregtech.api.multitileentity.MultiTileEntityItem;
import gregtech.api.multitileentity.MultiTileEntityRegistry;
import gregtech.api.multitileentity.interfaces.IMultiTileEntity;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtil;
import gregtech.common.covers.CoverInfo;
import gregtech.common.render.MultiTileRenderer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;

@Optional.Interface(iface="com.cricketcraft.chisel.api.IFacade", modid="ChiselAPI")
public class MultiTileEntityBlock
extends BlockContainer
implements IDebugableBlock,
ITileEntityProvider,
IFacade {
    private MultiTileEntityRegistry registry;
    private static boolean LOCK = false;
    private boolean registered = false;
    private boolean normalCube;
    protected String internalName;
    protected String toolName;
    protected String materialName;
    protected String modID;

    public String getName() {
        return String.join((CharSequence)".", "gt.block.multiblock", this.materialName, this.field_149762_H.field_150501_a, this.toolName, Boolean.toString(this.field_149787_q), Boolean.toString(this.normalCube));
    }

    public MultiTileEntityBlock(Material material) {
        super(material);
        if (GregTechAPI.sPreloadFinished) {
            throw new IllegalStateException("Blocks can only be initialized within preInit!");
        }
    }

    public MultiTileEntityBlock tool(String toolName) {
        this.toolName = toolName.toLowerCase();
        return this;
    }

    public MultiTileEntityBlock sound(Block.SoundType soundtype) {
        this.func_149672_a(soundtype);
        return this;
    }

    public MultiTileEntityBlock opaque(Boolean opaque) {
        this.field_149787_q = opaque;
        return this;
    }

    public MultiTileEntityBlock normalCube(Boolean normalCube) {
        this.normalCube = normalCube;
        return this;
    }

    public MultiTileEntityBlock modID(String modID) {
        this.modID = modID;
        return this;
    }

    public MultiTileEntityBlock materialName(String materialName) {
        this.materialName = materialName;
        return this;
    }

    public MultiTileEntityBlock register() {
        if (this.registered) {
            throw new IllegalStateException("Block already registered " + this.internalName);
        }
        if (GregTechAPI.sPreloadFinished) {
            throw new IllegalStateException("Blocks can only be initialized within preInit!");
        }
        this.registered = true;
        this.internalName = this.getName();
        this.field_149786_r = this.func_149662_c() ? 255 : 0;
        GameRegistry.registerBlock((Block)this, MultiTileEntityItem.class, (String)this.internalName);
        return this;
    }

    public final void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        TileEntity tileEntity = GTUtil.getTileEntity(world, x, y, z, true);
        if (tileEntity != null) {
            GTUtil.LAST_BROKEN_TILEENTITY.set(tileEntity);
        }
        if (tileEntity == null || !tileEntity.shouldRefresh((Block)this, block, metadata, metadata, world, x, y, z)) {
            return;
        }
        if (tileEntity instanceof IMultiTileEntity) {
            IMultiTileEntity mute = (IMultiTileEntity)tileEntity;
            mute.onBlockBroken();
        }
        world.func_147475_p(x, y, z);
        super.func_149749_a(world, x, y, z, block, metadata);
    }

    @Override
    public ArrayList<String> getDebugInfo(EntityPlayer aPlayer, int x, int y, int z, int aLogLevel) {
        TileEntity tileEntity = aPlayer.field_70170_p.func_147438_o(x, y, z);
        if (tileEntity instanceof IDebugableTileEntity) {
            IDebugableTileEntity mte = (IDebugableTileEntity)tileEntity;
            return mte.getDebugInfo(aPlayer, aLogLevel);
        }
        return new ArrayList<String>();
    }

    public int func_149645_b() {
        return MultiTileRenderer.INSTANCE == null ? super.func_149645_b() : MultiTileRenderer.INSTANCE.getRenderId();
    }

    public final float func_149712_f(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        return tileEntity instanceof IMultiTileEntity ? ((IMultiTileEntity)tileEntity).getBlockHardness() : 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess aIBlockAccess, int x, int y, int z, int ordinalSide) {
        return Textures.BlockIcons.MACHINE_LV_SIDE.getIcon();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int ordinalSide, int meta) {
        return Textures.BlockIcons.MACHINE_LV_SIDE.getIcon();
    }

    public final void func_149743_a(World world, int x, int y, int z, AxisAlignedBB aAABB, List<AxisAlignedBB> aList, Entity aEntity) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof IMultiTileEntity) {
            ((IMultiTileEntity)tileEntity).addCollisionBoxesToList(aAABB, aList, aEntity);
        } else {
            super.func_149743_a(world, x, y, z, aAABB, aList, aEntity);
        }
    }

    public final AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        AxisAlignedBB axisAlignedBB;
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof IMultiTileEntity) {
            IMultiTileEntity mte = (IMultiTileEntity)tileEntity;
            axisAlignedBB = mte.getCollisionBoundingBoxFromPool();
        } else {
            axisAlignedBB = tileEntity == null ? null : super.func_149668_a(world, x, y, z);
        }
        return axisAlignedBB;
    }

    public final AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        AxisAlignedBB axisAlignedBB;
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof IMultiTileEntity) {
            IMultiTileEntity mte = (IMultiTileEntity)tileEntity;
            axisAlignedBB = mte.getSelectedBoundingBoxFromPool();
        } else {
            axisAlignedBB = super.func_149633_g(world, x, y, z);
        }
        return axisAlignedBB;
    }

    public void func_149719_a(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntity tileEntity = blockAccess.func_147438_o(x, y, z);
        if (tileEntity instanceof IMultiTileEntity) {
            IMultiTileEntity mte = (IMultiTileEntity)tileEntity;
            mte.setBlockBoundsBasedOnState((Block)this);
            return;
        }
        super.func_149719_a(blockAccess, x, y, z);
    }

    public final boolean func_149662_c() {
        return this.field_149787_q;
    }

    public final void onNeighborChange(IBlockAccess world, int x, int y, int z, int aTileX, int aTileY, int aTileZ) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!LOCK) {
            LOCK = true;
            if (tileEntity instanceof BaseTileEntity) {
                ((BaseTileEntity)tileEntity).onAdjacentBlockChange(aTileX, aTileY, aTileZ);
            }
            LOCK = false;
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!LOCK) {
            LOCK = true;
            if (tileEntity instanceof BaseTileEntity) {
                BaseTileEntity bte = (BaseTileEntity)tileEntity;
                bte.onAdjacentBlockChange(x, y, z);
            }
            LOCK = false;
        }
        if (tileEntity instanceof IMultiTileEntity) {
            IMultiTileEntity change = (IMultiTileEntity)tileEntity;
            change.onNeighborBlockChange(world, block);
        }
        if (tileEntity == null) {
            world.func_147468_f(x, y, z);
        }
    }

    public final void func_149726_b(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof IMultiTileEntity) {
            IMultiTileEntity mte = (IMultiTileEntity)tileEntity;
            mte.onBlockAdded();
        }
    }

    public float func_149737_a(EntityPlayer aPlayer, World world, int x, int y, int z) {
        IMultiTileEntity mte;
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        return tileEntity instanceof IMultiTileEntity && (mte = (IMultiTileEntity)tileEntity).privateAccess() && !((IMultiTileEntity)tileEntity).playerOwnsThis(aPlayer, true) ? -1.0f : super.func_149737_a(aPlayer, world, x, y, z);
    }

    public final void func_149699_a(World world, int x, int y, int z, EntityPlayer aPlayer) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof IMultiTileEntity) {
            IMultiTileEntity mte = (IMultiTileEntity)tileEntity;
            mte.onLeftClick(aPlayer);
        } else {
            super.func_149699_a(world, x, y, z, aPlayer);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer aPlayer, int ordinalSide, float aHitX, float aHitY, float aHitZ) {
        IMultiTileEntity mte;
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (aPlayer != null && ItemList.TC_Thaumometer.isStackEqual(aPlayer.func_70694_bm(), true, true)) {
            return false;
        }
        return tileEntity instanceof IMultiTileEntity && (mte = (IMultiTileEntity)tileEntity).onBlockActivated(aPlayer, ForgeDirection.getOrientation((int)ordinalSide), aHitX, aHitY, aHitZ);
    }

    public final int func_149709_b(IBlockAccess world, int x, int y, int z, int ordinalSide) {
        int n;
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof IMultiTileEntity) {
            IMultiTileEntity power = (IMultiTileEntity)tileEntity;
            n = power.isProvidingWeakPower(ForgeDirection.getOrientation((int)ordinalSide));
        } else {
            n = super.func_149709_b(world, x, y, z, ordinalSide);
        }
        return n;
    }

    public final int func_149748_c(IBlockAccess world, int x, int y, int z, int ordinalSide) {
        int n;
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof IMultiTileEntity) {
            IMultiTileEntity power = (IMultiTileEntity)tileEntity;
            n = power.isProvidingStrongPower(ForgeDirection.getOrientation((int)ordinalSide));
        } else {
            n = super.func_149748_c(world, x, y, z, ordinalSide);
        }
        return n;
    }

    public final boolean shouldCheckWeakPower(IBlockAccess world, int x, int y, int z, int ordinalSide) {
        boolean bl;
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof IMultiTileEntity) {
            IMultiTileEntity power = (IMultiTileEntity)tileEntity;
            bl = power.shouldCheckWeakPower(ForgeDirection.getOrientation((int)ordinalSide));
        } else {
            bl = this.isNormalCube(world, x, y, z);
        }
        return bl;
    }

    public final boolean getWeakChanges(IBlockAccess world, int x, int y, int z) {
        boolean bl;
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof IMultiTileEntity) {
            IMultiTileEntity changes = (IMultiTileEntity)tileEntity;
            bl = changes.getWeakChanges();
        } else {
            bl = super.getWeakChanges(world, x, y, z);
        }
        return bl;
    }

    public final void func_149636_a(World world, EntityPlayer aPlayer, int x, int y, int z, int meta) {
        if (aPlayer == null) {
            aPlayer = (EntityPlayer)this.harvesters.get();
        }
        aPlayer.func_71064_a(StatList.field_75934_C[MultiTileEntityBlock.func_149682_b((Block)this)], 1);
        aPlayer.func_71020_j(0.025f);
        boolean aSilkTouch = EnchantmentHelper.func_77502_d((EntityLivingBase)aPlayer);
        int aFortune = EnchantmentHelper.func_77517_e((EntityLivingBase)aPlayer);
        float aChance = 1.0f;
        TileEntity tileEntity = GTUtil.getTileEntity(world, x, y, z, true);
        if (!(tileEntity instanceof IMultiTileEntity)) {
            return;
        }
        IMultiTileEntity mte = (IMultiTileEntity)tileEntity;
        ArrayList<ItemStack> tList = mte.getDrops(aFortune, aSilkTouch);
        aChance = ForgeEventFactory.fireBlockHarvesting(tList, (World)world, (Block)this, (int)x, (int)y, (int)z, (int)meta, (int)aFortune, (float)aChance, (boolean)aSilkTouch, (EntityPlayer)aPlayer);
        for (ItemStack tStack : tList) {
            if (!(XSTR.XSTR_INSTANCE.nextFloat() <= aChance)) continue;
            this.func_149642_a(world, x, y, z, tStack);
        }
    }

    public final boolean func_149646_a(IBlockAccess world, int x, int y, int z, int ordinalSide) {
        boolean bl;
        TileEntity tileEntity = world.func_147438_o(x - GTValues.OFFX[ordinalSide], y - GTValues.OFFY[ordinalSide], z - GTValues.OFFZ[ordinalSide]);
        if (tileEntity instanceof IMultiTileEntity) {
            IMultiTileEntity mte = (IMultiTileEntity)tileEntity;
            bl = mte.shouldSideBeRendered(ForgeDirection.getOrientation((int)ordinalSide));
        } else {
            bl = super.func_149646_a(world, x, y, z, ordinalSide);
        }
        return bl;
    }

    public Block getFacade(IBlockAccess world, int x, int y, int z, int ordinalSide) {
        TileEntity tTileEntity = world.func_147438_o(x, y, z);
        if (tTileEntity instanceof CoverableTileEntity) {
            CoverableTileEntity tile = (CoverableTileEntity)tTileEntity;
            ForgeDirection side = ForgeDirection.getOrientation((int)ordinalSide);
            if (ordinalSide != -1) {
                Block facadeBlock = tile.getCoverInfoAtSide(side).getFacadeBlock();
                if (facadeBlock != null) {
                    return facadeBlock;
                }
            } else {
                for (ForgeDirection tSide : ForgeDirection.VALID_DIRECTIONS) {
                    Block facadeBlock = tile.getCoverInfoAtSide(tSide).getFacadeBlock();
                    if (facadeBlock == null) continue;
                    return facadeBlock;
                }
            }
        }
        return Blocks.field_150350_a;
    }

    public int getFacadeMetadata(IBlockAccess world, int x, int y, int z, int ordinalSide) {
        TileEntity tTileEntity = world.func_147438_o(x, y, z);
        if (tTileEntity instanceof CoverableTileEntity) {
            CoverableTileEntity tile = (CoverableTileEntity)tTileEntity;
            ForgeDirection side = ForgeDirection.getOrientation((int)ordinalSide);
            if (ordinalSide != -1) {
                CoverInfo coverInfo = tile.getCoverInfoAtSide(side);
                Block facadeBlock = coverInfo.getFacadeBlock();
                if (facadeBlock != null) {
                    return coverInfo.getFacadeMeta();
                }
            } else {
                for (ForgeDirection tSide : ForgeDirection.VALID_DIRECTIONS) {
                    CoverInfo coverInfo = tile.getCoverInfoAtSide(tSide);
                    Block facadeBlock = coverInfo.getFacadeBlock();
                    if (facadeBlock == null) continue;
                    return coverInfo.getFacadeMeta();
                }
            }
        }
        return 0;
    }

    public MultiTileEntityRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(MultiTileEntityRegistry registry) {
        this.registry = registry;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    protected boolean func_149700_E() {
        return false;
    }

    public final String func_149732_F() {
        return StatCollector.func_74838_a((String)(this.internalName + ".name"));
    }

    public final String func_149739_a() {
        return this.internalName;
    }

    public final boolean func_149696_a(World world, int x, int y, int z, int aID, int aData) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        return tileEntity == null || tileEntity.func_145842_c(aID, aData);
    }

    public final void func_149666_a(Item aItem, CreativeTabs aCreativeTab, List<ItemStack> aList) {
    }

    public boolean func_149740_M() {
        return true;
    }

    public final int func_149736_g(World world, int x, int y, int z, int ordinalSide) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof IMultiTileEntity) {
            IMultiTileEntity mute = (IMultiTileEntity)tileEntity;
            if (mute.hasComparatorInputOverride()) {
                return mute.getComparatorInputOverride(ForgeDirection.getOrientation((int)ordinalSide));
            }
            return mute.isProvidingWeakPower(ForgeDirection.getOrientation((int)ordinalSide).getOpposite());
        }
        return super.func_149736_g(world, x, y, z, ordinalSide);
    }

    public final void func_149651_a(IIconRegister aIconRegister) {
    }

    public final boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        boolean bl;
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof IMultiTileEntity) {
            IMultiTileEntity mute = (IMultiTileEntity)tileEntity;
            bl = mute.isSideSolid(side);
        } else {
            bl = this.field_149787_q;
        }
        return bl;
    }

    public boolean removedByPlayer(World world, EntityPlayer aPlayer, int x, int y, int z, boolean aWillHarvest) {
        TileEntity tileEntity = GTUtil.getTileEntity(world, x, y, z, true);
        if (tileEntity != null) {
            GTUtil.LAST_BROKEN_TILEENTITY.set(tileEntity);
        }
        return super.removedByPlayer(world, aPlayer, x, y, z, aWillHarvest);
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 0;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return GregTechAPI.sMachineFlammable && world.func_72805_g(x, y, z) == 0 ? 100 : 0;
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public final ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int aUnusableMetaData, int aFortune) {
        TileEntity tileEntity = GTUtil.getTileEntity(world, x, y, z, true);
        if (tileEntity instanceof IMultiTileEntity) {
            IMultiTileEntity mute = (IMultiTileEntity)tileEntity;
            return mute.getDrops(aFortune, false);
        }
        return new ArrayList<ItemStack>();
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public final float getExplosionResistance(Entity aExploder, World world, int x, int y, int z, double aExplosionX, double aExplosionY, double aExplosionZ) {
        float f;
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof IMultiTileEntity) {
            IMultiTileEntity mute = (IMultiTileEntity)tileEntity;
            f = mute.getExplosionResistance(aExploder, aExplosionX, aExplosionY, aExplosionZ);
        } else {
            f = 1.0f;
        }
        return f;
    }

    public final void onBlockExploded(World world, int x, int y, int z, Explosion aExplosion) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tileEntity = GTUtil.getTileEntity(world, x, y, z, true);
        if (tileEntity != null) {
            GTUtil.LAST_BROKEN_TILEENTITY.set(tileEntity);
        }
        if (tileEntity instanceof IMultiTileEntity) {
            IMultiTileEntity mute = (IMultiTileEntity)tileEntity;
            GTLog.exp.printf("Explosion at : %d | %d | %d DIMID: %s due to near explosion!%n", x, y, z, world.field_73011_w.field_76574_g);
            mute.onExploded(aExplosion);
        } else {
            world.func_147468_f(x, y, z);
        }
    }

    public final boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int ordinalSide) {
        return true;
    }

    public final boolean recolourBlock(World world, int x, int y, int z, ForgeDirection side, int color) {
        IMultiTileEntity mute;
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        return tileEntity instanceof IMultiTileEntity && (mute = (IMultiTileEntity)tileEntity).recolourBlock(side, (byte)color);
    }

    public final String getHarvestTool(int meta) {
        return this.toolName;
    }

    public int getHarvestLevel(int meta) {
        return meta % 4;
    }

    public final boolean isToolEffective(String toolType, int meta) {
        return this.getHarvestTool(meta).equals(toolType);
    }

    public final ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer aPlayer) {
        ItemStack itemStack;
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof IMultiTileEntity) {
            IMultiTileEntity mte = (IMultiTileEntity)tileEntity;
            itemStack = mte.getPickBlock(target);
        } else {
            itemStack = null;
        }
        return itemStack;
    }

    public final ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        ItemStack itemStack;
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof IMultiTileEntity) {
            IMultiTileEntity mte = (IMultiTileEntity)tileEntity;
            itemStack = mte.getPickBlock(target);
        } else {
            itemStack = null;
        }
        return itemStack;
    }

    @Nullable
    public final IMultiTileEntity receiveMultiTileEntityData(@Nonnull IBlockAccess world, int x, int y, int z, int registryId, int aID) {
        IMultiTileEntity mute;
        if (!(world instanceof World)) {
            return null;
        }
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!(tileEntity instanceof IMultiTileEntity) || (mute = (IMultiTileEntity)tileEntity).getMultiTileEntityRegistryID() != registryId || mute.getMultiTileEntityID() != aID) {
            MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(registryId);
            if (tRegistry == null) {
                return null;
            }
            tileEntity = tRegistry.getNewTileEntity((World)world, x, y, z, aID);
            if (!(tileEntity instanceof IMultiTileEntity)) {
                return null;
            }
            GTUtil.setTileEntity((World)world, x, y, z, tileEntity, false);
        }
        return (IMultiTileEntity)tileEntity;
    }

    public void receiveCoverData(IMultiTileEntity mute, int aCover0, int aCover1, int aCover2, int aCover3, int aCover4, int aCover5) {
        boolean updated = mute.setCoverIDAtSideNoUpdate(ForgeDirection.DOWN, aCover0);
        updated |= mute.setCoverIDAtSideNoUpdate(ForgeDirection.UP, aCover1);
        updated |= mute.setCoverIDAtSideNoUpdate(ForgeDirection.NORTH, aCover2);
        updated |= mute.setCoverIDAtSideNoUpdate(ForgeDirection.SOUTH, aCover3);
        updated |= mute.setCoverIDAtSideNoUpdate(ForgeDirection.WEST, aCover4);
        if (updated |= mute.setCoverIDAtSideNoUpdate(ForgeDirection.EAST, aCover5)) {
            mute.issueBlockUpdate();
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return this.registry.getNewTileEntity(meta);
    }
}

