/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects.overclockdescriber;

import gregtech.GTMod;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.api.util.OverclockCalculator;
import gregtech.nei.RecipeDisplayInfo;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class OverclockDescriber {
    protected final byte tier;

    public OverclockDescriber(byte tier) {
        this.tier = tier;
    }

    public final byte getTier() {
        return this.tier;
    }

    public abstract String getTierString();

    public abstract OverclockCalculator createCalculator(OverclockCalculator var1, GTRecipe var2);

    public abstract void drawEnergyInfo(RecipeDisplayInfo var1);

    public void drawDurationInfo(RecipeDisplayInfo recipeInfo) {
        if (this.getDurationTicks(recipeInfo.calculator) <= 0) {
            return;
        }
        String textToDraw = GTUtility.trans("158", "Time: ");
        if (GTMod.gregtechproxy.mNEIRecipeSecondMode) {
            textToDraw = textToDraw + this.getDurationStringSeconds(recipeInfo.calculator);
            if (this.getDurationSeconds(recipeInfo.calculator) <= 1.0) {
                textToDraw = textToDraw + String.format(" (%s)", this.getDurationStringTicks(recipeInfo.calculator));
            }
        } else {
            textToDraw = textToDraw + this.getDurationStringTicks(recipeInfo.calculator);
        }
        recipeInfo.drawText(textToDraw);
    }

    public boolean canHandle(GTRecipe recipe) {
        byte tier = GTUtility.getTier(recipe.mEUt);
        return this.tier >= tier;
    }

    private int getDurationTicks(OverclockCalculator calculator) {
        return calculator.getDuration();
    }

    private double getDurationSeconds(OverclockCalculator calculator) {
        return 0.05 * (double)this.getDurationTicks(calculator);
    }

    private String getDurationStringSeconds(OverclockCalculator calculator) {
        return GTUtility.formatNumbers(this.getDurationSeconds(calculator)) + GTUtility.trans("161", " secs");
    }

    private String getDurationStringTicks(OverclockCalculator calculator) {
        String ticksString = this.getDurationTicks(calculator) == 1 ? GTUtility.trans("209.1", " tick") : GTUtility.trans("209", " ticks");
        return GTUtility.formatNumbers(this.getDurationTicks(calculator)) + ticksString;
    }
}

