/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;

public class GTRenderingWorld
implements IBlockAccess {
    private static final GTRenderingWorld INSTANCE = new GTRenderingWorld();
    private final Map<ChunkPosition, BlockInfo> infos = new HashMap<ChunkPosition, BlockInfo>();
    private final Map<ChunkCoordIntPair, Set<ChunkPosition>> index = new HashMap<ChunkCoordIntPair, Set<ChunkPosition>>();
    private IBlockAccess mWorld;

    private GTRenderingWorld() {
        this.mWorld = Minecraft.func_71410_x().field_71441_e;
        new FMLEventHandler();
        new ForgeEventHandler();
    }

    public static GTRenderingWorld getInstance() {
        return INSTANCE;
    }

    public static GTRenderingWorld getInstance(IBlockAccess aWorld) {
        if (aWorld == INSTANCE) {
            return INSTANCE;
        }
        GTRenderingWorld.INSTANCE.mWorld = aWorld == null ? Minecraft.func_71410_x().field_71441_e : aWorld;
        return INSTANCE;
    }

    private void setWorld(IBlockAccess aWorld) {
        this.mWorld = aWorld == null ? Minecraft.func_71410_x().field_71441_e : aWorld;
    }

    public void register(int x, int y, int z, Block block, int meta) {
        ChunkPosition key = new ChunkPosition(x, y, z);
        this.infos.put(key, new BlockInfo(block, meta));
        this.index.computeIfAbsent(new ChunkCoordIntPair(x >> 4, z >> 4), p -> new HashSet()).add(key);
    }

    public void unregister(int x, int y, int z, Block block, int meta) {
        ChunkPosition key = new ChunkPosition(x, y, z);
        if (this.infos.remove(key, new BlockInfo(block, meta))) {
            ChunkCoordIntPair chunkKey = new ChunkCoordIntPair(x >> 4, z >> 4);
            Set<ChunkPosition> set = this.index.get(chunkKey);
            set.remove(key);
            if (set.isEmpty()) {
                this.index.remove(chunkKey);
            }
        }
    }

    public Block func_147439_a(int p_147439_1_, int p_147439_2_, int p_147439_3_) {
        BlockInfo blockInfo = this.infos.get(new ChunkPosition(p_147439_1_, p_147439_2_, p_147439_3_));
        return blockInfo != null ? blockInfo.block : this.mWorld.func_147439_a(p_147439_1_, p_147439_2_, p_147439_3_);
    }

    public TileEntity func_147438_o(int p_147438_1_, int p_147438_2_, int p_147438_3_) {
        return this.mWorld.func_147438_o(p_147438_1_, p_147438_2_, p_147438_3_);
    }

    public int func_72802_i(int p_72802_1_, int p_72802_2_, int p_72802_3_, int p_72802_4_) {
        return this.mWorld.func_72802_i(p_72802_1_, p_72802_2_, p_72802_3_, p_72802_4_);
    }

    public int func_72805_g(int p_72805_1_, int p_72805_2_, int p_72805_3_) {
        BlockInfo blockInfo = this.infos.get(new ChunkPosition(p_72805_1_, p_72805_2_, p_72805_3_));
        return blockInfo != null ? blockInfo.meta : this.mWorld.func_72805_g(p_72805_1_, p_72805_2_, p_72805_3_);
    }

    public int func_72879_k(int p_72879_1_, int p_72879_2_, int p_72879_3_, int p_72879_4_) {
        return this.mWorld.func_72879_k(p_72879_1_, p_72879_2_, p_72879_3_, p_72879_4_);
    }

    public boolean func_147437_c(int p_147437_1_, int p_147437_2_, int p_147437_3_) {
        return this.func_147439_a(p_147437_1_, p_147437_2_, p_147437_3_).isAir(this.mWorld, p_147437_1_, p_147437_2_, p_147437_3_);
    }

    public BiomeGenBase func_72807_a(int p_72807_1_, int p_72807_2_) {
        return this.mWorld.func_72807_a(p_72807_1_, p_72807_2_);
    }

    public int func_72800_K() {
        return this.mWorld.func_72800_K();
    }

    public boolean func_72806_N() {
        return this.mWorld.func_72806_N();
    }

    public boolean isSideSolid(int x, int y, int z, ForgeDirection side, boolean _default) {
        return this.func_147439_a(x, y, z).isSideSolid((IBlockAccess)this, x, y, z, side);
    }

    public class FMLEventHandler {
        public FMLEventHandler() {
            FMLCommonHandler.instance().bus().register((Object)this);
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void onRenderTickStart(TickEvent.RenderTickEvent e) {
            if (e.phase == TickEvent.Phase.START) {
                GTRenderingWorld.this.mWorld = (IBlockAccess)Minecraft.func_71410_x().field_71441_e;
            }
        }
    }

    public class ForgeEventHandler {
        private ForgeEventHandler() {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void onChunkUnloaded(ChunkEvent.Unload e) {
            if (!e.world.field_72995_K) {
                return;
            }
            Set set = (Set)GTRenderingWorld.this.index.remove(e.getChunk().func_76632_l());
            if (set != null) {
                GTRenderingWorld.this.infos.keySet().removeAll(set);
            }
        }

        @SubscribeEvent
        public void onWorldUnloaded(WorldEvent.Unload e) {
            if (!e.world.field_72995_K) {
                return;
            }
            GTRenderingWorld.this.infos.clear();
            GTRenderingWorld.this.index.clear();
        }
    }

    private static class BlockInfo {
        private final Block block;
        private final int meta;

        public BlockInfo(Block block, int meta) {
            this.block = block;
            this.meta = meta;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlockInfo blockInfo = (BlockInfo)o;
            if (this.meta != blockInfo.meta) {
                return false;
            }
            return Objects.equals(this.block, blockInfo.block);
        }

        public int hashCode() {
            int result = this.block != null ? this.block.hashCode() : 0;
            result = 31 * result + this.meta;
            return result;
        }
    }
}

