/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.objects.XSTR;
import gregtech.api.util.CoverBehavior;
import gregtech.api.util.GTUtility;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class CoverVent
extends CoverBehavior {
    private final int mEfficiency;
    private final Fluid IC2_HOT_COOLANT = FluidRegistry.getFluid((String)"ic2hotcoolant");
    private final Fluid IC2_COOLANT = FluidRegistry.getFluid((String)"ic2coolant");

    public CoverVent(int aEfficiency) {
        this.mEfficiency = aEfficiency;
    }

    @Override
    public boolean isRedstoneSensitive(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return false;
    }

    @Override
    public int doCoverThings(ForgeDirection side, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        if (side == ForgeDirection.UNKNOWN) {
            return 0;
        }
        int ret = 0;
        if (aTileEntity instanceof IFluidHandler) {
            ret = this.doCoolFluid(side, aTileEntity);
        }
        if (aTileEntity instanceof IMachineProgress) {
            ret = this.doProgressEfficiency(side, (IMachineProgress)((Object)aTileEntity), aCoverID);
        }
        return ret;
    }

    @Override
    public boolean alwaysLookConnected(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public int getTickRate(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 100;
    }

    protected int doProgressEfficiency(ForgeDirection side, IMachineProgress aTileEntity, int aCoverVariable) {
        int offsetX = aTileEntity.getOffsetX(side, 1);
        short offsetY = aTileEntity.getOffsetY(side, 1);
        int offsetZ = aTileEntity.getOffsetZ(side, 1);
        World world = aTileEntity.getWorld();
        if (aTileEntity.hasThingsToDo() && aCoverVariable != aTileEntity.getProgress() && !GTUtility.hasBlockHitBox(world, offsetX, offsetY, offsetZ)) {
            aTileEntity.increaseProgress(this.mEfficiency);
        }
        return aTileEntity.getProgress();
    }

    protected int doCoolFluid(ForgeDirection side, ICoverable aTileEntity) {
        int chances;
        IFluidHandler fluidHandler;
        block12: {
            block13: {
                Block blockAtSide;
                World world;
                int offsetZ;
                short offsetY;
                int offsetX;
                block11: {
                    int n;
                    offsetX = aTileEntity.getOffsetX(side, 1);
                    offsetY = aTileEntity.getOffsetY(side, 1);
                    offsetZ = aTileEntity.getOffsetZ(side, 1);
                    world = aTileEntity.getWorld();
                    fluidHandler = (IFluidHandler)aTileEntity;
                    if (!fluidHandler.canDrain(ForgeDirection.UNKNOWN, this.IC2_HOT_COOLANT)) {
                        return 0;
                    }
                    blockAtSide = aTileEntity.getBlockAtSide(side);
                    if (blockAtSide == null) {
                        return 0;
                    }
                    if (blockAtSide != Blocks.field_150355_j && blockAtSide != Blocks.field_150358_i) break block11;
                    switch (this.mEfficiency) {
                        case 3: {
                            n = 10000;
                            break;
                        }
                        case 2: {
                            n = 5000;
                            break;
                        }
                        default: {
                            n = 2500;
                        }
                    }
                    chances = n;
                    break block12;
                }
                if (!blockAtSide.isAir((IBlockAccess)world, offsetX, (int)offsetY, offsetZ)) break block13;
                switch (this.mEfficiency) {
                    case 3: {
                        chances = 2500;
                        break block12;
                    }
                    case 2: {
                        chances = 1250;
                        break block12;
                    }
                    default: {
                        return 0;
                    }
                }
            }
            return 0;
        }
        if (chances > XSTR.XSTR_INSTANCE.nextInt(10000)) {
            FluidStack hotFluidStack = fluidHandler.drain(ForgeDirection.UNKNOWN, Integer.MAX_VALUE, true);
            FluidStack coldFluidStack = new FluidStack(this.IC2_COOLANT, hotFluidStack.amount);
            fluidHandler.fill(ForgeDirection.UNKNOWN, coldFluidStack, true);
            return hotFluidStack.amount;
        }
        return 0;
    }
}

