/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.api.GregTechAPI;
import gregtech.api.enums.SoundResource;
import gregtech.api.interfaces.IItemBehaviour;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.items.MetaBaseItem;
import gregtech.api.util.CoverBehaviorBase;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.items.behaviors.BehaviourNone;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BehaviourCoverTool
extends BehaviourNone {
    public static final IItemBehaviour<MetaBaseItem> INSTANCE = new BehaviourCoverTool();
    private final String mTooltip = GTLanguageManager.addStringLocalization("gt.behaviour.cover_copy_paste", "Can copy/paste cover data.");
    private ISerializableObject mStoredData = GregTechAPI.sNoBehavior.createDataObject();
    private int mCoverType;
    private int mTickRateAddition = 0;

    @Override
    public boolean onItemUseFirst(MetaBaseItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, ForgeDirection side, float hitX, float hitY, float hitZ) {
        if (aWorld.field_72995_K) {
            return false;
        }
        NBTTagCompound tNBT = aStack.func_77978_p();
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        boolean isCopyMode = aPlayer.func_70093_af();
        this.initDataFromNBT(tNBT);
        if (aPlayer instanceof EntityPlayerMP && aItem.canUse(aStack, 100.0)) {
            if (isCopyMode) {
                ArrayList tList = new ArrayList();
                this.doCopy(tTileEntity, aWorld, aX, aY, aZ, side, hitX, hitY, hitZ, tList);
                aItem.discharge(aStack, 100.0, Integer.MAX_VALUE, true, false, false);
                this.writeListToNBT(tList, tNBT, aPlayer);
                this.saveDataToNBT(tNBT);
            } else {
                this.doPaste(tTileEntity, side, hitX, hitY, hitZ, aPlayer);
                aItem.discharge(aStack, 25.0, Integer.MAX_VALUE, true, false, false);
            }
        }
        GTUtility.doSoundAtClient(SoundResource.IC2_TOOLS_OD_SCANNER, 1, 1.0f, (double)aX, (double)aY, (double)aZ);
        return aPlayer instanceof EntityPlayerMP;
    }

    private void initDataFromNBT(NBTTagCompound aNBT) {
        if (aNBT != null) {
            this.mCoverType = aNBT.func_74762_e("mCoverType");
            CoverBehaviorBase<?> tBehavior = GregTechAPI.getCoverBehaviorNew(this.mCoverType);
            NBTBase tData = aNBT.func_74781_a("mCoverData");
            this.mStoredData = tData != null ? tBehavior.createDataObject(tData) : GregTechAPI.sNoBehavior.createDataObject();
            this.mTickRateAddition = aNBT.func_74764_b("mTickRateAddition") ? aNBT.func_74762_e("mTickRateAddition") : 0;
        }
    }

    private void saveDataToNBT(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mCoverType", this.mCoverType);
        if (this.mStoredData == null) {
            this.mStoredData = GregTechAPI.sNoBehavior.createDataObject();
        }
        aNBT.func_74782_a("mCoverData", this.mStoredData.saveDataToNBT());
        aNBT.func_74768_a("mTickRateAddition", this.mTickRateAddition);
    }

    private void writeListToNBT(List aList, NBTTagCompound aNBT, EntityPlayer aPlayer) {
        if (aList != null && aNBT != null) {
            int tSize = aList.size();
            aNBT.func_74768_a("dataLinesCount", tSize);
            for (int i = 0; i < tSize; ++i) {
                aNBT.func_74778_a("dataLines" + i, (String)aList.get(i));
                GTUtility.sendChatToPlayer(aPlayer, (String)aList.get(i));
            }
        }
    }

    private void doCopy(TileEntity aTileEntity, World aWorld, int aX, int aY, int aZ, ForgeDirection side, float hitX, float hitY, float hitZ, List aList) {
        aList.add(EnumChatFormatting.STRIKETHROUGH + "-----" + EnumChatFormatting.RESET + " X: " + EnumChatFormatting.AQUA + GTUtility.formatNumbers(aX) + EnumChatFormatting.RESET + " Y: " + EnumChatFormatting.AQUA + GTUtility.formatNumbers(aY) + EnumChatFormatting.RESET + " Z: " + EnumChatFormatting.AQUA + GTUtility.formatNumbers(aZ) + EnumChatFormatting.RESET + " D: " + EnumChatFormatting.AQUA + aWorld.field_73011_w.field_76574_g + EnumChatFormatting.RESET + " " + EnumChatFormatting.STRIKETHROUGH + "-----");
        if (aTileEntity instanceof ICoverable) {
            ForgeDirection tSide;
            ICoverable tCoverable = (ICoverable)aTileEntity;
            ForgeDirection forgeDirection = tCoverable.getCoverItemAtSide(side) != null ? side : (tSide = tCoverable.getCoverItemAtSide(GTUtility.determineWrenchingSide(side, hitX, hitY, hitZ)) != null ? GTUtility.determineWrenchingSide(side, hitX, hitY, hitZ) : ForgeDirection.UNKNOWN);
            if (tSide != ForgeDirection.UNKNOWN) {
                if (tCoverable.getCoverBehaviorAtSideNew(tSide).allowsCopyPasteTool()) {
                    this.mStoredData = tCoverable.getComplexCoverDataAtSide(tSide);
                    this.mCoverType = tCoverable.getCoverIDAtSide(tSide);
                    this.mTickRateAddition = tCoverable.getCoverInfoAtSide(tSide).getTickRateAddition();
                    aList.add("Block Side: " + EnumChatFormatting.AQUA + tSide.name() + EnumChatFormatting.RESET);
                    aList.add("Cover Type: " + EnumChatFormatting.GREEN + tCoverable.getCoverItemAtSide(tSide).func_82833_r() + EnumChatFormatting.RESET);
                } else {
                    this.mStoredData = GregTechAPI.sNoBehavior.createDataObject();
                    this.mCoverType = 0;
                    this.mTickRateAddition = 0;
                    aList.add("Copy unavailable for this cover type");
                }
            } else {
                this.mStoredData = GregTechAPI.sNoBehavior.createDataObject();
                this.mCoverType = 0;
                this.mTickRateAddition = 0;
                aList.add("No Cover Found");
            }
        } else {
            this.mStoredData = GregTechAPI.sNoBehavior.createDataObject();
            this.mCoverType = 0;
            this.mTickRateAddition = 0;
            aList.add("No Cover Found");
        }
    }

    private void doPaste(TileEntity aTileEntity, ForgeDirection side, float hitX, float hitY, float hitZ, EntityPlayer aPlayer) {
        if (aTileEntity instanceof ICoverable) {
            ForgeDirection tSide;
            ICoverable tCoverable = (ICoverable)aTileEntity;
            if (this.mCoverType == 0 || this.mStoredData == null) {
                GTUtility.sendChatToPlayer(aPlayer, "Please Copy a Valid Cover First.");
                return;
            }
            ForgeDirection forgeDirection = tCoverable.getCoverItemAtSide(side) != null ? side : (tSide = tCoverable.getCoverItemAtSide(GTUtility.determineWrenchingSide(side, hitX, hitY, hitZ)) != null ? GTUtility.determineWrenchingSide(side, hitX, hitY, hitZ) : ForgeDirection.UNKNOWN);
            if (tSide != ForgeDirection.UNKNOWN) {
                int tCoverID = tCoverable.getCoverIDAtSide(tSide);
                if (tCoverID == this.mCoverType) {
                    tCoverable.setCoverDataAtSide(tSide, this.mStoredData);
                    tCoverable.getCoverInfoAtSide(tSide).setTickRateAddition(this.mTickRateAddition);
                    GTUtility.sendChatToPlayer(aPlayer, "Cover Data Pasted.");
                } else {
                    GTUtility.sendChatToPlayer(aPlayer, "Not Matched Cover.");
                }
            } else {
                GTUtility.sendChatToPlayer(aPlayer, "No Cover Found.");
            }
        }
    }

    @Override
    public List<String> getAdditionalToolTips(MetaBaseItem aItem, List<String> aList, ItemStack aStack) {
        try {
            NBTTagCompound tNBT = aStack.func_77978_p();
            int tSize = tNBT.func_74762_e("dataLinesCount");
            if (tSize < 1) {
                throw new Exception();
            }
            aList.add(EnumChatFormatting.BLUE + "Stored Cover Data:");
            for (int i = 0; i < tSize; ++i) {
                aList.add(EnumChatFormatting.RESET + tNBT.func_74779_i("dataLines" + i));
            }
        }
        catch (Exception e) {
            aList.add(this.mTooltip);
        }
        return aList;
    }
}

