/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.misc.spaceprojects.commands;

import gregtech.api.util.GTUtility;
import gregtech.common.misc.spaceprojects.SpaceProjectManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumChatFormatting;
import org.apache.commons.lang3.tuple.Pair;

public class SPCommand
extends CommandBase {
    private static final Set<Pair<EntityPlayerMP, EntityPlayerMP>> invite = Collections.newSetFromMap(new WeakHashMap());
    private static final Set<EntityPlayerMP> confirm = Collections.newSetFromMap(new WeakHashMap());
    private static final String INVITE = "invite";
    private static final String ACCEPT = "accept";
    private static final String LEAVE = "leave";
    private static final String CONFIRM = "confirm";

    public String func_71517_b() {
        return "sp";
    }

    public int func_82362_a() {
        return 0;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/" + this.func_71517_b() + "<subCommand> [PlayerName]";
    }

    public void func_71515_b(ICommandSender sender, String[] arguments) {
        if (arguments.length < 1) {
            return;
        }
        switch (arguments[0]) {
            case "invite": {
                if (arguments.length < 2) {
                    return;
                }
                this.processInvite(sender, arguments[1]);
                break;
            }
            case "accept": {
                if (arguments.length < 2) {
                    return;
                }
                this.processAccept(sender, arguments[1]);
                break;
            }
            case "leave": {
                this.processLeave(sender);
                break;
            }
            case "confirm": {
                this.processConfirm(sender);
            }
        }
    }

    private void processInvite(ICommandSender sender, String playerInvited) {
        EntityPlayerMP teamLeader = SPCommand.func_71521_c((ICommandSender)sender);
        EntityPlayerMP teamMember = SPCommand.func_82359_c((ICommandSender)sender, (String)playerInvited);
        invite.add((Pair<EntityPlayerMP, EntityPlayerMP>)Pair.of((Object)teamMember, (Object)teamLeader));
        String message = EnumChatFormatting.GOLD + teamLeader.func_70005_c_() + EnumChatFormatting.RESET + " has sent you an invite to join their team. Accept it with" + EnumChatFormatting.GOLD + " /sp accept " + teamLeader.func_70005_c_();
        GTUtility.sendChatToPlayer((EntityPlayer)teamMember, message);
    }

    private void processAccept(ICommandSender sender, String playerInviter) {
        EntityPlayerMP teamLeader;
        EntityPlayerMP teamMember = SPCommand.func_71521_c((ICommandSender)sender);
        if (invite.contains(Pair.of((Object)teamMember, (Object)(teamLeader = SPCommand.func_82359_c((ICommandSender)sender, (String)playerInviter))))) {
            String message = EnumChatFormatting.GOLD + teamMember.func_70005_c_() + EnumChatFormatting.RESET + " has accepted the invite.";
            SpaceProjectManager.putInTeam(teamMember.func_110124_au(), teamLeader.func_110124_au());
            GTUtility.sendChatToPlayer((EntityPlayer)teamLeader, message);
            invite.remove(Pair.of((Object)teamMember, (Object)teamLeader));
        }
    }

    private void processLeave(ICommandSender sender) {
        EntityPlayerMP player = SPCommand.func_71521_c((ICommandSender)sender);
        String message = "Are you sure you want to leave the team. You will lose all progress. Use " + EnumChatFormatting.GOLD + "/sp confirm" + EnumChatFormatting.RESET + " to confirm this. This does nothing if you are the team leader.";
        GTUtility.sendChatToPlayer((EntityPlayer)player, message);
        confirm.add(player);
    }

    private void processConfirm(ICommandSender sender) {
        EntityPlayerMP player = SPCommand.func_71521_c((ICommandSender)sender);
        if (confirm.contains(player)) {
            String message = "Successfully left the team.";
            SpaceProjectManager.putInTeam(player.func_110124_au(), player.func_110124_au());
            GTUtility.sendChatToPlayer((EntityPlayer)player, message);
            confirm.remove(player);
        }
    }

    public List<String> func_71516_a(ICommandSender sender, String[] arguments) {
        ArrayList<String> autoComplete = new ArrayList<String>();
        String filter = arguments.length == 0 ? "" : arguments[0].trim();
        switch (arguments.length) {
            case 1: {
                autoComplete.addAll(Arrays.asList(this.getSubCommands()));
                break;
            }
            case 2: {
                Optional<Pair> pairOpt;
                filter = arguments[1].trim();
                if (arguments[0].equals(INVITE)) {
                    autoComplete.addAll(Arrays.asList(this.getPlayers()));
                    break;
                }
                if (!arguments[0].equals(CONFIRM) || !(pairOpt = invite.stream().filter(e -> ((EntityPlayerMP)e.getKey()).func_110124_au() == SPCommand.func_71521_c((ICommandSender)sender).func_110124_au()).findFirst()).isPresent()) break;
                autoComplete.add(SpaceProjectManager.getPlayerNameFromUUID(((EntityPlayerMP)pairOpt.get().getRight()).func_110124_au()));
            }
        }
        String finalFilter = filter;
        return autoComplete.stream().filter(s -> finalFilter.isEmpty() || s.startsWith(finalFilter)).collect(Collectors.toList());
    }

    private String[] getPlayers() {
        return MinecraftServer.func_71276_C().func_71213_z();
    }

    private String[] getSubCommands() {
        return new String[]{INVITE, ACCEPT, LEAVE, CONFIRM};
    }
}

