/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tools;

import gregtech.GTMod;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTToolHarvestHelper;
import gregtech.api.util.GTUtility;
import gregtech.common.tools.ToolDrillLV;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.event.world.BlockEvent;

public class ToolJackHammer
extends ToolDrillLV {
    @Override
    public int getToolDamagePerBlockBreak() {
        return 400;
    }

    @Override
    public int getToolDamagePerDropConversion() {
        return 400;
    }

    @Override
    public int getToolDamagePerContainerCraft() {
        return 3200;
    }

    @Override
    public int getToolDamagePerEntityAttack() {
        return 800;
    }

    @Override
    public int getBaseQuality() {
        return 1;
    }

    @Override
    public float getBaseDamage() {
        return 3.0f;
    }

    @Override
    public float getSpeedMultiplier() {
        return 12.0f;
    }

    @Override
    public float getMaxDurabilityMultiplier() {
        return 2.0f;
    }

    @Override
    public boolean isMinableBlock(Block aBlock, byte aMetaData) {
        return GTToolHarvestHelper.isAppropriateTool(aBlock, aMetaData, "pickaxe") || GTToolHarvestHelper.isAppropriateMaterial(aBlock, Material.field_151576_e, Material.field_151592_s, Material.field_151588_w, Material.field_151598_x);
    }

    @Override
    public int convertBlockDrops(List<ItemStack> aDrops, ItemStack aStack, EntityPlayer aPlayer, Block aBlock, int aX, int aY, int aZ, byte aMetaData, int aFortune, boolean aSilkTouch, BlockEvent.HarvestDropsEvent aEvent) {
        int rConversions = 0;
        GTRecipe tRecipe = RecipeMaps.hammerRecipes.findRecipeQuery().items(new ItemStack(aBlock, 1, (int)aMetaData)).notUnificated(true).find();
        if (tRecipe == null || aBlock.hasTileEntity((int)aMetaData)) {
            for (ItemStack tDrop : aDrops) {
                ItemStack tHammeringOutput;
                tRecipe = RecipeMaps.hammerRecipes.findRecipeQuery().items(GTUtility.copyAmount(1, tDrop)).notUnificated(true).find();
                if (tRecipe == null || (tHammeringOutput = tRecipe.getOutput(0)) == null) continue;
                rConversions += tDrop.field_77994_a;
                tDrop.field_77994_a *= tHammeringOutput.field_77994_a;
                tHammeringOutput.field_77994_a = tDrop.field_77994_a;
                GTUtility.setStack(tDrop, tHammeringOutput);
            }
        } else {
            aDrops.clear();
            aDrops.add(tRecipe.getOutput(0));
            ++rConversions;
        }
        return rConversions;
    }

    @Override
    public void onToolCrafted(ItemStack aStack, EntityPlayer aPlayer) {
        super.onToolCrafted(aStack, aPlayer);
        try {
            GTMod.achievements.issueAchievement(aPlayer, "hammertime");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public IIconContainer getIcon(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? Textures.ItemIcons.JACKHAMMER : null;
    }

    @Override
    public IChatComponent getDeathMessage(EntityLivingBase aPlayer, EntityLivingBase aEntity) {
        return new ChatComponentText(EnumChatFormatting.RED + aEntity.func_70005_c_() + EnumChatFormatting.WHITE + " has been jackhammered into pieces by " + EnumChatFormatting.GREEN + aPlayer.func_70005_c_() + EnumChatFormatting.WHITE);
    }
}

