/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations;

import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.objects.GTRenderedTexture;
import gregtech.api.util.GTUtility;
import gtPlusPlus.core.lib.GTPPCore;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class MTEHatchNaquadah
extends MTEHatchInput {
    public final FluidStack[] mFluidsToUse = new FluidStack[3];
    public final int mFluidCapacity;
    private static final String[] aDescCache = new String[3];

    public MTEHatchNaquadah(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 6);
        this.mFluidCapacity = 32000;
        this.initHatch();
    }

    public MTEHatchNaquadah(String aName, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, 6, aDescription[0], aTextures);
        this.mFluidCapacity = 32000;
        this.initHatch();
    }

    private void initHatch() {
        if (this.mFluidsToUse[0] == null) {
            this.mFluidsToUse[0] = Materials.Naquadah.getMolten(1L);
        }
        if (this.mFluidsToUse[1] == null) {
            this.mFluidsToUse[1] = Materials.NaquadahEnriched.getMolten(1L);
        }
        if (this.mFluidsToUse[2] == null) {
            this.mFluidsToUse[2] = Materials.Naquadria.getMolten(1L);
        }
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GTRenderedTexture(Textures.BlockIcons.NAQUADAH_REACTOR_FLUID_SIDE_ACTIVE)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GTRenderedTexture(Textures.BlockIcons.NAQUADAH_REACTOR_FLUID_SIDE)};
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        if (side == aBaseMetaTileEntity.getFrontFacing() && aIndex == 0) {
            for (FluidStack f : this.mFluidsToUse) {
                if (f == null || GTUtility.getFluidForFilledItem(aStack, true).getFluid() != f.getFluid()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isFluidInputAllowed(FluidStack aFluid) {
        for (FluidStack f : this.mFluidsToUse) {
            if (f == null || aFluid.getFluid() != f.getFluid()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getCapacity() {
        return this.mFluidCapacity;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchNaquadah(this.mName, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public String[] getDescription() {
        if (aDescCache[0] == null || aDescCache[0].contains(".name") || aDescCache[0].contains("fluid.")) {
            MTEHatchNaquadah.aDescCache[0] = this.formatFluidString(this.mFluidsToUse[0]);
        }
        if (aDescCache[1] == null || aDescCache[1].contains(".name") || aDescCache[1].contains("fluid.")) {
            MTEHatchNaquadah.aDescCache[1] = this.formatFluidString(this.mFluidsToUse[1]);
        }
        if (aDescCache[2] == null || aDescCache[2].contains(".name") || aDescCache[2].contains("fluid.")) {
            MTEHatchNaquadah.aDescCache[2] = this.formatFluidString(this.mFluidsToUse[2]);
        }
        String aNaq = aDescCache[0];
        String aEnrNaq = aDescCache[1];
        String aNaquad = aDescCache[2];
        return new String[]{"Fluid Input for Multiblocks", "Capacity: " + this.getCapacity() + "L", "Accepted Fluid: " + aNaq, "Accepted Fluid: " + aEnrNaq, "Accepted Fluid: " + aNaquad, GTPPCore.GT_Tooltip.get()};
    }

    private String formatFluidString(FluidStack fluidStack) {
        String mTempMod = EnumChatFormatting.RESET.toString();
        int mLockedTemp = fluidStack.getFluid().getTemperature();
        if (mLockedTemp <= -3000) {
            mTempMod = "" + EnumChatFormatting.DARK_PURPLE;
        } else if (mLockedTemp <= -500) {
            mTempMod = "" + EnumChatFormatting.DARK_BLUE;
        } else if (mLockedTemp <= -50) {
            mTempMod = "" + EnumChatFormatting.BLUE;
        } else if (mLockedTemp >= 30 && mLockedTemp <= 300) {
            mTempMod = "" + EnumChatFormatting.AQUA;
        } else if (mLockedTemp >= 301 && mLockedTemp <= 800) {
            mTempMod = "" + EnumChatFormatting.YELLOW;
        } else if (mLockedTemp >= 801 && mLockedTemp <= 1500) {
            mTempMod = "" + EnumChatFormatting.GOLD;
        } else if (mLockedTemp >= 1501) {
            mTempMod = "" + EnumChatFormatting.RED;
        }
        return mTempMod + fluidStack.getLocalizedName();
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray;
        byte a1 = this.getActualTexture();
        byte a2 = this.getmTexturePage();
        int textureIndex = a1 | a2 << 7;
        byte texturePointer = (byte)(a1 & 0x7F);
        if (side == ForgeDirection.UP || side == ForgeDirection.DOWN) {
            ITexture g = textureIndex > 0 ? Textures.BlockIcons.casingTexturePages[a2][texturePointer] : Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1];
            return new ITexture[]{g, new GTRenderedTexture(Textures.BlockIcons.NAQUADAH_REACTOR_FLUID_TOP_ACTIVE)};
        }
        if (side != facing) {
            if (textureIndex > 0) {
                ITexture[] iTextureArray2 = new ITexture[1];
                iTextureArray = iTextureArray2;
                iTextureArray2[0] = Textures.BlockIcons.casingTexturePages[a2][texturePointer];
            } else {
                ITexture[] iTextureArray3 = new ITexture[1];
                iTextureArray = iTextureArray3;
                iTextureArray3[0] = Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1];
            }
        } else {
            iTextureArray = textureIndex > 0 ? (aActive ? this.getTexturesActive(Textures.BlockIcons.casingTexturePages[a2][texturePointer]) : this.getTexturesInactive(Textures.BlockIcons.casingTexturePages[a2][texturePointer])) : (aActive ? this.getTexturesActive(Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1]) : this.getTexturesInactive(Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1]));
        }
        return iTextureArray;
    }
}

