/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.interfaces.RunnableWithInfo;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialGenerator;
import gtPlusPlus.core.material.MaterialStack;
import gtPlusPlus.core.material.state.MaterialState;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.RecipeUtils;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGenBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeGenDustGeneration
extends RecipeGenBase {
    public static final Set<RunnableWithInfo<Material>> mRecipeGenMap = new HashSet<RunnableWithInfo<Material>>();

    public RecipeGenDustGeneration(Material M) {
        this(M, false);
    }

    public RecipeGenDustGeneration(Material M, boolean O) {
        this.toGenerate = M;
        this.disableOptional = O;
        mRecipeGenMap.add(this);
        ItemStack normalDust = M.getDust(1);
        ItemStack smallDust = M.getSmallDust(1);
        ItemStack tinyDust = M.getTinyDust(1);
        if (tinyDust != null && normalDust != null) {
            if (RecipeUtils.addShapedRecipe(tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, normalDust)) {
                Logger.INFO("9 Tiny dust to 1 Dust Recipe: " + M.getLocalizedName() + " - Success");
            } else {
                Logger.INFO("9 Tiny dust to 1 Dust Recipe: " + M.getLocalizedName() + " - Failed");
            }
            if (RecipeUtils.addShapedRecipe(normalDust, null, null, null, null, null, null, null, null, M.getTinyDust(9))) {
                Logger.INFO("9 Tiny dust from 1 Recipe: " + M.getLocalizedName() + " - Success");
            } else {
                Logger.INFO("9 Tiny dust from 1 Recipe: " + M.getLocalizedName() + " - Failed");
            }
        }
        if (smallDust != null && normalDust != null) {
            if (RecipeUtils.addShapedRecipe(smallDust, smallDust, null, smallDust, smallDust, null, null, null, null, normalDust)) {
                Logger.INFO("4 Small dust to 1 Dust Recipe: " + M.getLocalizedName() + " - Success");
            } else {
                Logger.INFO("4 Small dust to 1 Dust Recipe: " + M.getLocalizedName() + " - Failed");
            }
            if (RecipeUtils.addShapedRecipe(null, normalDust, null, null, null, null, null, null, null, M.getSmallDust(4))) {
                Logger.INFO("4 Small dust from 1 Dust Recipe: " + M.getLocalizedName() + " - Success");
            } else {
                Logger.INFO("4 Small dust from 1 Dust Recipe: " + M.getLocalizedName() + " - Failed");
            }
        }
    }

    @Override
    public void run() {
        this.generateRecipes(this.toGenerate, this.disableOptional);
    }

    private void generateRecipes(Material material, boolean disableOptional) {
        Logger.INFO("Generating Shaped Crafting recipes for " + material.getLocalizedName());
        ItemStack normalDust = material.getDust(1);
        ItemStack smallDust = material.getSmallDust(1);
        ItemStack tinyDust = material.getTinyDust(1);
        ItemStack[] inputStacks = material.getMaterialComposites();
        ItemStack outputStacks = material.getDust(material.smallestStackSizeWhenProcessing);
        if (ItemUtils.checkForInvalidItems(smallDust) && ItemUtils.checkForInvalidItems(tinyDust)) {
            RecipeGenDustGeneration.generatePackagerRecipes(material);
        }
        ItemStack ingot = material.getIngot(1);
        if (ItemUtils.checkForInvalidItems(normalDust) && ItemUtils.checkForInvalidItems(ingot)) {
            this.addFurnaceRecipe(material);
        }
        if (inputStacks == null || disableOptional) {
            return;
        }
        Logger.WARNING("mixer length: " + inputStacks.length);
        if (inputStacks.length == 0 || inputStacks.length > 4) {
            return;
        }
        Logger.WARNING(ItemUtils.getArrayStackNames(inputStacks));
        long[] inputStackSize = material.vSmallestRatio;
        Logger.WARNING("mixer is stacksizeVar null? " + (inputStackSize != null));
        if (inputStackSize == null) {
            return;
        }
        for (int x = 0; x < inputStacks.length; x = (int)((short)(x + 1))) {
            if (inputStacks[x] == null || inputStackSize[x] == 0L) continue;
            inputStacks[x].field_77994_a = (int)inputStackSize[x];
        }
        Logger.WARNING(ItemUtils.getArrayStackNames(inputStacks));
        ItemStack[] input = new ItemStack[4];
        ItemStack itemStack = inputStacks.length >= 1 ? (inputStacks[0] == null ? null : inputStacks[0]) : (input[0] = null);
        ItemStack itemStack2 = inputStacks.length >= 2 ? (inputStacks[1] == null ? null : inputStacks[1]) : (input[1] = null);
        ItemStack itemStack3 = inputStacks.length >= 3 ? (inputStacks[2] == null ? null : inputStacks[2]) : (input[2] = null);
        ItemStack itemStack4 = inputStacks.length >= 4 ? (inputStacks[3] == null ? null : inputStacks[3]) : (input[3] = null);
        if (inputStacks.length == 1) {
            input[1] = input[0];
            input[0] = GTUtility.getIntegratedCircuit(inputStacks.length + 10);
        } else if (inputStacks.length == 2) {
            input[2] = input[1];
            input[1] = input[0];
            input[0] = GTUtility.getIntegratedCircuit(inputStacks.length + 10);
        } else if (inputStacks.length == 3) {
            input[3] = input[2];
            input[2] = input[1];
            input[1] = input[0];
            input[0] = GTUtility.getIntegratedCircuit(inputStacks.length + 10);
        }
        FluidStack oxygen = GTValues.NF;
        if (material.getComposites() != null) {
            for (MaterialStack x : material.getComposites()) {
                if (material.getComposites().isEmpty() || x == null || x.getStackMaterial() == null || x.getStackMaterial().getDust(1) != null || x.getStackMaterial().getState() == MaterialState.SOLID || x.getStackMaterial().getState() == MaterialState.ORE || x.getStackMaterial().getState() == MaterialState.PLASMA) continue;
                oxygen = x.getStackMaterial().getFluidStack(1000);
                break;
            }
        }
        input = ItemUtils.cleanItemStackArray(input);
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(Arrays.asList(input));
        inputs.removeIf(Objects::isNull);
        if (oxygen == null) {
            GTValues.RA.stdBuilder().itemInputs(inputs.toArray(new ItemStack[0])).itemOutputs(outputStacks).duration((int)Math.max(material.getMass() * 2L * 1L, 1L)).eut(material.vVoltageMultiplier).addTo(RecipeMaps.mixerRecipes);
        } else {
            GTValues.RA.stdBuilder().itemInputs(inputs.toArray(new ItemStack[0])).itemOutputs(outputStacks).fluidInputs(oxygen).duration((int)Math.max(material.getMass() * 2L * 1L, 1L)).eut(material.vVoltageMultiplier).addTo(RecipeMaps.mixerRecipes);
        }
        Logger.WARNING("Dust Mixer Recipe: " + material.getLocalizedName() + " - Success");
    }

    public static boolean addMixerRecipe_Standalone(Material material) {
        ItemStack input4;
        ItemStack input3;
        ItemStack input2;
        ItemStack[] inputStacks = material.getMaterialComposites();
        ItemStack outputStacks = material.getDust(material.smallestStackSizeWhenProcessing);
        if (inputStacks == null) {
            Logger.WARNING("InputStacks == NUll - " + material.getLocalizedName());
            return false;
        }
        Logger.WARNING("mixer length: " + inputStacks.length);
        if (inputStacks.length < 1 || inputStacks.length > 4) {
            Logger.WARNING("InputStacks is out range 1-4 - " + material.getLocalizedName());
            return false;
        }
        Logger.WARNING(ItemUtils.getArrayStackNames(inputStacks));
        long[] inputStackSize = material.vSmallestRatio;
        Logger.WARNING("mixer is stacksizeVar not null? " + (inputStackSize != null));
        if (inputStackSize == null) {
            Logger.WARNING("inputStackSize == NUll - " + material.getLocalizedName());
            return true;
        }
        for (int x = 0; x < inputStacks.length; x = (int)((short)(x + 1))) {
            if (inputStacks[x] == null || inputStackSize[x] == 0L) continue;
            inputStacks[x].field_77994_a = (int)inputStackSize[x];
        }
        Logger.WARNING(ItemUtils.getArrayStackNames(inputStacks));
        ItemStack input1 = inputStacks[0];
        ItemStack itemStack = inputStacks.length >= 2 ? (input2 = inputStacks[1] == null ? null : inputStacks[1]) : (input2 = null);
        ItemStack itemStack2 = inputStacks.length >= 3 ? (input3 = inputStacks[2] == null ? null : inputStacks[2]) : (input3 = null);
        ItemStack itemStack3 = inputStacks.length >= 4 ? (input4 = inputStacks[3] == null ? null : inputStacks[3]) : (input4 = null);
        if (inputStacks.length == 1) {
            input2 = input1;
            input1 = GTUtility.getIntegratedCircuit(20);
        } else if (inputStacks.length == 2) {
            input3 = input2;
            input2 = input1;
            input1 = GTUtility.getIntegratedCircuit(20);
        } else if (inputStacks.length == 3) {
            input4 = input3;
            input3 = input2;
            input2 = input1;
            input1 = GTUtility.getIntegratedCircuit(20);
        }
        FluidStack oxygen = GTValues.NF;
        if (material.getComposites() != null) {
            int compSlot = 0;
            for (MaterialStack x : material.getComposites()) {
                if (material.getComposites().isEmpty()) {
                    ++compSlot;
                    continue;
                }
                if (x == null) {
                    ++compSlot;
                    continue;
                }
                if (x.getStackMaterial() == null) {
                    ++compSlot;
                    continue;
                }
                if (x.getStackMaterial().getDust(1) == null) {
                    ++compSlot;
                    continue;
                }
                MaterialState f = x.getStackMaterial().getState();
                if (f == MaterialState.GAS || f == MaterialState.LIQUID || f == MaterialState.PURE_LIQUID || f == MaterialState.PURE_GAS) {
                    oxygen = x.getStackMaterial().getFluidStack((int)(material.vSmallestRatio[compSlot] * 1000L));
                }
                ++compSlot;
            }
        }
        try {
            if (oxygen == null) {
                GTValues.RA.stdBuilder().itemInputs(input1, input2, input3, input4).itemOutputs(outputStacks).duration((int)Math.max(material.getMass() * 2L * 1L, 1L)).eut(material.vVoltageMultiplier).addTo(RecipeMaps.mixerRecipes);
            } else {
                GTValues.RA.stdBuilder().itemInputs(input1, input2, input3, input4).itemOutputs(outputStacks).fluidInputs(oxygen).duration((int)Math.max(material.getMass() * 2L * 1L, 1L)).eut(material.vVoltageMultiplier).addTo(RecipeMaps.mixerRecipes);
            }
            Logger.WARNING("Dust Mixer Recipe: " + material.getLocalizedName() + " - Success");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return true;
    }

    public static boolean generatePackagerRecipes(Material aMatInfo) {
        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(4, aMatInfo.getSmallDust(4)), ItemList.Schematic_Dust.get(0L, new Object[0])).itemOutputs(aMatInfo.getDust(1)).duration(100).eut(4).addTo(RecipeMaps.packagerRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(9, aMatInfo.getTinyDust(9)), ItemList.Schematic_Dust.get(0L, new Object[0])).itemOutputs(aMatInfo.getDust(1)).duration(100).eut(4).addTo(RecipeMaps.packagerRecipes);
        return true;
    }

    private void addFurnaceRecipe(Material aMatInfo) {
        ItemStack aDust = aMatInfo.getDust(1);
        try {
            if (aMatInfo.requiresBlastFurnace()) {
                ItemStack aOutput = aMatInfo.getHotIngot(1);
                if (ItemUtils.checkForInvalidItems(aOutput)) {
                    if (this.addBlastFurnaceRecipe(aMatInfo, aDust, aOutput, aMatInfo.getMeltingPointK())) {
                        Logger.MATERIALS("Successfully added a blast furnace recipe for " + aMatInfo.getLocalizedName());
                    } else {
                        Logger.MATERIALS("Failed to add a blast furnace recipe for " + aMatInfo.getLocalizedName());
                    }
                } else {
                    Logger.MATERIALS("Failed to add a blast furnace recipe for " + aMatInfo.getLocalizedName());
                }
            } else {
                ItemStack aOutput = aMatInfo.getIngot(1);
                if (ItemUtils.checkForInvalidItems(aOutput)) {
                    if (GTModHandler.addSmeltingAndAlloySmeltingRecipe(aDust, aOutput, false)) {
                        Logger.MATERIALS("Successfully added a furnace recipe for " + aMatInfo.getLocalizedName());
                    } else {
                        Logger.MATERIALS("Failed to add a furnace recipe for " + aMatInfo.getLocalizedName());
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private boolean addBlastFurnaceRecipe(Material aMatInfo, ItemStack input1, ItemStack output1, int tempRequired) {
        int timeTaken = aMatInfo.vTier <= 4 ? 25 * aMatInfo.vTier * 10 : 125 * aMatInfo.vTier * 10;
        long aVoltage = aMatInfo.vVoltageMultiplier;
        GTValues.RA.stdBuilder().itemInputs(input1).itemOutputs(output1).duration(timeTaken).eut(aVoltage).metadata(GTRecipeConstants.COIL_HEAT, tempRequired).addTo(RecipeMaps.blastFurnaceRecipes);
        return true;
    }

    static {
        MaterialGenerator.mRecipeMapsToGenerate.add(mRecipeGenMap);
    }
}

