/*
 * Decompiled with CFR 0.152.
 */
package tectech.rendering.EOH;

import cpw.mods.fml.client.FMLClientHandler;
import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import tectech.rendering.EOH.EOHTileEntitySR;

public abstract class EOHRenderingUtils {
    static final double[] BLOCK_X = new double[]{-0.5, -0.5, 0.5, 0.5, 0.5, 0.5, -0.5, -0.5};
    static final double[] BLOCK_Y = new double[]{0.5, -0.5, -0.5, 0.5, 0.5, -0.5, -0.5, 0.5};
    static final double[] BLOCK_Z = new double[]{0.5, 0.5, 0.5, 0.5, -0.5, -0.5, -0.5, -0.5};

    public static void renderStar(IItemRenderer.ItemRenderType type, Color color, int size) {
        GL11.glPushMatrix();
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
            if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
                GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
            }
        }
        EOHRenderingUtils.renderStarLayer(0, EOHTileEntitySR.STAR_LAYER_0, color, 1.0f, size);
        EOHRenderingUtils.renderStarLayer(1, EOHTileEntitySR.STAR_LAYER_1, color, 0.4f, size);
        EOHRenderingUtils.renderStarLayer(2, EOHTileEntitySR.STAR_LAYER_2, color, 0.2f, size);
        GL11.glPopMatrix();
    }

    public static void renderStar(IItemRenderer.ItemRenderType type, int size) {
        EOHRenderingUtils.renderStar(type, new Color(1.0f, 0.4f, 0.05f, 1.0f), size);
    }

    public static void renderStarLayer(int layer, ResourceLocation texture, Color color, float alpha, int size) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        if (alpha < 1.0f) {
            GL11.glBlendFunc((int)770, (int)1);
        } else {
            GL11.glBlendFunc((int)770, (int)771);
        }
        FMLClientHandler.instance().getClient().func_110434_K().func_110577_a(texture);
        float scale = 0.01f * (float)size;
        scale = (float)((double)scale * Math.pow(1.04f, layer));
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        switch (layer) {
            case 0: {
                GL11.glRotatef((float)(130L + System.currentTimeMillis() / 64L % 360L), (float)0.0f, (float)1.0f, (float)1.0f);
                break;
            }
            case 1: {
                GL11.glRotatef((float)(-49L + System.currentTimeMillis() / 64L % 360L), (float)1.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 2: {
                GL11.glRotatef((float)(67L + System.currentTimeMillis() / 64L % 360L), (float)1.0f, (float)0.0f, (float)1.0f);
            }
        }
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
        EOHTileEntitySR.starModel.renderAll();
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2896);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glPopMatrix();
    }

    public static void beginRenderingBlocksInWorld(float blockSize) {
        Tessellator tes = Tessellator.field_78398_a;
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2896);
        tes.func_78386_a(1.0f, 1.0f, 1.0f);
        tes.func_78382_b();
        GL11.glScalef((float)blockSize, (float)blockSize, (float)blockSize);
    }

    public static void endRenderingBlocksInWorld() {
        Tessellator.field_78398_a.func_78381_a();
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public static void addRenderedBlockInWorld(Block block, int meta, double x, double y, double z) {
        Tessellator tes = Tessellator.field_78398_a;
        IIcon texture = block.func_149691_a(4, meta);
        double minU = texture.func_94209_e();
        double maxU = texture.func_94212_f();
        double minV = texture.func_94206_g();
        double maxV = texture.func_94210_h();
        tes.func_78374_a(x + BLOCK_X[1], y + BLOCK_Y[1], z + BLOCK_Z[1], maxU, maxV);
        tes.func_78374_a(x + BLOCK_X[0], y + BLOCK_Y[0], z + BLOCK_Z[0], maxU, minV);
        tes.func_78374_a(x + BLOCK_X[7], y + BLOCK_Y[7], z + BLOCK_Z[7], minU, minV);
        tes.func_78374_a(x + BLOCK_X[6], y + BLOCK_Y[6], z + BLOCK_Z[6], minU, maxV);
        texture = block.func_149691_a(0, meta);
        minU = texture.func_94209_e();
        maxU = texture.func_94212_f();
        minV = texture.func_94206_g();
        maxV = texture.func_94210_h();
        tes.func_78374_a(x + BLOCK_X[5], y + BLOCK_Y[5], z + BLOCK_Z[5], maxU, minV);
        tes.func_78374_a(x + BLOCK_X[2], y + BLOCK_Y[2], z + BLOCK_Z[2], maxU, maxV);
        tes.func_78374_a(x + BLOCK_X[1], y + BLOCK_Y[1], z + BLOCK_Z[1], minU, maxV);
        tes.func_78374_a(x + BLOCK_X[6], y + BLOCK_Y[6], z + BLOCK_Z[6], minU, minV);
        texture = block.func_149691_a(2, meta);
        minU = texture.func_94209_e();
        maxU = texture.func_94212_f();
        minV = texture.func_94206_g();
        maxV = texture.func_94210_h();
        tes.func_78374_a(x + BLOCK_X[6], y + BLOCK_Y[6], z + BLOCK_Z[6], maxU, maxV);
        tes.func_78374_a(x + BLOCK_X[7], y + BLOCK_Y[7], z + BLOCK_Z[7], maxU, minV);
        tes.func_78374_a(x + BLOCK_X[4], y + BLOCK_Y[4], z + BLOCK_Z[4], minU, minV);
        tes.func_78374_a(x + BLOCK_X[5], y + BLOCK_Y[5], z + BLOCK_Z[5], minU, maxV);
        texture = block.func_149691_a(5, meta);
        minU = texture.func_94209_e();
        maxU = texture.func_94212_f();
        minV = texture.func_94206_g();
        maxV = texture.func_94210_h();
        tes.func_78374_a(x + BLOCK_X[5], y + BLOCK_Y[5], z + BLOCK_Z[5], maxU, maxV);
        tes.func_78374_a(x + BLOCK_X[4], y + BLOCK_Y[4], z + BLOCK_Z[4], maxU, minV);
        tes.func_78374_a(x + BLOCK_X[3], y + BLOCK_Y[3], z + BLOCK_Z[3], minU, minV);
        tes.func_78374_a(x + BLOCK_X[2], y + BLOCK_Y[2], z + BLOCK_Z[2], minU, maxV);
        texture = block.func_149691_a(1, meta);
        minU = texture.func_94209_e();
        maxU = texture.func_94212_f();
        minV = texture.func_94206_g();
        maxV = texture.func_94210_h();
        tes.func_78374_a(x + BLOCK_X[3], y + BLOCK_Y[3], z + BLOCK_Z[3], maxU, maxV);
        tes.func_78374_a(x + BLOCK_X[4], y + BLOCK_Y[4], z + BLOCK_Z[4], maxU, minV);
        tes.func_78374_a(x + BLOCK_X[7], y + BLOCK_Y[7], z + BLOCK_Z[7], minU, minV);
        tes.func_78374_a(x + BLOCK_X[0], y + BLOCK_Y[0], z + BLOCK_Z[0], minU, maxV);
        texture = block.func_149691_a(3, meta);
        minU = texture.func_94209_e();
        maxU = texture.func_94212_f();
        minV = texture.func_94206_g();
        maxV = texture.func_94210_h();
        tes.func_78374_a(x + BLOCK_X[2], y + BLOCK_Y[2], z + BLOCK_Z[2], maxU, maxV);
        tes.func_78374_a(x + BLOCK_X[3], y + BLOCK_Y[3], z + BLOCK_Z[3], maxU, minV);
        tes.func_78374_a(x + BLOCK_X[0], y + BLOCK_Y[0], z + BLOCK_Z[0], minU, minV);
        tes.func_78374_a(x + BLOCK_X[1], y + BLOCK_Y[1], z + BLOCK_Z[1], minU, maxV);
    }

    public static void renderBlockInWorld(Block block, int meta, float blockSize) {
        EOHRenderingUtils.beginRenderingBlocksInWorld(blockSize);
        EOHRenderingUtils.addRenderedBlockInWorld(block, meta, 0.0, 0.0, 0.0);
        EOHRenderingUtils.endRenderingBlocksInWorld();
    }

    public static void renderOuterSpaceShell() {
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        FMLClientHandler.instance().getClient().func_110434_K().func_110577_a(new ResourceLocation("tectech", "models/spaceLayer.png"));
        float scale = 0.175f;
        GL11.glScalef((float)0.175f, (float)0.175f, (float)0.175f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        EOHTileEntitySR.spaceModel.renderAll();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }
}

