/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.casing;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Textures;
import gregtech.api.objects.GTCopiedBlockTexture;
import gregtech.api.util.GTLanguageManager;
import gregtech.common.blocks.BlockCasingsAbstract;
import gregtech.common.blocks.MaterialCasings;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import tectech.thing.CustomItemList;
import tectech.thing.casing.ItemCasingsGodforge;

public class BlockGodforgeCasings
extends BlockCasingsAbstract {
    private static IIcon GodforgeTrim;
    private static IIcon GodforgeInner;
    private static IIcon GodforgeSupport;
    private static IIcon GodforgeOuter;
    private static IIcon GodforgeEnergy;
    private static IIcon GravitonModulatorT1;
    private static IIcon GravitonModulatorT2;
    private static IIcon GravitonModulatorT3;
    private static IIcon PhononConduit;
    private static final byte START_INDEX = 64;

    public BlockGodforgeCasings() {
        super(ItemCasingsGodforge.class, "gt.godforgecasing", MaterialCasings.INSTANCE);
        for (int b = 0; b < 16; b = (int)((byte)(b + 1))) {
            Textures.BlockIcons.casingTexturePages[7][b + 64] = new GTCopiedBlockTexture(this, 6, b);
        }
        GTLanguageManager.addStringLocalization(this.func_149739_a() + ".0.name", "Singularity Reinforced Stellar Shielding Casing");
        GTLanguageManager.addStringLocalization(this.func_149739_a() + ".1.name", "Celestial Matter Guidance Casing");
        GTLanguageManager.addStringLocalization(this.func_149739_a() + ".2.name", "Boundless Gravitationally Severed Structure Casing");
        GTLanguageManager.addStringLocalization(this.func_149739_a() + ".3.name", "Transcendentally Amplified Magnetic Confinement Casing");
        GTLanguageManager.addStringLocalization(this.func_149739_a() + ".4.name", "Stellar Energy Siphon Casing");
        GTLanguageManager.addStringLocalization(this.func_149739_a() + ".5.name", "Remote Graviton Flow Modulator");
        GTLanguageManager.addStringLocalization(this.func_149739_a() + ".6.name", "Medial Graviton Flow Modulator");
        GTLanguageManager.addStringLocalization(this.func_149739_a() + ".7.name", "Central Graviton Flow Modulator");
        GTLanguageManager.addStringLocalization(this.func_149739_a() + ".8.name", "Harmonic Phonon Transmission Conduit");
        CustomItemList.Godforge_SingularityShieldingCasing.set(new ItemStack((Block)this, 1, 0));
        CustomItemList.Godforge_GuidanceCasing.set(new ItemStack((Block)this, 1, 1));
        CustomItemList.Godforge_BoundlessStructureCasing.set(new ItemStack((Block)this, 1, 2));
        CustomItemList.Godforge_MagneticConfinementCasing.set(new ItemStack((Block)this, 1, 3));
        CustomItemList.Godforge_StellarEnergySiphonCasing.set(new ItemStack((Block)this, 1, 4));
        CustomItemList.Godforge_GravitonFlowModulatorTier1.set(new ItemStack((Block)this, 1, 5));
        CustomItemList.Godforge_GravitonFlowModulatorTier2.set(new ItemStack((Block)this, 1, 6));
        CustomItemList.Godforge_GravitonFlowModulatorTier3.set(new ItemStack((Block)this, 1, 7));
        CustomItemList.Godforge_HarmonicPhononTransmissionConduit.set(new ItemStack((Block)this, 1, 8));
    }

    @Override
    public void func_149651_a(IIconRegister aIconRegister) {
        GodforgeTrim = aIconRegister.func_94245_a("gregtech:iconsets/GODFORGE_TRIM");
        GodforgeInner = aIconRegister.func_94245_a("gregtech:iconsets/GODFORGE_INNER");
        GodforgeSupport = aIconRegister.func_94245_a("gregtech:iconsets/GODFORGE_SUPPORT");
        GodforgeOuter = aIconRegister.func_94245_a("gregtech:iconsets/GRAVITON_TOP_BOTTOM");
        GodforgeEnergy = aIconRegister.func_94245_a("gregtech:iconsets/GODFORGE_ENERGY");
        GravitonModulatorT1 = aIconRegister.func_94245_a("gregtech:iconsets/GRAVITON_CASING_2");
        GravitonModulatorT2 = aIconRegister.func_94245_a("gregtech:iconsets/GRAVITON_CASING_1");
        GravitonModulatorT3 = aIconRegister.func_94245_a("gregtech:iconsets/GRAVITON_CASING_0");
        PhononConduit = aIconRegister.func_94245_a("gregtech:iconsets/PHONON_CONDUIT");
    }

    public IIcon func_149691_a(int aSide, int aMeta) {
        switch (aMeta) {
            case 0: {
                return GodforgeTrim;
            }
            case 1: {
                return GodforgeInner;
            }
            case 2: {
                return GodforgeSupport;
            }
            case 3: {
                return GodforgeOuter;
            }
            case 4: {
                return GodforgeEnergy;
            }
            case 5: {
                if (aSide < 2) {
                    return GodforgeOuter;
                }
                return GravitonModulatorT1;
            }
            case 6: {
                if (aSide < 2) {
                    return GodforgeOuter;
                }
                return GravitonModulatorT2;
            }
            case 7: {
                if (aSide < 2) {
                    return GodforgeOuter;
                }
                return GravitonModulatorT3;
            }
            case 8: {
                return PhononConduit;
            }
        }
        return Textures.BlockIcons.MACHINE_CASING_SOLID_STEEL.getIcon();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess aWorld, int xCoord, int yCoord, int zCoord, int aSide) {
        int tMeta = aWorld.func_72805_g(xCoord, yCoord, zCoord);
        return this.func_149691_a(aSide, tMeta);
    }

    public void func_149666_a(Item aItem, CreativeTabs par2CreativeTabs, List aList) {
        for (int i = 0; i <= 8; ++i) {
            aList.add(new ItemStack(aItem, 1, i));
        }
    }
}

