/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.multi.base;

import java.util.ArrayList;
import tectech.thing.metaTileEntity.multi.base.INameFunction;
import tectech.thing.metaTileEntity.multi.base.IStatusFunction;
import tectech.thing.metaTileEntity.multi.base.LedStatus;
import tectech.thing.metaTileEntity.multi.base.TTMultiblockBase;

public class Parameters {
    private static final IStatusFunction<?> LED_STATUS_FUNCTION_DEFAULT = (b, p) -> LedStatus.STATUS_UNDEFINED;
    private static final INameFunction<?> NAME_FUNCTION_DEFAULT = (b, p) -> "Undefined";
    final Group[] groups = new Group[10];
    double[] iParamsIn = new double[20];
    double[] iParamsOut = new double[20];
    final ArrayList<Group.ParameterIn> parameterInArrayList = new ArrayList();
    final ArrayList<Group.ParameterOut> parameterOutArrayList = new ArrayList();
    LedStatus[] eParamsInStatus = LedStatus.makeArray(20, LedStatus.STATUS_UNUSED);
    LedStatus[] eParamsOutStatus = LedStatus.makeArray(20, LedStatus.STATUS_UNUSED);
    private final TTMultiblockBase parent;

    double getIn(int hatchNo, int parameterId) {
        return this.iParamsIn[hatchNo + 10 * parameterId];
    }

    double getOut(int hatchNo, int parameterId) {
        return this.iParamsOut[hatchNo + 10 * parameterId];
    }

    LedStatus getStatusIn(int hatchNo, int parameterId) {
        return this.eParamsInStatus[hatchNo + 10 * parameterId];
    }

    LedStatus getStatusOut(int hatchNo, int parameterId) {
        return this.eParamsOutStatus[hatchNo + 10 * parameterId];
    }

    Parameters(TTMultiblockBase parent) {
        this.parent = parent;
    }

    public boolean trySetParameters(int hatch, double parameter0, double parameter1) {
        Group p = this.groups[hatch];
        if (this.parent.mMaxProgresstime <= 0 || p != null && p.updateWhileRunning) {
            this.iParamsIn[hatch] = parameter0;
            this.iParamsIn[hatch + 10] = parameter1;
            return true;
        }
        return false;
    }

    public boolean trySetParameters(int hatchNo, int parameterId, double parameter) {
        Group p = this.groups[hatchNo];
        if (this.parent.mMaxProgresstime <= 0 || p != null && p.updateWhileRunning) {
            this.iParamsIn[hatchNo + 10 * parameterId] = parameter;
            return true;
        }
        return false;
    }

    public void setToDefaults(int hatch, boolean defaultIn, boolean defaultOut) {
        Group p = this.groups[hatch];
        if (p == null) {
            if (defaultIn) {
                this.iParamsIn[hatch] = 0.0;
                this.iParamsIn[hatch + 10] = 0.0;
            }
            if (defaultOut) {
                this.iParamsOut[hatch] = 0.0;
                this.iParamsOut[hatch + 10] = 0.0;
            }
        } else {
            p.setToDefaults(defaultIn, defaultOut);
        }
    }

    public void setToDefaults(boolean defaultIn, boolean defaultOut) {
        for (int hatch = 0; hatch < 10; ++hatch) {
            this.setToDefaults(hatch, defaultIn, defaultOut);
        }
    }

    public Group getGroup(int hatchNo, boolean updateWhileRunning) {
        return this.groups[hatchNo] != null ? this.groups[hatchNo] : new Group(hatchNo, updateWhileRunning);
    }

    public Group getGroup(int hatchNo) {
        return this.groups[hatchNo] != null ? this.groups[hatchNo] : new Group(hatchNo, false);
    }

    public class Group {
        private final int hatchNo;
        public final ParameterIn[] parameterIn = new ParameterIn[2];
        public final ParameterOut[] parameterOut = new ParameterOut[2];
        public boolean updateWhileRunning;

        private Group(int hatchNo, boolean updateWhileRunning) {
            if (hatchNo < 0 || hatchNo >= 10) {
                throw new IllegalArgumentException("Hatch id must be in 0 to 9 range");
            }
            this.hatchNo = hatchNo;
            this.updateWhileRunning = updateWhileRunning;
            Parameters.this.groups[hatchNo] = this;
        }

        public ParameterIn makeInParameter(int paramID, double defaultValue, INameFunction<?> name, IStatusFunction<?> status) {
            return new ParameterIn(paramID, defaultValue, name, status);
        }

        public ParameterOut makeOutParameter(int paramID, double defaultValue, INameFunction<?> name, IStatusFunction<?> status) {
            return new ParameterOut(paramID, defaultValue, name, status);
        }

        public void setToDefaults(boolean defaultIn, boolean defaultOut) {
            if (defaultIn) {
                if (this.parameterIn[0] != null) {
                    this.parameterIn[0].setDefault();
                } else {
                    Parameters.this.iParamsIn[this.hatchNo] = 0.0;
                }
                if (this.parameterIn[1] != null) {
                    this.parameterIn[1].setDefault();
                } else {
                    Parameters.this.iParamsIn[this.hatchNo + 10] = 0.0;
                }
            }
            if (defaultOut) {
                if (this.parameterOut[0] != null) {
                    this.parameterOut[0].setDefault();
                } else {
                    Parameters.this.iParamsOut[this.hatchNo] = 0.0;
                }
                if (this.parameterOut[1] != null) {
                    this.parameterOut[1].setDefault();
                } else {
                    Parameters.this.iParamsOut[this.hatchNo + 10] = 0.0;
                }
            }
        }

        public class ParameterIn
        implements IParameter {
            public final int id;
            public final double defaultValue;
            IStatusFunction status;
            INameFunction name;

            private ParameterIn(int paramID, double defaultValue, INameFunction<?> name, IStatusFunction<?> status) {
                this.name = name == null ? NAME_FUNCTION_DEFAULT : name;
                this.id = Group.this.hatchNo + 10 * paramID;
                if (paramID < 0 || paramID > 2) {
                    throw new IllegalArgumentException("Parameter id must be in 0 to 1 range");
                }
                if (Group.this.parameterIn[paramID] != null) {
                    throw new IllegalArgumentException("Parameter id already occupied");
                }
                this.defaultValue = defaultValue;
                this.status = status == null ? LED_STATUS_FUNCTION_DEFAULT : status;
                Parameters.this.parameterInArrayList.add(this);
                Group.this.parameterIn[paramID] = this;
            }

            void setDefault() {
                this.set(this.defaultValue);
            }

            @Override
            public double get() {
                return Parameters.this.iParamsIn[this.id];
            }

            void set(double value) {
                Parameters.this.iParamsIn[this.id] = value;
            }

            @Override
            public double getDefault() {
                return this.defaultValue;
            }

            @Override
            public void updateStatus() {
                Parameters.this.eParamsInStatus[this.id] = this.status.apply(Parameters.this.parent, this);
            }

            @Override
            public LedStatus getStatus(boolean update) {
                if (update) {
                    this.updateStatus();
                }
                return Parameters.this.eParamsInStatus[this.id];
            }

            @Override
            public String getBrief() {
                return this.name.apply(Parameters.this.parent, this);
            }

            @Override
            public int id() {
                return this.id;
            }

            @Override
            public int hatchId() {
                return this.id % 10;
            }

            @Override
            public int parameterId() {
                return this.id / 10;
            }
        }

        public class ParameterOut
        implements IParameter {
            public final int id;
            public final double defaultValue;
            IStatusFunction status;
            INameFunction name;

            private ParameterOut(int paramID, double defaultValue, INameFunction<?> name, IStatusFunction<?> status) {
                INameFunction<?> iNameFunction = this.name = name == null ? NAME_FUNCTION_DEFAULT : name;
                if (paramID < 0 || paramID > 2) {
                    throw new IllegalArgumentException("Parameter id must be in 0 to 1 range");
                }
                if (Group.this.parameterOut[paramID] != null) {
                    throw new IllegalArgumentException("Parameter id already occupied");
                }
                this.id = Group.this.hatchNo + 10 * paramID;
                this.defaultValue = defaultValue;
                this.status = status == null ? LED_STATUS_FUNCTION_DEFAULT : status;
                Parameters.this.parameterOutArrayList.add(this);
                Group.this.parameterOut[paramID] = this;
            }

            void setDefault() {
                this.set(this.defaultValue);
            }

            @Override
            public double get() {
                return Parameters.this.iParamsOut[this.id];
            }

            @Override
            public double getDefault() {
                return this.defaultValue;
            }

            public void set(double value) {
                Parameters.this.iParamsOut[this.id] = value;
            }

            @Override
            public void updateStatus() {
                Parameters.this.eParamsOutStatus[this.id] = this.status.apply(Parameters.this.parent, this);
            }

            @Override
            public LedStatus getStatus(boolean update) {
                if (update) {
                    this.updateStatus();
                }
                return Parameters.this.eParamsOutStatus[this.id];
            }

            @Override
            public String getBrief() {
                return this.name.apply(Parameters.this.parent, this);
            }

            @Override
            public int id() {
                return this.id;
            }

            @Override
            public int hatchId() {
                return this.id % 10;
            }

            @Override
            public int parameterId() {
                return this.id / 10;
            }
        }
    }

    public static interface IParameter {
        public double get();

        public double getDefault();

        public void updateStatus();

        public LedStatus getStatus(boolean var1);

        public int id();

        public int hatchId();

        public int parameterId();

        public String getBrief();
    }
}

