/*
 * Decompiled with CFR 0.152.
 */
package bartworks.common.loaders;

import bartworks.API.recipe.DynamicGTRecipe;
import bartworks.common.loaders.ElectricImplosionCompressorRecipes;
import bartworks.system.material.Werkstoff;
import bartworks.system.material.WerkstoffLoader;
import bartworks.util.BWUtil;
import bartworks.util.log.DebugLog;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.registry.GameRegistry;
import gnu.trove.map.hash.TObjectDoubleHashMap;
import gregtech.api.enums.Element;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMapBackend;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;

public class StaticRecipeChangeLoaders {
    private static TObjectDoubleHashMap<Materials> gtEbfGasRecipeTimeMultipliers = null;
    private static TObjectDoubleHashMap<Materials> gtEbfGasRecipeConsumptionMultipliers = null;
    public static final List<ItemStack> whitelistForEBFNoGasRecipeDontCheckItemData = Collections.singletonList(GTModHandler.getModItem(Mods.TinkerConstruct.ID, "materials", 1L, 12));

    private StaticRecipeChangeLoaders() {
    }

    public static void addEBFGasRecipes() {
        if (gtEbfGasRecipeTimeMultipliers == null) {
            gtEbfGasRecipeTimeMultipliers = new TObjectDoubleHashMap(10, 0.5f, -1.0);
            gtEbfGasRecipeTimeMultipliers.put((Object)Materials.Nitrogen, 1.0);
            gtEbfGasRecipeTimeMultipliers.put((Object)Materials.Helium, 0.9);
            gtEbfGasRecipeTimeMultipliers.put((Object)Materials.Argon, 0.8);
            gtEbfGasRecipeTimeMultipliers.put((Object)Materials.Radon, 0.7);
        }
        if (gtEbfGasRecipeConsumptionMultipliers == null) {
            gtEbfGasRecipeConsumptionMultipliers = new TObjectDoubleHashMap(10, 0.5f, 1.0);
            gtEbfGasRecipeConsumptionMultipliers.put((Object)Materials.Nitrogen, 1.0);
            gtEbfGasRecipeConsumptionMultipliers.put((Object)Materials.Helium, 1.0);
            gtEbfGasRecipeConsumptionMultipliers.put((Object)Materials.Argon, 0.85);
            gtEbfGasRecipeConsumptionMultipliers.put((Object)Materials.Radon, 0.7);
        }
        ArrayListMultimap<SubTag, GTRecipe> toChange = StaticRecipeChangeLoaders.getRecipesToChange(WerkstoffLoader.NOBLE_GAS, WerkstoffLoader.ANAEROBE_GAS);
        StaticRecipeChangeLoaders.editRecipes(toChange, StaticRecipeChangeLoaders.getNoGasItems(toChange));
    }

    public static void unificationRecipeEnforcer() {
        ArrayList<GTRecipe> toRemove = new ArrayList<GTRecipe>();
        OrePrefixes[] OREPREFIX_VALUES = OrePrefixes.values();
        for (Werkstoff werkstoff : Werkstoff.werkstoffHashSet) {
            StaticRecipeChangeLoaders.runMaterialLinker(werkstoff);
            if (!werkstoff.getGenerationFeatures().enforceUnification) continue;
            HashSet<String> oreDictNames = new HashSet<String>(werkstoff.getADDITIONAL_OREDICT());
            oreDictNames.add(werkstoff.getVarName());
            StaticRecipeChangeLoaders.runMoltenUnificationEnfocement(werkstoff);
            StaticRecipeChangeLoaders.runUnficationDeleter(werkstoff);
            for (String s : oreDictNames) {
                for (OrePrefixes prefixes : OREPREFIX_VALUES) {
                    String fullOreName;
                    List ores;
                    if (!werkstoff.hasItemType(prefixes) || (ores = OreDictionary.getOres((String)(fullOreName = (Object)((Object)prefixes) + s), (boolean)false)).size() <= 1) continue;
                    for (ItemStack toReplace : ores) {
                        ItemStack replacement = werkstoff.get(prefixes);
                        if (toReplace == null || GTUtility.areStacksEqual(toReplace, replacement) || replacement == null || replacement.func_77973_b() == null) continue;
                        for (RecipeMap<?> map : RecipeMap.ALL_RECIPE_MAPS.values()) {
                            toRemove.clear();
                            block5: for (GTRecipe recipe : map.getAllRecipes()) {
                                ItemStack specialItemStack;
                                int i;
                                boolean removal = map.equals(RecipeMaps.fluidExtractionRecipes) || map.equals(RecipeMaps.fluidSolidifierRecipes);
                                for (i = 0; i < recipe.mInputs.length; ++i) {
                                    if (!GTUtility.areStacksEqual(recipe.mInputs[i], toReplace)) continue;
                                    if (removal) {
                                        toRemove.add(recipe);
                                        continue block5;
                                    }
                                    recipe.mInputs[i] = GTUtility.copyAmount(recipe.mInputs[i].field_77994_a, replacement);
                                }
                                for (i = 0; i < recipe.mOutputs.length; ++i) {
                                    if (!GTUtility.areStacksEqual(recipe.mOutputs[i], toReplace)) continue;
                                    if (removal) {
                                        toRemove.add(recipe);
                                        continue block5;
                                    }
                                    recipe.mOutputs[i] = GTUtility.copyAmount(recipe.mOutputs[i].field_77994_a, replacement);
                                }
                                Object object = recipe.mSpecialItems;
                                if (!(object instanceof ItemStack) || !GTUtility.areStacksEqual(specialItemStack = (ItemStack)object, toReplace)) continue;
                                if (removal) {
                                    toRemove.add(recipe);
                                    continue;
                                }
                                recipe.mSpecialItems = GTUtility.copyAmount(specialItemStack.field_77994_a, replacement);
                            }
                            ((RecipeMapBackend)map.getBackend()).removeRecipes(toRemove);
                        }
                    }
                }
            }
        }
    }

    private static void runMoltenUnificationEnfocement(Werkstoff werkstoff) {
        if (werkstoff.getGenerationFeatures().enforceUnification && werkstoff.hasItemType(OrePrefixes.cellMolten)) {
            try {
                FluidContainerRegistry.FluidContainerData data = new FluidContainerRegistry.FluidContainerData(new FluidStack(Objects.requireNonNull((Fluid)WerkstoffLoader.molten.get((Object)werkstoff)), 144), werkstoff.get(OrePrefixes.cellMolten), Materials.Empty.getCells(1));
                Field f = GTUtility.class.getDeclaredField("sFilledContainerToData");
                f.setAccessible(true);
                Map sFilledContainerToData = (Map)f.get(null);
                HashSet toremFilledContainerToData = new HashSet();
                ItemStack toReplace = null;
                for (Map.Entry entry : sFilledContainerToData.entrySet()) {
                    String MODID = GameRegistry.findUniqueIdentifierFor((Item)data.filledContainer.func_77973_b()).modId;
                    if ("bartworks".equals(MODID) || "bartworkscrossmod".equals(MODID) || !((FluidContainerRegistry.FluidContainerData)entry.getValue()).fluid.equals((Object)data.fluid) || ((FluidContainerRegistry.FluidContainerData)entry.getValue()).filledContainer.equals(data.filledContainer)) continue;
                    toReplace = ((FluidContainerRegistry.FluidContainerData)entry.getValue()).filledContainer;
                    toremFilledContainerToData.add(entry);
                }
                sFilledContainerToData.entrySet().removeAll(toremFilledContainerToData);
                HashSet<GTRecipe> toremRecipeList = new HashSet<GTRecipe>();
                if (toReplace != null) {
                    for (RecipeMap<?> map : RecipeMap.ALL_RECIPE_MAPS.values()) {
                        toremRecipeList.clear();
                        for (GTRecipe recipe : map.getAllRecipes()) {
                            for (ItemStack mInput : recipe.mInputs) {
                                if (!GTUtility.areStacksEqual(mInput, toReplace)) continue;
                                toremRecipeList.add(recipe);
                            }
                            for (ItemStack mOutput : recipe.mOutputs) {
                                if (!GTUtility.areStacksEqual(mOutput, toReplace)) continue;
                                toremRecipeList.add(recipe);
                                if (map != RecipeMaps.fluidCannerRecipes || !GTUtility.areStacksEqual(mOutput, data.filledContainer) || recipe.mFluidInputs[0].equals((Object)data.fluid)) continue;
                                toremRecipeList.add(recipe);
                            }
                            if (!(recipe.mSpecialItems instanceof ItemStack) || !GTUtility.areStacksEqual((ItemStack)recipe.mSpecialItems, toReplace)) continue;
                            toremRecipeList.add(recipe);
                        }
                        ((RecipeMapBackend)map.getBackend()).removeRecipes(toremRecipeList);
                    }
                }
                GTUtility.addFluidContainerData(data);
            }
            catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    private static void runUnficationDeleter(Werkstoff werkstoff) {
        if (werkstoff.getType() == Werkstoff.Types.ELEMENT && werkstoff.getBridgeMaterial() != null && Element.get(werkstoff.getToolTip()) != Element._NULL) {
            werkstoff.getBridgeMaterial().mElement = Element.get(werkstoff.getToolTip());
            Element.get((String)werkstoff.getToolTip()).mLinkedMaterials = new ArrayList();
            Element.get((String)werkstoff.getToolTip()).mLinkedMaterials.add(werkstoff.getBridgeMaterial());
        }
        for (OrePrefixes prefixes : OrePrefixes.values()) {
            if (!werkstoff.hasItemType(prefixes)) continue;
            GTOreDictUnificator.set(prefixes, werkstoff.getBridgeMaterial(), werkstoff.get(prefixes), true, true);
            for (ItemStack stack : OreDictionary.getOres((String)((Object)((Object)prefixes) + werkstoff.getVarName()))) {
                GTOreDictUnificator.addAssociation(prefixes, werkstoff.getBridgeMaterial(), stack, false);
                GTOreDictUnificator.getAssociation((ItemStack)stack).mUnificationTarget = werkstoff.get(prefixes);
            }
        }
    }

    private static void runMaterialLinker(Werkstoff werkstoff) {
        if (werkstoff.getType() == Werkstoff.Types.ELEMENT && werkstoff.getBridgeMaterial() != null && Element.get(werkstoff.getToolTip()) != Element._NULL) {
            werkstoff.getBridgeMaterial().mElement = Element.get(werkstoff.getToolTip());
            Element.get((String)werkstoff.getToolTip()).mLinkedMaterials = new ArrayList();
            Element.get((String)werkstoff.getToolTip()).mLinkedMaterials.add(werkstoff.getBridgeMaterial());
        }
        for (OrePrefixes prefixes : OrePrefixes.values()) {
            if (!werkstoff.hasItemType(prefixes) || werkstoff.getBridgeMaterial() == null) continue;
            GTOreDictUnificator.set(prefixes, werkstoff.getBridgeMaterial(), werkstoff.get(prefixes), true, true);
            for (ItemStack stack : OreDictionary.getOres((String)((Object)((Object)prefixes) + werkstoff.getVarName()))) {
                GTOreDictUnificator.addAssociation(prefixes, werkstoff.getBridgeMaterial(), stack, false);
            }
        }
    }

    private static ArrayListMultimap<SubTag, GTRecipe> getRecipesToChange(SubTag ... GasTags) {
        ArrayListMultimap toAdd = ArrayListMultimap.create();
        for (GTRecipe recipe : RecipeMaps.blastFurnaceRecipes.getAllRecipes()) {
            Materials mat;
            if (recipe.mFluidInputs == null || recipe.mFluidInputs.length <= 0 || (mat = StaticRecipeChangeLoaders.getMaterialFromInputFluid(recipe)) == Materials._NULL) continue;
            for (SubTag tag : GasTags) {
                if (!mat.contains(tag)) continue;
                DebugLog.log("Found EBF Recipe to change, Output:" + BWUtil.translateGTItemStack(recipe.mOutputs[0]));
                toAdd.put((Object)tag, (Object)recipe);
            }
        }
        return toAdd;
    }

    private static HashSet<ItemStack> getNoGasItems(ArrayListMultimap<SubTag, GTRecipe> base) {
        HashSet<ItemStack> toAdd = new HashSet<ItemStack>();
        ArrayListMultimap repToAdd = ArrayListMultimap.create();
        for (GTRecipe recipe : RecipeMaps.blastFurnaceRecipes.getAllRecipes()) {
            for (SubTag tag : base.keySet()) {
                block2: for (GTRecipe baseRe : base.get((Object)tag)) {
                    if (recipe.mInputs.length != baseRe.mInputs.length || recipe.mOutputs.length != baseRe.mOutputs.length) continue;
                    for (int i = 0; i < recipe.mInputs.length; ++i) {
                        ItemStack tmpInput = recipe.mInputs[i];
                        if (recipe.mFluidInputs != null && recipe.mFluidInputs.length != 0 || !whitelistForEBFNoGasRecipeDontCheckItemData.stream().anyMatch(s -> GTUtility.areStacksEqual(s, tmpInput)) && (!BWUtil.checkStackAndPrefix(recipe.mInputs[i]) || !BWUtil.checkStackAndPrefix(baseRe.mInputs[i]) || !GTOreDictUnificator.getAssociation((ItemStack)recipe.mInputs[i]).mMaterial.mMaterial.equals(GTOreDictUnificator.getAssociation((ItemStack)baseRe.mInputs[i]).mMaterial.mMaterial) || !GTUtility.areStacksEqual(recipe.mOutputs[0], baseRe.mOutputs[0]))) continue;
                        toAdd.add(recipe.mOutputs[0]);
                        repToAdd.put((Object)tag, (Object)recipe);
                        continue block2;
                    }
                }
            }
        }
        base.putAll((Multimap)repToAdd);
        return toAdd;
    }

    private static int transformEBFGasRecipeTime(int originalDuration, long originalGasProtons, long newGasProtons) {
        double protonTerm = (double)originalGasProtons * (newGasProtons >= originalGasProtons ? 1.0 : 2.75) - (double)newGasProtons;
        return Math.max(1, (int)((double)originalDuration / 200.0 * Math.max(200.0 + protonTerm, 1.0)));
    }

    private static int transformEBFGasRecipeTime(GTRecipe recipe, Materials originalGas, Materials newGas) {
        double newEbfMul = gtEbfGasRecipeTimeMultipliers.get((Object)newGas);
        double originalEbfMul = gtEbfGasRecipeTimeMultipliers.get((Object)originalGas);
        if (newEbfMul < 0.0 || originalEbfMul < 0.0) {
            return StaticRecipeChangeLoaders.transformEBFGasRecipeTime(recipe.mDuration, originalGas.getProtons(), newGas.getProtons());
        }
        return Math.max(1, (int)((double)recipe.mDuration * newEbfMul / originalEbfMul));
    }

    private static int transformEBFGasRecipeTime(GTRecipe recipe, Materials originalGas, Werkstoff newGas) {
        double newEbfMul = newGas.getStats().getEbfGasRecipeTimeMultiplier();
        double originalEbfMul = gtEbfGasRecipeTimeMultipliers.get((Object)originalGas);
        if (newEbfMul < 0.0 || originalEbfMul < 0.0) {
            return StaticRecipeChangeLoaders.transformEBFGasRecipeTime(recipe.mDuration, originalGas.getProtons(), newGas.getStats().getProtons());
        }
        return Math.max(1, (int)((double)recipe.mDuration * newEbfMul / originalEbfMul));
    }

    private static int transformEBFNoGasRecipeTime(GTRecipe recipe, Materials originalGas) {
        return StaticRecipeChangeLoaders.transformEBFGasRecipeTime(recipe.mDuration, originalGas.getProtons(), 0L);
    }

    private static void editEBFMaterialRecipes(SubTag GasTag, GTRecipe recipe, Materials originalGas, HashSet<GTRecipe> toAdd) {
        for (Materials newGas : Materials.values()) {
            if (!newGas.contains(GasTag)) continue;
            int time = StaticRecipeChangeLoaders.transformEBFGasRecipeTime(recipe, originalGas, newGas);
            int gasAmount = Math.max(1, (int)Math.round((double)recipe.mFluidInputs[0].amount * gtEbfGasRecipeConsumptionMultipliers.get((Object)newGas)));
            if (recipe.mFluidInputs != null && recipe.mFluidInputs.length == 1 && recipe.mFluidInputs[0].isFluidEqual(newGas.getGas(0L))) {
                toAdd.add(new DynamicGTRecipe(false, recipe.mInputs, recipe.mOutputs, recipe.mSpecialItems, recipe.mChances, new FluidStack[]{newGas.getGas(gasAmount)}, recipe.mFluidOutputs, time, recipe.mEUt, recipe.mSpecialValue, recipe));
                continue;
            }
            toAdd.add(new GTRecipe(false, recipe.mInputs, recipe.mOutputs, recipe.mSpecialItems, recipe.mChances, new FluidStack[]{newGas.getGas(gasAmount)}, recipe.mFluidOutputs, time, recipe.mEUt, recipe.mSpecialValue));
        }
    }

    private static void editEBFWerkstoffRecipes(SubTag GasTag, GTRecipe recipe, Materials originalGas, HashSet<GTRecipe> toAdd) {
        for (Werkstoff newGas : Werkstoff.werkstoffHashMap.values()) {
            if (!newGas.contains(GasTag)) continue;
            int time = StaticRecipeChangeLoaders.transformEBFGasRecipeTime(recipe, originalGas, newGas);
            int gasAmount = Math.max(1, (int)Math.round((double)recipe.mFluidInputs[0].amount * newGas.getStats().getEbfGasRecipeConsumedAmountMultiplier()));
            if (recipe.mFluidInputs != null && recipe.mFluidInputs.length == 1 && recipe.mFluidInputs[0].isFluidEqual(new FluidStack(Objects.requireNonNull((Fluid)WerkstoffLoader.fluids.get((Object)newGas)), 0))) {
                toAdd.add(new DynamicGTRecipe(false, recipe.mInputs, recipe.mOutputs, recipe.mSpecialItems, recipe.mChances, new FluidStack[]{new FluidStack(Objects.requireNonNull((Fluid)WerkstoffLoader.fluids.get((Object)newGas)), gasAmount)}, recipe.mFluidOutputs, time, recipe.mEUt, recipe.mSpecialValue, recipe));
                continue;
            }
            toAdd.add(new GTRecipe(false, recipe.mInputs, recipe.mOutputs, recipe.mSpecialItems, recipe.mChances, new FluidStack[]{new FluidStack(Objects.requireNonNull((Fluid)WerkstoffLoader.fluids.get((Object)newGas)), gasAmount)}, recipe.mFluidOutputs, time, recipe.mEUt, recipe.mSpecialValue));
        }
    }

    private static void editEBFNoGasRecipes(GTRecipe recipe, Materials originalGas, HashSet<GTRecipe> toAdd, HashSet<ItemStack> noGas) {
        for (ItemStack is : noGas) {
            int circuitConfiguration = 1;
            if (!GTUtility.areStacksEqual(is, recipe.mOutputs[0])) continue;
            ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(recipe.mInputs.length);
            for (ItemStack stack : recipe.mInputs) {
                if (GTUtility.areStacksEqual(GTUtility.getIntegratedCircuit(11), stack) || GTUtility.areStacksEqual(GTUtility.getIntegratedCircuit(14), stack) || GTUtility.areStacksEqual(GTUtility.getIntegratedCircuit(19), stack)) continue;
                if (BWUtil.checkStackAndPrefix(stack)) {
                    circuitConfiguration = (byte)(OrePrefixes.dustSmall.equals((Object)GTOreDictUnificator.getAssociation((ItemStack)stack).mPrefix) ? 4 : (OrePrefixes.dustTiny.equals((Object)GTOreDictUnificator.getAssociation((ItemStack)stack).mPrefix) ? 9 : 1));
                }
                inputs.add(stack);
            }
            inputs.add(GTUtility.getIntegratedCircuit(circuitConfiguration));
            toAdd.add(new DynamicGTRecipe(false, inputs.toArray(new ItemStack[0]), recipe.mOutputs, recipe.mSpecialItems, recipe.mChances, null, recipe.mFluidOutputs, StaticRecipeChangeLoaders.transformEBFNoGasRecipeTime(recipe, originalGas), recipe.mEUt, recipe.mSpecialValue, recipe));
            break;
        }
    }

    private static void removeDuplicateGasRecipes(HashSet<GTRecipe> toAdd) {
        HashSet<GTRecipe> duplicates = new HashSet<GTRecipe>();
        for (GTRecipe recipe : toAdd) {
            for (GTRecipe recipe2 : toAdd) {
                int i;
                if (recipe.mEUt != recipe2.mEUt || recipe.mDuration != recipe2.mDuration || recipe.mSpecialValue != recipe2.mSpecialValue || recipe == recipe2 || recipe.mInputs.length != recipe2.mInputs.length || recipe.mFluidInputs.length != recipe2.mFluidInputs.length) continue;
                boolean isSame = true;
                for (i = 0; i < recipe.mInputs.length; ++i) {
                    if (GTUtility.areStacksEqual(recipe.mInputs[i], recipe2.mInputs[i])) continue;
                    isSame = false;
                }
                for (i = 0; i < recipe.mFluidInputs.length; ++i) {
                    if (GTUtility.areFluidsEqual(recipe.mFluidInputs[i], recipe2.mFluidInputs[i])) continue;
                    isSame = false;
                }
                if (!isSame) continue;
                duplicates.add(recipe2);
            }
        }
        toAdd.removeAll(duplicates);
    }

    private static Materials getMaterialFromInputFluid(GTRecipe recipe) {
        String materialString = recipe.mFluidInputs[0].getFluid().getName();
        materialString = StringUtils.removeStart((String)materialString, (String)"molten");
        materialString = StringUtils.removeStart((String)materialString, (String)"fluid");
        materialString = StringUtils.capitalize((String)materialString);
        return Materials.get(materialString);
    }

    private static void editRecipes(ArrayListMultimap<SubTag, GTRecipe> base, HashSet<ItemStack> noGas) {
        HashSet<GTRecipe> toAdd = new HashSet<GTRecipe>();
        for (SubTag gasTag : base.keySet()) {
            for (GTRecipe recipe : base.get((Object)gasTag)) {
                Materials originalGas;
                if (recipe.mFluidInputs == null || recipe.mFluidInputs.length <= 0 || (originalGas = StaticRecipeChangeLoaders.getMaterialFromInputFluid(recipe)) == Materials._NULL) continue;
                StaticRecipeChangeLoaders.editEBFWerkstoffRecipes(gasTag, recipe, originalGas, toAdd);
                StaticRecipeChangeLoaders.editEBFMaterialRecipes(gasTag, recipe, originalGas, toAdd);
                StaticRecipeChangeLoaders.editEBFNoGasRecipes(recipe, originalGas, toAdd, noGas);
            }
            RecipeMaps.blastFurnaceRecipes.getBackend().removeRecipes(base.get((Object)gasTag));
        }
        StaticRecipeChangeLoaders.removeDuplicateGasRecipes(toAdd);
        toAdd.forEach(RecipeMaps.blastFurnaceRecipes::add);
    }

    public static void addElectricImplosionCompressorRecipes() {
        new ElectricImplosionCompressorRecipes().run();
    }
}

