/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.items;

import bartworks.system.material.Werkstoff;
import bartworks.system.material.WerkstoffLoader;
import bartworks.util.BWUtil;
import bartworks.util.Pair;
import goodgenerator.util.CharExchanger;
import gregtech.api.enums.Materials;
import gregtech.api.enums.TextureSet;

public class GGMaterial
implements Runnable {
    protected static final int OffsetID = 10001;
    public static final Werkstoff graphiteUraniumMixture = new Werkstoff(new short[]{58, 119, 61}, "Graphite-Uranium Mixture", BWUtil.subscriptNumbers("C3U"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addMixerRecipes().onlyDust(), 10001, TextureSet.SET_DULL, new Pair<Materials, Integer>(Materials.Graphite, 3), new Pair<Materials, Integer>(Materials.Uranium, 1));
    public static final Werkstoff uraniumBasedLiquidFuel = new Werkstoff(new short[]{0, 255, 0}, "Uranium Based Liquid Fuel", BWUtil.subscriptNumbers("U36K8Qt4Rn"), new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10002, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff uraniumBasedLiquidFuelExcited = new Werkstoff(new short[]{0, 255, 0}, "Uranium Based Liquid Fuel (Excited State)", BWUtil.subscriptNumbers("*(U36K8Qt4Rn)*"), new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10003, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff uraniumBasedLiquidFuelDepleted = new Werkstoff(new short[]{110, 139, 61}, "Uranium Based Liquid Fuel (Depleted)", BWUtil.subscriptNumbers("Pb?Bi?Ba?Xe?"), new Werkstoff.Stats().setToxic(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10004, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff uraniumCarbideThoriumMixture = new Werkstoff(new short[]{22, 50, 7}, "Uranium Carbide-Thorium Mixture", Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addMixerRecipes().onlyDust(), 10005, TextureSet.SET_DULL, new Pair<Materials, Integer>(Materials.Thorium, 11), new Pair<Werkstoff, Integer>(WerkstoffLoader.Thorium232, 1), new Pair<Materials, Integer>(Materials.Uranium235, 1), new Pair<Materials, Integer>(Materials.Carbon, 3));
    public static final Werkstoff thoriumBasedLiquidFuel = new Werkstoff(new short[]{80, 50, 102}, "Thorium Based Liquid Fuel", BWUtil.subscriptNumbers("Th432Li4D2Hg"), new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10006, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff thoriumBasedLiquidFuelExcited = new Werkstoff(new short[]{80, 50, 102}, "Thorium Based Liquid Fuel (Excited State)", BWUtil.subscriptNumbers("*(Th432Li4D2Hg)*"), new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10007, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff thoriumBasedLiquidFuelDepleted = new Werkstoff(new short[]{125, 108, 138}, "Thorium Based Liquid Fuel (Depleted)", BWUtil.subscriptNumbers("Th?Pr?B?In?"), new Werkstoff.Stats().setToxic(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10008, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff plutoniumOxideUraniumMixture = new Werkstoff(new short[]{209, 31, 74}, "Plutonium Oxide-Uranium Mixture", Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addMixerRecipes().onlyDust(), 10009, TextureSet.SET_SHINY, new Pair<Materials, Integer>(Materials.Plutonium, 10), new Pair<Materials, Integer>(Materials.Oxygen, 12), new Pair<Materials, Integer>(Materials.Uranium, 2), new Pair<Materials, Integer>(Materials.Carbon, 8));
    public static final Werkstoff plutoniumBasedLiquidFuel = new Werkstoff(new short[]{239, 21, 21}, "Plutonium Based Liquid Fuel", BWUtil.subscriptNumbers("Pu45Nt8Cs16Nq2"), new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10010, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff plutoniumBasedLiquidFuelExcited = new Werkstoff(new short[]{239, 21, 21}, "Plutonium Based Liquid Fuel (Excited State)", BWUtil.subscriptNumbers("*(Pu45Nt8Cs16Nq2)*"), new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10011, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff plutoniumBasedLiquidFuelDepleted = new Werkstoff(new short[]{103, 25, 25}, "Plutonium Based Liquid Fuel (Depleted)", BWUtil.subscriptNumbers("Tn?Ce?Au?Kr?"), new Werkstoff.Stats().setToxic(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10012, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff oxalate = new Werkstoff(new short[]{121, 216, 85}, "Oxalate", Werkstoff.Types.BIOLOGICAL, new Werkstoff.GenerationFeatures().disable().addCells(), 10013, TextureSet.SET_FLUID, new Pair<Materials, Integer>(Materials.Hydrogen, 2), new Pair<Materials, Integer>(Materials.Carbon, 2), new Pair<Materials, Integer>(Materials.Oxygen, 4));
    public static final Werkstoff vanadiumPentoxide = new Werkstoff(new short[]{222, 141, 18}, "Vanadium Pentoxide", Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10014, TextureSet.SET_SHINY, new Pair<Materials, Integer>(Materials.Vanadium, 2), new Pair<Materials, Integer>(Materials.Oxygen, 5));
    public static final Werkstoff thoriumNitrate = new Werkstoff(new short[]{186, 232, 38}, "Thorium Nitrate", BWUtil.subscriptNumbers("Th(NO3)4"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10015, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff thoriumOxalate = new Werkstoff(new short[]{80, 99, 19}, "Thorium Oxalate", BWUtil.subscriptNumbers("Th(C2O4)2"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10016, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff thoriumHydroxide = new Werkstoff(new short[]{146, 174, 137}, "Thorium Hydroxide", BWUtil.subscriptNumbers("Th(OH)4"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10017, TextureSet.SET_SHINY, new Pair[0]);
    public static final Werkstoff sodiumOxalate = new Werkstoff(new short[]{228, 248, 155}, "Sodium Oxalate", BWUtil.subscriptNumbers("Na2C2O4"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10018, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff thoriumTetrachloride = new Werkstoff(new short[]{19, 124, 22}, "Thorium Tetrachloride", BWUtil.subscriptNumbers("ThCl4"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10019, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff thoriumTetrafluoride = new Werkstoff(new short[]{21, 106, 106}, "Thorium Tetrafluoride", BWUtil.subscriptNumbers("ThF4"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10020, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff thorium232Tetrafluoride = new Werkstoff(new short[]{21, 106, 106}, "Thorium-232 Tetrafluoride", new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10021, TextureSet.SET_FLUID, new Pair<Werkstoff, Integer>(WerkstoffLoader.Thorium232, 1), new Pair<Materials, Integer>(Materials.Fluorine, 4));
    public static final Werkstoff orundum = new Werkstoff(new short[]{205, 38, 38}, "Orundum", "Or", new Werkstoff.Stats().setProtons(120L).setMass(300L), Werkstoff.Types.ELEMENT, new Werkstoff.GenerationFeatures().addGems().addMolten(), 10023, TextureSet.SET_DIAMOND, new Pair[0]);
    public static final Werkstoff atomicSeparationCatalyst = new Werkstoff(new short[]{232, 94, 12}, "Atomic Separation Catalyst", "the melting core...", new Werkstoff.Stats().setMeltingPoint(5000), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems().addSimpleMetalWorkingItems().addMultipleIngotMetalWorkingItems().addMetaSolidifierRecipes(), 10022, TextureSet.SET_SHINY, new Pair<Werkstoff, Integer>(orundum, 2), new Pair<Materials, Integer>(Materials.Plutonium, 1), new Pair<Materials, Integer>(Materials.Naquadah, 2));
    public static final Werkstoff extremelyUnstableNaquadah = new Werkstoff(new short[]{6, 38, 5}, "Extremely Unstable Naquadah", "Nq" + CharExchanger.shifter(9734), new Werkstoff.Stats().setMeltingPoint(7000).setBlastFurnace(true).setProtons(200L).setMass(450L).setRadioactive(true).setDurOverride(180224).setSpeedOverride(100.0f).setQualityOverride((byte)11).disableAutoGeneratedBlastFurnaceRecipes().disableAutoGeneratedVacuumFreezerRecipes(), Werkstoff.Types.ELEMENT, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems().addSimpleMetalWorkingItems().addMultipleIngotMetalWorkingItems().addMetaSolidifierRecipes().addMetalCraftingSolidifierRecipes(), 10024, TextureSet.SET_SHINY, new Pair[0]);
    public static final Werkstoff lightNaquadahFuel = new Werkstoff(new short[]{92, 203, 92}, "Light Naquadah Fuel", "far from enough", new Werkstoff.Stats().setToxic(true).setRadioactive(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10025, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff heavyNaquadahFuel = new Werkstoff(new short[]{54, 255, 54}, "Heavy Naquadah Fuel", "still need processing", new Werkstoff.Stats().setToxic(true).setRadioactive(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10026, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahGas = new Werkstoff(new short[]{93, 219, 0}, "Naquadah Gas", "Who need it?", new Werkstoff.Stats().setToxic(true).setRadioactive(true).setGas(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10027, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahAsphalt = new Werkstoff(new short[]{5, 37, 5}, "Naquadah Asphalt", "It will damage the reactor.", new Werkstoff.Stats().setToxic(true).setRadioactive(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10028, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff ether = new Werkstoff(new short[]{235, 188, 47}, "Ether", BWUtil.subscriptNumbers("CH3CH2OCH2CH3"), new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10029, TextureSet.SET_FLUID, new Pair<Materials, Integer>(Materials.Carbon, 4), new Pair<Materials, Integer>(Materials.Hydrogen, 10), new Pair<Materials, Integer>(Materials.Oxygen, 1));
    public static final Werkstoff antimonyTrichloride = new Werkstoff(new short[]{15, 220, 52}, "Antimony Trichloride Solution", BWUtil.subscriptNumbers("SbCl3"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10030, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff antimonyPentachlorideSolution = new Werkstoff(new short[]{21, 147, 44}, "Antimony Pentachloride Solution", BWUtil.subscriptNumbers("SbCl5"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10031, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff antimonyPentachloride = new Werkstoff(new short[]{21, 147, 44}, "Antimony Pentachloride", BWUtil.subscriptNumbers("SbCl5"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10032, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff antimonyPentafluoride = new Werkstoff(new short[]{22, 213, 226}, "Antimony Pentafluoride", BWUtil.subscriptNumbers("SbF5"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10033, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff fluoroantimonicAcid = new Werkstoff(new short[]{22, 213, 226}, "Fluoroantimonic Acid", BWUtil.subscriptNumbers("HSbF6"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10034, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff radioactiveSludge = new Werkstoff(new short[]{179, 73, 30}, "Radioactive Sludge", ">>> DANGER <<<", new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10035, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff acidNaquadahEmulsion = new Werkstoff(new short[]{37, 34, 34}, "Acid Naquadah Emulsion", "??Nq??H" + CharExchanger.shifter(8314), new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10036, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahEmulsion = new Werkstoff(new short[]{74, 70, 69}, "Naquadah Emulsion", "??Nq??", new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10037, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahSolution = new Werkstoff(new short[]{132, 129, 128}, "Naquadah Solution", "~Nq~", new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10038, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahBasedFuelMkI = new Werkstoff(new short[]{98, 92, 91}, "Naquadah Based Liquid Fuel MkI", new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10039, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahBasedFuelMkIDepleted = new Werkstoff(new short[]{203, 195, 193}, "Naquadah Based Liquid Fuel MkI (Depleted)", new Werkstoff.Stats().setToxic(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10040, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahBasedFuelMkII = new Werkstoff(new short[]{82, 78, 77}, "Naquadah Based Liquid Fuel MkII", new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10041, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahBasedFuelMkIIDepleted = new Werkstoff(new short[]{181, 176, 174}, "Naquadah Based Liquid Fuel MkII (Depleted)", new Werkstoff.Stats().setToxic(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10042, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahBasedFuelMkIII = new Werkstoff(new short[]{41, 34, 33}, "Naquadah Based Liquid Fuel MkIII", new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10046, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahBasedFuelMkIIIDepleted = new Werkstoff(new short[]{102, 64, 56}, "Naquadah Based Liquid Fuel MkIII (Depleted)", new Werkstoff.Stats().setToxic(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10047, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahBasedFuelMkIV = new Werkstoff(new short[]{14, 12, 12}, "Naquadah Based Liquid Fuel MkIV", new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10048, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahBasedFuelMkIVDepleted = new Werkstoff(new short[]{142, 52, 34}, "Naquadah Based Liquid Fuel MkIV (Depleted)", new Werkstoff.Stats().setToxic(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10049, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahBasedFuelMkV = new Werkstoff(new short[]{0, 0, 0}, "Naquadah Based Liquid Fuel MkV", "THE END", new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10050, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahBasedFuelMkVDepleted = new Werkstoff(new short[]{255, 255, 255}, "Naquadah Based Liquid Fuel MkV (Depleted)", "THE END (literally)", new Werkstoff.Stats().setToxic(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10051, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahBasedFuelMkVI = new Werkstoff(new short[]{48, 0, 0}, "Naquadah Based Liquid Fuel MkVI", "THE FUTURE", new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10116, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahBasedFuelMkVIDepleted = new Werkstoff(new short[]{153, 51, 51}, "Naquadah Based Liquid Fuel MkVI (Depleted)", "THE FUTURE (achieved)", new Werkstoff.Stats().setToxic(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10117, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff zincChloride = new Werkstoff(new short[]{115, 165, 252}, "Zinc Chloride", BWUtil.subscriptNumbers("ZnCl2"), new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10052, TextureSet.SET_SHINY, new Pair<Materials, Integer>(Materials.Zinc, 1), new Pair<Materials, Integer>(Materials.Chlorine, 2));
    public static final Werkstoff zincThoriumAlloy = new Werkstoff(new short[]{18, 52, 86}, "Zn-Th Alloy", BWUtil.subscriptNumbers("ZnTh"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust().addMolten().addMetalItems(), 10053, TextureSet.SET_SHINY, new Pair<Materials, Integer>(Materials.Zinc, 1), new Pair<Materials, Integer>(Materials.Thorium, 1));
    public static final Werkstoff naquadahEarth = new Werkstoff(new short[]{76, 76, 76}, "Naquadah Oxide Mixture", BWUtil.subscriptNumbers("??NqTiGaAd??"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures(), 10054, TextureSet.SET_METALLIC, new Pair[0]);
    public static final Werkstoff titaniumTrifluoride = new Werkstoff(new short[]{192, 146, 168}, "Titanium Trifluoride", BWUtil.subscriptNumbers("TiF3"), new Werkstoff.Stats().setElektrolysis(false), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10055, TextureSet.SET_METALLIC, new Pair<Materials, Integer>(Materials.Titanium, 1), new Pair<Materials, Integer>(Materials.Fluorine, 3));
    public static final Werkstoff lowQualityNaquadahEmulsion = new Werkstoff(new short[]{76, 76, 76}, "Low Quality Naquadah Emulsion", BWUtil.subscriptNumbers("??NqGaAd??"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10056, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff galliumHydroxide = new Werkstoff(new short[]{166, 166, 166}, "Gallium Hydroxide", BWUtil.subscriptNumbers("Ga(OH)3"), new Werkstoff.Stats().setElektrolysis(false), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10057, TextureSet.SET_DULL, new Pair<Materials, Integer>(Materials.Gallium, 1), new Pair<Materials, Integer>(Materials.Oxygen, 3), new Pair<Materials, Integer>(Materials.Hydrogen, 3));
    public static final Werkstoff lowQualityNaquadahSolution = new Werkstoff(new short[]{113, 98, 98}, "Low Quality Naquadah Solution", BWUtil.subscriptNumbers("~??NqAd??~"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10058, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff towEthyl1Hexanol = new Werkstoff(new short[]{128, 181, 87}, "2-Ethyl-1-Hexanol", BWUtil.subscriptNumbers("C8H18O"), new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10059, TextureSet.SET_FLUID, new Pair<Materials, Integer>(Materials.Carbon, 8), new Pair<Materials, Integer>(Materials.Oxygen, 1), new Pair<Materials, Integer>(Materials.Hydrogen, 18));
    public static final Werkstoff P507 = new Werkstoff(new short[]{41, 194, 42}, "P-507", BWUtil.subscriptNumbers("(C8H17)2PO3H"), new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10060, TextureSet.SET_FLUID, new Pair<Materials, Integer>(Materials.Carbon, 16), new Pair<Materials, Integer>(Materials.Phosphorus, 1), new Pair<Materials, Integer>(Materials.Oxygen, 3), new Pair<Materials, Integer>(Materials.Hydrogen, 35));
    public static final Werkstoff naquadahAdamantiumSolution = new Werkstoff(new short[]{61, 56, 56}, "Naquadah-Adamantium Solution", BWUtil.subscriptNumbers("~NqAd~"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10061, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahRichSolution = new Werkstoff(new short[]{51, 51, 51}, "Naquadah-Rich Solution", BWUtil.subscriptNumbers("~?Nq?~"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10062, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahine = new Werkstoff(new short[]{51, 51, 51}, "Naquadahine", BWUtil.subscriptNumbers("NqO2"), new Werkstoff.Stats().setElektrolysis(false), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10063, TextureSet.SET_METALLIC, new Pair<Materials, Integer>(Materials.Naquadah, 1), new Pair<Materials, Integer>(Materials.Oxygen, 2));
    public static final Werkstoff fluorineRichWasteLiquid = new Werkstoff(new short[]{19, 104, 98}, "Fluorine-Rich Waste Liquid", new Werkstoff.Stats().setToxic(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10064, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff wasteLiquid = new Werkstoff(new short[]{20, 28, 104}, "Waste Liquid", new Werkstoff.Stats().setToxic(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10065, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff adamantine = new Werkstoff(new short[]{183, 183, 183}, "Adamantine", BWUtil.subscriptNumbers("Ad2O3"), new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10066, TextureSet.SET_DULL, new Pair<Materials, Integer>(Materials.Adamantium, 2), new Pair<Materials, Integer>(Materials.Oxygen, 3));
    public static final Werkstoff enrichedNaquadahEarth = new Werkstoff(new short[]{130, 104, 104}, "Enriched-Naquadah Oxide Mixture", BWUtil.subscriptNumbers("??KeNq") + CharExchanger.shifter(8314) + "??", new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures(), 10067, TextureSet.SET_METALLIC, new Pair[0]);
    public static final Werkstoff triniumSulphate = new Werkstoff(new short[]{218, 218, 218}, "Trinium Sulphate", BWUtil.subscriptNumbers("KeSO4"), new Werkstoff.Stats().setElektrolysis(false), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10068, TextureSet.SET_METALLIC, new Pair<Materials, Integer>(Materials.Trinium, 1), new Pair<Materials, Integer>(Materials.Sulfur, 1), new Pair<Materials, Integer>(Materials.Oxygen, 4));
    public static final Werkstoff enrichedNaquadahRichSolution = new Werkstoff(new short[]{82, 57, 57}, "Enriched-Naquadah-Rich Solution", BWUtil.subscriptNumbers("~?Nq") + CharExchanger.shifter(8314) + "?~", new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10069, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff concentratedEnrichedNaquadahSludge = new Werkstoff(new short[]{82, 57, 57}, "Concentrated Enriched-Naquadah Sludge", BWUtil.subscriptNumbers("?Nq") + CharExchanger.shifter(8314) + "?", new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10070, TextureSet.SET_METALLIC, new Pair[0]);
    public static final Werkstoff enrichedNaquadahSulphate = new Werkstoff(new short[]{82, 57, 57}, "Enriched-Naquadah Sulphate", "Nq" + CharExchanger.shifter(8314) + BWUtil.subscriptNumbers("(SO4)2"), new Werkstoff.Stats().setRadioactive(true).setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10071, TextureSet.SET_DULL, new Pair<Materials, Integer>(Materials.NaquadahEnriched, 1), new Pair<Materials, Integer>(Materials.Sulfur, 2), new Pair<Materials, Integer>(Materials.Oxygen, 8));
    public static final Werkstoff naquadriaEarth = new Werkstoff(new short[]{77, 77, 85}, "Naquadria Oxide Mixture", BWUtil.subscriptNumbers("??Nq*BaIn??"), new Werkstoff.Stats().setRadioactive(true).setToxic(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures(), 10072, TextureSet.SET_METALLIC, new Pair[0]);
    public static final Werkstoff indiumPhosphate = new Werkstoff(new short[]{43, 46, 112}, "Indium Phosphate", BWUtil.subscriptNumbers("InPO4"), new Werkstoff.Stats().setToxic(true).setElektrolysis(false), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10073, TextureSet.SET_DULL, new Pair<Materials, Integer>(Materials.Indium, 1), new Pair<Materials, Integer>(Materials.Phosphorus, 1), new Pair<Materials, Integer>(Materials.Oxygen, 4));
    public static final Werkstoff lowQualityNaquadriaPhosphate = new Werkstoff(new short[]{77, 77, 85}, "Low Quality Naquadria Phosphate", BWUtil.subscriptNumbers("??Nq*3(PO4)4??"), new Werkstoff.Stats().setRadioactive(true).setToxic(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10074, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff naquadriaRichSolution = new Werkstoff(new short[]{31, 30, 51}, "Naquadria-Rich Solution", BWUtil.subscriptNumbers("~?Nq*?~"), new Werkstoff.Stats().setRadioactive(true).setToxic(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10075, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff lowQualityNaquadriaSulphate = new Werkstoff(new short[]{115, 114, 132}, "Low Quality Naquadria Sulphate", BWUtil.subscriptNumbers("??Nq*(SO4)2??"), new Werkstoff.Stats().setRadioactive(true).setToxic(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10076, TextureSet.SET_METALLIC, new Pair[0]);
    public static final Werkstoff lowQualityNaquadriaSolution = new Werkstoff(new short[]{115, 114, 132}, "Low Quality Naquadria Sulphate", BWUtil.subscriptNumbers("~??Nq*??~"), new Werkstoff.Stats().setRadioactive(true).setToxic(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10077, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadriaSulphate = new Werkstoff(new short[]{31, 30, 51}, "Naquadria Sulphate", BWUtil.subscriptNumbers("Nq*(SO4)2"), new Werkstoff.Stats().setRadioactive(true).setToxic(true).setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10078, TextureSet.SET_METALLIC, new Pair<Materials, Integer>(Materials.Naquadria, 1), new Pair<Materials, Integer>(Materials.Sulfur, 2), new Pair<Materials, Integer>(Materials.Oxygen, 8));
    public static final Werkstoff naquadahGoo = new Werkstoff(new short[]{76, 76, 76}, "Naquadah Goo", BWUtil.subscriptNumbers("??NqTiGaAd??"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10079, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff enrichedNaquadahGoo = new Werkstoff(new short[]{130, 104, 104}, "Enriched Naquadah Goo", BWUtil.subscriptNumbers("??KeNq") + CharExchanger.shifter(8314) + "??", new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10080, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadriaGoo = new Werkstoff(new short[]{77, 77, 85}, "Naquadria Goo", BWUtil.subscriptNumbers("??Nq*BaIn??"), new Werkstoff.Stats().setRadioactive(true).setToxic(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10081, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff zircaloy4 = new Werkstoff(new short[]{138, 110, 104}, "Zircaloy-4", BWUtil.subscriptNumbers("Zr34Sn5Fe2Cr"), new Werkstoff.Stats().setCentrifuge(true).setBlastFurnace(true).setMeltingPoint(2800), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems().addMixerRecipes((short)4), 10082, TextureSet.SET_METALLIC, new Pair<Werkstoff, Integer>(WerkstoffLoader.Zirconium, 34), new Pair<Materials, Integer>(Materials.Tin, 5), new Pair<Materials, Integer>(Materials.Iron, 2), new Pair<Materials, Integer>(Materials.Chrome, 1));
    public static final Werkstoff zircaloy2 = new Werkstoff(new short[]{164, 143, 139}, "Zircaloy-2", BWUtil.subscriptNumbers("Zr34Sn4FeCrNi"), new Werkstoff.Stats().setCentrifuge(true).setBlastFurnace(true).setMeltingPoint(2800), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems().addMixerRecipes((short)2), 10083, TextureSet.SET_METALLIC, new Pair<Werkstoff, Integer>(WerkstoffLoader.Zirconium, 34), new Pair<Materials, Integer>(Materials.Tin, 4), new Pair<Materials, Integer>(Materials.Iron, 1), new Pair<Materials, Integer>(Materials.Chrome, 1), new Pair<Materials, Integer>(Materials.Nickel, 1));
    public static final Werkstoff incoloy903 = new Werkstoff(new short[]{164, 143, 139}, "Incoloy-903", BWUtil.subscriptNumbers("Fe12Ni10Co8Ti4Mo2Al"), new Werkstoff.Stats().setCentrifuge(true).setBlastFurnace(true).setMeltingPoint(3700), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems().addSimpleMetalWorkingItems().addMixerRecipes((short)6), 10084, TextureSet.SET_METALLIC, new Pair<Materials, Integer>(Materials.Iron, 12), new Pair<Materials, Integer>(Materials.Nickel, 10), new Pair<Materials, Integer>(Materials.Cobalt, 8), new Pair<Materials, Integer>(Materials.Titanium, 4), new Pair<Materials, Integer>(Materials.Molybdenum, 2), new Pair<Materials, Integer>(Materials.Aluminium, 1));
    public static final Werkstoff adamantiumAlloy = new Werkstoff(new short[]{160, 160, 160}, "Adamantium Alloy", BWUtil.subscriptNumbers("Ad5Nq2La3"), new Werkstoff.Stats().setCentrifuge(true).setBlastFurnace(true).setMeltingPoint(5500).setSpeedOverride(191.2f).setDurOverride(102400), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems().addSimpleMetalWorkingItems().addMultipleIngotMetalWorkingItems().addMixerRecipes((short)3), 10085, TextureSet.SET_SHINY, new Pair<Materials, Integer>(Materials.Adamantium, 5), new Pair<Materials, Integer>(Materials.Naquadah, 2), new Pair<Materials, Integer>(Materials.Lanthanum, 3));
    public static final Werkstoff ethanolGasoline = new Werkstoff(new short[]{228, 198, 97}, "Ethanol Gasoline", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10086, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff cyclopentadiene = new Werkstoff(new short[]{255, 246, 189}, "Cyclopentadiene", BWUtil.subscriptNumbers("C5H6"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10087, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff ferrousChloride = new Werkstoff(new short[]{91, 91, 91}, "Iron II Chloride", BWUtil.subscriptNumbers("FeCl2"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10088, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff diethylamine = new Werkstoff(new short[]{105, 119, 202}, "Diethylamine", BWUtil.subscriptNumbers("C4H11N"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10089, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff impureFerroceneMixture = new Werkstoff(new short[]{121, 85, 8}, "Impure Ferrocene Mixture", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10090, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff ferroceneSolution = new Werkstoff(new short[]{222, 126, 28}, "Ferrocene Solution", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10091, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff ferroceneWaste = new Werkstoff(new short[]{53, 29, 3}, "Ferrocene Waste", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10092, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff ferrocene = new Werkstoff(new short[]{241, 143, 43}, "Ferrocene", BWUtil.subscriptNumbers("Fe(C5H5)2"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10093, TextureSet.SET_SHINY, new Pair[0]);
    public static final Werkstoff ironedKerosene = new Werkstoff(new short[]{151, 0, 97}, "Jet Fuel No.3", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10094, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff ironedFuel = new Werkstoff(new short[]{255, 152, 0}, "Jet Fuel A", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10095, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff marM200 = new Werkstoff(new short[]{81, 81, 81}, "MAR-M200 Steel", new Werkstoff.Stats().setCentrifuge(true).setBlastFurnace(true).setMeltingPoint(5000), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems().addSimpleMetalWorkingItems().addMultipleIngotMetalWorkingItems().addMixerRecipes((short)7), 10096, TextureSet.SET_SHINY, new Pair<Materials, Integer>(Materials.Niobium, 2), new Pair<Materials, Integer>(Materials.Chrome, 9), new Pair<Materials, Integer>(Materials.Aluminium, 5), new Pair<Materials, Integer>(Materials.Titanium, 2), new Pair<Materials, Integer>(Materials.Cobalt, 10), new Pair<Materials, Integer>(Materials.Tungsten, 13), new Pair<Materials, Integer>(Materials.Nickel, 18));
    public static final Werkstoff marCeM200 = new Werkstoff(new short[]{56, 48, 48}, "MAR-Ce-M200 Steel", new Werkstoff.Stats().setCentrifuge(true).setBlastFurnace(true).setMeltingPoint(5000).setMass(1200L).setProtons(1000L).setSpeedOverride(150.0f).setDurOverride(204800), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems().addSimpleMetalWorkingItems().addMultipleIngotMetalWorkingItems(), 10097, TextureSet.SET_METALLIC, new Pair<Werkstoff, Integer>(marM200, 18), new Pair<Materials, Integer>(Materials.Cerium, 1));
    public static final Werkstoff lithiumChloride = new Werkstoff(new short[]{183, 226, 206}, "Lithium Chloride", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().enforceUnification(), 10098, TextureSet.SET_DULL, new Pair<Materials, Integer>(Materials.Lithium, 1), new Pair<Materials, Integer>(Materials.Chlorine, 1));
    public static final Werkstoff signalium = new Werkstoff(new short[]{212, 64, 0}, "Signalium", new Werkstoff.Stats().setBlastFurnace(true).setMeltingPoint(4000), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems(), 10099, TextureSet.SET_SHINY, new Pair<Materials, Integer>(Materials.AnnealedCopper, 4), new Pair<Materials, Integer>(Materials.Ardite, 2), new Pair<Materials, Integer>(Materials.RedAlloy, 2));
    public static final Werkstoff lumiinessence = new Werkstoff(new short[]{232, 242, 36}, "Lumiinessence", BWUtil.subscriptNumbers("(Al??)2(PO4)4"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust(), 10100, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff lumiium = new Werkstoff(new short[]{232, 242, 36}, "Lumiium", new Werkstoff.Stats().setBlastFurnace(true).setMeltingPoint(4000), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems(), 10101, TextureSet.SET_SHINY, new Pair<Materials, Integer>(Materials.TinAlloy, 4), new Pair<Materials, Integer>(Materials.SterlingSilver, 2), new Pair<Werkstoff, Integer>(lumiinessence, 2));
    public static final Werkstoff artheriumSn = new Werkstoff(new short[]{96, 54, 247}, "Artherium-Sn", new Werkstoff.Stats().setBlastFurnace(true).setMeltingPoint(6500).setCentrifuge(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems().addMixerRecipes((short)6), 10102, TextureSet.SET_SHINY, new Pair<Werkstoff, Integer>(adamantiumAlloy, 12), new Pair<Werkstoff, Integer>(orundum, 9), new Pair<Materials, Integer>(Materials.Tin, 8), new Pair<Materials, Integer>(Materials.Arsenic, 7), new Pair<Materials, Integer>(Materials.Caesium, 4), new Pair<Materials, Integer>(Materials.Osmiridium, 3));
    public static final Werkstoff titaniumBetaC = new Werkstoff(new short[]{199, 47, 204}, "Tanmolyium Beta-C", new Werkstoff.Stats().setBlastFurnace(true).setMeltingPoint(5300).setCentrifuge(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems().addMixerRecipes((short)5), 10103, TextureSet.SET_METALLIC, new Pair<Materials, Integer>(Materials.Titanium, 5), new Pair<Materials, Integer>(Materials.Molybdenum, 5), new Pair<Materials, Integer>(Materials.Vanadium, 2), new Pair<Materials, Integer>(Materials.Chrome, 3), new Pair<Materials, Integer>(Materials.Aluminium, 1));
    public static final Werkstoff dalisenite = new Werkstoff(new short[]{176, 184, 18}, "Dalisenite", new Werkstoff.Stats().setMeltingPoint(8700).setCentrifuge(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems().addMetaSolidifierRecipes().addMetalCraftingSolidifierRecipes().addMixerRecipes((short)6), 10104, TextureSet.SET_SHINY, new Pair<Werkstoff, Integer>(titaniumBetaC, 14), new Pair<Materials, Integer>(Materials.Tungsten, 10), new Pair<Materials, Integer>(Materials.NiobiumTitanium, 9), new Pair<Werkstoff, Integer>(WerkstoffLoader.LuVTierMaterial, 8), new Pair<Materials, Integer>(Materials.Quantium, 7), new Pair<Materials, Integer>(Materials.Erbium, 3));
    public static final Werkstoff hikarium = new Werkstoff(new short[]{255, 214, 251}, "Hikarium", new Werkstoff.Stats().setBlastFurnace(true).setMeltingPoint(5400).setCentrifuge(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems().addMixerRecipes((short)3), 10105, TextureSet.SET_SHINY, new Pair<Werkstoff, Integer>(lumiium, 18), new Pair<Materials, Integer>(Materials.Silver, 8), new Pair<Materials, Integer>(Materials.Sunnarium, 4));
    public static final Werkstoff tairitsu = new Werkstoff(new short[]{54, 54, 54}, "Tairitsu", new Werkstoff.Stats().setBlastFurnace(true).setMeltingPoint(7400).setCentrifuge(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems().addMetaSolidifierRecipes().addMetalCraftingSolidifierRecipes().addMixerRecipes((short)6), 10106, TextureSet.SET_SHINY, new Pair<Materials, Integer>(Materials.Tungsten, 8), new Pair<Materials, Integer>(Materials.Naquadria, 7), new Pair<Materials, Integer>(Materials.Bedrockium, 4), new Pair<Materials, Integer>(Materials.Carbon, 4), new Pair<Materials, Integer>(Materials.Vanadium, 3), new Pair<Materials, Integer>(Materials.BlackPlutonium, 1));
    public static final Werkstoff antimonyPentafluorideSolution = new Werkstoff(new short[]{22, 213, 226}, "Antimony Pentafluoride Solution", BWUtil.subscriptNumbers("SbF5"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10107, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff magnesiumSulphate = new Werkstoff(new short[]{135, 116, 145}, "Magnesium Sulphate", BWUtil.subscriptNumbers("MgSO4"), new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10108, TextureSet.SET_DULL, new Pair<Materials, Integer>(Materials.Magnesium, 1), new Pair<Materials, Integer>(Materials.Sulfur, 1), new Pair<Materials, Integer>(Materials.Oxygen, 4));
    public static final Werkstoff preciousMetalAlloy = new Werkstoff(new short[]{157, 144, 198}, "Precious Metals Alloy", new Werkstoff.Stats().setBlastFurnace(true).setMeltingPoint(10000).setCentrifuge(true).setSpeedOverride(100.0f), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems().addMultipleIngotMetalWorkingItems().addMetaSolidifierRecipes().addMetalCraftingSolidifierRecipes().addMixerRecipes((short)6), 10109, TextureSet.SET_SHINY, new Pair<Werkstoff, Integer>(WerkstoffLoader.Ruthenium, 1), new Pair<Werkstoff, Integer>(WerkstoffLoader.Rhodium, 1), new Pair<Materials, Integer>(Materials.Palladium, 1), new Pair<Materials, Integer>(Materials.Platinum, 1), new Pair<Materials, Integer>(Materials.Osmium, 1), new Pair<Materials, Integer>(Materials.Iridium, 1));
    public static final Werkstoff enrichedNaquadahAlloy = new Werkstoff(new short[]{22, 7, 64}, "Enriched Naquadah Alloy", new Werkstoff.Stats().setBlastFurnace(true).setMeltingPoint(11000).setCentrifuge(true).setSpeedOverride(180.0f), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems().addSimpleMetalWorkingItems().addMultipleIngotMetalWorkingItems().addMixerRecipes((short)4), 10110, TextureSet.SET_METALLIC, new Pair<Materials, Integer>(Materials.NaquadahEnriched, 8), new Pair<Materials, Integer>(Materials.Tritanium, 5), new Pair<Werkstoff, Integer>(WerkstoffLoader.Californium, 3), new Pair<Materials, Integer>(Materials.BlackPlutonium, 2));
    public static final Werkstoff metastableOganesson = new Werkstoff(new short[]{20, 57, 127}, "Metastable Oganesson", "Og*", new Werkstoff.Stats().setBlastFurnace(true).setProtons(118L).setMass(294L).setMeltingPoint(11000), Werkstoff.Types.ELEMENT, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems().addSimpleMetalWorkingItems().addMultipleIngotMetalWorkingItems().addMetaSolidifierRecipes().addMetalCraftingSolidifierRecipes(), 10111, TextureSet.SET_SHINY, new Pair[0]);
    public static final Werkstoff shirabon = new Werkstoff(new short[]{224, 21, 109}, "Shirabon", "Sh" + CharExchanger.shifter(9191), new Werkstoff.Stats().setProtons(500L).setMass(750L).setMeltingPoint(13000).setSpeedOverride(640.0f).setDurOverride(0xF00000).setQualityOverride((byte)26), Werkstoff.Types.ELEMENT, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems().addSimpleMetalWorkingItems().addMultipleIngotMetalWorkingItems().addMetaSolidifierRecipes().addMetalCraftingSolidifierRecipes(), 10112, TextureSet.SET_SHINY, new Pair[0]);
    public static final Werkstoff inertNaquadah = new Werkstoff(new short[]{59, 59, 59}, "Inert Naquadah", new Werkstoff.Stats(), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10113, TextureSet.SET_METALLIC, new Pair<Materials, Integer>(Materials.Naquadah, 1));
    public static final Werkstoff inertEnrichedNaquadah = new Werkstoff(new short[]{97, 68, 68}, "Inert Enriched Naquadah", new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10114, TextureSet.SET_METALLIC, new Pair<Materials, Integer>(Materials.NaquadahEnriched, 1));
    public static final Werkstoff inertNaquadria = new Werkstoff(new short[]{0, 0, 0}, "Inert Naquadria", new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10115, TextureSet.SET_METALLIC, new Pair<Materials, Integer>(Materials.Naquadria, 1));

    @Override
    public void run() {
    }
}

