/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.loader;

import goodgenerator.api.recipe.GoodGeneratorRecipeMaps;
import goodgenerator.loader.ComponentAssemblyLineMiscRecipes;
import goodgenerator.loader.Loaders;
import goodgenerator.util.StackUtils;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.MaterialsUEVplus;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.objects.ItemData;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import gregtech.common.items.ItemIntegratedCircuit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;

public class ComponentAssemblyLineRecipeLoader {
    private static final String[] compPrefixes = new String[]{"Electric_Motor_", "Electric_Piston_", "Electric_Pump_", "Robot_Arm_", "Conveyor_Module_", "Emitter_", "Sensor_", "Field_Generator_"};
    private static final String[] blacklistedDictPrefixes = new String[]{"circuit"};
    private static final String[] softBlacklistedDictPrefixes = new String[]{"Any", "crafting", "nanite"};
    private static final String moltenMHDCSM = "molten.magnetohydrodynamicallyconstrainedstarmatter";
    private static LinkedHashMap<List<GTRecipe>, Pair<ItemList, Integer>> allAssemblerRecipes;
    private static LinkedHashMap<List<GTRecipe.RecipeAssemblyLine>, Pair<ItemList, Integer>> allAsslineRecipes;
    private static final HashMap<OrePrefixes, Double> magnetoConversionMultipliers;
    private static final HashMap<OrePrefixes, OrePrefixes> conversion;
    private static final int INPUT_MULTIPLIER = 48;
    private static final int OUTPUT_MULTIPLIER = 64;
    private static final int FLUID_CONVERSION_STACKSIZE_THRESHOLD = 64;

    public static void run() {
        ComponentAssemblyLineMiscRecipes.run();
        conversion.put(OrePrefixes.cableGt01, OrePrefixes.cableGt16);
        conversion.put(OrePrefixes.wireGt01, OrePrefixes.wireGt16);
        conversion.put(OrePrefixes.cableGt02, OrePrefixes.cableGt16);
        conversion.put(OrePrefixes.wireGt02, OrePrefixes.wireGt16);
        conversion.put(OrePrefixes.cableGt04, OrePrefixes.cableGt16);
        conversion.put(OrePrefixes.wireGt04, OrePrefixes.wireGt16);
        conversion.put(OrePrefixes.cableGt08, OrePrefixes.cableGt16);
        conversion.put(OrePrefixes.wireGt08, OrePrefixes.wireGt16);
        conversion.put(OrePrefixes.plate, OrePrefixes.plateDense);
        conversion.put(OrePrefixes.foil, OrePrefixes.plate);
        conversion.put(OrePrefixes.stick, OrePrefixes.stickLong);
        conversion.put(OrePrefixes.gearGtSmall, OrePrefixes.gearGt);
        magnetoConversionMultipliers.put(OrePrefixes.frameGt, 1.0);
        magnetoConversionMultipliers.put(OrePrefixes.plate, 1.0);
        magnetoConversionMultipliers.put(OrePrefixes.plateDense, 3.0);
        magnetoConversionMultipliers.put(OrePrefixes.stick, 0.5);
        magnetoConversionMultipliers.put(OrePrefixes.round, 0.125);
        magnetoConversionMultipliers.put(OrePrefixes.bolt, 0.125);
        magnetoConversionMultipliers.put(OrePrefixes.screw, 0.125);
        magnetoConversionMultipliers.put(OrePrefixes.ring, 0.25);
        magnetoConversionMultipliers.put(OrePrefixes.foil, 0.125);
        magnetoConversionMultipliers.put(OrePrefixes.gearGtSmall, 1.0);
        magnetoConversionMultipliers.put(OrePrefixes.rotor, 2.0);
        magnetoConversionMultipliers.put(OrePrefixes.stickLong, 1.0);
        magnetoConversionMultipliers.put(OrePrefixes.gearGt, 2.0);
        magnetoConversionMultipliers.put(OrePrefixes.wireFine, 0.125);
        ComponentAssemblyLineRecipeLoader.findAllRecipes();
        ComponentAssemblyLineRecipeLoader.generateAssemblerRecipes();
        ComponentAssemblyLineRecipeLoader.generateAsslineRecipes();
    }

    private static void generateAssemblerRecipes() {
        allAssemblerRecipes.forEach((recipeList, info) -> {
            for (GTRecipe recipe : recipeList) {
                int j;
                if (recipe == null) continue;
                ArrayList<ItemStack> fixedInputs = new ArrayList<ItemStack>();
                ArrayList<FluidStack> fixedFluids = new ArrayList<FluidStack>();
                for (j = 0; j < recipe.mInputs.length; ++j) {
                    ItemStack input = recipe.mInputs[j];
                    if (!GTUtility.isStackValid(input) || input.func_77973_b() instanceof ItemIntegratedCircuit) continue;
                    fixedInputs.addAll(StackUtils.multiplyAndSplitIntoStacks(input, 48));
                }
                for (j = 0; j < recipe.mFluidInputs.length; ++j) {
                    FluidStack currFluid = recipe.mFluidInputs[j].copy();
                    currFluid.amount *= 48;
                    fixedFluids.add(currFluid);
                }
                fixedInputs = ComponentAssemblyLineRecipeLoader.compactItems(fixedInputs, (Integer)info.getRight());
                ComponentAssemblyLineRecipeLoader.replaceIntoFluids(fixedInputs, fixedFluids, 64);
                int tier = (Integer)info.getRight();
                int energy = (int)Math.min(0x7FFFFFF8L, GTValues.VP[tier - 1]);
                GTValues.RA.stdBuilder().itemInputs(fixedInputs.toArray(new ItemStack[0])).itemOutputs(((ItemList)info.getLeft()).get(64L, new Object[0])).fluidInputs(fixedFluids.toArray(new FluidStack[0])).duration(recipe.mDuration * 48).eut(energy).metadata(GTRecipeConstants.COAL_CASING_TIER, (Integer)info.getRight()).noOptimize().addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
            }
        });
    }

    private static void generateAsslineRecipes() {
        allAsslineRecipes.forEach((recipeList, info) -> {
            for (GTRecipe.RecipeAssemblyLine recipe : recipeList) {
                if (recipe == null) continue;
                int componentCircuit = -1;
                for (int i = 0; i < compPrefixes.length; ++i) {
                    if (!((ItemList)info.getLeft()).toString().startsWith(compPrefixes[i])) continue;
                    componentCircuit = i + 1;
                }
                if (componentCircuit == -1) {
                    throw new NullPointerException("Wrong circuit. Comp: " + ((ItemList)info.getLeft()).toString());
                }
                boolean addProgrammedCircuit = componentCircuit <= 7;
                ArrayList<ItemStack> fixedInputs = new ArrayList<ItemStack>();
                ArrayList<FluidStack> fixedFluids = new ArrayList<FluidStack>();
                for (int j = 0; j < recipe.mFluidInputs.length; ++j) {
                    FluidStack fluidStack = recipe.mFluidInputs[j].copy();
                    fluidStack.amount = (int)((double)fluidStack.amount * 48.0);
                    fixedFluids.add(fluidStack);
                }
                for (ItemStack input : recipe.mInputs) {
                    if (!GTUtility.isStackValid(input)) continue;
                    int count = input.field_77994_a;
                    if (input.func_77973_b() instanceof ItemIntegratedCircuit) continue;
                    ItemData data = GTOreDictUnificator.getAssociation(input);
                    if (data != null && data.mPrefix == OrePrefixes.circuit) {
                        fixedInputs.addAll(StackUtils.multiplyAndSplitIntoStacks(GTOreDictUnificator.get(data.mPrefix, data.mMaterial.mMaterial, (long)count), 48));
                        continue;
                    }
                    fixedInputs.addAll(StackUtils.multiplyAndSplitIntoStacks(input, 48));
                }
                fixedInputs = ComponentAssemblyLineRecipeLoader.compactItems(fixedInputs, (Integer)info.getRight());
                ComponentAssemblyLineRecipeLoader.replaceIntoFluids(fixedInputs, fixedFluids, 64);
                if (fixedInputs.size() > (addProgrammedCircuit ? 8 : 9)) {
                    ComponentAssemblyLineRecipeLoader.replaceIntoFluids(fixedInputs, fixedFluids, 32);
                }
                if (addProgrammedCircuit) {
                    fixedInputs.add(GTUtility.getIntegratedCircuit(componentCircuit));
                }
                ComponentAssemblyLineRecipeLoader.addEternityForMHDCSM(fixedFluids);
                for (ArrayList arrayList : ComponentAssemblyLineRecipeLoader.addFluidsForProtoHalkonite(fixedFluids)) {
                    ComponentAssemblyLineRecipeLoader.addFinalRecipes((Pair<ItemList, Integer>)info, fixedInputs, arrayList, recipe);
                }
            }
        });
    }

    private static void addFinalRecipes(Pair<ItemList, Integer> info, ArrayList<ItemStack> fixedInputs, ArrayList<FluidStack> fixedFluids, GTRecipe.RecipeAssemblyLine recipe) {
        GTValues.RA.stdBuilder().itemInputs(fixedInputs.toArray(new ItemStack[0])).itemOutputs(((ItemList)info.getLeft()).get(64L, new Object[0])).fluidInputs(fixedFluids.toArray(new FluidStack[0])).duration(recipe.mDuration * 48).eut(recipe.mEUt).metadata(GTRecipeConstants.COAL_CASING_TIER, (Integer)info.getRight()).noOptimize().addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        if (ComponentAssemblyLineRecipeLoader.swapSiliconeForStyreneButadiene(fixedFluids)) {
            GTValues.RA.stdBuilder().itemInputs(fixedInputs.toArray(new ItemStack[0])).itemOutputs(((ItemList)info.getLeft()).get(64L, new Object[0])).fluidInputs(fixedFluids.toArray(new FluidStack[0])).duration(recipe.mDuration * 48).eut(recipe.mEUt).metadata(GTRecipeConstants.COAL_CASING_TIER, (Integer)info.getRight()).noOptimize().addTo(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes);
        }
    }

    private static void replaceIntoFluids(List<ItemStack> inputs, List<FluidStack> fluidOutputs, int threshold) {
        HashMap<ItemStack, Integer> totals = StackUtils.getTotalItems(inputs.toArray(new ItemStack[0]));
        ArrayList<ItemStack> newInputs = new ArrayList<ItemStack>();
        for (ItemStack input : totals.keySet()) {
            int count = totals.get(input);
            boolean isConverted = false;
            if (OreDictionary.getOreIDs((ItemStack)input).length > 0 && count > threshold) {
                FluidStack foundFluidStack = ComponentAssemblyLineRecipeLoader.tryConvertItemStackToFluidMaterial(input);
                ItemData data = GTOreDictUnificator.getAssociation(input);
                if (data != null && data.mMaterial.mMaterial == Materials.SamariumMagnetic) {
                    input = GTOreDictUnificator.get(data.mPrefix, Materials.Samarium, 1L);
                    foundFluidStack = ComponentAssemblyLineRecipeLoader.tryConvertItemStackToFluidMaterial(input);
                } else if (data != null && data.mMaterial.mMaterial == Materials.TengamAttuned) {
                    input = GTOreDictUnificator.get(data.mPrefix, Materials.TengamPurified, 1L);
                    foundFluidStack = ComponentAssemblyLineRecipeLoader.tryConvertItemStackToFluidMaterial(input);
                }
                if (foundFluidStack != null) {
                    foundFluidStack.amount *= count;
                    boolean alreadyHasFluid = false;
                    for (FluidStack fluidstack : fluidOutputs) {
                        if (!foundFluidStack.getFluid().equals(fluidstack.getFluid())) continue;
                        fluidstack.amount += foundFluidStack.amount;
                        alreadyHasFluid = true;
                        break;
                    }
                    if (!alreadyHasFluid) {
                        fluidOutputs.add(foundFluidStack);
                    }
                    isConverted = true;
                }
            }
            if (isConverted) continue;
            newInputs.add(GTUtility.copyAmountUnsafe(count, input));
        }
        inputs.clear();
        inputs.addAll(newInputs);
    }

    @Nullable
    private static FluidStack tryConvertItemStackToFluidMaterial(ItemStack input) {
        ArrayList<String> oreDicts = new ArrayList<String>();
        for (int id : OreDictionary.getOreIDs((ItemStack)input)) {
            oreDicts.add(OreDictionary.getOreName((int)id));
        }
        Object object = oreDicts.iterator();
        block3: while (object.hasNext()) {
            OrePrefixes orePrefix;
            String dict = (String)object.next();
            for (String blacklistedPrefix : blacklistedDictPrefixes) {
                if (!dict.startsWith(blacklistedPrefix)) continue;
                return null;
            }
            for (String blacklistedPrefix : softBlacklistedDictPrefixes) {
                if (dict.startsWith(blacklistedPrefix)) continue block3;
            }
            try {
                orePrefix = OrePrefixes.valueOf(ComponentAssemblyLineRecipeLoader.findBestPrefix(dict));
            }
            catch (Exception e) {
                continue;
            }
            String strippedOreDict = dict.substring(orePrefix.toString().length());
            if (strippedOreDict.contains("Any")) continue;
            if (strippedOreDict.contains("PTMEG")) {
                return FluidRegistry.getFluidStack((String)"molten.silicone", (int)((int)(orePrefix.mMaterialAmount / 25200L) * input.field_77994_a));
            }
            if (strippedOreDict.contains("protohalkonite")) {
                return MaterialsUEVplus.MoltenProtoHalkoniteBase.getFluid(orePrefix.mMaterialAmount / 25200L * (long)input.field_77994_a);
            }
            return FluidRegistry.getFluidStack((String)("molten." + strippedOreDict.toLowerCase()), (int)((int)(orePrefix.mMaterialAmount / 25200L) * input.field_77994_a));
        }
        return null;
    }

    private static String findBestPrefix(String oreDict) {
        int longestPrefixLength = 0;
        String matchingPrefix = null;
        for (OrePrefixes prefix : OrePrefixes.values()) {
            String name = prefix.toString();
            if (!oreDict.startsWith(name) || name.length() <= longestPrefixLength) continue;
            longestPrefixLength = name.length();
            matchingPrefix = name;
        }
        return matchingPrefix;
    }

    private static ArrayList<ItemStack> compactItems(List<ItemStack> items, int tier) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        HashMap<ItemStack, Integer> totals = StackUtils.getTotalItems(items);
        for (ItemStack itemstack : totals.keySet()) {
            OrePrefixes goInto;
            int totalItems = totals.get(itemstack);
            ItemData data = GTOreDictUnificator.getAssociation(itemstack);
            boolean isCompacted = false;
            for (String dict : Arrays.stream(OreDictionary.getOreIDs((ItemStack)itemstack)).mapToObj(OreDictionary::getOreName).collect(Collectors.toList())) {
                if (dict.startsWith("circuit")) {
                    stacks.addAll(ComponentAssemblyLineRecipeLoader.getWrappedCircuits(itemstack, totalItems, dict));
                    isCompacted = true;
                    break;
                }
                if (!dict.contains("Magneto")) continue;
                stacks.addAll(ComponentAssemblyLineRecipeLoader.getMagnetoConversion(itemstack, totalItems));
                isCompacted = true;
                break;
            }
            if (data != null && !isCompacted && (goInto = conversion.get((Object)data.mPrefix)) != null && GTOreDictUnificator.get(goInto, data.mMaterial.mMaterial, 1L) != null) {
                ComponentAssemblyLineRecipeLoader.compactorHelper(data, goInto, stacks, totalItems);
                isCompacted = true;
            }
            if (GTUtility.areStacksEqual(itemstack, ItemList.Gravistar.get(1L, new Object[0])) && tier >= 9) {
                stacks.addAll(StackUtils.multiplyAndSplitIntoStacks(ItemList.NuclearStar.get(1L, new Object[0]), totalItems / 16));
                isCompacted = true;
            }
            if (GTUtility.areStacksEqual(itemstack, GTOreDictUnificator.get(OrePrefixes.nanite, Materials.Neutronium, 1L))) {
                stacks.addAll(StackUtils.multiplyAndSplitIntoStacks(GTOreDictUnificator.get(OrePrefixes.nanite, Materials.Gold, 1L), totalItems / 16));
                isCompacted = true;
            }
            if (isCompacted) continue;
            stacks.addAll(StackUtils.multiplyAndSplitIntoStacks(itemstack, totalItems));
        }
        stacks = StackUtils.mergeStacks(stacks);
        return stacks;
    }

    private static void compactorHelper(ItemData data, OrePrefixes compactInto, ArrayList<ItemStack> output, int total) {
        int materialRatio = (int)((double)compactInto.mMaterialAmount / (double)data.mPrefix.mMaterialAmount);
        output.addAll(StackUtils.multiplyAndSplitIntoStacks(GTOreDictUnificator.get(compactInto, data.mMaterial.mMaterial, 1L), total / materialRatio));
    }

    private static void findAllRecipes() {
        allAssemblerRecipes = new LinkedHashMap();
        allAsslineRecipes = new LinkedHashMap();
        for (String compPrefix : compPrefixes) {
            for (int t = 1; t <= 13; ++t) {
                ArrayList<Object> foundRecipes;
                String vName = GTValues.VN[t];
                ItemList currentComponent = ItemList.valueOf(compPrefix + vName);
                if (!currentComponent.hasBeenSet()) continue;
                if (t < 6) {
                    foundRecipes = new ArrayList<Object>();
                    for (GTRecipe gTRecipe : RecipeMaps.assemblerRecipes.getAllRecipes()) {
                        if (!GTUtility.areStacksEqual(currentComponent.get(1L, new Object[0]), gTRecipe.mOutputs[0])) continue;
                        foundRecipes.add(gTRecipe);
                    }
                    allAssemblerRecipes.put(foundRecipes, (Pair<ItemList, Integer>)Pair.of((Object)currentComponent, (Object)t));
                    continue;
                }
                foundRecipes = new ArrayList();
                for (GTRecipe.RecipeAssemblyLine recipeAssemblyLine : GTRecipe.RecipeAssemblyLine.sAssemblylineRecipes) {
                    if (!GTUtility.areStacksEqual(currentComponent.get(1L, new Object[0]), recipeAssemblyLine.mOutput)) continue;
                    foundRecipes.add(recipeAssemblyLine);
                }
                allAsslineRecipes.put(foundRecipes, (Pair<ItemList, Integer>)Pair.of((Object)currentComponent, (Object)t));
            }
        }
    }

    private static List<ItemStack> getWrappedCircuits(ItemStack item, int total, String oreDict) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        String circuitMaterial = oreDict.substring(7);
        int tier = ComponentAssemblyLineMiscRecipes.NameToTier.get(circuitMaterial);
        if (total >= 16) {
            stacks.addAll(StackUtils.multiplyAndSplitIntoStacks(new ItemStack(Loaders.circuitWrap, 1, tier), total / 16));
        } else {
            stacks.addAll(StackUtils.multiplyAndSplitIntoStacks(item, total));
        }
        return stacks;
    }

    private static List<ItemStack> getMagnetoConversion(ItemStack item, int total) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ItemData data = GTOreDictUnificator.getAssociation(item);
        if (data == null) {
            return stacks;
        }
        if (total >= 64) {
            double multiplier = magnetoConversionMultipliers.get((Object)data.mPrefix);
            stacks.addAll(ComponentAssemblyLineRecipeLoader.getWrappedCircuits(GTOreDictUnificator.get(OrePrefixes.circuit, Materials.UHV, 1L), (int)((double)total * multiplier), "circuitInfinite"));
        }
        stacks.addAll(StackUtils.multiplyAndSplitIntoStacks(item, total));
        return stacks;
    }

    private static void addEternityForMHDCSM(ArrayList<FluidStack> fluidInputs) {
        boolean eternity = false;
        boolean mhdcsm = false;
        int mhdcsmAmount = 0;
        for (FluidStack fluidstack : fluidInputs) {
            if (fluidstack.getFluid().equals(FluidRegistry.getFluid((String)moltenMHDCSM))) {
                mhdcsm = true;
                mhdcsmAmount = fluidstack.amount;
            }
            if (!fluidstack.getFluid().equals(FluidRegistry.getFluid((String)"molten.eternity"))) continue;
            eternity = true;
        }
        if (mhdcsm && !eternity) {
            fluidInputs.add(MaterialsUEVplus.Eternity.getMolten(mhdcsmAmount - 27648));
        }
    }

    private static ArrayList<ArrayList<FluidStack>> addFluidsForProtoHalkonite(ArrayList<FluidStack> fluidInputs) {
        int phkIndex = -1;
        int infinityIndex = -1;
        int creonIndex = -1;
        int mellionIndex = -1;
        int superfluidIndex = -1;
        for (int i = 0; i < fluidInputs.size(); ++i) {
            FluidStack stack = fluidInputs.get(i);
            if (stack.getFluid().equals(FluidRegistry.getFluid((String)"protohalkonitebase"))) {
                phkIndex = i;
            }
            if (stack.getFluid().equals(FluidRegistry.getFluid((String)"molten.infinity"))) {
                infinityIndex = i;
            }
            if (stack.getFluid().equals(FluidRegistry.getFluid((String)"molten.creon"))) {
                creonIndex = i;
            }
            if (stack.getFluid().equals(FluidRegistry.getFluid((String)"molten.mellion"))) {
                mellionIndex = i;
            }
            if (!stack.getFluid().equals(FluidRegistry.getFluid((String)"dimensionallyshiftedsuperfluid"))) continue;
            superfluidIndex = i;
        }
        ArrayList<ArrayList<FluidStack>> fixedFluidsRecipes = new ArrayList<ArrayList<FluidStack>>();
        if (phkIndex != -1) {
            int originalPhk = fluidInputs.get((int)phkIndex).amount;
            ArrayList<FluidStack> infinityRecipe = new ArrayList<FluidStack>(fluidInputs);
            if (infinityIndex != -1) {
                int originalInfinity = infinityRecipe.get((int)infinityIndex).amount;
                infinityRecipe.set(infinityIndex, Materials.Infinity.getMolten(originalInfinity + originalPhk));
            } else {
                infinityRecipe.add(Materials.Infinity.getMolten(originalPhk));
            }
            fixedFluidsRecipes.add(infinityRecipe);
            ArrayList<FluidStack> creonMellionRecipe = new ArrayList<FluidStack>(fluidInputs);
            creonMellionRecipe.set(phkIndex, MaterialsUEVplus.MoltenProtoHalkoniteBase.getFluid(originalPhk / 2));
            if (creonIndex != -1) {
                int originalCreon = creonMellionRecipe.get((int)creonIndex).amount;
                creonMellionRecipe.set(creonIndex, MaterialsUEVplus.Creon.getMolten(originalCreon + originalPhk / 2));
            } else {
                creonMellionRecipe.add(MaterialsUEVplus.Creon.getMolten(originalPhk / 2));
            }
            if (mellionIndex != -1) {
                int originalMellion = creonMellionRecipe.get((int)mellionIndex).amount;
                creonMellionRecipe.set(mellionIndex, MaterialsUEVplus.Mellion.getMolten(originalMellion + originalPhk / 2));
            } else {
                creonMellionRecipe.add(MaterialsUEVplus.Mellion.getMolten(originalPhk / 2));
            }
            fixedFluidsRecipes.add(creonMellionRecipe);
            for (ArrayList<FluidStack> fluids : fixedFluidsRecipes) {
                if (superfluidIndex != -1) {
                    int originalSuperfluid = fluids.get((int)superfluidIndex).amount;
                    fluids.set(superfluidIndex, MaterialsUEVplus.DimensionallyShiftedSuperfluid.getFluid(originalSuperfluid + originalPhk / 4));
                    continue;
                }
                fluids.add(MaterialsUEVplus.DimensionallyShiftedSuperfluid.getFluid(originalPhk / 4));
            }
        } else {
            fixedFluidsRecipes.add(fluidInputs);
        }
        return fixedFluidsRecipes;
    }

    private static boolean swapSiliconeForStyreneButadiene(ArrayList<FluidStack> fluidInputs) {
        for (int i = 0; i < fluidInputs.size(); ++i) {
            FluidStack fluidstack = fluidInputs.get(i);
            if (!fluidstack.getFluid().equals(FluidRegistry.getFluid((String)"molten.silicone"))) continue;
            fluidInputs.set(i, FluidRegistry.getFluidStack((String)"molten.styrenebutadienerubber", (int)fluidstack.amount));
            return true;
        }
        return false;
    }

    static {
        magnetoConversionMultipliers = new HashMap();
        conversion = new HashMap();
    }
}

