/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.enums;

import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchDynamo;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.metatileentity.implementations.MTEHatchMaintenance;
import gregtech.api.metatileentity.implementations.MTEHatchMuffler;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.metatileentity.implementations.MTEHatchOutputBus;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.util.ExoticEnergyInputHelper;
import gregtech.api.util.IGTHatchAdder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum HatchElement implements IHatchElement<MTEMultiBlockBase>
{
    Muffler(MTEMultiBlockBase::addMufflerToMachineList, new Class[]{MTEHatchMuffler.class}){

        @Override
        public long count(MTEMultiBlockBase t) {
            return t.mMufflerHatches.size();
        }
    }
    ,
    Maintenance(MTEMultiBlockBase::addMaintenanceToMachineList, new Class[]{MTEHatchMaintenance.class}){

        @Override
        public long count(MTEMultiBlockBase t) {
            return t.mMaintenanceHatches.size();
        }
    }
    ,
    InputHatch(MTEMultiBlockBase::addInputHatchToMachineList, new Class[]{MTEHatchInput.class}){

        @Override
        public long count(MTEMultiBlockBase t) {
            return t.mInputHatches.size();
        }
    }
    ,
    InputBus(MTEMultiBlockBase::addInputBusToMachineList, new Class[]{MTEHatchInputBus.class}){

        @Override
        public long count(MTEMultiBlockBase t) {
            return t.mInputBusses.size();
        }
    }
    ,
    OutputHatch(MTEMultiBlockBase::addOutputHatchToMachineList, new Class[]{MTEHatchOutput.class}){

        @Override
        public long count(MTEMultiBlockBase t) {
            return t.mOutputHatches.size();
        }
    }
    ,
    OutputBus(MTEMultiBlockBase::addOutputBusToMachineList, new Class[]{MTEHatchOutputBus.class}){

        @Override
        public long count(MTEMultiBlockBase t) {
            return t.mOutputBusses.size();
        }
    }
    ,
    Energy(MTEMultiBlockBase::addEnergyInputToMachineList, new Class[]{MTEHatchEnergy.class}){

        @Override
        public long count(MTEMultiBlockBase t) {
            return t.mEnergyHatches.size();
        }
    }
    ,
    Dynamo(MTEMultiBlockBase::addDynamoToMachineList, new Class[]{MTEHatchDynamo.class}){

        @Override
        public long count(MTEMultiBlockBase t) {
            return t.mDynamoHatches.size();
        }
    }
    ,
    ExoticEnergy(MTEMultiBlockBase::addExoticEnergyInputToMachineList, new Class[0]){

        @Override
        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return ExoticEnergyInputHelper.getAllClasses();
        }

        @Override
        public long count(MTEMultiBlockBase t) {
            return t.getExoticEnergyHatches().size();
        }
    };

    private final List<Class<? extends IMetaTileEntity>> mteClasses;
    private final IGTHatchAdder<MTEMultiBlockBase> adder;

    @SafeVarargs
    private HatchElement(IGTHatchAdder<MTEMultiBlockBase> adder, Class<? extends IMetaTileEntity> ... mteClasses) {
        this.mteClasses = Collections.unmodifiableList(Arrays.asList(mteClasses));
        this.adder = adder;
    }

    @Override
    public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
        return this.mteClasses;
    }

    @Override
    public IGTHatchAdder<? super MTEMultiBlockBase> adder() {
        return this.adder;
    }
}

