/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity;

import appeng.core.CreativeTab;
import com.gtnewhorizon.gtnhlib.util.map.ItemStackMap;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import gregtech.GTMod;
import gregtech.api.multitileentity.MultiTileEntityBlock;
import gregtech.api.multitileentity.MultiTileEntityClassContainer;
import gregtech.api.multitileentity.base.MultiTileEntity;
import gregtech.api.multitileentity.interfaces.IMultiTileEntity;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTUtil;
import gregtech.api.util.GTUtility;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class MultiTileEntityRegistry {
    private static final HashMap<String, MultiTileEntityRegistry> NAMED_REGISTRIES = new HashMap();
    private static final ItemStackMap<MultiTileEntityRegistry> REGISTRIES = new ItemStackMap(false);
    private static final HashSet<Class<?>> sRegisteredTileEntities = new HashSet();
    public HashMap<Short, CreativeTab> creativeTabs = new HashMap();
    public final Short2ObjectMap<MultiTileEntityClassContainer> registry = new Short2ObjectOpenHashMap();
    public List<MultiTileEntityClassContainer> registrations = new ArrayList<MultiTileEntityClassContainer>();
    private final String internalName;
    private final MultiTileEntityBlock block;
    public short mLastRegisteredID = Short.MAX_VALUE;

    public MultiTileEntityRegistry(String internalName, MultiTileEntityBlock block) {
        if (!Loader.instance().isInState(LoaderState.PREINITIALIZATION)) {
            throw new IllegalStateException("The MultiTileEntity Registry must be initialized during Preload Phase and not before");
        }
        if (!block.isRegistered()) {
            throw new IllegalStateException("Block not registered");
        }
        this.internalName = internalName;
        this.block = block;
        GTMod.GT_FML_LOGGER.info(internalName + " " + Block.func_149682_b((Block)block) + " This is the answer");
        this.block.setRegistry(this);
        REGISTRIES.put(new ItemStack(Item.func_150899_d((int)Block.func_149682_b((Block)block)), 1, Short.MAX_VALUE), (Object)this);
        NAMED_REGISTRIES.put(internalName, this);
    }

    public static TileEntity getReferenceTileEntity(int aRegistryID, int aMultiTileEntityID) {
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(aRegistryID);
        if (tRegistry == null) {
            return null;
        }
        MultiTileEntityClassContainer tClassContainer = tRegistry.getClassContainer(aMultiTileEntityID);
        if (tClassContainer == null) {
            return null;
        }
        return tClassContainer.getReferenceTileEntity();
    }

    public MultiTileEntity getReferenceTileEntity(ItemStack stack) {
        return this.getReferenceTileEntity(Items.field_151008_G.getDamage(stack));
    }

    public MultiTileEntity getReferenceTileEntity(int metaId) {
        MultiTileEntityClassContainer muteClass = (MultiTileEntityClassContainer)this.registry.get((short)metaId);
        if (muteClass == null) {
            return null;
        }
        return muteClass.getReferenceTileEntity();
    }

    public static MultiTileEntityRegistry getRegistry(int aRegistryID) {
        return (MultiTileEntityRegistry)REGISTRIES.get((Object)new ItemStack(Item.func_150899_d((int)aRegistryID), 1, Short.MAX_VALUE));
    }

    public static MultiTileEntityRegistry getRegistry(String aRegistryName) {
        return NAMED_REGISTRIES.get(aRegistryName);
    }

    public MultiTileEntityClassContainer create(int aID, Class<? extends MultiTileEntity> aClass) {
        return new MultiTileEntityClassContainer(this, aID, aClass);
    }

    public ItemStack add(String aLocalised, MultiTileEntityClassContainer aClassContainer) {
        boolean tFailed = false;
        if (GTUtility.isStringInvalid(aLocalised)) {
            GTMod.GT_FML_LOGGER.error("MULTI-TILE REGISTRY ERROR: Localisation Missing!");
            tFailed = true;
        }
        if (aClassContainer == null) {
            GTMod.GT_FML_LOGGER.error("MULTI-TILE REGISTRY ERROR: Class Container is null!");
            tFailed = true;
        } else {
            if (aClassContainer.getMuteClass() == null) {
                GTMod.GT_FML_LOGGER.error("MULTI-TILE REGISTRY ERROR: Class inside Class Container is null!");
                tFailed = true;
            }
            if (aClassContainer.getMuteID() == Short.MAX_VALUE) {
                GTMod.GT_FML_LOGGER.error("MULTI-TILE REGISTRY ERROR: Class Container uses Wildcard MetaData!");
                tFailed = true;
            }
            if (aClassContainer.getMuteID() < 0) {
                GTMod.GT_FML_LOGGER.error("MULTI-TILE REGISTRY ERROR: Class Container uses negative MetaData!");
                tFailed = true;
            }
            if (this.registry.containsKey(aClassContainer.getMuteID())) {
                GTMod.GT_FML_LOGGER.error("MULTI-TILE REGISTRY ERROR: Class Container uses occupied MetaData! (" + aClassContainer.getMuteID() + ")");
                tFailed = true;
            }
        }
        if (tFailed) {
            GTMod.GT_FML_LOGGER.error("MULTI-TILE REGISTRY ERROR " + aLocalised + " : STACKTRACE START");
            int i = 0;
            for (StackTraceElement tElement : new Exception().getStackTrace()) {
                if (i++ >= 5 || tElement.getClassName().startsWith("sun")) break;
                GTMod.GT_FML_LOGGER.error("\tat " + tElement);
            }
            GTMod.GT_FML_LOGGER.error("MULTI-TILE REGISTRY ERROR: STACKTRACE END");
            return null;
        }
        GTLanguageManager.addStringLocalization(this.internalName + "." + aClassContainer.getMuteID() + ".name", aLocalised);
        this.registry.put(aClassContainer.getMuteID(), (Object)aClassContainer);
        this.mLastRegisteredID = aClassContainer.getMuteID();
        this.registrations.add(aClassContainer);
        if (sRegisteredTileEntities.add(aClassContainer.getReferenceTileEntity().getClass())) {
            aClassContainer.getReferenceTileEntity().onRegistrationFirst(this, aClassContainer.getMuteID());
        }
        return this.getItem(aClassContainer.getMuteID());
    }

    public ItemStack getItem() {
        return this.getItem(this.mLastRegisteredID, 1L, null);
    }

    public ItemStack getItem(int aID) {
        return this.getItem(aID, 1L, null);
    }

    public ItemStack getItem(int aID, NBTTagCompound nbt) {
        return this.getItem(aID, 1L, nbt);
    }

    public ItemStack getItem(int aID, long aAmount) {
        return this.getItem(aID, aAmount, null);
    }

    public ItemStack getItem(int metaID, long amount, NBTTagCompound nbt) {
        ItemStack stack = new ItemStack((Block)this.block, (int)amount, metaID);
        if (nbt == null || nbt.func_82582_d()) {
            nbt = new NBTTagCompound();
            TileEntity tileEntity = this.getNewTileEntity(metaID, nbt);
            ((IMultiTileEntity)tileEntity).writeItemNBT(nbt);
        }
        stack.func_77982_d(nbt);
        return stack;
    }

    public String getLocal(int aID) {
        return StatCollector.func_74838_a((String)(this.internalName + "." + aID + ".name"));
    }

    public MultiTileEntityClassContainer getClassContainer(int aID) {
        return (MultiTileEntityClassContainer)this.registry.get((short)aID);
    }

    public MultiTileEntityClassContainer getClassContainer(ItemStack stack) {
        return (MultiTileEntityClassContainer)this.registry.get((short)Items.field_151008_G.getDamage(stack));
    }

    public TileEntity getNewTileEntity(int aID) {
        return this.getNewTileEntity(null, 0, 0, 0, aID);
    }

    public TileEntity getNewTileEntity(World aWorld, int x, int y, int z, int metaID) {
        return this.getNewTileEntity(aWorld, x, y, z, metaID, null);
    }

    public TileEntity getNewTileEntity(World aWorld, int x, int y, int z, int metaID, NBTTagCompound nbt) {
        MultiTileEntityClassContainer container = (MultiTileEntityClassContainer)this.registry.get((short)metaID);
        if (container == null) {
            return null;
        }
        MultiTileEntity te = (MultiTileEntity)GTUtility.callConstructor(container.getMuteClass(), -1, null, true, new Object[0]);
        te.func_145834_a(aWorld);
        te.field_145851_c = x;
        te.field_145848_d = y;
        te.field_145849_e = z;
        nbt = nbt == null || nbt.func_82582_d() ? container.getParameters() : GTUtil.fuseNBT(nbt, container.getParameters());
        te.initFromNBT(nbt, (short)metaID, (short)Block.func_149682_b((Block)this.block));
        return te;
    }

    public TileEntity getNewTileEntity(int meta, NBTTagCompound nbt) {
        return this.getNewTileEntity(null, 0, 0, 0, meta, nbt);
    }

    public String getInternalName() {
        return this.internalName;
    }

    public MultiTileEntityBlock getBlock() {
        return this.block;
    }
}

