/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects.overclockdescriber;

import gregtech.api.objects.overclockdescriber.OverclockDescriber;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.api.util.OverclockCalculator;
import gregtech.nei.RecipeDisplayInfo;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class EUNoOverclockDescriber
extends OverclockDescriber {
    protected final int amperage;

    public EUNoOverclockDescriber(byte tier, int amperage) {
        super(tier);
        if (amperage < 1) {
            throw new IllegalArgumentException("Amperage cannot be lower than 1");
        }
        this.amperage = amperage;
    }

    @Override
    public OverclockCalculator createCalculator(OverclockCalculator template, GTRecipe recipe) {
        return OverclockCalculator.ofNoOverclock(recipe);
    }

    @Override
    public String getTierString() {
        return GTUtility.getColoredTierNameFromTier(this.tier);
    }

    @Override
    public final void drawEnergyInfo(RecipeDisplayInfo recipeInfo) {
        if (recipeInfo.calculator.getDuration() > 0 && recipeInfo.calculator.getConsumption() > 0L) {
            recipeInfo.drawText(GTUtility.trans("152", "Total: ") + this.getTotalPowerString(recipeInfo.calculator));
        }
        this.drawEnergyInfoImpl(recipeInfo);
    }

    protected void drawEnergyInfoImpl(RecipeDisplayInfo recipeInfo) {
        if (recipeInfo.calculator.getConsumption() <= 0L) {
            return;
        }
        recipeInfo.drawText(GTUtility.trans("153", "Usage: ") + this.getEUtDisplay(recipeInfo.calculator));
        if (this.shouldShowAmperage(recipeInfo.calculator)) {
            recipeInfo.drawText(GTUtility.trans("154", "Voltage: ") + this.getVoltageString(recipeInfo.calculator));
            recipeInfo.drawText(GTUtility.trans("155", "Amperage: ") + this.getAmperageString(recipeInfo.calculator));
        }
    }

    protected String getTotalPowerString(OverclockCalculator calculator) {
        return GTUtility.formatNumbers(calculator.getConsumption() * (long)calculator.getDuration()) + " EU";
    }

    protected boolean shouldShowAmperage(OverclockCalculator calculator) {
        return this.amperage != 1;
    }

    protected String getEUtWithoutTier(OverclockCalculator calculator) {
        return GTUtility.formatNumbers(calculator.getConsumption()) + " EU/t";
    }

    protected String getEUtWithTier(OverclockCalculator calculator) {
        return this.getEUtWithoutTier(calculator) + GTUtility.getTierNameWithParentheses(calculator.getConsumption());
    }

    protected String getEUtDisplay(OverclockCalculator calculator) {
        return this.shouldShowAmperage(calculator) ? this.getEUtWithoutTier(calculator) : this.getEUtWithTier(calculator);
    }

    protected String getVoltageString(OverclockCalculator calculator) {
        long voltage = this.computeVoltageForEURate(calculator.getConsumption());
        return GTUtility.formatNumbers(voltage) + " EU/t" + GTUtility.getTierNameWithParentheses(voltage);
    }

    protected String getAmperageString(OverclockCalculator calculator) {
        return GTUtility.formatNumbers(this.amperage);
    }

    protected long computeVoltageForEURate(long euPerTick) {
        return euPerTick / (long)this.amperage;
    }
}

