/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe.maps;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.SubTag;
import gregtech.api.objects.ItemData;
import gregtech.api.objects.MaterialStack;
import gregtech.api.recipe.RecipeMapBackendPropertiesBuilder;
import gregtech.api.recipe.maps.NonGTBackend;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTRecipeBuilder;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MicrowaveBackend
extends NonGTBackend {
    public MicrowaveBackend(RecipeMapBackendPropertiesBuilder propertiesBuilder) {
        super(propertiesBuilder);
    }

    @Override
    protected GTRecipe overwriteFindRecipe(ItemStack[] items, FluidStack[] fluids, @Nullable ItemStack specialSlot, @Nullable GTRecipe cachedRecipe) {
        if (items.length == 0 || items[0] == null) {
            return null;
        }
        if (cachedRecipe != null && cachedRecipe.isRecipeInputEqual(false, true, fluids, items)) {
            return cachedRecipe;
        }
        ItemStack output = GTModHandler.getSmeltingOutput(items[0], false, null);
        if (GTUtility.areStacksEqual(items[0], new ItemStack(Items.field_151122_aG, 1, Short.MAX_VALUE))) {
            return GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, items[0])).itemOutputs(GTUtility.getWrittenBook("Manual_Microwave", ItemList.Book_Written_03.get(1L, new Object[0]))).duration(32).eut(4).noOptimize().build().orElse(null);
        }
        for (ItemStack item : new ItemStack[]{GTUtility.getContainerItem(items[0], true), items[0], GTUtility.getContainerItem(output, true), output}) {
            if (item == null) continue;
            if (GTUtility.areStacksEqual(item, new ItemStack(Blocks.field_150424_aL, 1, Short.MAX_VALUE), true) || GTUtility.areStacksEqual(item, new ItemStack(Blocks.field_150335_W, 1, Short.MAX_VALUE), true) || GTUtility.areStacksEqual(item, new ItemStack(Items.field_151110_aK, 1, Short.MAX_VALUE), true) || GTUtility.areStacksEqual(item, new ItemStack(Items.field_151154_bQ, 1, Short.MAX_VALUE), true) || GTUtility.areStacksEqual(item, new ItemStack(Items.field_151152_bP, 1, Short.MAX_VALUE), true) || GTUtility.areStacksEqual(item, new ItemStack(Items.field_151059_bz, 1, Short.MAX_VALUE), true)) {
                GTLog.exp.println("Microwave Explosion due to TNT || EGG || FIREWORKCHARGE || FIREWORK || FIRE CHARGE");
                return GTRecipeBuilder.empty().metadata(GTRecipeConstants.EXPLODE, true).build().orElse(null);
            }
            ItemData itemData = GTOreDictUnificator.getItemData(item);
            if (itemData != null) {
                if (itemData.mMaterial != null && itemData.mMaterial.mMaterial != null) {
                    if (itemData.mMaterial.mMaterial.contains(SubTag.METAL) || itemData.mMaterial.mMaterial.contains(SubTag.EXPLOSIVE)) {
                        GTLog.exp.println("Microwave Explosion due to METAL insertion");
                        return GTRecipeBuilder.empty().metadata(GTRecipeConstants.EXPLODE, true).build().orElse(null);
                    }
                    if (itemData.mMaterial.mMaterial.contains(SubTag.FLAMMABLE)) {
                        GTLog.exp.println("Microwave INFLAMMATION due to FLAMMABLE insertion");
                        return GTRecipeBuilder.empty().metadata(GTRecipeConstants.ON_FIRE, true).build().orElse(null);
                    }
                }
                for (MaterialStack materialStack : itemData.mByProducts) {
                    if (materialStack == null) continue;
                    if (materialStack.mMaterial.contains(SubTag.METAL) || materialStack.mMaterial.contains(SubTag.EXPLOSIVE)) {
                        GTLog.exp.println("Microwave Explosion due to METAL insertion");
                        return GTRecipeBuilder.empty().metadata(GTRecipeConstants.EXPLODE, true).build().orElse(null);
                    }
                    if (!materialStack.mMaterial.contains(SubTag.FLAMMABLE)) continue;
                    GTLog.exp.println("Microwave INFLAMMATION due to FLAMMABLE insertion");
                    return GTRecipeBuilder.empty().metadata(GTRecipeConstants.ON_FIRE, true).build().orElse(null);
                }
            }
            if (TileEntityFurnace.func_145952_a((ItemStack)item) <= 0) continue;
            GTLog.exp.println("Microwave INFLAMMATION due to BURNABLE insertion");
            return GTRecipeBuilder.empty().metadata(GTRecipeConstants.ON_FIRE, true).build().orElse(null);
        }
        return output == null ? null : (GTRecipe)GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, items[0])).itemOutputs(output).duration(32).eut(4).noOptimize().build().orElse(null);
    }

    @Override
    public boolean containsInput(ItemStack item) {
        return GTModHandler.getSmeltingOutput(item, false, null) != null;
    }
}

